/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Ensemble;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleFlagWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener {
    protected GenericObjectListener m_listener = new GenericObjectListener();
    protected JTextField m_txtMin = new JTextField("");
    protected JTextField m_txtMax = new JTextField("");
    protected ComboStringListWrapper m_tableCombo = new ComboStringListWrapper("Receiver");
    protected ComboStringListWrapper m_columnCombo = new ComboStringListWrapper("LineNumber");
    protected JButton m_btnReload = new JButton("Reload columns");
    protected JCheckBox m_chkOn;
    protected ParameterTree m_parameterTree;

    public GenericObjectListener listener() {
        return this.m_listener;
    }

    public EnsembleFlagWidget(int insets, String label, ParameterTree pt) {
        super(LinearLayoutWidget.Direction.Vertical, insets, label);
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_parameterTree = pt;
            this.m_chkOn = new JCheckBox("Only apply the operation to traces within limits");
            this.addComponent(this.m_chkOn, 0);
            GridLayoutWidget grid = this.createGridLayoutWidget(insets, 0);
            int row = 0;
            grid.addSimple(row++, new JLabel("Table:"), this.m_tableCombo);
            grid.addSimple(row++, new JLabel("Column:"), this.m_columnCombo);
            grid.addSimple(row++, new JLabel("Minimum:"), this.m_txtMin);
            grid.addSimple(row++, new JLabel("Maximum:"), this.m_txtMax);
            grid.addSimple(row++, new JLabel(" "), this.m_btnReload);
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_tableCombo.listener().addListener(this);
            this.m_columnCombo.listener().addListener(this);
            this.m_txtMin.addActionListener(this);
            this.m_txtMax.addActionListener(this);
            this.m_chkOn.addActionListener(this);
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("Shot");
            tables.add("Receiver");
            tables.add("Trace");
            this.m_tableCombo.setStringArray(tables);
            this.m_tableCombo.setPreferredSelected(this.m_parameterTree.string_get("Table", "Shot"));
            String tableName = this.m_tableCombo.getSelectedString();
            ArrayList<String> columns = tableName.equalsIgnoreCase("Trace") ? p.traceTableWrapper().traceTable().columns() : p.geometryDatabase().listOfColumnNames(tableName);
            this.m_columnCombo.setStringArray(columns);
            this.m_columnCombo.setPreferredSelected(this.m_parameterTree.string_get("Column", "PointDepth"));
            this.m_txtMin.setText(this.m_parameterTree.string_get("Minimum", "0"));
            this.m_txtMax.setText(this.m_parameterTree.string_get("Maximum", "100"));
            this.m_chkOn.setSelected(this.m_parameterTree.bool_get("On", false));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setOn(boolean on) {
        try {
            this.m_chkOn.setSelected(on);
            this.m_parameterTree.bool_put("On", this.m_chkOn.isSelected());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void getParameters() {
        try {
            this.m_parameterTree.string_put("Table", this.m_tableCombo.getSelectedString());
            this.m_parameterTree.string_put("Column", this.m_columnCombo.getSelectedString());
            this.m_parameterTree.double_put("Minimum", Tools_Widget.extractDouble(this.m_txtMin, 0.0, -1.0E20, 1.0E20));
            this.m_parameterTree.double_put("Maximum", Tools_Widget.extractDouble(this.m_txtMax, 0.0, -1.0E20, 1.0E20));
            this.m_parameterTree.bool_put("On", this.m_chkOn.isSelected());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void changed() {
        try {
            this.getParameters();
            this.m_listener.broadcast(this, null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.changed();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (sender == this.m_tableCombo) {
                String tableName = this.m_tableCombo.getSelectedString();
                ArrayList<String> columns = tableName.equalsIgnoreCase("Trace") ? p.traceTableWrapper().traceTable().columns() : p.geometryDatabase().listOfColumnNames(tableName);
                this.m_columnCombo.setStringArray(columns);
            }
            this.changed();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

