/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.EchosInterface;
import com.PecosLibrary.Echos.Result;
import com.PecosLibrary.Echos.SWIGTYPE_p_float;
import com.PecosLibrary.Echos.XtEchosColumnMap;
import com.PecosLibrary.Echos.XtEchosColumnMapEntry;
import com.PecosLibrary.Echos.XtParadigmSeisDataAttributeInfo;
import com.PecosLibrary.Echos.XtParadigmSeisDataAttributeInfoList;
import com.PecosLibrary.Echos.XtParadigmSeisDataDB;
import com.PecosLibrary.Echos.XtParadigmSeisDataDbAtr;
import com.PecosLibrary.Echos.XtParadigmSeisDataModelInfo;
import com.PecosLibrary.Echos.XtParadigmTableTools;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.IShotRecTableModelProvider;
import com.PecosLibrary.Windows.Echos.SeisDataAttributeInfoViewModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class XtEchosColumnMapWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ItemListener {
    JLabel _lblModelName;
    JLabel _lblSurveyName;
    JLabel _lblLineName;
    JLabel _lblUseKeys;
    JLabel _lblColumn;
    JLabel _lblEventAttribute;
    JCheckBox _cbUseKey1;
    JCheckBox _cbUseKey2;
    JCheckBox _cbUseKey3;
    JComboBox _cmbKey1Column;
    JComboBox _cmbKey1EventAttribute;
    JComboBox _cmbKey2Column;
    JComboBox _cmbKey2EventAttribute;
    JComboBox _cmbKey3Column;
    JComboBox _cmbKey3EventAttribute;
    String _sEchosModelName;
    String _sEchosSurveyName = "";
    String _sEchosLineName = "";
    String _sEchosHostName = "";
    JLabel _lblError;
    JLabel _lblOutputColumn;
    JComboBox _cmbOutputColumn;
    JLabel _lblOutputEchosEvent;
    JTextField _txtOutputEchosEvent;
    JLabel _lblOutputEchosAttribute;
    JTextField _txtOutputEchosAttribute;
    JLabel _lblInputColumn;
    JTextField _txtInputColumn;
    JLabel _lblInputEventAttribute;
    JComboBox _cmbEchosInputEventAttribute;
    JCheckBox _cbWriteDefaultValueIfKeysDontMatch;
    JLabel _lblDefaultValue;
    JTextField _txtDefaultValue;
    EchosDatabaseImportExportSharedData _data;
    XtParadigmSeisDataAttributeInfoList _attributeInfoList;
    List<SeisDataAttributeInfoViewModel> _attributeInfoVmList;
    IShotRecTableModelProvider _tableModelProvider;
    boolean _bImportWidget;
    boolean _bGeometryExport = false;

    public XtEchosColumnMapWidget(boolean bImportWidget, String sTitle, String sEchosModelName, EchosDatabaseImportExportSharedData data, IShotRecTableModelProvider tableModelProvider, boolean bGeometryExport) {
        super(LinearLayoutWidget.Direction.Vertical, 4, null);
        try {
            this._bGeometryExport = bGeometryExport;
            this._bImportWidget = bImportWidget;
            this._tableModelProvider = tableModelProvider;
            this._data = data;
            LinearLayoutWidget topWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, "", 10);
            GridLayoutWidget keyGridWidget = this.createGridLayoutWidget(0, "Keys", 10);
            GridLayoutWidget outputGridWidget = this.createGridLayoutWidget(0, "Value", 10);
            GridLayoutWidget errorHandlingGridWidget = this.createGridLayoutWidget(0, "Error Handling", 10);
            LinearLayoutWidget bottomWidget = this.createLinearLayoutWidget(LinearLayoutWidget.Direction.Horizontal, 0, "", 10);
            this._sEchosModelName = sEchosModelName;
            this._lblModelName = new JLabel("Echos Model : " + this._sEchosModelName);
            this._lblSurveyName = new JLabel("Survey : ");
            this._lblLineName = new JLabel("Line : ");
            this._lblUseKeys = new JLabel("Use Keys");
            this._lblColumn = new JLabel("Column");
            this._lblEventAttribute = new JLabel("Event Attribute");
            this._cbUseKey1 = new JCheckBox("Use Key1");
            this._cbUseKey2 = new JCheckBox("Use Key2");
            this._cbUseKey3 = new JCheckBox("Use Key3");
            this._cmbKey1Column = new JComboBox();
            this._cmbKey1EventAttribute = new JComboBox();
            this._cmbKey2Column = new JComboBox();
            this._cmbKey2EventAttribute = new JComboBox();
            this._cmbKey3Column = new JComboBox();
            this._cmbKey3EventAttribute = new JComboBox();
            this._lblError = new JLabel("STATUS:");
            this._lblError.setForeground(Color.red);
            if (!this._bImportWidget) {
                this._lblOutputColumn = new JLabel("Column");
                this._cmbOutputColumn = new JComboBox();
                this._lblOutputEchosEvent = new JLabel("Echos Event");
                this._txtOutputEchosEvent = new JTextField("");
                this._lblOutputEchosAttribute = new JLabel("Echos Attribute");
                this._txtOutputEchosAttribute = new JTextField("");
            } else {
                this._lblInputColumn = new JLabel("Column");
                this._txtInputColumn = new JTextField("Static");
                this._lblInputEventAttribute = new JLabel("Echos Event Attribute");
                this._cmbEchosInputEventAttribute = new JComboBox();
            }
            this._cbWriteDefaultValueIfKeysDontMatch = new JCheckBox("Write default value if keys don't match");
            this._lblDefaultValue = new JLabel("Default Value:");
            if (!this._bImportWidget && this._bGeometryExport) {
                this._txtDefaultValue = new JTextField("Echos Geometry");
                this._txtDefaultValue.setEnabled(false);
            } else {
                this._txtDefaultValue = new JTextField("-9999");
            }
            topWidget.addComponent(this._lblModelName, 10);
            topWidget.addComponent(this._lblSurveyName, 10);
            topWidget.addComponent(this._lblLineName, 10);
            keyGridWidget.addComponent(this._lblUseKeys, 0, 0);
            keyGridWidget.addComponent(this._lblColumn, 0, 1);
            keyGridWidget.addComponent(this._lblEventAttribute, 0, 2);
            keyGridWidget.addComponent(this._cbUseKey1, 1, 0);
            keyGridWidget.addComponent(this._cmbKey1Column, 1, 1);
            keyGridWidget.addComponent(this._cmbKey1EventAttribute, 1, 2);
            keyGridWidget.addComponent(this._cbUseKey2, 2, 0);
            keyGridWidget.addComponent(this._cmbKey2Column, 2, 1);
            keyGridWidget.addComponent(this._cmbKey2EventAttribute, 2, 2);
            keyGridWidget.addComponent(this._cbUseKey3, 3, 0);
            keyGridWidget.addComponent(this._cmbKey3Column, 3, 1);
            keyGridWidget.addComponent(this._cmbKey3EventAttribute, 3, 2);
            if (!this._bImportWidget) {
                if (!this._bGeometryExport) {
                    outputGridWidget.addComponent(this._lblOutputColumn, 0, 0);
                    outputGridWidget.addComponent(this._cmbOutputColumn, 0, 1);
                    outputGridWidget.addComponent(this._lblOutputEchosEvent, 0, 2);
                    outputGridWidget.addComponent(this._txtOutputEchosEvent, 0, 3);
                    outputGridWidget.addComponent(this._lblOutputEchosAttribute, 0, 4);
                    outputGridWidget.addComponent(this._txtOutputEchosAttribute, 0, 5);
                } else {
                    String sEvent = "SHOT";
                    if (this._sEchosModelName.equals("SHOT")) {
                        sEvent = "SHOT";
                    } else if (this._sEchosModelName.equals("STATION")) {
                        sEvent = "REC";
                    }
                    JLabel lblGeometryExport1 = new JLabel("Flatirons Geometry will be exported to Echos Event Attributes:");
                    JLabel lblGeometryExport2 = new JLabel(sEvent + " XFL");
                    JLabel lblGeometryExport3 = new JLabel(sEvent + " YFL");
                    JLabel lblGeometryExport4 = new JLabel(sEvent + " MOVEDFL");
                    outputGridWidget.addComponent(lblGeometryExport1, 0, 0);
                    outputGridWidget.addComponent(lblGeometryExport2, 1, 0);
                    outputGridWidget.addComponent(lblGeometryExport3, 2, 0);
                    outputGridWidget.addComponent(lblGeometryExport4, 3, 0);
                }
            } else {
                outputGridWidget.addComponent(this._lblInputColumn, 0, 0);
                outputGridWidget.addComponent(this._txtInputColumn, 0, 1);
                outputGridWidget.addComponent(this._lblInputEventAttribute, 0, 2);
                outputGridWidget.addComponent(this._cmbEchosInputEventAttribute, 0, 3);
            }
            errorHandlingGridWidget.addComponent(this._cbWriteDefaultValueIfKeysDontMatch, 0, 0);
            errorHandlingGridWidget.addComponent(this._lblDefaultValue, 1, 0);
            errorHandlingGridWidget.addComponent(this._txtDefaultValue, 1, 1);
            bottomWidget.addComponent(this._lblError, 10);
            this.fillGeometryKeys();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void fillGeometryKeys() {
        try {
            if (this._sEchosModelName.equals("SHOT")) {
                Table_Abstract shotTable = this._tableModelProvider.getShotTable();
                this.setXtGeoGeometryTable(shotTable);
            } else if (this._sEchosModelName.equals("STATION")) {
                Table_Abstract recTable = this._tableModelProvider.getRecTable();
                this.setXtGeoGeometryTable(recTable);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public float getDefaultValue() {
        float fVal = -9999.0f;
        try {
            if (!this._bGeometryExport) {
                fVal = Float.parseFloat(this._txtDefaultValue.getText());
            }
            return fVal;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return fVal;
        }
    }

    public void setDefaultValue(float fVal) {
        try {
            if (!this._bGeometryExport) {
                this._txtDefaultValue.setText(Float.toString(fVal));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean getUseDefaultValue() {
        boolean bUseDefaultValue = false;
        try {
            bUseDefaultValue = this._cbWriteDefaultValueIfKeysDontMatch.isSelected();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return bUseDefaultValue;
    }

    public void setUseDefaultValue(boolean bUseDefault) {
        try {
            this._cbWriteDefaultValueIfKeysDontMatch.setSelected(bUseDefault);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setXtGeoGeometryTable(Table_Abstract table) {
        try {
            this.fillComboFromTable(this._cmbKey1Column, table);
            this.fillComboFromTable(this._cmbKey2Column, table);
            this.fillComboFromTable(this._cmbKey3Column, table);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setXtGeoResultsTable(Table_Abstract table) {
        try {
            this.fillComboFromTable(this._cmbOutputColumn, table);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setEchosLine(String sSurvey, String sLine, String sHost) {
        try {
            this._lblSurveyName.setText("Survey : " + sSurvey);
            this._lblLineName.setText("Line : " + sLine);
            this._sEchosSurveyName = sSurvey;
            this._sEchosLineName = sLine;
            this._sEchosHostName = sHost;
            XtParadigmTableTools.openEchosSurveySeisDataDB(sSurvey, sLine, sHost);
            this._attributeInfoList = XtParadigmTableTools.getAttributeInfoList(this._sEchosModelName, this._sEchosLineName);
            this._attributeInfoVmList = this.createAttributeInfoVmList();
            this.fillComboAttrInfo(this._cmbKey1EventAttribute, this._attributeInfoVmList, "");
            this.fillComboAttrInfo(this._cmbKey2EventAttribute, this._attributeInfoVmList, "");
            this.fillComboAttrInfo(this._cmbKey3EventAttribute, this._attributeInfoVmList, "");
            String sDefaultEventAttr = "";
            if (this._sEchosModelName.equals("SHOT")) {
                sDefaultEventAttr = "SHOT SSTAT";
            } else if (this._sEchosModelName.equals("STATION")) {
                sDefaultEventAttr = "REC SSTAT";
            }
            this.fillComboAttrInfo(this._cmbEchosInputEventAttribute, this._attributeInfoVmList, sDefaultEventAttr);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this._lblError.setText("ERROR : " + error.getMessage());
        }
    }

    List<SeisDataAttributeInfoViewModel> createAttributeInfoVmList() {
        ArrayList<SeisDataAttributeInfoViewModel> list = new ArrayList<SeisDataAttributeInfoViewModel>();
        try {
            int nAttributes = this._attributeInfoList.size();
            SeisDataAttributeInfoViewModel vmID = null;
            SeisDataAttributeInfoViewModel vmStation = null;
            ArrayList<SeisDataAttributeInfoViewModel> vmList = new ArrayList<SeisDataAttributeInfoViewModel>();
            for (int i = 0; i < nAttributes; ++i) {
                XtParadigmSeisDataAttributeInfo attrInfo = this._attributeInfoList.get(i);
                String sAttribute = attrInfo.getAttribute();
                String sEvent = attrInfo.getEvent();
                String sLine = attrInfo.getLine();
                String sModel = attrInfo.getModel();
                int nLocs = attrInfo.getNlocs();
                int nVals = attrInfo.getNvals();
                if (!sLine.equals(this._sEchosLineName) || !sModel.equals(this._sEchosModelName) || nVals != 1) continue;
                SeisDataAttributeInfoViewModel vm = new SeisDataAttributeInfoViewModel(attrInfo);
                if (sAttribute.equals("Model") && sEvent.equals("Model")) {
                    vmID = vm;
                    continue;
                }
                if (sAttribute.equals("STATION") && sEvent.equals("RECEIVER")) {
                    vmStation = vm;
                    continue;
                }
                if (sAttribute.equals("STATION") && sEvent.equals("SHOT")) {
                    vmStation = vm;
                    continue;
                }
                vmList.add(vm);
            }
            if (vmID != null) {
                list.add(vmID);
            }
            if (vmStation != null) {
                list.add(vmStation);
            }
            for (SeisDataAttributeInfoViewModel vm : vmList) {
                list.add(vm);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return list;
    }

    public boolean getIsKeyValid(int iKey) {
        boolean bValid = false;
        try {
            if (iKey == 0) {
                bValid = this._cbUseKey1.isSelected();
            }
            if (iKey == 1) {
                bValid = this._cbUseKey2.isSelected();
            }
            if (iKey == 2) {
                bValid = this._cbUseKey3.isSelected();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return bValid;
    }

    public String getColumnForKey(int iKey) {
        String sColumn = null;
        if (iKey < 0 || iKey > 2) {
            return null;
        }
        try {
            Object objSelected;
            if (iKey == 0 && (objSelected = this._cmbKey1Column.getSelectedItem()) instanceof String) {
                sColumn = (String)objSelected;
                return sColumn;
            }
            if (iKey == 1 && (objSelected = this._cmbKey2Column.getSelectedItem()) instanceof String) {
                sColumn = (String)objSelected;
                return sColumn;
            }
            if (iKey == 2 && (objSelected = this._cmbKey3Column.getSelectedItem()) instanceof String) {
                sColumn = (String)objSelected;
                return sColumn;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sColumn;
    }

    public SeisDataAttributeInfoViewModel getEventAttributeForKey(int iKey) {
        SeisDataAttributeInfoViewModel vm = null;
        if (iKey < 0 || iKey > 2) {
            return null;
        }
        try {
            Object objSelected;
            if (iKey == 0 && (objSelected = this._cmbKey1EventAttribute.getSelectedItem()) instanceof SeisDataAttributeInfoViewModel) {
                vm = (SeisDataAttributeInfoViewModel)objSelected;
                return vm;
            }
            if (iKey == 1 && (objSelected = this._cmbKey2EventAttribute.getSelectedItem()) instanceof SeisDataAttributeInfoViewModel) {
                vm = (SeisDataAttributeInfoViewModel)objSelected;
                return vm;
            }
            if (iKey == 2 && (objSelected = this._cmbKey3EventAttribute.getSelectedItem()) instanceof SeisDataAttributeInfoViewModel) {
                vm = (SeisDataAttributeInfoViewModel)objSelected;
                return vm;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return vm;
    }

    void fillComboFromTable(JComboBox comboBox, Table_Abstract table) {
        try {
            if (comboBox == null) {
                return;
            }
            Object objSelected = comboBox.getSelectedItem();
            comboBox.removeAllItems();
            int nColumns = table.column_count();
            for (int iColumn = 0; iColumn < nColumns; ++iColumn) {
                String sColumnName = table.column_name(iColumn);
                comboBox.addItem(sColumnName);
            }
            if (objSelected instanceof String) {
                String sSelectedColumn = (String)objSelected;
                int nItemsInCombo = comboBox.getItemCount();
                int iSelectedItemIndex = -1;
                for (int i = 0; i < nItemsInCombo; ++i) {
                    String sItem = comboBox.getItemAt(i).toString();
                    if (!sItem.equals(sSelectedColumn)) continue;
                    iSelectedItemIndex = i;
                }
                if (iSelectedItemIndex >= 0) {
                    comboBox.setSelectedIndex(iSelectedItemIndex);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void fillComboAttrInfo(JComboBox comboBox, List<SeisDataAttributeInfoViewModel> vmList, String sDefaultValue) {
        try {
            if (comboBox == null) {
                return;
            }
            Object objSelected = comboBox.getSelectedItem();
            comboBox.removeAllItems();
            for (int i = 0; i < vmList.size(); ++i) {
                comboBox.addItem(vmList.get(i));
            }
            if (objSelected instanceof SeisDataAttributeInfoViewModel) {
                SeisDataAttributeInfoViewModel selectedVM = (SeisDataAttributeInfoViewModel)objSelected;
                XtParadigmSeisDataAttributeInfo selecteAttrInfo = selectedVM.getAttributeInfo();
                String sSelectedName = selectedVM.toString();
                int nItemsInCombo = comboBox.getItemCount();
                int iSelectedItemIndex = -1;
                for (int i = 0; i < nItemsInCombo; ++i) {
                    String sItem = comboBox.getItemAt(i).toString();
                    if (!sItem.equals(sSelectedName)) continue;
                    iSelectedItemIndex = i;
                }
                if (iSelectedItemIndex >= 0) {
                    comboBox.setSelectedIndex(iSelectedItemIndex);
                }
            } else if (sDefaultValue.length() > 0) {
                int nItemsInCombo = comboBox.getItemCount();
                int iSelectedItemIndex = -1;
                for (int i = 0; i < nItemsInCombo; ++i) {
                    String sItem = comboBox.getItemAt(i).toString();
                    if (!sItem.equals(sDefaultValue)) continue;
                    iSelectedItemIndex = i;
                }
                if (iSelectedItemIndex >= 0) {
                    comboBox.setSelectedIndex(iSelectedItemIndex);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean checkForErrors() {
        try {
            this._lblError.setText("");
            int nKeys = 0;
            for (int iKey = 0; iKey < 3; ++iKey) {
                boolean bKeyOK = this.getIsKeyValid(iKey);
                if (!bKeyOK) continue;
                ++nKeys;
            }
            if (nKeys == 0) {
                throw new Exception("Please check at least one key");
            }
            if (this._data.Solution.length() <= 0) {
                throw new Exception("Invalid solution ");
            }
            int iXtGeoModelIndex = -1;
            if (!this._bImportWidget && (iXtGeoModelIndex = this._tableModelProvider.getModelIndex(this._data.Solution)) < 0) {
                throw new Exception("Solution not found : " + this._data.Solution);
            }
            Table_Abstract modelTable = null;
            Table_Abstract geometryTable = null;
            if (this._sEchosModelName.equals("SHOT")) {
                if (!this._bImportWidget) {
                    modelTable = this._tableModelProvider.getShotModel(iXtGeoModelIndex);
                }
                geometryTable = this._tableModelProvider.getShotTable();
            } else if (this._sEchosModelName.equals("STATION")) {
                if (!this._bImportWidget) {
                    modelTable = this._tableModelProvider.getRecModel(iXtGeoModelIndex);
                }
                geometryTable = this._tableModelProvider.getRecTable();
            } else {
                throw new Exception("Invalid echos model name " + this._sEchosModelName);
            }
            if (!this._bImportWidget && modelTable == null) {
                throw new Exception("null model table");
            }
            if (geometryTable == null) {
                throw new Exception("null geometry table");
            }
            ArrayList<SeisDataAttributeInfoViewModel> attrVmArray = new ArrayList<SeisDataAttributeInfoViewModel>();
            ArrayList<SWIGTYPE_p_float> keyArray = new ArrayList<SWIGTYPE_p_float>();
            ArrayList<String> columnArray = new ArrayList<String>();
            XtParadigmSeisDataModelInfo modelInfo = XtParadigmSeisDataDB.echos_sdb_mdlget(this._sEchosLineName, this._sEchosModelName);
            if (modelInfo == null) {
                throw new Exception("Invalid model : " + this._sEchosModelName + " Line: " + this._sEchosLineName);
            }
            if (modelInfo.getResult() != 0) {
                throw new Exception("sdb_mdlget error: " + XtParadigmSeisDataDB.getErrorMessage(modelInfo.getResult()) + " Model : " + this._sEchosModelName + " Line " + this._sEchosLineName);
            }
            int nEchosRows = -999;
            for (int iKey = 0; iKey < 3; ++iKey) {
                boolean bKeyOK = this.getIsKeyValid(iKey);
                if (!bKeyOK) continue;
                SeisDataAttributeInfoViewModel attr = this.getEventAttributeForKey(iKey);
                String sColumn = this.getColumnForKey(iKey);
                XtParadigmSeisDataAttributeInfo attrInfo = attr.getAttributeInfo();
                int nRows = attrInfo.getNlocs();
                String sTmpAttribute = attrInfo.getAttribute();
                String sTmpEvent = attrInfo.getEvent();
                String sTmpLine = attrInfo.getLine();
                String sTmpModel = attrInfo.getModel();
                if (nEchosRows == -999) {
                    nEchosRows = nRows;
                } else if (nEchosRows != nRows) {
                    int nTmpRows2;
                    int nModelRows = modelInfo.getNlocs();
                    XtParadigmSeisDataDbAtr tmpAttr = XtParadigmSeisDataDB.echos_sdb_atrget(sTmpLine, sTmpModel, sTmpEvent, sTmpAttribute, "USE", nModelRows);
                    int nTmpRows = tmpAttr.getNlocs();
                    if (nTmpRows != (nTmpRows2 = attrInfo.getNlocs())) {
                        int jjj = 0;
                        ++jjj;
                    }
                    throw new Exception("inconsistent row count for model : " + this._sEchosModelName + " : " + Integer.toString(nEchosRows) + " : " + Integer.toString(nRows));
                }
                int nBufferSize = nRows * 2;
                SWIGTYPE_p_float floatArray = EchosInterface.new_floatArray(nBufferSize);
                Result result = new Result();
                XtParadigmSeisDataDB.echos_sdb_atrget_float(attrInfo, floatArray, nBufferSize, result);
                if (result.getErrorCode() != 0) {
                    throw new Exception("Error getting event attribute : " + attrInfo.getEvent() + " " + attrInfo.getAttribute() + " : " + result.getErrorMessage());
                }
                if (sColumn == null) {
                    throw new Exception("Invalid column for key " + Integer.toString(iKey));
                }
                keyArray.add(floatArray);
                columnArray.add(sColumn);
                attrVmArray.add(attr);
            }
            int nGeometryRows = geometryTable.row_count();
            HashMap_Integers<Integer> map = new HashMap_Integers<Integer>();
            int[] columnIndexes = new int[3];
            for (int i = 0; i < 3; ++i) {
                columnIndexes[i] = -1;
            }
            for (int iKey = 0; iKey < nKeys; ++iKey) {
                int iIndex;
                String sColumn = (String)columnArray.get(iKey);
                columnIndexes[iKey] = iIndex = geometryTable.column_indexOfColumn(sColumn);
            }
            boolean bUniqueMap = true;
            for (int i = 0; i < nGeometryRows; ++i) {
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                if (columnIndexes[0] >= 0) {
                    iKeyVal1 = geometryTable.getInt(i, columnIndexes[0]);
                }
                if (columnIndexes[1] >= 0) {
                    iKeyVal2 = geometryTable.getInt(i, columnIndexes[1]);
                }
                if (columnIndexes[2] >= 0) {
                    iKeyVal3 = geometryTable.getInt(i, columnIndexes[2]);
                }
                if (!map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3)) {
                    map.put(i, iKeyVal1, iKeyVal2, iKeyVal3);
                    continue;
                }
                bUniqueMap = false;
            }
            int nMatches = 0;
            int nMissing = 0;
            for (int iEchosRow = 0; iEchosRow < nEchosRows; ++iEchosRow) {
                float fVal;
                int iKeyVal1 = 0;
                int iKeyVal2 = 0;
                int iKeyVal3 = 0;
                if (columnIndexes[0] >= 0) {
                    fVal = EchosInterface.floatArray_getitem((SWIGTYPE_p_float)keyArray.get(0), iEchosRow);
                    iKeyVal1 = (int)fVal;
                }
                if (columnIndexes[1] >= 0) {
                    fVal = EchosInterface.floatArray_getitem((SWIGTYPE_p_float)keyArray.get(1), iEchosRow);
                    iKeyVal2 = (int)fVal;
                }
                if (columnIndexes[2] >= 0) {
                    fVal = EchosInterface.floatArray_getitem((SWIGTYPE_p_float)keyArray.get(2), iEchosRow);
                    iKeyVal3 = (int)fVal;
                }
                if (map.containsKey(iKeyVal1, iKeyVal2, iKeyVal3)) {
                    ++nMatches;
                    continue;
                }
                ++nMissing;
            }
            boolean bUseDefaultValue = this.getUseDefaultValue();
            if (!bUseDefaultValue) {
                boolean bOk;
                boolean bl = bOk = nMatches == nEchosRows && nGeometryRows == nEchosRows;
                if (!bOk) {
                    throw new Exception("Missing Keys: NumEchosRows = " + Integer.toString(nEchosRows) + " NumRows = " + Integer.toString(nGeometryRows) + " NumMatches = " + Integer.toString(nMatches) + " NumMissing = " + Integer.toString(nMissing));
                }
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this._lblError.setText("ERROR : " + error.getMessage());
            return false;
        }
    }

    public void setSelectedComboValue(JComboBox combo, String sValue) {
        try {
            int nItems = combo.getItemCount();
            int iSelectedIndex = -1;
            sValue = sValue.toUpperCase();
            for (int i = 0; i < nItems; ++i) {
                String sItem = combo.getItemAt(i).toString();
                if (!(sItem = sItem.toUpperCase()).equals(sValue)) continue;
                iSelectedIndex = i;
            }
            if (iSelectedIndex >= 0) {
                combo.setSelectedIndex(iSelectedIndex);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public XtEchosColumnMap getColumnMap() {
        XtEchosColumnMap map = new XtEchosColumnMap();
        try {
            XtEchosColumnMapEntry entry;
            String sAttribute;
            String sEvent;
            String[] parts;
            String sEventAttribute;
            String sColumn;
            map.setModelName(this._sEchosModelName);
            if (this._sEchosModelName.equals("SHOT")) {
                map.setTableName("Shot");
            } else if (this._sEchosModelName.equals("STATION")) {
                map.setTableName("Receiver");
            }
            float fDefaultValue = this.getDefaultValue();
            boolean bUseDefaultValue = this.getUseDefaultValue();
            if (this._cbUseKey1.isSelected()) {
                sColumn = this._cmbKey1Column.getSelectedItem().toString();
                sEventAttribute = this._cmbKey1EventAttribute.getSelectedItem().toString();
                parts = sEventAttribute.split(" ");
                if (parts.length == 2) {
                    sEvent = parts[0];
                    sAttribute = parts[1];
                    entry = new XtEchosColumnMapEntry(sColumn, sEvent, sAttribute);
                    entry.setDefaultValue(fDefaultValue);
                    entry.setUseDefaultValueOnError(bUseDefaultValue);
                    map.keyEntries().add(entry);
                }
            }
            if (this._cbUseKey2.isSelected()) {
                sColumn = this._cmbKey2Column.getSelectedItem().toString();
                sEventAttribute = this._cmbKey2EventAttribute.getSelectedItem().toString();
                parts = sEventAttribute.split(" ");
                if (parts.length == 2) {
                    sEvent = parts[0];
                    sAttribute = parts[1];
                    entry = new XtEchosColumnMapEntry(sColumn, sEvent, sAttribute);
                    entry.setDefaultValue(fDefaultValue);
                    entry.setUseDefaultValueOnError(bUseDefaultValue);
                    map.keyEntries().add(entry);
                }
            }
            if (this._cbUseKey3.isSelected()) {
                sColumn = this._cmbKey3Column.getSelectedItem().toString();
                sEventAttribute = this._cmbKey3EventAttribute.getSelectedItem().toString();
                parts = sEventAttribute.split(" ");
                if (parts.length == 2) {
                    sEvent = parts[0];
                    sAttribute = parts[1];
                    entry = new XtEchosColumnMapEntry(sColumn, sEvent, sAttribute);
                    entry.setDefaultValue(fDefaultValue);
                    entry.setUseDefaultValueOnError(bUseDefaultValue);
                    map.keyEntries().add(entry);
                }
            }
            if (!this._bImportWidget) {
                sValueColumn = this._cmbOutputColumn.getSelectedItem().toString();
                String sValueEvent = this._txtOutputEchosEvent.getText();
                String sValueAttribute = this._txtOutputEchosAttribute.getText();
                XtEchosColumnMapEntry valueEntry = new XtEchosColumnMapEntry(sValueColumn, sValueEvent, sValueAttribute);
                valueEntry.setDefaultValue(fDefaultValue);
                valueEntry.setUseDefaultValueOnError(bUseDefaultValue);
                map.valueEntries().add(valueEntry);
            } else {
                sValueColumn = this._txtInputColumn.getText();
                sEventAttribute = this._cmbEchosInputEventAttribute.getSelectedItem().toString();
                parts = sEventAttribute.split(" ");
                if (parts.length == 2) {
                    sEvent = parts[0];
                    sAttribute = parts[1];
                    XtEchosColumnMapEntry valueEntry = new XtEchosColumnMapEntry(sValueColumn, sEvent, sAttribute);
                    valueEntry.setDefaultValue(fDefaultValue);
                    valueEntry.setUseDefaultValueOnError(bUseDefaultValue);
                    map.valueEntries().add(valueEntry);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return map;
    }

    public void setColumnMap(XtEchosColumnMap map) {
        try {
            String sEventAttr;
            XtEchosColumnMapEntry entry;
            List<XtEchosColumnMapEntry> keyEntries = map.keyEntries();
            List<XtEchosColumnMapEntry> valueEntries = map.valueEntries();
            this._cbUseKey1.setSelected(false);
            this._cbUseKey2.setSelected(false);
            this._cbUseKey3.setSelected(false);
            if (keyEntries.size() >= 1) {
                entry = keyEntries.get(0);
                sEventAttr = entry.getEchosEvent() + " " + entry.getEchosAttribute();
                this.setSelectedComboValue(this._cmbKey1Column, entry.getColumnName());
                this.setSelectedComboValue(this._cmbKey1EventAttribute, sEventAttr);
                this._cbUseKey1.setSelected(true);
            }
            if (keyEntries.size() >= 2) {
                entry = keyEntries.get(1);
                sEventAttr = entry.getEchosEvent() + " " + entry.getEchosAttribute();
                this.setSelectedComboValue(this._cmbKey2Column, entry.getColumnName());
                this.setSelectedComboValue(this._cmbKey2EventAttribute, sEventAttr);
                this._cbUseKey2.setSelected(true);
            }
            if (keyEntries.size() >= 3) {
                entry = keyEntries.get(2);
                sEventAttr = entry.getEchosEvent() + " " + entry.getEchosAttribute();
                this.setSelectedComboValue(this._cmbKey3Column, entry.getColumnName());
                this.setSelectedComboValue(this._cmbKey3EventAttribute, sEventAttr);
                this._cbUseKey3.setSelected(true);
            }
            if (valueEntries.size() > 0) {
                if (!this._bImportWidget) {
                    valueEntry = valueEntries.get(0);
                    this.setSelectedComboValue(this._cmbOutputColumn, valueEntry.getColumnName());
                    this._txtOutputEchosEvent.setText(valueEntry.getEchosEvent());
                    this._txtOutputEchosAttribute.setText(valueEntry.getEchosAttribute());
                } else {
                    valueEntry = valueEntries.get(0);
                    String sColumnName = valueEntry.getColumnName();
                    String sEvent = valueEntry.getEchosEvent();
                    String sAttribute = valueEntry.getEchosAttribute();
                    String sEventAttribute = sEvent + " " + sAttribute;
                    this.setSelectedComboValue(this._cmbEchosInputEventAttribute, sEventAttribute);
                    this._txtInputColumn.setText(sColumnName);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    public void setSolution(String sSelectedSolution) {
        try {
            if (this._sEchosModelName.equals("SHOT")) {
                int iModelIndex = this._tableModelProvider.getModelIndex(sSelectedSolution);
                Table_Abstract shotResults = this._tableModelProvider.getShotModel(iModelIndex);
                this.setXtGeoResultsTable(shotResults);
            } else if (this._sEchosModelName.equals("STATION")) {
                int iModelIndex = this._tableModelProvider.getModelIndex(sSelectedSolution);
                Table_Abstract recResults = this._tableModelProvider.getRecModel(iModelIndex);
                this.setXtGeoResultsTable(recResults);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

