/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Echos.XtParadigmEposUser;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Windows.Echos.EchosDatabaseImportExportSharedData;
import com.PecosLibrary.Windows.Echos.EchosSurveysWidget;
import com.PecosLibrary.Windows.Wizard.ISimpleWizardPage;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public class Page_EchosSurvey
extends LinearLayoutWidget
implements ISimpleWizardPage,
ActionListener,
GenericObjectListener.Listener {
    protected EchosDatabaseImportExportSharedData _data;
    protected EchosSurveysWidget m_echosSurveyWidget;
    protected JLabel m_labelError;

    public Page_EchosSurvey(EchosDatabaseImportExportSharedData data) {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this._data = data;
            this.m_echosSurveyWidget = new EchosSurveysWidget();
            this.addComponent(this.m_echosSurveyWidget, 0);
            this.m_labelError = new JLabel();
            this.addComponent(this.m_labelError, 0);
            this.m_labelError.setForeground(Color.red);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void leavingPage() {
    }

    @Override
    public void activatePage() {
        try {
            boolean bValidSurvey;
            this.m_labelError.setText("");
            boolean bl = bValidSurvey = this._data.EchosSurvey.length() > 0 && this._data.EchosHost.length() > 0;
            if (bValidSurvey) {
                this.m_echosSurveyWidget.setSurvey(this._data.EchosSurvey, this._data.EchosHost);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean okayToGoToNextPage() {
        try {
            this.m_labelError.setText("");
            String sName = this.m_echosSurveyWidget.getSelectedName();
            String sHost = this.m_echosSurveyWidget.getSelectedHost();
            if (sName.length() == 0 || sHost.length() == 0) {
                this.m_labelError.setText("Please select a survey");
                return false;
            }
            String sUser = XtParadigmEposUser.getCurrentEposUser();
            String sNameAtHost = sName + "@" + sHost;
            boolean bIsReadable = XtParadigmSurvey.IsReadable(sNameAtHost, sUser);
            if (!bIsReadable) {
                this.m_labelError.setText("Survey '" + sNameAtHost + "' is not readable by user '" + sUser + "'");
                return false;
            }
            this._data.EchosHost = sHost;
            this._data.EchosSurvey = sName;
            this._data.EchosLineID = -1;
            this._data.EchosSurveyType = this.m_echosSurveyWidget.getSelectedSurveyType();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void dialogJustOpened() {
    }

    @Override
    public GenericObjectListener listener() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.handleGenericObjectListener(null, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }
}

