/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.Echos;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.Echos.XtEchos;
import com.PecosLibrary.Echos.XtLineInfo;
import com.PecosLibrary.Echos.XtParadigmFileDescr;
import com.PecosLibrary.Echos.XtParadigmFileRec;
import com.PecosLibrary.Echos.XtParadigmFileRecList;
import com.PecosLibrary.Echos.XtParadigmSurvey;
import com.PecosLibrary.Windows.Echos.ForcedListSelectionModel;
import com.PecosLibrary.Windows.Shared.ScrollTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EchosFilesWidget
extends LinearLayoutWidget
implements ActionListener,
GenericObjectListener.Listener,
ListSelectionListener {
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected Table_SimpleModel m_tableModel;
    protected ScrollTable m_scrollTable;
    protected int m_indexName;
    protected int m_indexPath;
    protected int m_indexLineID;
    protected int m_indexLineName;
    protected int m_indexSize;
    protected int m_indexAxisType;
    protected int m_indexPrimaryKey;
    ArrayList<String> _fileNameList = new ArrayList();
    ArrayList<Long> _fileIdList = new ArrayList();
    ArrayList<Integer> _lineIdList = new ArrayList();
    int _iSelectedFile = -1;

    public EchosFilesWidget() {
        super(LinearLayoutWidget.Direction.Vertical, 3, null);
        try {
            this.m_scrollTable = new ScrollTable();
            this.addComponent(this.m_scrollTable, 10);
            this.m_fileTable.setName("Files");
            this.m_indexName = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_indexLineName = this.m_fileTable.column_append("LineName", DataType.Text);
            this.m_indexSize = this.m_fileTable.column_append("Size(GB)", DataType.Text);
            this.m_indexPrimaryKey = this.m_fileTable.column_append("Ensemble", DataType.Text);
            this.m_tableModel = new Table_SimpleModel(this.m_fileTable);
            this.m_scrollTable.table().setModel(this.m_tableModel);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexName).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexPath).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexLineName).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexSize).setMinWidth(130);
            this.m_scrollTable.table().getColumnModel().getColumn(this.m_indexPrimaryKey).setMinWidth(130);
            this.m_scrollTable.table().setSelectionModel(new ForcedListSelectionModel());
            this.m_scrollTable.table().getSelectionModel().addListSelectionListener(this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int[] getSelectedRows() {
        int[] rows = null;
        try {
            rows = this.m_scrollTable.table().getSelectedRows();
        }
        catch (Exception error) {
            rows = null;
        }
        return rows;
    }

    public String getLname(int idx) {
        String sName = "";
        if (idx >= 0 && idx < this._fileNameList.size()) {
            sName = this._fileNameList.get(idx);
        }
        return sName;
    }

    public long getFileID(int idx) {
        long id = -1L;
        if (idx >= 0 && idx < this._fileIdList.size()) {
            id = this._fileIdList.get(idx);
        }
        return id;
    }

    public int getLineID(int idx) {
        int id = -1;
        if (idx >= 0 && idx < this._fileIdList.size()) {
            id = this._lineIdList.get(idx);
        }
        return id;
    }

    public void reloadTable(XtParadigmSurvey survey) {
        this._iSelectedFile = -1;
        try {
            this._fileNameList.clear();
            this._fileIdList.clear();
            this._lineIdList.clear();
            this.m_scrollTable.table().clearSelection();
            if (XtEchos.ParadigmEnvironment == null) {
                throw new Exception("uninitialized Paradigm Environment");
            }
            if (XtEchos.ParadigmEnvironment != null) {
                while (this.m_fileTable.row_count() > 0) {
                    this.m_fileTable.row_delete(0);
                }
                XtParadigmFileRecList fileRecs = survey.getFileRecList();
                DecimalFormat df = new DecimalFormat("#.00");
                int nFiles = fileRecs.size();
                int nLines = survey.getNumLineInfo();
                for (int i = 0; i < nFiles; ++i) {
                    boolean bFileOK;
                    XtParadigmFileRec fileRec = fileRecs.get(i);
                    String sFileName = fileRec.GetFileName();
                    String sFullPath = fileRec.GetFullPath();
                    int iLineID = fileRec.GetLineID();
                    String sLName = fileRec.GetLname();
                    long iSize = fileRec.GetSize();
                    long iFileID = fileRec.GetFileID();
                    XtParadigmFileDescr readDesc = fileRec.ReadFileDescr();
                    int iAxisType = readDesc.GetParameterDsIgAxisType();
                    String sAxisType = readDesc.GetParameterNameDsIgAxisType();
                    boolean bl = bFileOK = iAxisType != 0;
                    if (!bFileOK) continue;
                    String sLineName = "";
                    for (int iLine = 0; iLine < nLines; ++iLine) {
                        XtLineInfo lineInfo = survey.getLineInfo(iLine);
                        if (lineInfo.getId() != (long)iLineID) continue;
                        sLineName = lineInfo.getName();
                    }
                    int row = this.m_fileTable.row_increment();
                    this.m_fileTable.putString(row, this.m_indexName, sLName);
                    this.m_fileTable.putString(row, this.m_indexLineName, sLineName);
                    double nGB = (double)iSize / 1.073741824E9;
                    String sGB = df.format(nGB);
                    this.m_fileTable.putString(row, this.m_indexSize, sGB);
                    this.m_fileTable.putString(row, this.m_indexPrimaryKey, sAxisType);
                    this._fileIdList.add(iFileID);
                    this._fileNameList.add(sLName);
                    this._lineIdList.add(iLineID);
                }
                this.m_tableModel.fireTableDataChanged();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int[] getSelectedFileIndices() {
        int[] rows = this.getSelectedRows();
        return rows;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        try {
            int iFirstIndex = e.getFirstIndex();
            int iLastIndex = e.getLastIndex();
            int iPreviousFile = this._iSelectedFile;
            if (iFirstIndex == iLastIndex) {
                this._iSelectedFile = iFirstIndex;
            }
            this.firePropertyChange("FilesWidget", iPreviousFile, this._iSelectedFile);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

