/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Windows.ASCII;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FontChanger;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Data.Table_SimpleModel;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.ASCII.AsciiColumnDefWidgets;
import com.PecosLibrary.Windows.ASCII.AsciiFileWidget;
import com.PecosLibrary.Windows.ApplicationFrames.INumberedWidget;
import com.PecosLibrary.Windows.ApplicationFrames.ISaveableFrame;
import com.PecosLibrary.Windows.Shared.ParameterTreeWidgetManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class AsciiImportWidget
extends JSplitPane
implements INumberedWidget,
GenericObjectListener.Listener,
ActionListener,
ISaveableFrame {
    protected AsciiColumnDefWidgets m_asciiColumnDefWidgets;
    protected JTabbedPane m_rightTabs = new JTabbedPane();
    protected Table_Abstract m_importedTable = null;
    protected JTable m_tableImported = new JTable();
    protected JButton m_btnCreateImportTable;
    protected JLabel m_lblImportStatus = new JLabel("", 0);
    protected JButton m_btnExportToDatabase;
    protected JTextField m_txtDatabaseTableName = new JTextField("TableName");
    protected ParameterTree m_parameters = new ParameterTree();
    protected String m_paramFileName;
    protected ParameterTreeWidgetManager m_paramManager = new ParameterTreeWidgetManager();
    protected int m_widgetNumber = 1;
    protected boolean m_ignorePaintEvent = false;
    protected double m_alpha = 0.001;

    @Override
    public String TAB_NAME() {
        return "com.PecosLibrary.Windows.ASCII.AsciiImportWidget";
    }

    @Override
    public String TAB_LABEL() {
        return "ASCII";
    }

    @Override
    public String TAB_DESCRIPTION() {
        return "ASCII import";
    }

    @Override
    public boolean TAB_UNIQUE() {
        return false;
    }

    public AsciiImportWidget() {
        super(1);
        try {
            this.m_asciiColumnDefWidgets = new AsciiColumnDefWidgets(true, true, null);
            this.m_asciiColumnDefWidgets.listener().addListener(this);
            this.setLeftComponent(this.createLeft());
            this.setRightComponent(this.createRight());
            Tools_FontChanger.changeSizeOfFont(this, -2, null, true);
            this.m_asciiColumnDefWidgets.listener().addListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public int getWidgetNumber() {
        return this.m_widgetNumber;
    }

    @Override
    public void setWidgetNumber(int number) {
        this.m_widgetNumber = number;
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            String root = p.guiOptionsPath() + "/ASCII" + Integer.toString(this.m_widgetNumber);
            this.m_paramFileName = root + "Options.xml";
            this.m_parameters.read(this.m_paramFileName);
            String fileName = this.m_parameters.string_get("FileName", "");
            this.m_asciiColumnDefWidgets.setColumnDefFileName(fileName);
            this.m_asciiColumnDefWidgets.asciiImportData().read(fileName);
            int row = this.m_parameters.int_get("FirstRow", 1);
            this.m_asciiColumnDefWidgets.setFirstValidLine(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected JComponent createLeft() {
        try {
            return this.m_asciiColumnDefWidgets.leftWidget();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createRight() {
        try {
            this.m_rightTabs.addTab("ASCII file selection", this.m_asciiColumnDefWidgets.rightWidget());
            this.m_rightTabs.addTab("Import options", this.createImportWidget());
            return this.m_rightTabs;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected JComponent createImportWidget() {
        try {
            LinearLayoutWidget main = LinearLayoutWidget.vert(3, null);
            LinearLayoutWidget sub = main.createHorizontal(3, null, 0);
            this.m_btnCreateImportTable = sub.createButton("Create table using current ASCII file", this, 0);
            sub.addComponent(this.m_lblImportStatus, 10);
            main.addComponent(new JScrollPane(this.m_tableImported), 10);
            this.m_tableImported.setGridColor(Color.LIGHT_GRAY);
            this.m_tableImported.setShowGrid(true);
            sub = main.createHorizontal(3, null, 0);
            this.m_btnExportToDatabase = sub.createButton("Save table in database", this, 0);
            sub.addComponent(new JLabel("Database table name:"), 0);
            sub.addComponent(this.m_txtDatabaseTableName, 1);
            sub.addStretch(8);
            this.clearImportedTable();
            return main;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void createImportedTable() {
        try {
            this.clearImportedTable();
            if (this.m_asciiColumnDefWidgets.asciiFileWidget().lines().size() < 1) {
                this.m_lblImportStatus.setText("You must select an ASCII file first");
                this.m_lblImportStatus.setForeground(Color.red);
                return;
            }
            ArrayList<String> lines = this.m_asciiColumnDefWidgets.asciiFileWidget().lines();
            if (this.m_asciiColumnDefWidgets.asciiImportData().columns().size() < 1) {
                this.m_lblImportStatus.setText("You must define at least one column first");
                this.m_lblImportStatus.setForeground(Color.red);
                return;
            }
            this.m_importedTable = new Table_Memory();
            if (!this.m_asciiColumnDefWidgets.asciiImportData().prepTable(this.m_importedTable)) {
                this.m_importedTable = null;
                this.m_lblImportStatus.setText("Column definitions not valid");
                this.m_lblImportStatus.setForeground(Color.red);
                return;
            }
            int firstRow = this.m_asciiColumnDefWidgets.firstValidLine() - 1;
            for (int row = firstRow = Math.max(firstRow, 0); row < lines.size(); ++row) {
                String s = lines.get(row);
                if (s.isEmpty()) continue;
                this.m_asciiColumnDefWidgets.asciiImportData().addRow(this.m_importedTable, s);
            }
            if (this.m_importedTable.row_count() < 1) {
                this.m_importedTable = null;
                this.m_lblImportStatus.setText("No valid rows in ASCII file");
                this.m_lblImportStatus.setForeground(Color.red);
                return;
            }
            this.m_lblImportStatus.setText("Row count: " + this.m_importedTable.row_count() + " === NOTE, this table is NOT automatically saved in the database!");
            this.m_lblImportStatus.setForeground(Color.blue);
            this.m_tableImported.setModel(new Table_SimpleModel(this.m_importedTable));
            this.m_btnExportToDatabase.setEnabled(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void exportTable() {
        try {
            if (this.m_importedTable == null) {
                this.clearImportedTable();
                return;
            }
            String tableName = this.m_txtDatabaseTableName.getText();
            tableName = Tools_Strings.removeSpace(tableName);
            tableName = Tools_Strings.removeCrap(tableName);
            tableName = Tools_Strings.removeMostSpecialChars(tableName);
            this.m_txtDatabaseTableName.setText(tableName);
            if (tableName.length() < 2) {
                JOptionPane.showMessageDialog(null, "Table name too short", "Invalid table name", 0);
                return;
            }
            IDatabaseConnection db = RefractionStaticsProject.singleton().importDatabase();
            if (db.tableExists(tableName)) {
                JOptionPane.showMessageDialog(null, "Table already exists", "Table already exists", 0);
                return;
            }
            this.m_importedTable.setName(tableName);
            int index = this.m_importedTable.column_append(tableName + "ID", DataType.Int);
            for (int r = 0; r < this.m_importedTable.row_count(); ++r) {
                this.m_importedTable.putInt(r, index, r + 1000);
            }
            db.createDatabaseTable(this.m_importedTable);
            db.appendTable(this.m_importedTable, 0);
            this.createImportedTable();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void clearImportedTable() {
        try {
            this.m_lblImportStatus.setText(" ");
            this.m_tableImported.setModel(new DefaultTableModel());
            this.m_importedTable = null;
            this.m_btnExportToDatabase.setEnabled(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void save() {
        try {
            String fileName = this.m_asciiColumnDefWidgets.columnDefFileName();
            if (fileName.isEmpty()) {
                return;
            }
            this.m_asciiColumnDefWidgets.asciiImportData().save(fileName);
            this.m_asciiColumnDefWidgets.asciiFileWidget().forceImagePaint();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_btnExportToDatabase) {
                this.exportTable();
                return;
            }
            if (e.getSource() == this.m_btnCreateImportTable) {
                this.createImportedTable();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void handleColumnsSelected(AsciiFileWidget sender, int col1, int col2) {
    }

    protected void saveAll() {
        try {
            this.m_parameters.string_put("FileName", this.m_asciiColumnDefWidgets.columnDefFileName());
            this.m_parameters.save(this.m_paramFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            if (sender == this.m_asciiColumnDefWidgets) {
                this.saveAll();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

