/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Well;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Volume.VolumeProject;

public class Tools_WellTop {
    public static IDatabaseConnection getWellTopDatabase() {
        return VolumeProject.singleton().getWellTopDatabase();
    }

    public static void fillTimeGrid(Grid3D grid, String tableName, String colNameX, String colNameY, String colNameZ, double velocity) {
        try {
            Table_Abstract table = Tools_WellTop.loadSurfaceTable(tableName, colNameX, colNameY, colNameZ);
            int len = table.row_count();
            if (len < 1) {
                return;
            }
            double[] x = new double[len];
            double[] y = new double[len];
            double[] z = new double[len];
            int indexX = table.column_indexOfColumn("X");
            int indexY = table.column_indexOfColumn("Y");
            int indexZ = table.column_indexOfColumn("Z");
            for (int n = 0; n < len; ++n) {
                double time;
                x[n] = table.getDouble(n, indexX);
                y[n] = table.getDouble(n, indexY);
                double elev = table.getDouble(n, indexZ);
                z[n] = time = -2000.0 * elev / velocity;
            }
            double sum = 0.0;
            float[][] data = grid.data();
            int minInline = grid.inlineMin();
            int minCrossline = grid.crosslineMin();
            for (int i = grid.inlineMin(); i <= grid.inlineMax(); ++i) {
                for (int c = grid.crosslineMin(); c <= grid.crosslineMax(); ++c) {
                    double gx = grid.getWorldX(i, c);
                    double gy = grid.getWorldY(i, c);
                    double sum1 = 0.0;
                    double sum2 = 1.0E-60;
                    for (int n = 0; n < len; ++n) {
                        double dx = x[n] - gx;
                        double dy = y[n] - gy;
                        double w = 1000.0 / (1000.0 + dx * dx + dy * dy);
                        w *= w;
                        sum1 += w * z[n];
                        sum2 += w;
                    }
                    double v = sum1 / sum2;
                    sum += v;
                    data[i - minInline][c - minCrossline] = (float)(sum1 / sum2);
                }
            }
            double avg = sum / (double)(grid.numInline() * grid.numCrossline());
            for (int i = grid.inlineMin(); i <= grid.inlineMax(); ++i) {
                for (int c = grid.crosslineMin(); c <= grid.crosslineMax(); ++c) {
                    data[i - minInline][c - minCrossline] = data[i - minInline][c - minCrossline] - (float)avg;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Grid3D getTimeGrid(String tableName, String colNameX, String colNameY, String colNameZ, double velocity) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D();
            Tools_WellTop.fillTimeGrid(grid, tableName, colNameX, colNameY, colNameZ, velocity);
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public static Table_Abstract loadSurfaceTable(String tableName, String colNameX, String colNameY, String colNameZ) {
        try {
            if (!Tools_WellTop.getWellTopDatabase().tableExists(tableName)) {
                return null;
            }
            String sql = String.format("SELECT %s, %s, %s FROM %s", colNameX, colNameY, colNameZ, tableName);
            Table_Abstract table = Tools_WellTop.getWellTopDatabase().extractTableDataUsingQuery(tableName, sql, Pecos.MaxQueryRowCount);
            Table_Memory surfaceTable = new Table_Memory();
            surfaceTable.setName("Surface");
            int indexSurfaceX = surfaceTable.column_append("X", DataType.Double);
            int indexSurfaceY = surfaceTable.column_append("Y", DataType.Double);
            int indexSurfaceZ = surfaceTable.column_append("Z", DataType.Double);
            int indexSurfaceH = surfaceTable.column_append(colNameZ, DataType.Double);
            int indexX = table.column_indexOfColumn(colNameX);
            int indexY = table.column_indexOfColumn(colNameY);
            int indexZ = table.column_indexOfColumn(colNameZ);
            double sum = 0.0;
            for (int n = 0; n < table.row_count(); ++n) {
                if (!table.canConvertToDouble(n, indexX) || !table.canConvertToDouble(n, indexY) || !table.canConvertToDouble(n, indexZ)) continue;
                int row = surfaceTable.row_increment();
                double z = table.getDouble(n, indexZ);
                sum += z;
                surfaceTable.putDouble(row, indexSurfaceX, table.getDouble(n, indexX));
                surfaceTable.putDouble(row, indexSurfaceY, table.getDouble(n, indexY));
                surfaceTable.putDouble(row, indexSurfaceZ, z);
                surfaceTable.putDouble(row, indexSurfaceH, z);
            }
            double average = sum / (1.0E-10 + (double)surfaceTable.row_count());
            for (int row = 0; row < surfaceTable.row_count(); ++row) {
                double z = surfaceTable.getDouble(row, indexSurfaceZ);
                surfaceTable.putDouble(row, indexSurfaceZ, z - average);
            }
            return surfaceTable;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

