/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosCore.Data.Model.Model2D;
import com.PecosCore.Data.Model.Model3D_Profile;
import com.PecosCore.Data.Model.Model3D_Profile_SimpleAnalysis;
import com.PecosLibrary.WaveEquation.Model3D;
import java.util.Random;

public class Tools_Model {
    protected double[] m_tempX;
    protected double[] m_tempY;
    protected double[] m_tempZ;
    protected int m_tempCount = 0;
    protected double m_tempBuffer;
    protected Model2D m_model2D;

    public static void testAll() {
        Tools_Model.darrell();
    }

    public static Model3D createTestModel() {
        try {
            Model3D model = new Model3D();
            Random rand = new Random();
            double nodeSizeH = 25.0;
            double nodeSizeZ = 25.0;
            int nodeCountX = 200;
            int nodeCountY = 200;
            int nodeCountZ = 200;
            double originX = 0.0;
            double originY = 0.0;
            double originZ = 0.0;
            double angle = 0.0;
            model.setOrigin(originX, originY, originZ);
            model.setAngle(angle);
            model.setNodeCounts(nodeCountX, nodeCountY, nodeCountZ);
            float vh = 10000.0f;
            float vz = 12000.0f;
            model.array_setValue("VelocityZ", vz);
            model.array_setValue("VelocityH", vh);
            model.array_setValue("VelAngle", 0.0f);
            model.array_setValue("VelAnis", 0.0f);
            float maxError = 0.0f;
            Model3D_Profile profile = new Model3D_Profile();
            double maxZ = model.maximumGridZ();
            long start = System.currentTimeMillis();
            Model3D_Profile_SimpleAnalysis analysis = new Model3D_Profile_SimpleAnalysis();
            for (int iter = 0; iter < 100; ++iter) {
                double x1 = rand.nextDouble() * model.maximumGridX();
                double y1 = rand.nextDouble() * model.maximumGridY();
                double x2 = rand.nextDouble() * model.maximumGridX();
                double y2 = rand.nextDouble() * model.maximumGridY();
                model.profile_Prepare(profile, x1, y1, x2, y2);
                model.profile_CopyDataToProfile(profile, "VelocityZ");
                model.profile_CopyDataToProfile(profile, "VelocityH");
                model.profile_CopyDataToProfile(profile, "VelAngle");
                model.profile_CopyDataToProfile(profile, "VelAnis");
                double fromZ = maxZ * (0.02 + 0.96 * rand.nextDouble());
                double toZ = maxZ * (0.02 + 0.96 * rand.nextDouble());
                analysis.forward_method1(profile, fromZ, toZ);
                double dh = profile.offset();
                double dz = fromZ - toZ;
                double azimuth = Math.atan2(dz, dh);
                double cos2 = Math.cos(azimuth) * Math.cos(azimuth);
                double sin2 = Math.sin(azimuth) * Math.sin(azimuth);
                double dist = Math.sqrt(dh * dh + dz * dz);
                double v = Math.sqrt(cos2 * (double)vh * (double)vh + sin2 * (double)vz * (double)vz);
                double predTime = 1000.0 * dist / v;
                double modelTime = 1000.0 * analysis.minTime();
                long end = System.currentTimeMillis() - start;
                double perDiff = 100.0 * (predTime - modelTime) / predTime;
                String s = String.format("%2d  %4d  predicted=%8.4f  model=%8.4f  diff: %6.4f  %%diff: %5.3f  dh=%7.2f  dz=%8.2f", iter, end, predTime, modelTime, predTime - modelTime, perDiff, dh, dz);
                System.out.println(s);
            }
            return model;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    public static void darrell() {
        try {
            Model3D model = new Model3D();
            Random rand = new Random();
            double nodeSizeH = 25.0;
            double nodeSizeZ = 25.0;
            int nodeCountX = 200;
            int nodeCountY = 200;
            int nodeCountZ = 200;
            int numProfiles = 200;
            double originX = 0.0;
            double originY = 0.0;
            double originZ = 0.0;
            double angle = 0.0;
            model.setOrigin(originX, originY, originZ);
            model.setAngle(angle);
            model.setNodeCounts(nodeCountX, nodeCountY, nodeCountZ);
            float vh = 10000.0f;
            float vz = 12000.0f;
            model.array_setValue("VelocityZ", vz);
            model.array_setValue("VelocityH", vh);
            model.array_setValue("VelAngle", 0.0f);
            model.array_setValue("VelAnis", 0.0f);
            Model3D_Profile profile = new Model3D_Profile();
            double maxZ = model.maximumGridZ();
            long start = System.currentTimeMillis();
            Model3D_Profile_SimpleAnalysis analysis = new Model3D_Profile_SimpleAnalysis();
            for (int iter = 0; iter < numProfiles; ++iter) {
                double x1 = rand.nextDouble() * model.maximumGridX();
                double y1 = rand.nextDouble() * model.maximumGridY();
                double x2 = rand.nextDouble() * model.maximumGridX();
                double y2 = rand.nextDouble() * model.maximumGridY();
                model.profile_Prepare(profile, x1, y1, x2, y2);
                model.profile_CopyDataToProfile(profile, "VelocityZ");
                model.profile_CopyDataToProfile(profile, "VelocityH");
                model.profile_CopyDataToProfile(profile, "VelAngle");
                model.profile_CopyDataToProfile(profile, "VelAnis");
                double fromZ = maxZ * (0.02 + 0.96 * rand.nextDouble());
                double toZ = maxZ * (0.02 + 0.96 * rand.nextDouble());
                analysis.forward_method2(profile, fromZ, toZ);
                double dh = profile.offset();
                double dz = fromZ - toZ;
                double azimuth = Math.atan2(dz, dh);
                double cos2 = Math.cos(azimuth) * Math.cos(azimuth);
                double sin2 = Math.sin(azimuth) * Math.sin(azimuth);
                double dist = Math.sqrt(dh * dh + dz * dz);
                double v = Math.sqrt(cos2 * (double)vh * (double)vh + sin2 * (double)vz * (double)vz);
                double predTime = 1000.0 * Math.sqrt(dh * dh / (double)(vh * vh) + dz * dz / (double)(vz * vz));
                double modelTime = 1000.0 * analysis.minTime();
                long end = System.currentTimeMillis() - start;
                double perDiff = 100.0 * (predTime - modelTime) / predTime;
                String s = String.format("profile: %3d  time(ms): %4d  predicted=%8.4f  model=%8.4f  diff: %7.4f  %%diff: %6.3f  dh=%7.2f  dz=%8.2f", iter, end, predTime, modelTime, predTime - modelTime, perDiff, dh, dz);
                System.out.println(s);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public static void test() {
        try {
            Model2D model = new Model2D();
            Tools_Model tool = new Tools_Model();
            Random rand = new Random();
            double angle = 0.5235987755982988;
            double lenX = 4000.0;
            double lenY = 1000.0;
            int num = 400;
            double x0 = -1000.0;
            double y0 = 0.0;
            tool.bestAngle2D_Prep(model, 0.001);
            tool.bestAngle2D_AddPoint(x0, y0);
            for (int n = 0; n < num; ++n) {
                double dx = lenX * rand.nextDouble();
                double dy = lenY * rand.nextDouble();
                double x = x0 + dx * Math.cos(angle) - dy * Math.sin(angle);
                double y = y0 + dy * Math.cos(angle) + dx * Math.sin(angle);
                tool.bestAngle2D_AddPoint(x, y);
            }
            tool.bestAngle2D_Compute();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void bestAngle2D_Prep(Model2D model, double buffer) {
        try {
            this.m_model2D = model;
            this.m_model2D.setOrigin(0.0, 0.0);
            this.m_tempCount = 0;
            this.m_tempBuffer = Math.max(0.0, buffer);
            this.m_tempX = new double[30];
            this.m_tempY = new double[30];
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void bestAngle2D_AddPoint(double x, double y) {
        try {
            if (this.m_tempCount >= this.m_tempX.length) {
                int n;
                int newLen = this.m_tempCount * 2 + 2000;
                double[] temp = new double[newLen];
                for (n = 0; n < this.m_tempCount; ++n) {
                    temp[n] = this.m_tempX[n];
                }
                this.m_tempX = temp;
                temp = new double[newLen];
                for (n = 0; n < this.m_tempCount; ++n) {
                    temp[n] = this.m_tempY[n];
                }
                this.m_tempY = temp;
            }
            this.m_tempX[this.m_tempCount] = x;
            this.m_tempY[this.m_tempCount] = y;
            ++this.m_tempCount;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void bestAngle2D_Compute() {
        try {
            double bestAngle = 0.0;
            double maxRange = 0.0;
            int num = 20;
            for (int a = 0; a < num; ++a) {
                double angle = -1.5707963267948966 + (double)a * Math.PI / (double)(num - 1);
                this.m_model2D.setAngle(angle);
                this.m_model2D.prepareRangeFinder();
                for (int n = 0; n < this.m_tempCount; ++n) {
                    this.m_model2D.addToRangeFinder(this.m_tempX[n], this.m_tempY[n], this.m_tempBuffer);
                }
                if (!(this.m_model2D.RangeX.range() > maxRange)) continue;
                maxRange = this.m_model2D.RangeX.range();
                bestAngle = angle;
            }
            double minAngle = bestAngle - 0.7853981633974483;
            double maxAngle = bestAngle + 0.7853981633974483;
            int numAngles = 11;
            double minArea = Double.MAX_VALUE;
            for (int iter = 0; iter < 9; ++iter) {
                for (int a = 0; a < numAngles; ++a) {
                    double angle = minAngle + (double)a * (maxAngle - minAngle) / (double)(numAngles - 1);
                    this.m_model2D.setAngle(angle);
                    this.m_model2D.prepareRangeFinder();
                    for (int n = 0; n < this.m_tempCount; ++n) {
                        this.m_model2D.addToRangeFinder(this.m_tempX[n], this.m_tempY[n], this.m_tempBuffer);
                    }
                    double area = this.m_model2D.RangeX.range() * this.m_model2D.RangeY.range();
                    if (!(area < minArea)) continue;
                    minArea = area;
                    bestAngle = angle;
                }
                double oldAngleRange = maxAngle - minAngle;
                minAngle = bestAngle - 0.2 * oldAngleRange;
                maxAngle = bestAngle + 0.2 * oldAngleRange;
            }
            this.m_model2D.setAngle(bestAngle);
            this.m_model2D.prepareRangeFinder();
            double cos = Math.cos(bestAngle);
            double sin = Math.sin(bestAngle);
            for (int n = 0; n < this.m_tempCount; ++n) {
                this.m_model2D.addToRangeFinder(this.m_tempX[n], this.m_tempY[n], this.m_tempBuffer);
            }
            double minRotatedX = this.m_model2D.RangeX.rangeMin();
            double minRotatedY = this.m_model2D.RangeY.rangeMin();
            double x = cos * minRotatedX - sin * minRotatedY;
            double y = cos * minRotatedY + sin * minRotatedX;
            this.m_model2D.setOrigin(x, y);
            for (int n = 0; n < this.m_tempCount; ++n) {
                this.m_model2D.setWorldLocation(this.m_tempX[n], this.m_tempY[n]);
                if (!(this.m_model2D.GridX < 0.0) && !(this.m_model2D.GridY < 0.0)) continue;
                System.out.println("ERROR!!!! (this.GridX < 0 || this.GridY < 0)");
            }
            this.m_tempX = null;
            this.m_tempY = null;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

