/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosLibrary.WaveEquation.Model3D;

public class Propagator_Darrell {
    protected int m_numX;
    protected int m_numZ;
    protected int m_numY;
    protected float[] m_spongeX = new float[2];
    protected float[] m_spongeZ = new float[2];
    protected float[] m_spongeY = new float[2];
    protected int m_boundary = 10;
    protected double m_epsilon = 0.9;
    protected double m_delta = 0.02;
    private int m_order;
    private double[] m_coeff;
    protected double m_timeStep = 2.5E-4;
    public double m_currentTime;
    protected int m_shotIndexX;
    protected int m_shotIndexZ;
    protected int m_shotIndexY;
    protected static long m_stepper = 0L;

    public void prepareForPropagation(Model3D model, double shotX, double shotY, double shotZ, double timeStep) {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            shotY -= model.originY();
            shotZ -= model.originZ();
            this.m_currentTime = 0.0;
            this.m_timeStep = 0.001 * timeStep;
            this.m_shotIndexX = (int)(0.5 + (shotX -= model.originX()) / model.nodeSpacing());
            this.m_shotIndexX = Math.max(0, this.m_shotIndexX);
            this.m_shotIndexX = Math.min(numX - 1, this.m_shotIndexX);
            this.m_shotIndexZ = (int)(0.5 + shotZ / model.nodeSpacing());
            this.m_shotIndexZ = Math.max(0, this.m_shotIndexZ);
            this.m_shotIndexZ = Math.min(numZ - 1, this.m_shotIndexZ);
            this.m_shotIndexY = (int)(0.5 + shotY / model.nodeSpacing());
            this.m_shotIndexY = Math.max(0, this.m_shotIndexY);
            this.m_shotIndexY = Math.min(numY - 1, this.m_shotIndexY);
            model.array_setValue("pfield_time", 0.0f);
            model.array_setValue("pfield_timeMinus", 0.0f);
            model.array_setValue("pfield_timePlus", 0.0f);
            model.array_setValue("Buoyancy", 0.0f);
            float[][][] vel = model.array_get("Velocity");
            float[][][] buoy = model.array_get("Buoyancy");
            for (int ix = 0; ix < numX; ++ix) {
                for (int iy = 0; iy < numY; ++iy) {
                    for (int iz = 0; iz < numZ; ++iz) {
                        buoy[ix][iy][iz] = (float)(4.35 * Math.pow(vel[ix][iy][iz], -0.25));
                    }
                }
            }
            int numCoeffs = (this.m_boundary - 6) / 2 + 1;
            if (numCoeffs < 3) {
                numCoeffs = 3;
            }
            if (numCoeffs > 9) {
                numCoeffs = 9;
            }
            this.m_order = 2 * (numCoeffs - 1);
            this.m_coeff = new double[9];
            this.setCoefficients(this.m_order);
            System.out.format("timeStep: %f  SID [%d %d %d] order: %d  numCoeffs: %d\n", timeStep, this.m_shotIndexX, this.m_shotIndexY, this.m_shotIndexZ, this.m_order, numCoeffs);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    private void setCoefficients(int numCoeffs) {
        try {
            System.out.format("Setting coefficients for %dth order.\n", numCoeffs);
            switch (numCoeffs) {
                case 2: {
                    this.m_coeff[0] = -2.0;
                    this.m_coeff[1] = 1.0;
                    break;
                }
                case 3: {
                    this.m_coeff[0] = -2.55567466;
                    this.m_coeff[1] = 1.36106192;
                    this.m_coeff[2] = -0.09322459;
                    break;
                }
                case 4: {
                    this.m_coeff[0] = -2.81952122;
                    this.m_coeff[1] = 1.57500756;
                    this.m_coeff[2] = -0.18267338;
                    this.m_coeff[3] = 0.01742643;
                    break;
                }
                case 5: {
                    this.m_coeff[0] = -2.97399944;
                    this.m_coeff[1] = 1.70507669;
                    this.m_coeff[2] = -0.25861812;
                    this.m_coeff[3] = 0.04577745;
                    this.m_coeff[4] = -0.0052363;
                    break;
                }
                case 6: {
                    this.m_coeff[0] = -3.05450492;
                    this.m_coeff[1] = 1.77642739;
                    this.m_coeff[2] = -0.30779013;
                    this.m_coeff[3] = 0.07115999;
                    this.m_coeff[4] = -0.01422784;
                    this.m_coeff[5] = 0.00168305;
                    break;
                }
                case 7: {
                    this.m_coeff[0] = -3.12108522;
                    this.m_coeff[1] = 1.83730507;
                    this.m_coeff[2] = -0.35408741;
                    this.m_coeff[3] = 0.09988277;
                    this.m_coeff[4] = -0.02817135;
                    this.m_coeff[5] = 0.006539;
                    this.m_coeff[6] = -9.2547E-4;
                    break;
                }
                case 8: {
                    this.m_coeff[0] = -3.1627598;
                    this.m_coeff[1] = 1.87636137;
                    this.m_coeff[2] = -0.38612121;
                    this.m_coeff[3] = 0.12263042;
                    this.m_coeff[4] = -0.04190565;
                    this.m_coeff[5] = 0.01330243;
                    this.m_coeff[6] = -0.00344731;
                    this.m_coeff[7] = 5.5985E-4;
                    break;
                }
                case 9: {
                    this.m_coeff[0] = -3.1854341;
                    this.m_coeff[1] = 1.89789462;
                    this.m_coeff[2] = -0.40456799;
                    this.m_coeff[3] = 0.13676734;
                    this.m_coeff[4] = -0.05150324;
                    this.m_coeff[5] = 0.01893502;
                    this.m_coeff[6] = -0.00619345;
                    this.m_coeff[7] = 0.00159455;
                    this.m_coeff[8] = -2.098E-4;
                    break;
                }
                default: {
                    this.m_coeff[0] = -2.55567466;
                    this.m_coeff[1] = 1.36106192;
                    this.m_coeff[2] = -0.09322459;
                    break;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void propagate(Model3D model, double totalRunTime, int method) throws Exception {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            if (numX != this.m_spongeX.length) {
                throw new Exception("numX != m_spongeX.length");
            }
            if (numZ != this.m_spongeZ.length || numY != this.m_spongeY.length) {
                throw new Exception("numZ or numY != m_spongeZ.length");
            }
            int numSteps = (int)(0.001 * totalRunTime / this.m_timeStep);
            for (int step = 0; step < numSteps; ++step) {
                if (method == 0) {
                    this.acousticIsotropic(model);
                } else {
                    this.acousticESG(model);
                }
                this.m_currentTime += this.m_timeStep;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static float sourceWavelet(double time) {
        try {
            double Alpha = 157.07963267948966;
            double Beta = -Math.log(0.2) / 0.0016;
            double peakTime = 0.02;
            double DT = Math.abs(peakTime - time);
            double s = Math.cos(Alpha * DT) * Math.exp(-Beta * DT * DT);
            ++m_stepper;
            return (float)s;
        }
        catch (Exception error) {
            error.printStackTrace();
            return 0.0f;
        }
    }

    public void acousticIsotropic(Model3D model) {
        try {
            int ix;
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            double nodeSpacing = model.nodeSpacing();
            double scalar = this.m_timeStep / nodeSpacing;
            float[][][] pfield_timePlus = model.array_get("pfield_timePlus");
            float[][][] pfield_time = model.array_get("pfield_time");
            float[][][] pfield_timeMinus = model.array_get("pfield_timeMinus");
            float[][][] vel = model.array_get("Velocity");
            int numCoeffs = (this.m_boundary - 6) / 2 + 1;
            if (this.m_currentTime < this.m_timeStep) {
                pfield_timeMinus[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] = 1000.0f * Propagator_Darrell.sourceWavelet(this.m_currentTime - this.m_timeStep);
                pfield_time[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] = 1000.0f * Propagator_Darrell.sourceWavelet(this.m_currentTime);
            }
            for (int ix2 = 0; ix2 < numX; ++ix2) {
                for (int iy = 0; iy < numY; ++iy) {
                    for (int iz = 0; iz < numZ; ++iz) {
                        float total = this.m_spongeX[ix2] * this.m_spongeZ[iz] * this.m_spongeY[iy];
                        pfield_timeMinus[ix2][iy][iz] = total * pfield_time[ix2][iy][iz];
                        pfield_time[ix2][iy][iz] = total * pfield_timePlus[ix2][iy][iz];
                    }
                }
            }
            double vdt = (double)vel[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] * (this.m_currentTime + this.m_timeStep);
            int nodes = (int)(vdt / nodeSpacing) + 2;
            int xmin = this.m_shotIndexX - nodes > 1 ? this.m_shotIndexX - nodes : 1;
            int ymin = this.m_shotIndexY - nodes > 1 ? this.m_shotIndexY - nodes : 1;
            int zmin = this.m_shotIndexZ - nodes > 1 ? this.m_shotIndexZ - nodes : 1;
            int xmax = this.m_shotIndexX + nodes < numX - 1 ? this.m_shotIndexX + nodes : numX - 1;
            int ymax = this.m_shotIndexY + nodes < numY - 1 ? this.m_shotIndexY + nodes : numY - 1;
            int zmax = this.m_shotIndexZ + nodes < numZ - 1 ? this.m_shotIndexZ + nodes : numZ - 1;
            for (ix = xmin; ix < xmax; ++ix) {
                int bx = numCoeffs;
                if (ix < numCoeffs) {
                    bx = ix + 1;
                }
                if (ix > numX - numCoeffs) {
                    bx = numX - ix;
                }
                for (int iy = ymin; iy < ymax; ++iy) {
                    int by = numCoeffs;
                    if (iy < numCoeffs) {
                        by = iy + 1;
                    }
                    if (iy > numY - numCoeffs) {
                        by = numY - iy;
                    }
                    for (int iz = zmin; iz < zmax; ++iz) {
                        int n;
                        int bz = numCoeffs;
                        if (iz < numCoeffs) {
                            bz = iz + 1;
                        }
                        if (iz > numZ - numCoeffs) {
                            bz = numZ - iz;
                        }
                        float v0 = vel[ix][iy][iz];
                        float coeff1 = (float)((double)(v0 * v0) * scalar * scalar);
                        float timeTerm = 2.0f * pfield_time[ix][iy][iz] - pfield_timeMinus[ix][iy][iz];
                        double term0 = this.m_coeff[0] * (double)pfield_time[ix][iy][iz];
                        double xterms = 0.0;
                        double yterms = 0.0;
                        double zterms = 0.0;
                        for (n = 1; n < bx; ++n) {
                            xterms += this.m_coeff[n] * (double)(pfield_time[ix + n][iy][iz] + pfield_time[ix - n][iy][iz]);
                        }
                        for (n = 1; n < by; ++n) {
                            yterms += this.m_coeff[n] * (double)(pfield_time[ix][iy + n][iz] + pfield_time[ix][iy - n][iz]);
                        }
                        for (n = 1; n < bz; ++n) {
                            zterms += this.m_coeff[n] * (double)(pfield_time[ix][iy][iz + n] + pfield_time[ix][iy][iz - n]);
                        }
                        pfield_timePlus[ix][iy][iz] = (float)((double)timeTerm + (double)coeff1 * ((xterms += term0) + (yterms += term0) + (zterms += term0)));
                    }
                }
            }
            for (int iy = 1; iy < numY - 1; ++iy) {
                for (int iz = 1; iz < numZ - 1; ++iz) {
                    float v0 = vel[0][iy][iz];
                    float r = (float)((double)v0 * scalar);
                    double term1 = r * (pfield_timePlus[1][iy][iz] - (pfield_timeMinus[1][iy][iz] - pfield_timeMinus[0][iy][iz]));
                    double term2 = -(pfield_timeMinus[1][iy][iz] + pfield_timePlus[1][iy][iz] - 2.0f * pfield_time[1][iy][iz]) - (pfield_timeMinus[0][iy][iz] - 2.0f * pfield_time[0][iy][iz]);
                    double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[1][iy + 1][iz] + pfield_time[1][iy - 1][iz] - 2.0f * pfield_time[1][iy][iz] + pfield_time[1][iy][iz + 1] + pfield_time[1][iy][iz - 1] - 2.0f * pfield_time[1][iy][iz] + pfield_time[0][iy + 1][iz] + pfield_time[0][iy - 1][iz] - 2.0f * pfield_time[0][iy][iz] + pfield_time[0][iy][iz + 1] + pfield_time[0][iy][iz - 1] - 2.0f * pfield_time[0][iy][iz]);
                    pfield_timePlus[0][iy][iz] = (float)(term1 + term2 + term3) / (1.0f + r);
                }
            }
            for (ix = 1; ix < numX - 1; ++ix) {
                for (int iy = 1; iy < numY - 1; ++iy) {
                    float v0 = vel[ix][iy][0];
                    float r = (float)((double)v0 * scalar);
                    double term1 = r * (pfield_timePlus[ix][iy][1] - (pfield_timeMinus[ix][iy][1] - pfield_timeMinus[ix][iy][0]));
                    double term2 = -(pfield_timeMinus[ix][iy][1] + pfield_timePlus[ix][iy][1] - 2.0f * pfield_time[ix][iy][1]) - (pfield_timeMinus[ix][iy][0] - 2.0f * pfield_time[ix][iy][0]);
                    double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix][iy + 1][1] + pfield_time[ix][iy - 1][1] - 2.0f * pfield_time[ix][iy][1] + pfield_time[ix + 1][iy][1] + pfield_time[ix - 1][iy][1] - 2.0f * pfield_time[ix][iy][1] + pfield_time[ix][iy + 1][0] + pfield_time[ix][iy - 1][0] - 2.0f * pfield_time[ix][iy][0] + pfield_time[ix + 1][iy][0] + pfield_time[ix - 1][iy][0] - 2.0f * pfield_time[ix][iy][0]);
                    pfield_timePlus[ix][iy][0] = (float)(term1 + term2 + term3) / (1.0f + r);
                }
            }
            float[] fArray = pfield_timePlus[this.m_shotIndexX][this.m_shotIndexY];
            int n = this.m_shotIndexZ;
            fArray[n] = fArray[n] + 1000.0f * Propagator_Darrell.sourceWavelet(this.m_currentTime);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void acousticESG(Model3D model) {
        try {
            float spatialTerm;
            int iy;
            float r;
            int ix;
            int iz;
            float v0;
            int iz2;
            int iy2;
            int ix2;
            int numX = model.nodeCountX();
            int numY = model.nodeCountY();
            int numZ = model.nodeCountZ();
            double nodeSpacing = model.nodeSpacing();
            float invSpacing2 = (float)(1.0 / (nodeSpacing * nodeSpacing));
            double scalar = this.m_timeStep / nodeSpacing;
            float[][][] pfield_timePlus = model.array_get("pfield_timePlus");
            float[][][] pfield_time = model.array_get("pfield_time");
            float[][][] pfield_timeMinus = model.array_get("pfield_timeMinus");
            float[][][] vel = model.array_get("Velocity");
            float[][][] buoy = model.array_get("Buoyancy");
            float c1 = 1.125f;
            float c2 = 0.041666668f;
            int buff = 8;
            for (int ix3 = 0; ix3 < numX; ++ix3) {
                for (int iy3 = 0; iy3 < numY; ++iy3) {
                    for (int iz3 = 0; iz3 < numZ; ++iz3) {
                        float total = this.m_spongeX[ix3] * this.m_spongeZ[iz3] * this.m_spongeY[iy3];
                        pfield_timeMinus[ix3][iy3][iz3] = total * pfield_time[ix3][iy3][iz3];
                        pfield_time[ix3][iy3][iz3] = total * pfield_timePlus[ix3][iy3][iz3];
                    }
                }
            }
            int step = (int)(this.m_currentTime / this.m_timeStep);
            double vdt = (double)(vel[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] * (float)(step + 1)) * this.m_timeStep;
            int nodes = (int)(vdt / nodeSpacing) + 2;
            int xmin = this.m_shotIndexX - nodes > buff ? this.m_shotIndexX - nodes : buff;
            int ymin = this.m_shotIndexY - nodes > buff ? this.m_shotIndexY - nodes : buff;
            int zmin = this.m_shotIndexZ - nodes > buff ? this.m_shotIndexZ - nodes : buff;
            int xmax = this.m_shotIndexX + nodes < numX - buff ? this.m_shotIndexX + nodes : numX - buff;
            int ymax = this.m_shotIndexY + nodes < numY - buff ? this.m_shotIndexY + nodes : numY - buff;
            int zmax = this.m_shotIndexZ + nodes < numZ - buff ? this.m_shotIndexZ + nodes : numZ - buff;
            for (ix2 = xmin; ix2 < xmax; ++ix2) {
                for (iy2 = ymin; iy2 < ymax; ++iy2) {
                    for (iz2 = zmin; iz2 < zmax; ++iz2) {
                        v0 = vel[ix2][iy2][iz2];
                        float coeff1 = (float)((double)(v0 * v0) * scalar * scalar);
                        float timeTerm = 2.0f * pfield_time[ix2][iy2][iz2] - pfield_timeMinus[ix2][iy2][iz2];
                        float b1 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2 + 1][iy2][iz2]);
                        float b2 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2 - 1][iy2][iz2]);
                        float b3 = 0.5f * (buoy[ix2 + 1][iy2][iz2] + buoy[ix2 + 2][iy2][iz2]);
                        float b4 = 0.5f * (buoy[ix2 - 1][iy2][iz2] + buoy[ix2 - 2][iy2][iz2]);
                        float xtermA = c1 * (b1 * (c1 * (pfield_time[ix2 + 1][iy2][iz2] - pfield_time[ix2][iy2][iz2]) - c2 * (pfield_time[ix2 + 2][iy2][iz2] - pfield_time[ix2 - 1][iy2][iz2])) - b2 * (c1 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2 - 1][iy2][iz2]) - c2 * (pfield_time[ix2 + 1][iy2][iz2] - pfield_time[ix2 - 2][iy2][iz2])));
                        float xtermB = -c2 * (b3 * (c1 * (pfield_time[ix2 + 2][iy2][iz2] - pfield_time[ix2 + 1][iy2][iz2]) - c2 * (pfield_time[ix2 + 3][iy2][iz2] - pfield_time[ix2][iy2][iz2])) - b4 * (c1 * (pfield_time[ix2 - 1][iy2][iz2] - pfield_time[ix2 - 2][iy2][iz2]) - c2 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2 - 3][iy2][iz2])));
                        b1 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2][iy2 + 1][iz2]);
                        b2 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2][iy2 - 1][iz2]);
                        b3 = 0.5f * (buoy[ix2][iy2 + 1][iz2] + buoy[ix2][iy2 + 2][iz2]);
                        b4 = 0.5f * (buoy[ix2][iy2 - 1][iz2] + buoy[ix2][iy2 - 2][iz2]);
                        float ytermA = c1 * (b1 * (c1 * (pfield_time[ix2][iy2 + 1][iz2] - pfield_time[ix2][iy2][iz2]) - c2 * (pfield_time[ix2][iy2 + 2][iz2] - pfield_time[ix2][iy2 - 1][iz2])) - b2 * (c1 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2][iy2 - 1][iz2]) - c2 * (pfield_time[ix2][iy2 + 1][iz2] - pfield_time[ix2][iy2 - 2][iz2])));
                        float ytermB = -c2 * (b3 * (c1 * (pfield_time[ix2][iy2 + 2][iz2] - pfield_time[ix2][iy2 + 1][iz2]) - c2 * (pfield_time[ix2][iy2 + 3][iz2] - pfield_time[ix2][iy2][iz2])) - b4 * (c1 * (pfield_time[ix2][iy2 - 1][iz2] - pfield_time[ix2][iy2 - 2][iz2]) - c2 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2][iy2 - 3][iz2])));
                        b1 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2][iy2][iz2 + 1]);
                        b2 = 0.5f * (buoy[ix2][iy2][iz2] + buoy[ix2][iy2][iz2 - 1]);
                        b3 = 0.5f * (buoy[ix2][iy2][iz2 + 1] + buoy[ix2][iy2][iz2 + 2]);
                        b4 = 0.5f * (buoy[ix2][iy2][iz2 - 1] + buoy[ix2][iy2][iz2 - 2]);
                        float ztermA = c1 * (b1 * (c1 * (pfield_time[ix2][iy2][iz2 + 1] - pfield_time[ix2][iy2][iz2]) - c2 * (pfield_time[ix2][iy2][iz2 + 2] - pfield_time[ix2][iy2][iz2 - 1])) - b2 * (c1 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2][iy2][iz2 - 1]) - c2 * (pfield_time[ix2][iy2][iz2 + 1] - pfield_time[ix2][iy2][iz2 - 2])));
                        float ztermB = -c2 * (b3 * (c1 * (pfield_time[ix2][iy2][iz2 + 2] - pfield_time[ix2][iy2][iz2 + 1]) - c2 * (pfield_time[ix2][iy2][iz2 + 3] - pfield_time[ix2][iy2][iz2])) - b4 * (c1 * (pfield_time[ix2][iy2][iz2 - 1] - pfield_time[ix2][iy2][iz2 - 2]) - c2 * (pfield_time[ix2][iy2][iz2] - pfield_time[ix2][iy2][iz2 - 3])));
                        float density = 1.0f / buoy[ix2][iy2][iz2];
                        float spatialTerm2 = xtermA + xtermB + ytermA + ytermB + ztermA + ztermB;
                        pfield_timePlus[ix2][iy2][iz2] = timeTerm + density * coeff1 * spatialTerm2;
                    }
                }
            }
            if (zmin == buff) {
                for (iz = buff - 1; iz >= 0; --iz) {
                    for (ix = 1; ix < numX - 1; ++ix) {
                        for (int iy4 = 1; iy4 < numY - 1; ++iy4) {
                            v0 = vel[ix][iy4][iz];
                            r = (float)((double)v0 * scalar);
                            double term1 = r * (pfield_timePlus[ix][iy4][iz + 1] - (pfield_timeMinus[ix][iy4][iz + 1] - pfield_timeMinus[ix][iy4][iz]));
                            double term2 = -(pfield_timeMinus[ix][iy4][iz + 1] + pfield_timePlus[ix][iy4][iz + 1] - 2.0f * pfield_time[ix][iy4][iz + 1]) - (pfield_timeMinus[ix][iy4][iz] - 2.0f * pfield_time[ix][iy4][iz]);
                            double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix][iy4 + 1][iz + 1] + pfield_time[ix][iy4 - 1][iz + 1] - 2.0f * pfield_time[ix][iy4][iz + 1] + pfield_time[ix + 1][iy4][iz + 1] + pfield_time[ix - 1][iy4][iz + 1] - 2.0f * pfield_time[ix][iy4][iz + 1] + pfield_time[ix][iy4 + 1][iz] + pfield_time[ix][iy4 - 1][iz] - 2.0f * pfield_time[ix][iy4][iz] + pfield_time[ix + 1][iy4][iz] + pfield_time[ix - 1][iy4][iz] - 2.0f * pfield_time[ix][iy4][iz]);
                            pfield_timePlus[ix][iy4][iz] = (float)(term1 + term2 + term3) / (1.0f + r);
                        }
                    }
                }
            }
            if (xmin == buff) {
                for (ix2 = buff - 1; ix2 >= 0; --ix2) {
                    for (iy2 = 1; iy2 < numY - 1; ++iy2) {
                        for (iz2 = 1; iz2 < numZ - 1; ++iz2) {
                            v0 = vel[ix2][iy2][iz2];
                            r = (float)((double)v0 * scalar);
                            double term1 = r * (pfield_timePlus[ix2 + 1][iy2][iz2] - (pfield_timeMinus[ix2 + 1][iy2][iz2] - pfield_timeMinus[ix2][iy2][iz2]));
                            double term2 = -(pfield_timeMinus[ix2 + 1][iy2][iz2] + pfield_timePlus[ix2 + 1][iy2][iz2] - 2.0f * pfield_time[ix2 + 1][iy2][iz2]) - (pfield_timeMinus[ix2][iy2][iz2] - 2.0f * pfield_time[ix2][iy2][iz2]);
                            double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix2 + 1][iy2 + 1][iz2] + pfield_time[ix2 + 1][iy2 - 1][iz2] - 2.0f * pfield_time[ix2 + 1][iy2][iz2] + pfield_time[ix2 + 1][iy2][iz2 + 1] + pfield_time[ix2 + 1][iy2][iz2 - 1] - 2.0f * pfield_time[ix2 + 1][iy2][iz2] + pfield_time[ix2][iy2 + 1][iz2] + pfield_time[ix2][iy2 - 1][iz2] - 2.0f * pfield_time[ix2][iy2][iz2] + pfield_time[ix2][iy2][iz2 + 1] + pfield_time[ix2][iy2][iz2 - 1] - 2.0f * pfield_time[ix2][iy2][iz2]);
                            pfield_timePlus[ix2][iy2][iz2] = (float)(term1 + term2 + term3) / (1.0f + r);
                        }
                    }
                }
            }
            if (xmax == numX - buff) {
                for (ix2 = numX - buff; ix2 < numX; ++ix2) {
                    for (iy2 = 1; iy2 < numY - 1; ++iy2) {
                        for (iz2 = 1; iz2 < numZ - 1; ++iz2) {
                            v0 = vel[ix2][iy2][iz2];
                            r = (float)((double)v0 * scalar);
                            double term1 = r * (pfield_timePlus[ix2 - 1][iy2][iz2] - (pfield_timeMinus[ix2 - 1][iy2][iz2] - pfield_timeMinus[ix2][iy2][iz2]));
                            double term2 = -(pfield_timeMinus[ix2 - 1][iy2][iz2] + pfield_timePlus[ix2 - 1][iy2][iz2] - 2.0f * pfield_time[ix2 - 1][iy2][iz2]) - (pfield_timeMinus[ix2][iy2][iz2] - 2.0f * pfield_time[ix2][iy2][iz2]);
                            double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix2 - 1][iy2 + 1][iz2] + pfield_time[ix2 - 1][iy2 - 1][iz2] - 2.0f * pfield_time[ix2 - 1][iy2][iz2] + pfield_time[ix2 - 1][iy2][iz2 + 1] + pfield_time[ix2 - 1][iy2][iz2 - 1] - 2.0f * pfield_time[ix2 - 1][iy2][iz2] + pfield_time[ix2][iy2 + 1][iz2] + pfield_time[ix2][iy2 - 1][iz2] - 2.0f * pfield_time[ix2][iy2][iz2] + pfield_time[ix2][iy2][iz2 + 1] + pfield_time[ix2][iy2][iz2 - 1] - 2.0f * pfield_time[ix2][iy2][iz2]);
                            pfield_timePlus[ix2][iy2][iz2] = (float)(term1 + term2 + term3) / (1.0f + r);
                        }
                    }
                }
            }
            if (ymin == buff) {
                for (iy = buff - 1; iy >= 0; --iy) {
                    for (ix = 1; ix < numX - 1; ++ix) {
                        for (iz2 = 1; iz2 < numZ - 1; ++iz2) {
                            v0 = vel[ix][iy][iz2];
                            r = (float)((double)v0 * scalar);
                            double term1 = r * (pfield_timePlus[ix][iy + 1][iz2] - (pfield_timeMinus[ix][iy + 1][iz2] - pfield_timeMinus[ix][iy][iz2]));
                            double term2 = -(pfield_timeMinus[ix][iy + 1][iz2] + pfield_timePlus[ix][iy + 1][iz2] - 2.0f * pfield_time[ix][iy + 1][iz2]) - (pfield_timeMinus[ix][iy][iz2] - 2.0f * pfield_time[ix][iy][iz2]);
                            double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix + 1][iy + 1][iz2] + pfield_time[ix - 1][iy + 1][iz2] - 2.0f * pfield_time[ix][iy + 1][iz2] + pfield_time[ix][iy + 1][iz2 + 1] + pfield_time[ix][iy + 1][iz2 - 1] - 2.0f * pfield_time[ix][iy + 1][iz2] + pfield_time[ix + 1][iy][iz2] + pfield_time[ix - 1][iy][iz2] - 2.0f * pfield_time[ix][iy][iz2] + pfield_time[ix][iy][iz2 + 1] + pfield_time[ix][iy][iz2 - 1] - 2.0f * pfield_time[ix][iy][iz2]);
                            pfield_timePlus[ix][iy][iz2] = (float)(term1 + term2 + term3) / (1.0f + r);
                        }
                    }
                }
            }
            if (ymax == numY - buff) {
                for (iy = numY - buff; iy < numY; ++iy) {
                    for (ix = 1; ix < numX - 1; ++ix) {
                        for (iz2 = 1; iz2 < numZ - 1; ++iz2) {
                            v0 = vel[ix][iy][iz2];
                            r = (float)((double)v0 * scalar);
                            double term1 = r * (pfield_timePlus[ix][iy - 1][iz2] - (pfield_timeMinus[ix][iy - 1][iz2] - pfield_timeMinus[ix][iy][iz2]));
                            double term2 = -(pfield_timeMinus[ix][iy - 1][iz2] + pfield_timePlus[ix][iy - 1][iz2] - 2.0f * pfield_time[ix][iy - 1][iz2]) - (pfield_timeMinus[ix][iy][iz2] - 2.0f * pfield_time[ix][iy][iz2]);
                            double term3 = 0.5 * (double)r * (double)r * (double)(pfield_time[ix + 1][iy - 1][iz2] + pfield_time[ix - 1][iy - 1][iz2] - 2.0f * pfield_time[ix][iy - 1][iz2] + pfield_time[ix][iy - 1][iz2 + 1] + pfield_time[ix][iy - 1][iz2 - 1] - 2.0f * pfield_time[ix][iy - 1][iz2] + pfield_time[ix + 1][iy][iz2] + pfield_time[ix - 1][iy][iz2] - 2.0f * pfield_time[ix][iy][iz2] + pfield_time[ix][iy][iz2 + 1] + pfield_time[ix][iy][iz2 - 1] - 2.0f * pfield_time[ix][iy][iz2]);
                            pfield_timePlus[ix][iy][iz2] = (float)(term1 + term2 + term3) / (1.0f + r);
                        }
                    }
                }
            }
            if (xmin == buff && zmin == buff) {
                for (iy = 0; iy < numY - 1; ++iy) {
                    float r2 = (float)((double)vel[0][iy][0] * scalar);
                    float timeTerm = r2 * (pfield_timePlus[1][iy][1] + pfield_time[1][iy][1] - pfield_time[0][iy][0]);
                    spatialTerm = pfield_time[1][iy][1] + pfield_time[0][iy][0] - pfield_timePlus[1][iy][1];
                    pfield_timePlus[0][iy][0] = 1.0f / (1.0f + r2) * (timeTerm + spatialTerm);
                }
            }
            if (xmax == numX - buff && zmin == buff) {
                for (iy = 0; iy < numY - 1; ++iy) {
                    float r3 = (float)((double)vel[numX - 1][iy][0] * scalar);
                    float timeTerm = r3 * (pfield_timePlus[numX - 2][iy][1] + pfield_time[numX - 2][iy][1] - pfield_time[numX - 1][iy][0]);
                    spatialTerm = pfield_time[numX - 2][iy][1] + pfield_time[numX - 1][iy][0] - pfield_timePlus[numX - 2][iy][1];
                    pfield_timePlus[numX - 1][iy][0] = 1.0f / (1.0f + r3) * (timeTerm + spatialTerm);
                }
            }
            if (xmin == buff && zmax == numZ - buff) {
                for (iy = 0; iy < numY - 1; ++iy) {
                    float r4 = (float)((double)vel[0][iy][numZ - 1] * scalar);
                    float timeTerm = r4 * (pfield_timePlus[1][iy][numZ - 2] + pfield_time[1][iy][numZ - 2] - pfield_time[0][iy][numZ - 1]);
                    spatialTerm = pfield_time[1][iy][numZ - 2] + pfield_time[0][iy][numZ - 1] - pfield_timePlus[1][iy][numZ - 2];
                    pfield_timePlus[0][iy][numZ - 1] = 1.0f / (1.0f + r4) * (timeTerm + spatialTerm);
                }
            }
            if (xmax == numX - buff && zmax == numZ - buff) {
                for (iy = 0; iy < numY - 1; ++iy) {
                    float r5 = (float)((double)vel[numX - 1][iy][numZ - 1] * scalar);
                    float timeTerm = r5 * (pfield_timePlus[numX - 2][iy][numZ - 2] + pfield_time[numX - 2][iy][numZ - 2] - pfield_time[numX - 1][iy][numZ - 1]);
                    spatialTerm = pfield_time[numX - 2][iy][numZ - 2] + pfield_time[numX - 1][iy][numZ - 1] - pfield_timePlus[numX - 2][iy][numZ - 2];
                    pfield_timePlus[numX - 1][iy][numZ - 1] = 1.0f / (1.0f + r5) * (timeTerm + spatialTerm);
                }
            }
            if (ymin == buff && zmin == buff) {
                for (ix2 = 0; ix2 < numX - 1; ++ix2) {
                    float r6 = (float)((double)vel[ix2][0][0] * scalar);
                    float timeTerm = r6 * (pfield_timePlus[ix2][1][1] + pfield_time[ix2][1][1] - pfield_time[ix2][0][0]);
                    spatialTerm = pfield_time[ix2][1][1] + pfield_time[ix2][0][0] - pfield_timePlus[ix2][1][1];
                    pfield_timePlus[ix2][0][0] = 1.0f / (1.0f + r6) * (timeTerm + spatialTerm);
                }
            }
            if (ymax == numY - buff && zmin == buff) {
                for (ix2 = 0; ix2 < numX - 1; ++ix2) {
                    float r7 = (float)((double)vel[ix2][numY - 1][0] * scalar);
                    float timeTerm = r7 * (pfield_timePlus[ix2][numY - 2][1] + pfield_time[ix2][numY - 2][1] - pfield_time[ix2][numY - 1][0]);
                    spatialTerm = pfield_time[ix2][numY - 2][1] + pfield_time[ix2][numY - 1][0] - pfield_timePlus[ix2][numY - 2][1];
                    pfield_timePlus[ix2][numY - 1][0] = 1.0f / (1.0f + r7) * (timeTerm + spatialTerm);
                }
            }
            if (ymin == buff && zmax == numZ - buff) {
                for (ix2 = 0; ix2 < numX - 1; ++ix2) {
                    float r8 = (float)((double)vel[ix2][0][numZ - 1] * scalar);
                    float timeTerm = r8 * (pfield_timePlus[ix2][1][numZ - 2] + pfield_time[ix2][1][numZ - 2] - pfield_time[ix2][0][numZ - 1]);
                    spatialTerm = pfield_time[ix2][1][numZ - 2] + pfield_time[ix2][0][numZ - 1] - pfield_timePlus[ix2][1][numZ - 2];
                    pfield_timePlus[ix2][0][numZ - 1] = 1.0f / (1.0f + r8) * (timeTerm + spatialTerm);
                }
            }
            if (ymax == numY - buff && zmax == numZ - buff) {
                for (ix2 = 0; ix2 < numX - 1; ++ix2) {
                    float r9 = (float)((double)vel[ix2][numY - 1][numZ - 1] * scalar);
                    float timeTerm = r9 * (pfield_timePlus[ix2][numY - 2][numZ - 2] + pfield_time[ix2][numY - 2][numZ - 2] - pfield_time[ix2][numY - 1][numZ - 1]);
                    spatialTerm = pfield_time[ix2][numY - 2][numZ - 2] + pfield_time[ix2][numY - 1][numZ - 1] - pfield_timePlus[ix2][numY - 2][numZ - 2];
                    pfield_timePlus[ix2][numY - 1][numZ - 1] = 1.0f / (1.0f + r9) * (timeTerm + spatialTerm);
                }
            }
            if (xmin == buff && ymin == buff) {
                for (iz = 0; iz < numZ - 1; ++iz) {
                    float r10 = (float)((double)vel[0][0][iz] * scalar);
                    float timeTerm = r10 * (pfield_timePlus[1][1][iz] + pfield_time[1][1][iz] - pfield_time[0][0][iz]);
                    spatialTerm = pfield_time[1][1][iz] + pfield_time[0][0][iz] - pfield_timePlus[1][1][iz];
                    pfield_timePlus[0][0][iz] = 1.0f / (1.0f + r10) * (timeTerm + spatialTerm);
                }
            }
            if (xmin == buff && ymax == numY - buff) {
                for (iz = 0; iz < numZ - 1; ++iz) {
                    float r11 = (float)((double)vel[0][numY - 1][iz] * scalar);
                    float timeTerm = r11 * (pfield_timePlus[1][numY - 2][iz] + pfield_time[1][numY - 2][iz] - pfield_time[0][numY - 1][iz]);
                    spatialTerm = pfield_time[1][numY - 2][iz] + pfield_time[0][numY - 1][iz] - pfield_timePlus[1][numY - 2][iz];
                    pfield_timePlus[0][numY - 1][iz] = 1.0f / (1.0f + r11) * (timeTerm + spatialTerm);
                }
            }
            if (xmax == numX - buff && ymin == buff) {
                for (iz = 0; iz < numZ - 1; ++iz) {
                    float r12 = (float)((double)vel[numX - 1][0][iz] * scalar);
                    float timeTerm = r12 * (pfield_timePlus[numX - 2][1][iz] + pfield_time[numX - 2][1][iz] - pfield_time[numX - 1][0][iz]);
                    spatialTerm = pfield_time[numX - 2][1][iz] + pfield_time[numX - 1][0][iz] - pfield_timePlus[numX - 2][1][iz];
                    pfield_timePlus[numX - 1][0][iz] = 1.0f / (1.0f + r12) * (timeTerm + spatialTerm);
                }
            }
            if (xmax == numX - buff && ymax == numY - buff) {
                for (iz = 0; iz < numZ - 1; ++iz) {
                    float r13 = (float)((double)vel[numX - 1][numY - 1][iz] * scalar);
                    float timeTerm = r13 * (pfield_timePlus[numX - 2][numY - 2][iz] + pfield_time[numX - 2][numY - 2][iz] - pfield_time[numX - 1][numY - 1][iz]);
                    spatialTerm = pfield_time[numX - 2][numY - 2][iz] + pfield_time[numX - 1][numY - 1][iz] - pfield_timePlus[numX - 2][numY - 2][iz];
                    pfield_timePlus[numX - 1][numY - 1][iz] = 1.0f / (1.0f + r13) * (timeTerm + spatialTerm);
                }
            }
            float[] fArray = pfield_timePlus[this.m_shotIndexX][this.m_shotIndexY];
            int n = this.m_shotIndexZ;
            fArray[n] = (float)((double)fArray[n] + 1000.0 * (double)Propagator_Darrell.sourceWavelet(this.m_currentTime));
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void prepareSponge(Model3D model, int boundarySize, double taperConstant) {
        try {
            double exp_squared;
            double exp;
            double difference;
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            this.m_boundary = boundarySize;
            if (this.m_spongeX.length != numX) {
                this.m_spongeX = new float[numX];
            }
            if (this.m_spongeZ.length != numZ) {
                this.m_spongeZ = new float[numZ];
            }
            if (this.m_spongeY.length != numY) {
                this.m_spongeY = new float[numY];
            }
            float sponge = 0.9995f;
            for (int iz = 0; iz < numZ; ++iz) {
                this.m_spongeZ[iz] = 1.0f;
                if (iz >= boundarySize) continue;
                difference = boundarySize - iz;
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeZ[iz] = (float)Math.exp(-exp_squared);
            }
            for (int ix = 0; ix < numX; ++ix) {
                this.m_spongeX[ix] = 1.0f;
                if (ix < boundarySize) {
                    difference = boundarySize - ix;
                    exp = taperConstant * difference;
                    exp_squared = exp * exp;
                    this.m_spongeX[ix] = (float)Math.exp(-exp_squared);
                }
                if (ix < numX - boundarySize) continue;
                difference = ix - (numX - boundarySize - 1);
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeX[ix] = (float)Math.exp(-exp_squared);
            }
            for (int iy = 0; iy < numY; ++iy) {
                this.m_spongeY[iy] = 1.0f;
                if (iy < boundarySize) {
                    difference = boundarySize - iy;
                    exp = taperConstant * difference;
                    exp_squared = exp * exp;
                    this.m_spongeY[iy] = (float)Math.exp(-exp_squared);
                }
                if (iy < numY - boundarySize) continue;
                difference = iy - (numY - boundarySize - 1);
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeY[iy] = (float)Math.exp(-exp_squared);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

