/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.WaveEquation;

import com.PecosLibrary.WaveEquation.Model3D;

public class Propagator_Chelsea {
    protected int m_numX;
    protected int m_numZ;
    protected int m_numY;
    protected float[] m_spongeX = new float[2];
    protected float[] m_spongeZ = new float[2];
    protected float[] m_spongeY = new float[2];
    protected double m_epsilon = 0.9;
    protected double m_delta = 0.02;
    protected double m_timeStep = 2.5E-4;
    public double m_currentTime;
    protected int m_shotIndexX;
    protected int m_shotIndexZ;
    protected int m_shotIndexY;
    protected static long m_stepper = 0L;

    public void prepareForPropagation(Model3D model, double shotX, double shotY, double shotZ, double timeStep) {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            shotY -= model.originY();
            shotZ -= model.originZ();
            this.m_currentTime = 0.0;
            this.m_timeStep = 0.001 * timeStep;
            this.m_shotIndexX = (int)(0.5 + (shotX -= model.originX()) / model.nodeSpacing());
            this.m_shotIndexX = Math.max(0, this.m_shotIndexX);
            this.m_shotIndexX = Math.min(numX - 1, this.m_shotIndexX);
            this.m_shotIndexZ = (int)(0.5 + shotZ / model.nodeSpacing());
            this.m_shotIndexZ = Math.max(0, this.m_shotIndexZ);
            this.m_shotIndexZ = Math.min(numZ - 1, this.m_shotIndexZ);
            this.m_shotIndexY = (int)(0.5 + shotY / model.nodeSpacing());
            this.m_shotIndexY = Math.max(0, this.m_shotIndexY);
            this.m_shotIndexY = Math.min(numY - 1, this.m_shotIndexY);
            model.array_setValue("pfield_time", 0.0f);
            model.array_setValue("pfield_timeMinus", 0.0f);
            model.array_setValue("pfield_timePlus", 0.0f);
            float[][][] fArray = model.array_get("Velocity");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void propagate(Model3D model, double totalRunTime) throws Exception {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            float[][][] pqSum_time = model.array_get("pqSum");
            float[][][] pfield_time = model.array_get("pfield_time");
            float[][][] qfield_time = model.array_get("qfield_time");
            if (numX != this.m_spongeX.length) {
                throw new Exception("numX != m_spongeX.length");
            }
            if (numZ != this.m_spongeZ.length || numY != this.m_spongeY.length) {
                throw new Exception("numZ or numY != m_spongeZ.length");
            }
            int numSteps = (int)(0.001 * totalRunTime / this.m_timeStep);
            for (int step = 0; step < numSteps; ++step) {
                this.pfieldStep2Order(model);
                this.m_currentTime += this.m_timeStep;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static float sourceWavelet(double time) {
        try {
            double Alpha = 157.07963267948966;
            double Beta = -Math.log(0.2) / 0.0016;
            double peakTime = 0.02;
            double DT = Math.abs(peakTime - time);
            double s = Math.cos(Alpha * DT) * Math.exp(-Beta * DT * DT);
            ++m_stepper;
            return (float)s;
        }
        catch (Exception error) {
            error.printStackTrace();
            return 0.0f;
        }
    }

    public void pfieldStep2Order(Model3D model) {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            double nodeSpacing = model.nodeSpacing();
            float[][][] pfield_timePlus = model.array_get("pfield_timePlus");
            float[][][] pfield_time = model.array_get("pfield_time");
            float[][][] pfield_timeMinus = model.array_get("pfield_timeMinus");
            float[][][] qfield_time = model.array_get("qfield_time");
            float[][][] vel = model.array_get("Velocity");
            float[][][] del = model.array_get("Delta");
            float[][][] epsil = model.array_get("Epsilon");
            float max = 0.0f;
            for (int ix = 0; ix < numX; ++ix) {
                for (int iy = 0; iy < numY; ++iy) {
                    float tmax = 0.0f;
                    for (int iz = 0; iz < numZ; ++iz) {
                        float total = this.m_spongeX[ix] * this.m_spongeZ[iz] * this.m_spongeY[iy];
                        pfield_timeMinus[ix][iy][iz] = pfield_time[ix][iy][iz];
                        pfield_time[ix][iy][iz] = total * pfield_timePlus[ix][iy][iz];
                        max = Math.max(max, Math.abs(pfield_time[ix][iy][iz]));
                        tmax = Math.max(tmax, Math.abs(pfield_time[ix][iy][iz]));
                    }
                    if (ix != iy) continue;
                }
            }
            pfield_timeMinus[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] = 1000.0f * Propagator_Chelsea.sourceWavelet(this.m_currentTime);
            pfield_time[this.m_shotIndexX][this.m_shotIndexY][this.m_shotIndexZ] = 1000.0f * Propagator_Chelsea.sourceWavelet(this.m_currentTime);
            double scalar = this.m_timeStep / nodeSpacing;
            boolean junk = false;
            for (int ix = 1; ix < numX - 1; ++ix) {
                for (int iy = 1; iy < numY - 1; ++iy) {
                    for (int iz = 1; iz < numZ - 1; ++iz) {
                        float v0 = vel[ix][iy][iz];
                        float coeff1 = (float)((double)(v0 * v0) * scalar * scalar);
                        float timeTerm = 2.0f * pfield_time[ix][iy][iz] - pfield_timeMinus[ix][iy][iz];
                        float xterm = pfield_time[ix + 1][iy][iz] - 2.0f * pfield_time[ix][iy][iz] + pfield_time[ix - 1][iy][iz];
                        float yterm = pfield_time[ix][iy + 1][iz] - 2.0f * pfield_time[ix][iy][iz] + pfield_time[ix][iy - 1][iz];
                        float zterm = pfield_time[ix][iy][iz + 1] - 2.0f * pfield_time[ix][iy][iz] + pfield_time[ix][iy][iz - 1];
                        pfield_timePlus[ix][iy][iz] = timeTerm + coeff1 * (xterm + yterm + zterm);
                        if (ix == this.m_shotIndexX && iy == this.m_shotIndexY) {
                            junk = false;
                        }
                        if (iy == 150) {
                            // empty if block
                        }
                        if (iz != 150) continue;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void qfieldStep2Order(Model3D model) {
        try {
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            double nodeSpacing = model.nodeSpacing();
            float[][][] qfield_timePlus = model.array_get("qfield_timePlus");
            float[][][] qfield_time = model.array_get("qfield_time");
            float[][][] qfield_timeMinus = model.array_get("qfield_timeMinus");
            float[][][] pfield_time = model.array_get("pfield_time");
            float[][][] vel = model.array_get("Velocity");
            float[][][] del = model.array_get("Delta");
            float[][][] epsil = model.array_get("Epsilon");
            float max = 0.0f;
            for (int ix = 0; ix < numX; ++ix) {
                for (int iz = 0; iz < numZ; ++iz) {
                    for (int iy = 0; iy < numY; ++iy) {
                        float total = this.m_spongeX[ix] * this.m_spongeZ[iz] * this.m_spongeY[iy];
                        qfield_timeMinus[ix][iy][iz] = qfield_time[ix][iy][iz];
                        qfield_time[ix][iy][iz] = total * qfield_timePlus[ix][iy][iz];
                        max = Math.max(max, Math.abs(qfield_time[ix][iy][iz]));
                    }
                }
            }
            double timeStep = this.m_timeStep / nodeSpacing;
            for (int ix = 2; ix < numX - 2; ++ix) {
                for (int iz = 2; iz < numZ - 2; ++iz) {
                    for (int iy = 2; iy < numY - 2; ++iy) {
                        float v0 = vel[ix][iy][iz];
                        float delta = 0.0f;
                        float epsilon = 0.25f;
                        qfield_timePlus[ix][iy][iz] = (float)((double)(2.0f * qfield_time[ix][iy][iz] - qfield_timeMinus[ix][iy][iz]) + (double)(v0 * v0) * timeStep * timeStep * ((double)(2.0f * (epsilon - delta)) / (nodeSpacing * nodeSpacing) * (double)(pfield_time[ix + 1][iy][iz] - 2.0f * pfield_time[ix][iy][iz] + pfield_time[ix - 1][iy][iz] + qfield_time[ix + 1][iy][iz] - 2.0f * qfield_time[ix][iy][iz] + qfield_time[ix - 1][iy][iz] + pfield_time[ix][iy][iz + 1] - 2.0f * pfield_time[ix][iy][iz] + pfield_time[ix][iy][iz - 1] + qfield_time[ix][iy][iz + 1] - 2.0f * qfield_time[ix][iy][iz] + qfield_time[ix][iy][iz - 1])));
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void prepareSponge(Model3D model, int boundarySize, double taperConstant) {
        try {
            double exp_squared;
            double exp;
            double difference;
            int numX = model.nodeCountX();
            int numZ = model.nodeCountZ();
            int numY = model.nodeCountY();
            if (this.m_spongeX.length != numX) {
                this.m_spongeX = new float[numX];
            }
            if (this.m_spongeZ.length != numZ) {
                this.m_spongeZ = new float[numZ];
            }
            if (this.m_spongeY.length != numY) {
                this.m_spongeY = new float[numY];
            }
            float sponge = 0.9995f;
            for (int iz = 0; iz < numZ; ++iz) {
                this.m_spongeZ[iz] = 1.0f;
                if (iz >= boundarySize) continue;
                difference = boundarySize - iz;
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeZ[iz] = (float)Math.exp(-exp_squared);
            }
            for (int ix = 0; ix < numX; ++ix) {
                this.m_spongeX[ix] = 1.0f;
                if (ix < boundarySize) {
                    difference = boundarySize - ix;
                    exp = taperConstant * difference;
                    exp_squared = exp * exp;
                    this.m_spongeX[ix] = (float)Math.exp(-exp_squared);
                }
                if (ix < numX - boundarySize) continue;
                difference = ix - (numX - boundarySize - 1);
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeX[ix] = (float)Math.exp(-exp_squared);
            }
            for (int iy = 0; iy < numY; ++iy) {
                this.m_spongeY[iy] = 1.0f;
                if (iy < boundarySize) {
                    difference = boundarySize - iy;
                    exp = taperConstant * difference;
                    exp_squared = exp * exp;
                    this.m_spongeY[iy] = (float)Math.exp(-exp_squared);
                }
                if (iy < numY - boundarySize) continue;
                difference = iy - (numY - boundarySize - 1);
                exp = taperConstant * difference;
                exp_squared = exp * exp;
                this.m_spongeY[iy] = (float)Math.exp(-exp_squared);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

