/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Velocity;

import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Stack.VelocityLocationCollection;

public class VolumeStackTools {
    protected HashMap_Integers<StackEntry> m_hash = new HashMap_Integers();
    protected double m_gridSize = 5000.0;
    protected float[] m_vel;
    protected double m_x;
    protected double m_y;
    protected int m_inputCount;
    protected float m_inputDigi;
    protected float m_inputTime0;
    protected int m_outputCount;
    protected float m_outputDigi;
    protected float m_outputTime0;
    protected double m_maxOffset;
    protected double m_minOffset;
    protected int m_numOffsets;
    protected float m_muteStretch;
    protected VelocityLocationCollection m_vlc;

    public VolumeStackTools(double gridSize, VelocityLocationCollection vlc, float inputTime0, float inputDigi, int inputCount, float outputTime0, float outputDigi, int outputCount, double minOffset, double maxOffset, int numOffsets, float muteStretch) throws Exception {
        try {
            this.m_vlc = vlc;
            this.m_gridSize = gridSize;
            this.m_muteStretch = muteStretch;
            this.m_minOffset = minOffset;
            this.m_maxOffset = maxOffset;
            this.m_numOffsets = numOffsets;
            this.m_inputTime0 = inputTime0;
            this.m_inputDigi = inputDigi;
            this.m_inputCount = inputCount;
            this.m_vlc.setRequestedInterp(this.m_inputTime0, this.m_inputDigi, inputCount);
            this.m_outputTime0 = outputTime0;
            this.m_outputDigi = outputDigi;
            this.m_outputCount = outputCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean prepareOutput(double x, double y, float[] output, float[] input, float[] weight, double offset) throws Exception {
        try {
            StackEntry entry;
            if (offset < this.m_minOffset || offset >= this.m_maxOffset) {
                return false;
            }
            int ix = (int)(0.5 + x / this.m_gridSize);
            int iy = (int)(0.5 + y / this.m_gridSize);
            if (!this.m_hash.containsKey(ix, iy)) {
                x = (double)ix * this.m_gridSize;
                y = (double)iy * this.m_gridSize;
                entry = new StackEntry(x, y, this.m_vlc, this.m_inputTime0, this.m_inputDigi, this.m_inputCount, this.m_outputTime0, this.m_outputDigi, this.m_outputCount, this.m_minOffset, this.m_maxOffset, this.m_numOffsets, this.m_muteStretch);
                this.m_hash.put(entry, ix, iy);
            }
            entry = this.m_hash.get(ix, iy);
            return entry.prepareOutput(output, input, weight, offset);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static class StackEntry {
        protected float[] m_vel;
        protected double m_x;
        protected double m_y;
        protected int m_inputCount;
        protected float m_inputDigi;
        protected float m_inputTime0;
        protected int m_outputCount;
        protected float m_outputDigi;
        protected float m_outputTime0;
        protected double m_maxOffset;
        protected double m_minOffset;
        protected int m_numOffsets;
        protected float m_muteStretch;
        protected int[] m_muteIndex;
        protected short[][] m_outputIndex;

        public StackEntry(double x, double y, VelocityLocationCollection vlc, float inputTime0, float inputDigi, int inputCount, float outputTime0, float outputDigi, int outputCount, double minOffset, double maxOffset, int numOffsets, float muteStretch) throws Exception {
            try {
                this.m_inputTime0 = inputTime0;
                this.m_inputDigi = inputDigi;
                this.m_inputCount = inputCount;
                this.m_muteStretch = muteStretch;
                this.m_minOffset = minOffset;
                this.m_maxOffset = maxOffset;
                this.m_numOffsets = numOffsets;
                this.m_outputTime0 = outputTime0;
                this.m_outputDigi = outputDigi;
                this.m_outputCount = outputCount;
                this.m_vel = vlc.getVelocity(x, y);
                this.m_outputIndex = new short[this.m_numOffsets][this.m_inputCount];
                this.m_muteIndex = new int[this.m_numOffsets];
                float muteFactor = 0.01f * this.m_muteStretch + 1.0f;
                for (int n = 0; n < this.m_numOffsets; ++n) {
                    this.m_muteIndex[n] = -999;
                    double offset = this.m_minOffset + (double)n * (this.m_maxOffset - this.m_minOffset) / (double)(this.m_numOffsets - 1);
                    for (int s = 0; s < this.m_inputCount; ++s) {
                        double outputTime;
                        int outputIndex;
                        this.m_outputIndex[n][s] = -9999;
                        double inputTime = (double)this.m_inputTime0 + (double)s * (double)this.m_inputDigi;
                        double v = this.m_vel[s];
                        double outputTimeSquared = inputTime * inputTime - 1000000.0 * offset * offset / (v * v);
                        if (!(outputTimeSquared > 0.0) || (outputIndex = (int)(0.5 + (outputTime = Math.sqrt(outputTimeSquared + 1.0E-6)) / (double)this.m_outputDigi)) < 0 || outputIndex >= this.m_outputCount) continue;
                        this.m_outputIndex[n][s] = (short)outputIndex;
                        if (!(inputTime / outputTime > (double)muteFactor) || this.m_muteIndex[n] >= 0) continue;
                        this.m_muteIndex[n] = s;
                    }
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }

        public boolean prepareOutput(float[] output, float[] input, float[] weight, double offset) throws Exception {
            try {
                for (int s = 0; s < output.length; ++s) {
                    output[s] = 0.0f;
                    weight[s] = 0.0f;
                }
                if (offset < this.m_minOffset || offset >= this.m_maxOffset) {
                    return false;
                }
                double offsetIndex = (double)(this.m_numOffsets - 1) * (offset - this.m_minOffset) / (this.m_maxOffset - this.m_minOffset);
                int nearestIndex = (int)(0.5 + offsetIndex);
                nearestIndex = Math.max(0, nearestIndex);
                nearestIndex = Math.min(this.m_numOffsets - 1, nearestIndex);
                short[] outputIndex = this.m_outputIndex[nearestIndex];
                int muteIndex = this.m_muteIndex[nearestIndex];
                if (muteIndex < 0) {
                    return false;
                }
                for (int s = muteIndex; s < this.m_inputCount; ++s) {
                    short index = outputIndex[s];
                    if (index < 0) continue;
                    weight[index] = 1.0f;
                    output[index] = input[s];
                }
                return true;
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }
}

