/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Velocity;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Velocity.VolumeStackTools;

public class StackSegmentizor {
    protected VolumeStackTools m_stacker;
    protected Grid3D m_grid;
    protected VelocityLocationCollection m_vlc;
    protected double m_velFunctionSpacing;
    protected int m_outputCount;
    protected int m_sumCount;
    protected float m_outputDigi;
    protected float m_outputStartTime;
    protected float m_outputEndTime;
    protected float m_sumDigi;
    protected int m_inputCount;
    protected float m_inputDigi;
    protected float m_inputTime0;
    protected float[] m_inputData;
    protected double m_maxOffset;
    protected double m_minOffset;
    protected int m_numOffsets;
    protected float[] m_outputData;
    protected float[] m_outputWeight;
    protected int m_numInline;
    protected int m_numCrossline;
    protected int m_numInlinesPerSegment;
    protected int m_numSegments;
    protected float m_muteStretch;
    protected int m_binSprayRadius;
    protected boolean m_bFirstSegment = true;
    protected int m_segmentMinInline;
    protected int m_segmentMaxInline;
    protected int m_segmentMinCrossline;
    protected int m_segmentMaxCrossline;
    protected float[][][] m_stackSum;
    protected float[][][] m_stackWeight;

    public StackSegmentizor(VelocityLocationCollection vlc, double velFunctionSpacing, Grid3D grid, float inputTime0, float inputDigi, int inputCount, float outputStartTime, float outputEndTime, double minOffset, double maxOffset, int numOffsets, int binSprayRadius, float muteStretch) {
        try {
            this.m_grid = grid;
            this.m_vlc = vlc;
            this.m_velFunctionSpacing = velFunctionSpacing;
            this.m_muteStretch = muteStretch;
            this.m_binSprayRadius = Math.max(binSprayRadius, 0);
            this.m_binSprayRadius = Math.min(this.m_binSprayRadius, 3);
            this.m_minOffset = minOffset;
            this.m_maxOffset = maxOffset;
            this.m_numOffsets = numOffsets;
            this.m_inputTime0 = inputTime0;
            this.m_inputDigi = inputDigi;
            this.m_inputCount = inputCount;
            this.m_inputData = new float[this.m_inputCount];
            this.m_outputStartTime = outputStartTime;
            this.m_outputEndTime = outputEndTime;
            this.m_outputDigi = 4.0f;
            this.m_sumDigi = 1.0f;
            this.m_outputCount = (int)((this.m_outputEndTime - this.m_outputStartTime) / this.m_outputDigi);
            this.m_sumCount = 4 * this.m_outputCount;
            this.m_outputWeight = new float[this.m_sumCount];
            this.m_outputData = new float[this.m_sumCount];
            this.m_stacker = new VolumeStackTools(this.m_velFunctionSpacing, this.m_vlc, this.m_inputTime0, this.m_inputDigi, this.m_inputCount, this.m_outputStartTime, this.m_sumDigi, this.m_sumCount, this.m_minOffset, this.m_maxOffset, this.m_numOffsets, this.m_muteStretch);
            int bytesPerSumTrace = 8 * this.m_sumCount;
            this.m_numInline = 1 + this.m_grid.inlineMax() - this.m_grid.inlineMin();
            this.m_numCrossline = 1 + this.m_grid.crosslineMax() - this.m_grid.crosslineMin();
            long bytesPerInline = (long)bytesPerSumTrace * (long)this.m_numCrossline;
            this.m_numInlinesPerSegment = 1 + 300000000 / (int)bytesPerInline;
            this.m_numSegments = 1 + this.m_numInline / this.m_numInlinesPerSegment;
            long l = (long)bytesPerSumTrace * (long)this.m_numInline * (long)this.m_numCrossline;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int numInlinesPerSegment() {
        return this.m_numInlinesPerSegment;
    }

    public int numSegments() {
        return this.m_numSegments;
    }

    public boolean prepareNextSegment() {
        try {
            this.m_segmentMinCrossline = this.m_grid.crosslineMin();
            this.m_segmentMaxCrossline = this.m_grid.crosslineMax();
            if (this.m_bFirstSegment) {
                this.m_bFirstSegment = false;
                this.m_segmentMinInline = this.m_grid.inlineMin();
                this.m_segmentMaxInline = this.m_segmentMinInline + this.m_numInlinesPerSegment - 1;
                this.m_stackSum = new float[this.m_numInlinesPerSegment][this.m_numCrossline][this.m_sumCount];
                this.m_stackWeight = new float[this.m_numInlinesPerSegment][this.m_numCrossline][this.m_sumCount];
            } else {
                this.m_segmentMinInline = this.m_segmentMaxInline + 1;
                this.m_segmentMaxInline = this.m_segmentMinInline + this.m_numInlinesPerSegment - 1;
                if (this.m_segmentMinInline > this.m_grid.inlineMax()) {
                    return false;
                }
            }
            for (int i = 0; i < this.m_numInlinesPerSegment; ++i) {
                for (int c = 0; c < this.m_numCrossline; ++c) {
                    for (int s = 0; s < this.m_sumCount; ++s) {
                        this.m_stackSum[i][c][s] = 0.0f;
                        this.m_stackSum[i][c][s] = 0.0f;
                    }
                }
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean finishCurrentSegment() {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void addEnsemble(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "Inline")) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "Crossline")) {
                return;
            }
            int indexInline = ensemble.dictionary().getEntryIndex("Trace", "Inline");
            int indexCrossline = ensemble.dictionary().getEntryIndex("Trace", "Crossline");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int minInlineWithSpray = this.m_segmentMinInline - this.m_binSprayRadius;
            int maxInlineWithSpray = this.m_segmentMaxInline + this.m_binSprayRadius;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                boolean killed = trace.header().getBool(indexShotKilled) || trace.header().getBool(indexRecKilled);
                double offset = trace.header().getDouble(indexOffset);
                int inline = trace.header().getInt(indexInline);
                int crossline = trace.header().getInt(indexCrossline);
                double cdpx = this.m_grid.getWorldX(inline, crossline);
                double cdpy = this.m_grid.getWorldY(inline, crossline);
                if (inline < minInlineWithSpray || inline > maxInlineWithSpray || killed || !this.m_stacker.prepareOutput(cdpx, cdpy, this.m_outputData, this.m_inputData, this.m_outputWeight, offset)) continue;
                for (int i = inline - this.m_binSprayRadius; i <= inline + this.m_binSprayRadius; ++i) {
                    for (int c = crossline - this.m_binSprayRadius; c <= crossline + this.m_binSprayRadius; ++c) {
                        if (i < this.m_segmentMinInline || i > this.m_segmentMaxInline || c < this.m_segmentMinCrossline || c > this.m_segmentMaxCrossline) continue;
                        int inlineIndexInArray = i - this.m_segmentMinInline;
                        int crosslineIndexInArray = c - this.m_segmentMinCrossline;
                        float[] output = this.m_stackSum[inlineIndexInArray][crosslineIndexInArray];
                        float[] weight = this.m_stackWeight[inlineIndexInArray][crosslineIndexInArray];
                        for (int s = 0; s < this.m_sumCount; ++s) {
                            output[s] = output[s] + this.m_outputData[s];
                            weight[s] = weight[s] + this.m_outputWeight[s];
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

