/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Velocity;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class RmsVelocityFunction
extends AbstractTableModel {
    protected ArrayList<Entry> m_list = new ArrayList();
    public boolean DixOkay = false;
    public String FailReason = "";
    public float SampleInterval;
    public float[] Time;
    public float[] RMS;
    public float[] Interval;
    public float[] SinAngle;

    public void computeArrays(float t0, float digi, int numSamples) {
        try {
            this.dix();
            this.SampleInterval = Math.max(digi, 0.5f);
            boolean needArrays = true;
            if (this.Time != null) {
                boolean bl = needArrays = this.Time.length != numSamples;
            }
            if (needArrays) {
                this.Time = new float[numSamples];
                this.RMS = new float[numSamples];
                this.Interval = new float[numSamples];
                this.SinAngle = new float[numSamples];
            }
            for (int n = 0; n < numSamples; ++n) {
                this.Time[n] = t0 + this.SampleInterval * (float)n;
                this.RMS[n] = (float)this.getRMS(this.Time[n]);
                this.Interval[n] = (float)this.getInterval(this.Time[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeSinAngle(double offset) {
        try {
            for (int n = 0; n < this.Time.length; ++n) {
                this.SinAngle[n] = 0.0f;
                double t = 0.001 * (double)this.Time[n];
                double rsq = this.RMS[n] * this.RMS[n];
                double denom = t * t + offset * offset / rsq;
                if (!(denom > 1.0E-10)) continue;
                this.SinAngle[n] = (float)(offset * (double)this.Interval[n] / (rsq * Math.sqrt(denom)));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double getInterval(double time) {
        try {
            int num = this.m_list.size();
            if (num < 1) {
                return -9999.0;
            }
            if (this.m_list.get((int)0).Time >= time) {
                return this.m_list.get((int)0).Velocity_Interval;
            }
            if (this.m_list.get((int)(num - 1)).Time <= time) {
                return this.m_list.get((int)(num - 1)).Velocity_Interval;
            }
            for (int n = 1; n < num; ++n) {
                Entry e1 = this.m_list.get(n - 1);
                Entry e2 = this.m_list.get(n);
                if (!(time >= e1.Time) || !(time <= e2.Time)) continue;
                return e2.Velocity_Interval;
            }
            return this.m_list.get((int)(num - 1)).Velocity_Interval;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0;
        }
    }

    public double getRMS(double time) {
        try {
            int num = this.m_list.size();
            if (num < 1) {
                return -9999.0;
            }
            if (this.m_list.get((int)0).Time >= time) {
                return this.m_list.get((int)0).Velocity_RMS;
            }
            if (this.m_list.get((int)(num - 1)).Time <= time) {
                return this.m_list.get((int)(num - 1)).Velocity_RMS;
            }
            for (int n = 1; n < num; ++n) {
                Entry e1 = this.m_list.get(n - 1);
                Entry e2 = this.m_list.get(n);
                if (!(time >= e1.Time) || !(time <= e2.Time)) continue;
                double a = (e2.Velocity_RMS - e1.Velocity_RMS) / (e2.Time - e1.Time);
                double b = e1.Velocity_RMS - a * e1.Time;
                return a * time + b;
            }
            return this.m_list.get((int)(num - 1)).Velocity_RMS;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999.0;
        }
    }

    public void dix() {
        try {
            for (Entry e : this.m_list) {
                e.Velocity_Interval = -9999.0;
            }
            this.DixOkay = false;
            if (this.m_list.size() < 1) {
                this.FailReason = "No time/velocity pairs";
                return;
            }
            Entry e = this.m_list.get(0);
            e.Velocity_Interval = e.Velocity_RMS;
            for (int n = 1; n < this.m_list.size(); ++n) {
                Entry e1 = this.m_list.get(n - 1);
                Entry e2 = this.m_list.get(n);
                if (e2.Time <= e1.Time) {
                    this.FailReason = "Times do not increase";
                    return;
                }
                double v2 = e2.Velocity_RMS;
                double t2 = 0.001 * e2.Time;
                double v1 = e1.Velocity_RMS;
                double t1 = 0.001 * e1.Time;
                double top = v2 * v2 * t2 - v1 * v1 * t1;
                if (top <= 0.0) {
                    this.FailReason = "Dix numerator is negative...";
                    return;
                }
                e2.Velocity_Interval = Math.sqrt(top / (t2 - t1));
            }
            this.DixOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailReason = error.getMessage();
        }
    }

    public void save(String fileName) {
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (Entry e : this.m_list) {
                writer.write(Double.toString(e.Time));
                writer.write("  ");
                writer.write(Double.toString(e.Velocity_RMS));
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void read(String fileName) {
        try {
            this.DixOkay = false;
            this.m_list.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.FailReason = "File not present";
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            double priorTime = -99999.0;
            while (line != null) {
                if (line.contains("MSEC=")) {
                    int index1 = line.indexOf("MSEC=");
                    int index2 = line.indexOf("VEL=");
                    String timeString = line.substring(index1 + 5, index2);
                    String velString = line.substring(index2 + 4);
                    double t = Double.parseDouble(timeString);
                    double v = Double.parseDouble(velString);
                    if (t > priorTime) {
                        priorTime = t;
                        Entry e = new Entry();
                        e.Time = t;
                        e.Velocity_RMS = v;
                        this.m_list.add(e);
                    }
                } else {
                    ArrayList<String> tokens = Tools_Strings.tokenizer_space(line, false);
                    if (tokens.size() >= 2) {
                        double t = Double.parseDouble(tokens.get(0));
                        double v = Double.parseDouble(tokens.get(1));
                        if (t > priorTime) {
                            priorTime = t;
                            Entry e = new Entry();
                            e.Time = t;
                            e.Velocity_RMS = v;
                            this.m_list.add(e);
                        }
                    }
                }
                line = br.readLine();
            }
            br.close();
            this.dix();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean columnLocked(String colName) {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Time";
            }
            if (column == 1) {
                return "RMS velocity";
            }
            if (column == 2) {
                return "Interval velocity";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        return this.m_list.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            Entry e = this.m_list.get(row);
            if (column == 0) {
                return Double.toString(e.Time);
            }
            if (column == 1) {
                return Integer.toString((int)(0.5 + e.Velocity_RMS));
            }
            if (column == 2) {
                if (e.Velocity_Interval > 1.0) {
                    return Integer.toString((int)(0.5 + e.Velocity_Interval));
                }
                return "Not valid";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public class Entry {
        public double Time;
        public double Velocity_RMS;
        public double Velocity_Interval;
        public boolean IntervalValid = false;
    }
}

