/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Java2D.Java2D_PointSymbol;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.awt.Color;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class VolumeStackManager {
    protected boolean m_valid = false;
    protected String m_path;
    protected Grid3D m_countGrid;
    protected Grid3D m_weightGrid;
    protected String m_inlineStackPath;
    protected ParameterTree m_parameters = new ParameterTree();
    protected int m_crosslineCount;
    protected int m_samplesPerTrace;
    protected int m_headerCount;
    protected float m_digi;
    protected float m_time0;

    public boolean valid() {
        return this.m_valid;
    }

    public void setPath(String path) {
        try {
            this.m_valid = false;
            this.m_path = path;
            this.m_inlineStackPath = this.m_path + "/InlineStacks";
            String countGridName = path + "/count.grid3d";
            this.m_countGrid = new Grid3D(countGridName);
            String weightGridName = path + "/weight.grid3d";
            this.m_weightGrid = new Grid3D(weightGridName);
            String paramFileName = path + "/params.xml";
            this.m_parameters.read(paramFileName);
            this.m_time0 = (float)this.m_parameters.double_get("MinTime");
            this.m_digi = (float)this.m_parameters.double_get("Digi");
            this.m_crosslineCount = this.m_parameters.int_get("CrosslineCount");
            this.m_samplesPerTrace = this.m_parameters.int_get("SamplesPerTrace");
            this.m_headerCount = this.m_parameters.int_get("HeaderCount");
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int appendHorizonToGrid(int horizonIndex, Grid3D grid, int inline) {
        try {
            if (!this.m_valid) {
                return 0;
            }
            String hdrFileName = this.m_inlineStackPath + "/" + Integer.toString(inline) + ".hdr";
            if (!Tools_FileSystem.exists_file(hdrFileName)) {
                return 0;
            }
            int totalHeaderBytes = this.m_crosslineCount * 4 * this.m_headerCount;
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(1, totalHeaderBytes);
            RandomAccessFile file = new RandomAccessFile(hdrFileName, "rw");
            file.read(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
            int count = 0;
            for (int n = 0; n < this.m_crosslineCount; ++n) {
                int offset = 4 * n * this.m_headerCount;
                offset += 4 * (2 + horizonIndex);
                double x = this.m_weightGrid.getWorldX(inline, n + this.crosslineMin());
                double y = this.m_weightGrid.getWorldY(inline, n + this.crosslineMin());
                float pick = bufferHeader.getFloat(offset);
                if (!(pick > 1.0f)) continue;
                grid.interp_Add(x, y, pick, 1.0f);
                ++count;
            }
            return count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public Grid3D getHorizonGrid(int horizonIndex) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            Grid3D grid = project.getEmptyGrid3D();
            grid.interp_Prep();
            int count = 0;
            for (int inline = this.inlineMin(); inline <= this.inlineMax(); ++inline) {
                count += this.appendHorizonToGrid(horizonIndex, grid, inline);
            }
            if (count < 1) {
                return null;
            }
            grid.interp_Finish(4);
            grid.interp_Free();
            return grid;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void saveInlineEnsembleHeaders(Ensemble ensemble, int inline) {
        try {
            if (!this.m_valid) {
                return;
            }
            String hdrFileName = this.m_inlineStackPath + "/" + Integer.toString(inline) + ".hdr";
            if (!Tools_FileSystem.exists_file(hdrFileName)) {
                return;
            }
            int totalHeaderBytes = this.m_crosslineCount * 4 * this.m_headerCount;
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(0, totalHeaderBytes);
            RandomAccessFile file = new RandomAccessFile(hdrFileName, "rw");
            file.read(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
            int numHorizons = 4;
            int totalHeaders = 2 + numHorizons;
            int[] indexHeader = new int[totalHeaders];
            indexHeader[0] = ensemble.dictionary().addEntry("Trace", "Count", DataType.Double);
            indexHeader[1] = ensemble.dictionary().addEntry("Trace", "Amplitude", DataType.Double);
            for (int h = 0; h < numHorizons; ++h) {
                String s = Pecos.getColNameHorizon(h + 1);
                indexHeader[h + 2] = ensemble.dictionary().addEntry("Trace", s, DataType.Double);
            }
            for (int n = 0; n < this.m_crosslineCount; ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                int offset = n * 4 * this.m_headerCount;
                for (int h = 2; h < totalHeaders; ++h) {
                    float ht = header.getFloat(indexHeader[h]);
                    bufferHeader.putFloat(h * 4 + offset, ht);
                }
            }
            file = new RandomAccessFile(hdrFileName, "rw");
            file.write(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return;
        }
    }

    public float stackAmplitude(float[] stack) {
        try {
            float sum = 0.0f;
            for (int n = 0; n < stack.length; ++n) {
                sum += Math.abs(stack[n]);
            }
            return sum / (float)stack.length;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    public void killPicks(int horizonIndex) {
        try {
            for (int inline = this.inlineMin(); inline <= this.inlineMax(); ++inline) {
                this.killPicks(horizonIndex, inline);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void killPicks(int horizonIndex, int inline) {
        try {
            if (!this.m_valid) {
                return;
            }
            String hdrFileName = this.m_inlineStackPath + "/" + Integer.toString(inline) + ".hdr";
            if (!Tools_FileSystem.exists_file(hdrFileName)) {
                return;
            }
            int totalHeaderBytes = this.m_crosslineCount * 4 * this.m_headerCount;
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(1, totalHeaderBytes);
            RandomAccessFile file = new RandomAccessFile(hdrFileName, "rw");
            file.read(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
            for (int n = 0; n < this.m_crosslineCount; ++n) {
                int offset = 4 * n * this.m_headerCount;
                bufferHeader.putFloat(offset += 4 * (2 + horizonIndex), -9999.0f);
            }
            file = new RandomAccessFile(hdrFileName, "rw");
            file.write(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Ensemble getInlineEnsemble(int inline) {
        try {
            Ensemble ensemble = new Ensemble();
            if (!this.m_valid) {
                return ensemble;
            }
            String dataFileName = this.m_inlineStackPath + "/" + Integer.toString(inline) + ".data";
            String hdrFileName = this.m_inlineStackPath + "/" + Integer.toString(inline) + ".hdr";
            if (!Tools_FileSystem.exists_file(dataFileName)) {
                return ensemble;
            }
            if (!Tools_FileSystem.exists_file(hdrFileName)) {
                return ensemble;
            }
            int totalDataBytes = this.m_crosslineCount * 4 * this.m_samplesPerTrace;
            int totalHeaderBytes = this.m_crosslineCount * 4 * this.m_headerCount;
            ByteBuffer bufferData = ByteBuffer_Shared.buffer(0, totalDataBytes);
            ByteBuffer bufferHeader = ByteBuffer_Shared.buffer(1, totalHeaderBytes);
            RandomAccessFile file = new RandomAccessFile(dataFileName, "rw");
            file.read(bufferData.array(), 0, totalDataBytes);
            file.close();
            file = new RandomAccessFile(hdrFileName, "rw");
            file.read(bufferHeader.array(), 0, totalHeaderBytes);
            file.close();
            float[] data = new float[this.m_samplesPerTrace];
            int indexInline = ensemble.dictionary().addEntry("Trace", "Inline", DataType.Int);
            int indexCrossline = ensemble.dictionary().addEntry("Trace", "Crossline", DataType.Int);
            int indexX = ensemble.dictionary().addEntry("Trace", "CdpX", DataType.Double);
            int indexY = ensemble.dictionary().addEntry("Trace", "CdpY", DataType.Double);
            int numHorizons = 4;
            int totalHeaders = 2 + numHorizons;
            int[] indexHeader = new int[totalHeaders];
            indexHeader[0] = ensemble.dictionary().addEntry("Trace", "Count", DataType.Double);
            indexHeader[1] = ensemble.dictionary().addEntry("Trace", "Amplitude", DataType.Double);
            for (int h = 0; h < numHorizons; ++h) {
                String s = Pecos.getColNameHorizon(h + 1);
                indexHeader[h + 2] = ensemble.dictionary().addEntry("Trace", s, DataType.Double);
            }
            float minAmp = Float.MAX_VALUE;
            float maxAmp = Float.MIN_VALUE;
            for (int n = 0; n < this.m_crosslineCount; ++n) {
                EnsembleTrace trace = ensemble.addTrace();
                Column_Abstract header = trace.header();
                header.putInt(indexInline, inline);
                header.putInt(indexCrossline, n + this.crosslineMin());
                double x = this.m_weightGrid.getWorldX(inline, n + this.crosslineMin());
                double y = this.m_weightGrid.getWorldY(inline, n + this.crosslineMin());
                header.putDouble(indexX, x);
                header.putDouble(indexY, y);
                int offset = n * 4 * this.m_samplesPerTrace;
                for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                    data[s] = bufferData.getFloat(offset + s * 4);
                }
                offset = n * 4 * this.m_headerCount;
                for (int h = 0; h < totalHeaders; ++h) {
                    float ht = bufferHeader.getFloat(h * 4 + offset);
                    header.putDouble(indexHeader[h], ht);
                }
                float stackAmp = this.stackAmplitude(data);
                minAmp = Math.min(minAmp, stackAmp);
                maxAmp = Math.max(maxAmp, stackAmp);
                trace.data().insertArray(data, this.m_samplesPerTrace);
                trace.data().setFirstSampleCoord(this.m_time0);
                trace.data().setSampleInterval(this.m_digi);
            }
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(1), Color.black, 5, Java2D_PointSymbol.FilledSquare);
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(2), Color.magenta, 5, Java2D_PointSymbol.FilledSquare);
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(3), Color.cyan, 5, Java2D_PointSymbol.FilledSquare);
            ensemble.pickPlotData().add(Pecos.getColNameHorizon(4), Color.black, 5, Java2D_PointSymbol.FilledSquare);
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public int crosslineMin() {
        return this.m_weightGrid.crosslineMin();
    }

    public int inlineMin() {
        return this.m_weightGrid.inlineMin();
    }

    public int inlineMax() {
        return this.m_weightGrid.inlineMax();
    }

    public Grid3D weightGrid() {
        return this.m_weightGrid;
    }
}

