/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Stack.VelocityLocation;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VelocityLocationCollection
implements Java2D_PaintableInterface {
    protected ArrayList<VelocityLocation> m_locations = new ArrayList();
    protected boolean m_transformValid = false;
    protected double m_scaleX;
    protected double m_shiftX;
    protected double m_scaleY;
    protected double m_shiftY;
    public VelocityLocation SelectedLocation = null;
    protected double[] m_sum = new double[10];
    protected int m_requestedSampleCount = 10;
    protected float m_requestedSampleInterval = 4.0f;
    protected float m_requestedStartTime = 0.0f;

    public int size() {
        return this.m_locations.size();
    }

    public int numValid() {
        try {
            int count = 0;
            for (VelocityLocation loc : this.m_locations) {
                if (loc.numPicks() <= 0) continue;
                ++count;
            }
            return count;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void deleteLocation(int pixelX, int pixelY) throws Exception {
        try {
            for (int n = this.m_locations.size() - 1; n >= 0; --n) {
                VelocityLocation loc = this.m_locations.get(n);
                if (loc.numPicks() >= 1) continue;
                if (loc == this.SelectedLocation) {
                    this.SelectedLocation = null;
                }
                this.m_locations.remove(n);
            }
            if (!this.m_transformValid) {
                throw new Exception("m_transformValid == false");
            }
            int minDist = 1000000000;
            int nearest = -9999;
            for (int n = 0; n < this.m_locations.size(); ++n) {
                VelocityLocation loc = this.m_locations.get(n);
                int dist = Math.abs(pixelX - loc.PixelX) + Math.abs(pixelY - loc.PixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                VelocityLocation loc = this.m_locations.get(nearest);
                if (loc == this.SelectedLocation) {
                    this.SelectedLocation = null;
                }
                this.m_locations.remove(nearest);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void clearLocations() {
        try {
            this.m_locations.clear();
            this.SelectedLocation = null;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean selectLocation(int pixelX, int pixelY) throws Exception {
        try {
            for (int n = this.m_locations.size() - 1; n >= 0; --n) {
                VelocityLocation loc = this.m_locations.get(n);
                if (loc.numPicks() >= 1) continue;
                if (loc == this.SelectedLocation) {
                    this.SelectedLocation = null;
                }
                this.m_locations.remove(n);
            }
            if (!this.m_transformValid) {
                throw new Exception("m_transformValid == false");
            }
            int minDist = 25;
            int nearest = -9999;
            for (int n = 0; n < this.m_locations.size(); ++n) {
                VelocityLocation loc = this.m_locations.get(n);
                int dist = Math.abs(pixelX - loc.PixelX) + Math.abs(pixelY - loc.PixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                if (this.m_locations.get(nearest) != this.SelectedLocation) {
                    this.SelectedLocation = this.m_locations.get(nearest);
                    return true;
                }
                return false;
            }
            this.SelectedLocation = new VelocityLocation();
            this.SelectedLocation.X = ((double)pixelX - this.m_shiftX) / this.m_scaleX;
            this.SelectedLocation.Y = ((double)pixelY - this.m_shiftY) / this.m_scaleY;
            this.SelectedLocation.PixelX = pixelX;
            this.SelectedLocation.PixelY = pixelY;
            this.m_locations.add(this.SelectedLocation);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void setRequestedInterp(float t0, float digi, int count) {
        try {
            this.m_requestedSampleCount = count;
            this.m_requestedSampleInterval = digi;
            this.m_requestedStartTime = t0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void importEchosAscii(String fileName) {
        try {
            this.m_locations.clear();
            this.SelectedLocation = null;
            ArrayList<String> lines = Tools_FileSystem.readAscii(fileName);
            for (String line : lines) {
                ArrayList<String> tokens = Tools_Strings.tokenizer(line);
                if (tokens.size() < 1) continue;
                boolean isKey = tokens.get(0).equalsIgnoreCase("XYVFUNC");
                if (isKey && tokens.size() >= 3) {
                    this.SelectedLocation = new VelocityLocation();
                    this.SelectedLocation.X = Double.parseDouble(tokens.get(1));
                    this.SelectedLocation.Y = Double.parseDouble(tokens.get(2));
                    this.m_locations.add(this.SelectedLocation);
                }
                if (isKey || tokens.size() < 2 || this.SelectedLocation == null) continue;
                int numPairs = tokens.size() / 2;
                for (int p = 0; p < numPairs; ++p) {
                    double t = Double.parseDouble(tokens.get(2 * p));
                    double v = Double.parseDouble(tokens.get(2 * p + 1));
                    this.SelectedLocation.addPickFromAuto(t, v);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[] getVelocity(double x, double y) throws Exception {
        try {
            float[] array = new float[this.m_requestedSampleCount];
            if (this.m_sum.length != this.m_requestedSampleCount) {
                this.m_sum = new double[this.m_requestedSampleCount];
            }
            for (int n = 0; n < this.m_requestedSampleCount; ++n) {
                this.m_sum[n] = 0.0;
            }
            int count = 0;
            double sumWeight = 1.0E-40;
            for (VelocityLocation loc : this.m_locations) {
                if (loc.numPicks() <= 0) continue;
                loc.setRequestedInterp(this.m_requestedStartTime, this.m_requestedSampleInterval, this.m_requestedSampleCount);
                float[] v = loc.getInterpolatedVelocity();
                double dx = 0.01 * (x - loc.X);
                double dy = 0.01 * (y - loc.Y);
                double rsq = dx * dx + dy * dy;
                double w = 1.0 / (1.0E-6 + rsq);
                ++count;
                sumWeight += w;
                for (int n = 0; n < this.m_requestedSampleCount; ++n) {
                    this.m_sum[n] = this.m_sum[n] + w * (double)v[n];
                }
            }
            if (count < 1) {
                throw new Exception("count < 1");
            }
            for (int n = 0; n < this.m_requestedSampleCount; ++n) {
                array[n] = (float)(this.m_sum[n] / sumWeight);
            }
            return array;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getVelocityAtTime(double x, double y, double time) throws Exception {
        try {
            int count = 0;
            double sumWeight = 1.0E-40;
            double sum = 0.0;
            for (VelocityLocation loc : this.m_locations) {
                if (loc.numPicks() <= 0) continue;
                double dx = 0.01 * (x - loc.X);
                double dy = 0.01 * (y - loc.Y);
                double rsq = dx * dx + dy * dy;
                double w = 1.0 / (1.0E-6 + rsq);
                ++count;
                double velocity = loc.getVelocityAtTime(time);
                sum += w * velocity;
                sumWeight += w;
            }
            if (count < 1) {
                throw new Exception("count < 1");
            }
            return sum / sumWeight;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void save(String fileName) {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("Velocity");
            document.appendChild(root);
            for (VelocityLocation loc : this.m_locations) {
                if (loc.numPicks() <= 0) continue;
                loc.writeToNode(root);
            }
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            this.m_locations.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            ArrayList<Element> entryList = Tools_XML.getChildListWithTagName(root, "Location");
            for (Element e : entryList) {
                VelocityLocation loc = new VelocityLocation();
                loc.readFromNode(e);
                this.m_locations.add(loc);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.green);
            int size = 15;
            int h = size / 2;
            this.m_transformValid = true;
            this.m_scaleX = transform.scaleX();
            this.m_shiftX = transform.shiftX();
            this.m_scaleY = transform.scaleY();
            this.m_shiftY = transform.shiftY();
            for (VelocityLocation loc : this.m_locations) {
                loc.PixelX = (int)(this.m_scaleX * loc.X + this.m_shiftX);
                loc.PixelY = (int)(this.m_scaleY * loc.Y + this.m_shiftY);
                g2d.fillOval(loc.PixelX - h, loc.PixelY - h, size, size);
            }
            if (this.SelectedLocation != null) {
                g2d.setColor(Color.red);
                g2d.drawOval(this.SelectedLocation.PixelX - h, this.SelectedLocation.PixelY - h, size, size);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void semblancePaint(Java2D_PaintParameter paintParameter) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_3);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            this.m_transformValid = true;
            this.m_scaleX = transform.scaleX();
            this.m_shiftX = transform.shiftX();
            this.m_scaleY = transform.scaleY();
            this.m_shiftY = transform.shiftY();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void noNmoPaint(Java2D_PaintParameter paintParameter) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double d = transform.shiftY();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            for (VelocityLocation loc : this.m_locations) {
                rangeX.expandRange(loc.X);
                rangeY.expandRange(loc.Y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

