/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Tools.Tools_GraphicalObjectLibrary;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.w3c.dom.Element;

public class VelocityLocation
implements Java2D_PaintableInterface {
    protected ArrayList<Pick> m_picks = new ArrayList();
    public double X;
    public double Y;
    public int PixelX;
    public int PixelY;
    protected boolean m_semblancePlotValid = false;
    protected double m_semblanceScaleX;
    protected double m_semblanceShiftX;
    protected double m_semblanceScaleY;
    protected double m_semblanceShiftY;
    protected float[] m_velocity = new float[10];
    protected boolean m_dirty = true;
    protected int m_requestedSampleCount = 10;
    protected float m_requestedSampleInterval = 4.0f;
    protected float m_requestedStartTime = 0.0f;

    public int numPicks() {
        return this.m_picks.size();
    }

    public Pick pick(int index) {
        return this.m_picks.get(index);
    }

    public float requestedStartTime() {
        return this.m_requestedStartTime;
    }

    public float requestedSampleInterval() {
        return this.m_requestedSampleInterval;
    }

    public void setRequestedInterp(float t0, float digi, int count) {
        try {
            count = Math.max(count, 10);
            if (count != this.m_velocity.length) {
                this.m_dirty = true;
            }
            if (Math.abs(digi - this.m_requestedSampleInterval) > 0.01f) {
                this.m_dirty = true;
            }
            if (Math.abs(t0 - this.m_requestedStartTime) > 0.1f) {
                this.m_dirty = true;
            }
            if (!this.m_dirty) {
                return;
            }
            this.m_requestedSampleCount = count;
            this.m_requestedSampleInterval = digi;
            this.m_requestedStartTime = t0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public float[] getInterpolatedVelocity() throws Exception {
        try {
            if (!this.m_dirty) {
                return this.m_velocity;
            }
            this.checkOrder();
            if (this.m_velocity.length != this.m_requestedSampleCount) {
                this.m_velocity = new float[this.m_requestedSampleCount];
            }
            if (this.m_picks.size() < 1) {
                for (int n = 0; n < this.m_requestedSampleCount; ++n) {
                    this.m_velocity[n] = 10000.0f;
                }
                return this.m_velocity;
            }
            for (int n = 0; n < this.m_requestedSampleCount; ++n) {
                double time = (double)this.m_requestedStartTime + (double)n * (double)this.m_requestedSampleInterval;
                this.m_velocity[n] = (float)this.getVelocityAtTime(time);
            }
            this.m_dirty = false;
            return this.m_velocity;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean checkOrder() throws Exception {
        try {
            for (int n = 1; n < this.m_picks.size(); ++n) {
                Pick p1 = this.m_picks.get(n - 1);
                Pick p2 = this.m_picks.get(n);
                if (!(p1.Time >= p2.Time)) continue;
                throw new Exception("p1.Time >= p2.Time");
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getVelocityAtTime(double time) throws Exception {
        try {
            int num = this.m_picks.size();
            if (num < 1) {
                throw new Exception("m_picks.size() < 1");
            }
            if (this.m_picks.size() == 1) {
                return this.m_picks.get((int)0).Velocity;
            }
            if (time <= this.m_picks.get((int)0).Time) {
                return this.m_picks.get((int)0).Velocity;
            }
            for (int n = 1; n < num; ++n) {
                Pick p1 = this.m_picks.get(n - 1);
                Pick p2 = this.m_picks.get(n);
                if (!(time <= p2.Time)) continue;
                double s = (time - p1.Time) / (p2.Time - p1.Time);
                return p1.Velocity + s * (p2.Velocity - p1.Velocity);
            }
            return this.m_picks.get((int)(num - 1)).Velocity;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            Element subNode = node.getOwnerDocument().createElement("Location");
            subNode.setAttribute("X", Double.toString(this.X));
            subNode.setAttribute("Y", Double.toString(this.Y));
            for (Pick pick : this.m_picks) {
                Element pn = subNode.getOwnerDocument().createElement("Entry");
                subNode.appendChild(pn);
                pn.setAttribute("Time", Integer.toString((int)pick.Time));
                pn.setAttribute("Velocity", Integer.toString((int)pick.Velocity));
            }
            node.appendChild(subNode);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void writeToFile(RandomAccessFile file) throws Exception {
        try {
            int version = 1000;
            int magic = 54893458;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeDouble(this.X);
                file.writeDouble(this.Y);
                file.writeInt(this.m_picks.size());
                for (Pick pick : this.m_picks) {
                    file.writeDouble(pick.Time);
                    file.writeDouble(pick.Velocity);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void readFromFile(RandomAccessFile file) throws Exception {
        block5: {
            try {
                this.m_picks.clear();
                int magic = file.readInt();
                if (magic != 54893458) {
                    throw new Exception("magic != 54893458");
                }
                int version = file.readInt();
                if (version == 1000) {
                    this.X = file.readDouble();
                    this.Y = file.readDouble();
                    int num = file.readInt();
                    for (int n = 0; n < num; ++n) {
                        Pick p = new Pick();
                        p.Time = file.readDouble();
                        p.Velocity = file.readDouble();
                        this.m_picks.add(p);
                    }
                    break block5;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    public void readFromNode(Element node) throws Exception {
        try {
            this.m_dirty = true;
            this.m_picks.clear();
            this.X = Double.parseDouble(node.getAttribute("X"));
            this.Y = Double.parseDouble(node.getAttribute("Y"));
            ArrayList<Element> entryList = Tools_XML.getChildListWithTagName(node, "Entry");
            for (Element e : entryList) {
                Pick p = new Pick();
                p.Time = Double.parseDouble(e.getAttribute("Time"));
                p.Velocity = Double.parseDouble(e.getAttribute("Velocity"));
                this.m_picks.add(p);
            }
            this.checkOrder();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void deleteAllPicks_SemblancePlot(int pixelY, int killDist) throws Exception {
        try {
            this.m_dirty = true;
            if (!this.m_semblancePlotValid) {
                throw new Exception("m_semblancePlotValid == false");
            }
            for (int n = this.m_picks.size() - 1; n >= 0; --n) {
                Pick pick = this.m_picks.get(n);
                int dist = Math.abs(pick.SemblancePixelY - pixelY);
                if (dist >= killDist) continue;
                this.m_picks.remove(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void deletePick_SemblancePlot(int pixelY) throws Exception {
        try {
            this.m_dirty = true;
            if (!this.m_semblancePlotValid) {
                throw new Exception("m_semblancePlotValid == false");
            }
            int minDist = Integer.MAX_VALUE;
            int nearest = -9999;
            for (int n = 0; n < this.m_picks.size(); ++n) {
                Pick pick = this.m_picks.get(n);
                int dist = Math.abs(pick.SemblancePixelY - pixelY);
                if (dist >= minDist) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                this.m_picks.remove(nearest);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void addPickFromAuto(double t, double v) {
        try {
            this.m_dirty = true;
            Pick pick = new Pick();
            pick.Time = t;
            pick.Velocity = v;
            this.m_picks.add(pick);
            this.checkOrder();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeAllPicks() {
        try {
            this.m_dirty = true;
            this.m_picks.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addPick_SemblancePlot(int pixelX, int pixelY) throws Exception {
        try {
            this.m_dirty = true;
            if (!this.m_semblancePlotValid) {
                throw new Exception("m_semblancePlotValid == false");
            }
            this.deleteAllPicks_SemblancePlot(pixelY, 25);
            double velocity = ((double)pixelX - this.m_semblanceShiftX) / this.m_semblanceScaleX;
            double time = ((double)pixelY - this.m_semblanceShiftY) / this.m_semblanceScaleY;
            int upper = -9999;
            for (int n = 0; n < this.m_picks.size() && upper < 0; ++n) {
                Pick pick = this.m_picks.get(n);
                if (!(time < pick.Time)) continue;
                upper = n;
            }
            Pick pick = new Pick();
            pick.Time = time;
            pick.Velocity = velocity;
            pick.SemblancePixelX = pixelX;
            pick.SemblancePixelY = pixelY;
            if (upper < 0) {
                this.m_picks.add(pick);
            } else {
                this.m_picks.add(upper, pick);
            }
            this.checkOrder();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        try {
            return false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 1;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 1) {
                return;
            }
            if (supplementalData == PlotType.Semblance.ordinal()) {
                this.semblancePaint(paintParameter);
            }
            if (supplementalData == PlotType.NoNmo.ordinal()) {
                this.noNmoPaint(paintParameter);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void semblancePaint(Java2D_PaintParameter paintParameter) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            int height = transform.sizeY();
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_2);
            g2d.setColor(Color.green);
            int size = 13;
            int h = size / 2;
            this.m_semblanceScaleX = transform.scaleX();
            this.m_semblanceShiftX = transform.shiftX();
            this.m_semblanceScaleY = transform.scaleY();
            this.m_semblanceShiftY = transform.shiftY();
            this.m_semblancePlotValid = true;
            if (this.m_picks.size() < 1) {
                return;
            }
            for (Pick pick : this.m_picks) {
                pick.SemblancePixelX = (int)(this.m_semblanceScaleX * pick.Velocity + this.m_semblanceShiftX);
                pick.SemblancePixelY = (int)(this.m_semblanceScaleY * pick.Time + this.m_semblanceShiftY);
                g2d.fillOval(pick.SemblancePixelX - h, pick.SemblancePixelY - h, size, size);
            }
            Pick pick = this.m_picks.get(0);
            g2d.drawLine(pick.SemblancePixelX, pick.SemblancePixelY, pick.SemblancePixelX, 0);
            pick = this.m_picks.get(this.m_picks.size() - 1);
            g2d.drawLine(pick.SemblancePixelX, pick.SemblancePixelY, pick.SemblancePixelX, height);
            for (int n = 1; n < this.m_picks.size(); ++n) {
                Pick p1 = this.m_picks.get(n - 1);
                Pick p2 = this.m_picks.get(n);
                g2d.drawLine(p1.SemblancePixelX, p1.SemblancePixelY, p2.SemblancePixelX, p2.SemblancePixelY);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void noNmoPaint(Java2D_PaintParameter paintParameter) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(Tools_GraphicalObjectLibrary.Stroke_1);
            g2d.setColor(Color.green);
            int size = 19;
            int h = size / 2;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double d = transform.shiftY();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static class Pick {
        public double Time;
        public double Velocity;
        public int SemblancePixelX;
        public int SemblancePixelY;
    }

    public static enum PlotType {
        Semblance,
        NoNmo;

    }
}

