/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class SemblanceProfileVolume
implements Java2D_PaintableInterface {
    protected String m_fileName;
    protected int m_numHeaderBytes = 1000;
    protected double m_stretchMutePercent = 25.0;
    protected double m_minimumVelocity = 1400.0;
    protected double m_maximumVelocity = 5700.0;
    protected double m_velocityIncrement = 5700.0;
    protected int m_numVelocities = 50;
    protected double m_minimumTime;
    protected double m_maximumTime;
    protected double m_digi;
    protected int m_numTimes = 50;
    protected double m_minimumOffset = 0.0;
    protected double m_maximumOffset = 16000.0;
    protected int m_numBins;
    protected float[][][] m_semblance;
    protected Range_Double m_range = new Range_Double();
    public int ClosestIndexTime;
    public int ClosestIndexVel;
    public double PickedVel;
    public double PickedTime;
    protected boolean m_bContentsChangedSinceLastPaint = false;
    public int PlotBin = 100000;
    public int PlotFixedVel = 200000;
    public int PlotFixedTime = 300000;

    public boolean valid() {
        if (this.m_semblance == null) {
            this.read();
        }
        return this.m_semblance != null;
    }

    public double stretchMutePercent() {
        return this.m_stretchMutePercent;
    }

    public double minimumVelocity() {
        return this.m_minimumVelocity;
    }

    public double maximumVelocity() {
        return this.m_maximumVelocity;
    }

    public int numVelocities() {
        return this.m_numVelocities;
    }

    public double minimumTime() {
        return this.m_minimumTime;
    }

    public double maximumTime() {
        return this.m_maximumTime;
    }

    public double digi() {
        return this.m_digi;
    }

    public int numTimes() {
        return this.m_numTimes;
    }

    public double minimumOffset() {
        return this.m_minimumOffset;
    }

    public double maximumOffset() {
        return this.m_maximumOffset;
    }

    public SemblanceProfileVolume(String fileName) {
        try {
            this.m_fileName = fileName;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean tryToMakePick(double t, double v, int bin) {
        try {
            float[][] semb = this.m_semblance[bin];
            int indexTime = (int)(0.5 + (t - this.m_minimumTime) / this.m_digi);
            int indexVel = (int)(0.5 + (v - this.m_minimumVelocity) / this.m_velocityIncrement);
            float maxSemb = 0.1f;
            this.ClosestIndexTime = -9999;
            this.ClosestIndexVel = -9999;
            for (int it = indexTime - 5; it <= indexTime + 5; ++it) {
                for (int iv = indexVel - 5; iv <= indexVel + 5; ++iv) {
                    if (it < 1 || it >= this.m_numTimes - 1 || iv < 1 || iv >= this.m_numVelocities - 1 || !(semb[iv][it] > maxSemb)) continue;
                    maxSemb = semb[iv][it];
                    this.ClosestIndexTime = it;
                    this.ClosestIndexVel = iv;
                }
            }
            if (this.ClosestIndexTime < 0) {
                return false;
            }
            this.PickedVel = this.m_minimumVelocity + (double)this.ClosestIndexVel * this.m_velocityIncrement;
            this.PickedTime = this.m_minimumTime + (double)this.ClosestIndexTime * this.m_digi;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void read() {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_range.clearRange();
            this.m_semblance = null;
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, this.m_numHeaderBytes);
            file.read(buff.array(), 0, this.m_numHeaderBytes);
            int magic = buff.getInt(0);
            int numBytes = buff.getInt(4);
            int version = buff.getInt(8);
            if (magic != 49254) {
                return;
            }
            if (numBytes < 3) {
                return;
            }
            if (version == 1000) {
                this.m_numBins = buff.getInt(12);
                this.m_numTimes = buff.getInt(16);
                this.m_numVelocities = buff.getInt(20);
                this.m_stretchMutePercent = buff.getDouble(30);
                this.m_minimumOffset = buff.getDouble(40);
                this.m_maximumOffset = buff.getDouble(48);
                this.m_minimumTime = buff.getDouble(60);
                this.m_maximumTime = buff.getDouble(68);
                this.m_minimumVelocity = buff.getDouble(80);
                this.m_maximumVelocity = buff.getDouble(88);
                this.m_velocityIncrement = (this.m_maximumVelocity - this.m_minimumVelocity) / (double)(this.m_numVelocities - 1);
                this.m_digi = (float)((this.m_maximumTime - this.m_minimumTime) / (double)(this.m_numTimes - 1));
                buff = ByteBuffer_Shared.buffer(0, numBytes);
                file.read(buff.array(), 0, numBytes);
                this.m_semblance = new float[this.m_numBins][this.m_numVelocities][this.m_numTimes];
                int off = 0;
                for (int b = 0; b < this.m_numBins; ++b) {
                    for (int v = 0; v < this.m_numVelocities; ++v) {
                        for (int t = 0; t < this.m_numTimes; ++t) {
                            this.m_semblance[b][v][t] = buff.getFloat(off);
                            off += 4;
                        }
                    }
                }
                file.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void findRange() {
        try {
            this.m_range.clearRange();
            if (this.m_semblance == null) {
                return;
            }
            for (int b = 0; b < this.m_numBins; ++b) {
                for (int v = 0; v < this.m_numVelocities; ++v) {
                    for (int t = 0; t < this.m_numTimes; ++t) {
                        this.m_range.expandRange(this.m_semblance[b][v][t]);
                    }
                }
            }
            System.out.println("findRange" + this.m_range.rangeMin() + "  " + this.m_range.rangeMax());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, this.m_numHeaderBytes);
            int numBytes = 0;
            if (this.m_semblance != null) {
                numBytes = 4 * this.m_numBins * this.m_numTimes * this.m_numVelocities;
            }
            int magic = 49254;
            int version = 1000;
            buff.putInt(0, magic);
            buff.putInt(4, numBytes);
            buff.putInt(8, version);
            if (numBytes < 1) {
                file.write(buff.array(), 0, this.m_numHeaderBytes);
                file.close();
                return;
            }
            if (version == 1000) {
                buff.putInt(12, this.m_numBins);
                buff.putInt(16, this.m_numTimes);
                buff.putInt(20, this.m_numVelocities);
                buff.putDouble(30, this.m_stretchMutePercent);
                buff.putDouble(40, this.m_minimumOffset);
                buff.putDouble(48, this.m_maximumOffset);
                buff.putDouble(60, this.m_minimumTime);
                buff.putDouble(68, this.m_maximumTime);
                buff.putDouble(80, this.m_minimumVelocity);
                buff.putDouble(88, this.m_maximumVelocity);
                file.write(buff.array(), 0, this.m_numHeaderBytes);
                buff = ByteBuffer_Shared.buffer(0, numBytes);
                int off = 0;
                for (int b = 0; b < this.m_numBins; ++b) {
                    for (int v = 0; v < this.m_numVelocities; ++v) {
                        for (int t = 0; t < this.m_numTimes; ++t) {
                            buff.putFloat(off, this.m_semblance[b][v][t]);
                            off += 4;
                        }
                    }
                }
                file.write(buff.array(), 0, numBytes);
                file.close();
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSemblanceAtBin(int bin, float[][] semb) throws Exception {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_range.clearRange();
            for (int v = 0; v < this.m_numVelocities; ++v) {
                for (int t = 0; t < this.m_numTimes; ++t) {
                    this.m_semblance[bin][v][t] = semb[v][t];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepArrays(int numBins, double minimumOffset, double maximumOffset, double minimumTime, double maximumTime, int numTimes, double minimumVelocity, double maximumVelocity, int numVel, double stretchMutePercent) {
        try {
            this.m_numBins = numBins;
            this.m_minimumOffset = minimumOffset;
            this.m_maximumOffset = maximumOffset;
            this.m_minimumTime = minimumTime;
            this.m_maximumTime = maximumTime;
            this.m_numTimes = numTimes;
            this.m_minimumVelocity = minimumVelocity;
            this.m_maximumVelocity = maximumVelocity;
            this.m_numVelocities = numVel;
            this.m_velocityIncrement = (this.m_maximumVelocity - this.m_minimumVelocity) / (double)(this.m_numVelocities - 1);
            this.m_digi = (float)((maximumTime - minimumTime) / (double)(this.m_numTimes - 1));
            this.m_stretchMutePercent = stretchMutePercent;
            this.m_semblance = new float[this.m_numBins][this.m_numVelocities][this.m_numTimes];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_semblance = null;
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return true;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    protected void paintBin(Java2D_PaintParameter paintParameter, int bin) {
        try {
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixPerVel = 1 + (int)(scaleX * this.m_velocityIncrement);
            float pixPerTime = (float)(scaleY * this.m_digi);
            int plotPixPerTime = 1 + (int)pixPerTime;
            for (int n = 0; n < this.m_numVelocities; ++n) {
                double v = this.m_minimumVelocity + this.m_velocityIncrement * ((double)n - 0.5);
                int x = (int)(scaleX * v + shiftX);
                double time = this.m_minimumTime - 0.5 * this.m_digi;
                double pixY = scaleY * time + shiftY;
                for (int s = 0; s < this.m_numTimes; ++s) {
                    double val = this.m_semblance[bin][n][s];
                    if (colorWrapper.valueOK(val)) {
                        g2d.setColor(colorWrapper.colorUsingValue(val));
                        g2d.fillRect(x, (int)pixY, pixPerVel, plotPixPerTime);
                    }
                    pixY += (double)pixPerTime;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.valid()) {
                return;
            }
            if (supplementalData >= this.PlotBin && supplementalData < this.PlotFixedVel) {
                this.paintBin(paintParameter, supplementalData - this.PlotBin);
                return;
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.valid()) {
                return;
            }
            if (supplementalData >= this.PlotBin && supplementalData < this.PlotFixedVel) {
                rangeX.expandRange(this.m_minimumVelocity - 100.0);
                rangeX.expandRange(this.m_maximumVelocity + 100.0);
                rangeY.expandRange(this.m_minimumTime - 40.0);
                rangeY.expandRange(this.m_maximumTime + 40.0);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            if (!this.valid()) {
                return;
            }
            if (supplementalData >= this.PlotBin && supplementalData < this.PlotFixedVel) {
                rangeC.expandRange(0.0);
                rangeC.expandRange(0.001);
                int bin = supplementalData - this.PlotBin;
                for (int n = 0; n < this.m_numVelocities; ++n) {
                    for (int s = 0; s < this.m_numTimes; ++s) {
                        double val = this.m_semblance[bin][n][s];
                        rangeC.expandRange(val);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

