/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Stack;

import com.PecosCore.Data.ArrayRenormalization;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Stack.SemblanceProfileVolume;
import com.PecosLibrary.Stack.StackGizmo;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Graphics2D;

public class Semblance
implements Java2D_PaintableInterface {
    protected double m_stretchMutePercent = 25.0;
    protected double m_minimumVelocity = 1400.0;
    protected double m_maximumVelocity = 5700.0;
    protected double m_velocityIncrement = 5700.0;
    protected int m_numVelocities = 50;
    protected double m_minimumTime;
    protected double m_maximumTime;
    protected double m_digi;
    protected double m_minimumOffset = 0.0;
    protected double m_maximumOffset = 16000.0;
    protected int m_numTimes = 50;
    public boolean ExtraWaveletShaping = false;
    protected boolean m_dirty;
    protected float[][] m_semblance;
    protected float[][] m_count;
    protected float m_semblanceMax;
    protected float m_countMax;
    protected float[] m_tempArray_Sum;
    protected float[] m_tempArray_SumSq;
    protected float[] m_tempArray_SumCount;
    protected boolean m_valid = false;
    protected StackGizmo m_stackGizmo;
    protected boolean m_bContentsChangedSinceLastPaint = true;
    protected ArrayRenormalization m_renorm = new ArrayRenormalization();
    protected int[] m_tracesPerOffsetBin = new int[20];

    public Semblance(StackGizmo stackGizmo) {
        this.m_stackGizmo = stackGizmo;
    }

    public void prepSemblanceProfileVolume(int numBins, SemblanceProfileVolume spv) {
        try {
            spv.prepArrays(numBins, this.m_minimumOffset, this.m_maximumOffset, this.m_minimumTime, this.m_maximumTime, this.m_numTimes, this.m_minimumVelocity, this.m_maximumVelocity, this.m_numVelocities, this.m_stretchMutePercent);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSemblanceProfileVolume(int bin, SemblanceProfileVolume spv) {
        try {
            spv.setSemblanceAtBin(bin, this.m_semblance);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double minVel() {
        return this.m_minimumVelocity;
    }

    public double maxVel() {
        return this.m_maximumVelocity;
    }

    public double maxTime() {
        return this.m_maximumTime;
    }

    public double minTime() {
        return this.m_minimumTime;
    }

    protected void prepTempArrays() throws Exception {
        try {
            if (this.m_tempArray_Sum == null) {
                this.m_tempArray_Sum = new float[this.m_numTimes];
            }
            if (this.m_tempArray_Sum.length != this.m_numTimes) {
                this.m_tempArray_Sum = new float[this.m_numTimes];
            }
            if (this.m_tempArray_SumSq == null) {
                this.m_tempArray_SumSq = new float[this.m_numTimes];
            }
            if (this.m_tempArray_SumSq.length != this.m_numTimes) {
                this.m_tempArray_SumSq = new float[this.m_numTimes];
            }
            if (this.m_tempArray_SumCount == null) {
                this.m_tempArray_SumCount = new float[this.m_numTimes];
            }
            if (this.m_tempArray_SumCount.length != this.m_numTimes) {
                this.m_tempArray_SumCount = new float[this.m_numTimes];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public int numTimes() {
        return this.m_numTimes;
    }

    public int numVels() {
        return this.m_numVelocities;
    }

    public void extractFixedTime(double time, float[] array) throws Exception {
        try {
            int timeIndex = (int)((time - this.minTime()) / (double)this.digi());
            timeIndex = Math.max(0, timeIndex);
            timeIndex = Math.min(timeIndex, this.numTimes() - 1);
            for (int n = 0; n < this.m_numVelocities; ++n) {
                array[n] = this.m_semblance[n][timeIndex];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepStuff() {
        try {
            this.m_numVelocities = Math.max(this.m_numVelocities, 50);
            this.m_numVelocities = Math.min(this.m_numVelocities, 200);
            this.m_numTimes = 1 + (int)((this.m_maximumTime - this.m_minimumTime) / this.m_digi);
            this.m_numTimes = Math.max(this.m_numTimes, 20);
            this.m_numTimes = Math.min(this.m_numTimes, 2000);
            this.m_velocityIncrement = (this.m_maximumVelocity - this.m_minimumVelocity) / (double)(this.m_numVelocities - 1);
            if (this.m_semblance == null) {
                this.m_semblance = new float[this.m_numVelocities][this.m_numTimes];
                this.m_count = new float[this.m_numVelocities][this.m_numTimes];
            }
            if (this.m_semblance.length != this.m_numVelocities) {
                this.m_semblance = new float[this.m_numVelocities][this.m_numTimes];
                this.m_count = new float[this.m_numVelocities][this.m_numTimes];
            }
            if (this.m_semblance[0].length != this.m_numTimes) {
                this.m_semblance = new float[this.m_numVelocities][this.m_numTimes];
                this.m_count = new float[this.m_numVelocities][this.m_numTimes];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeSemblance(int numOffsetBins, int maxTracesPerOffsetBin) throws Exception {
        try {
            this.m_bContentsChangedSinceLastPaint = true;
            this.m_valid = false;
            this.m_semblanceMax = 0.0f;
            this.m_countMax = 1.0E-30f;
            int numValidTraces = this.m_stackGizmo.getNumValidTraces();
            if (numValidTraces < 4) {
                return;
            }
            this.prepStuff();
            numOffsetBins = Math.max(numOffsetBins, 100);
            numOffsetBins = Math.min(numOffsetBins, 1000);
            if (this.m_tracesPerOffsetBin.length != numOffsetBins) {
                this.m_tracesPerOffsetBin = new int[numOffsetBins];
            }
            for (int n = 0; n < this.m_tracesPerOffsetBin.length; ++n) {
                this.m_tracesPerOffsetBin[n] = 0;
            }
            double offsetPerBin = (this.m_maximumOffset - this.m_minimumOffset) / (double)this.m_tracesPerOffsetBin.length;
            this.prepTempArrays();
            int numUsed = 0;
            for (int k = 0; k < numValidTraces; ++k) {
                StackGizmo.Trace trace = this.m_stackGizmo.getTrace(k);
                trace.InUse = false;
                if (!(trace.offset() > this.m_minimumOffset) || !(trace.offset() < this.m_maximumOffset)) continue;
                int offsetBin = (int)((trace.offset() - this.m_minimumOffset) / offsetPerBin);
                offsetBin = Math.max(0, offsetBin);
                if (this.m_tracesPerOffsetBin[offsetBin = Math.min(offsetBin, this.m_tracesPerOffsetBin.length - 1)] >= maxTracesPerOffsetBin) continue;
                trace.InUse = true;
                int n = offsetBin;
                this.m_tracesPerOffsetBin[n] = this.m_tracesPerOffsetBin[n] + 1;
                ++numUsed;
            }
            for (int n = 0; n < this.m_numVelocities; ++n) {
                int s;
                double v = this.m_minimumVelocity + this.m_velocityIncrement * (double)n;
                for (int k = 0; k < numValidTraces; ++k) {
                    StackGizmo.Trace trace = this.m_stackGizmo.getTrace(k);
                    if (!trace.InUse) continue;
                    trace.prepMoveoutArrays(this.m_numTimes);
                    trace.prepMoveout_ConstantVel(this.m_minimumTime, this.m_digi, v);
                    trace.computeStretchMuteTime0_ConstantVel(v, this.m_stretchMutePercent);
                    double tx = trace.MaxInputTraceTime;
                    double off = trace.offset();
                    double temp = 1000.0 * off / v * (1000.0 * off / v);
                    double temp2 = tx * tx - temp;
                    trace.MaxZeroOffsetTime = temp2 > 1.0 ? Math.sqrt(temp2) : 0.0;
                }
                for (int s2 = 0; s2 < this.m_numTimes; ++s2) {
                    this.m_tempArray_SumCount[s2] = 1.0E-30f;
                    this.m_tempArray_SumSq[s2] = 1.0E-40f;
                    this.m_tempArray_Sum[s2] = 0.0f;
                }
                double time0 = this.m_minimumTime;
                float sumCount = 1.0E-40f;
                for (s = 0; s < this.m_numTimes; ++s) {
                    this.m_semblance[n][s] = 0.0f;
                    this.m_count[n][s] = 0.0f;
                    for (int k = 0; k < numValidTraces; ++k) {
                        StackGizmo.Trace trace = this.m_stackGizmo.getTrace(k);
                        if (!(trace.StretchMuteTime0 < time0) || !(time0 < trace.MaxZeroOffsetTime) || !trace.InUse) continue;
                        float sample = 10000.0f * trace.MoveoutValue[s];
                        sumCount += 1.0f;
                        this.m_tempArray_SumCount[s] = this.m_tempArray_SumCount[s] + 1.0f;
                        this.m_tempArray_Sum[s] = this.m_tempArray_Sum[s] + sample;
                        this.m_tempArray_SumSq[s] = this.m_tempArray_SumSq[s] + sample * sample;
                    }
                    time0 += this.m_digi;
                }
                if (!(sumCount > 0.5f)) continue;
                for (s = 0; s < this.m_numTimes; ++s) {
                    int start = s - 7;
                    start = Math.max(s, 0);
                    int end = s + 7;
                    end = Math.min(end, this.m_numTimes - 1);
                    float sumTop = 0.0f;
                    float sumBottom = 0.0f;
                    boolean count = false;
                    for (int w = start; w <= end; ++w) {
                        if (!(this.m_tempArray_SumCount[w] > 0.5f)) continue;
                        float top = this.m_tempArray_Sum[w] * this.m_tempArray_Sum[w];
                        sumTop += top;
                        sumBottom += this.m_tempArray_SumSq[w];
                    }
                    this.m_semblance[n][s] = this.m_tempArray_SumCount[s] >= 1.0f && sumBottom > 1.0E-20f ? sumTop / (sumBottom * this.m_tempArray_SumCount[s]) : 0.0f;
                    this.m_count[n][s] = this.m_tempArray_SumCount[s];
                    this.m_countMax = Math.max(this.m_countMax, this.m_tempArray_SumCount[s]);
                }
            }
            float cutoff = this.m_countMax;
            float scalar = 1.0f / this.m_countMax;
            this.m_semblanceMax = 1.0E-14f;
            for (int n = 0; n < this.m_numVelocities; ++n) {
                for (int s = 0; s < this.m_numTimes; ++s) {
                    float weight = this.m_count[n][s] < cutoff ? this.m_count[n][s] * scalar : 1.0f;
                    this.m_semblance[n][s] = 10000.0f * this.m_semblance[n][s] * weight;
                    this.m_semblanceMax = Math.max(this.m_semblanceMax, this.m_semblance[n][s]);
                }
            }
            System.out.println("m_semblanceMax " + this.m_semblanceMax + "   m_countMax " + this.m_countMax + "   numUsed " + numUsed);
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float digi() {
        return (float)this.m_digi;
    }

    public void setDigi(double digi) {
        try {
            if (Math.abs(this.m_digi - digi) > 0.1) {
                this.m_dirty = true;
                this.m_digi = Math.max(digi, 2.0);
                this.prepStuff();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTimeRange(double minimumTime, double maximumTime) {
        try {
            if (Math.abs(this.m_minimumTime - minimumTime) > 0.1 || Math.abs(this.m_maximumTime - maximumTime) > 0.1) {
                this.m_dirty = true;
                this.m_minimumTime = Math.max(minimumTime, 0.0);
                this.m_maximumTime = Math.max(this.m_minimumTime + 10.0, maximumTime);
                this.prepStuff();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setNumVelocities(int numVelocities) {
        try {
            if (numVelocities != this.m_numVelocities) {
                this.m_numVelocities = numVelocities;
                this.m_dirty = true;
                this.prepStuff();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setOffsetRange(double minOff, double maxOff) {
        try {
            if (Math.abs(this.m_minimumOffset - minOff) > 0.1 || Math.abs(this.m_maximumOffset - maxOff) > 0.1) {
                this.m_dirty = true;
                this.m_minimumOffset = Math.max(minOff, 0.0);
                this.m_maximumOffset = Math.max(this.m_minimumOffset + 10.0, maxOff);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setVelocityRange(double minVel, double maxVel) {
        try {
            if (Math.abs(this.m_minimumVelocity - minVel) > 0.1 || Math.abs(this.m_maximumVelocity - maxVel) > 0.1) {
                this.m_dirty = true;
                this.m_minimumVelocity = Math.max(minVel, 100.0);
                this.m_maximumVelocity = Math.max(this.m_minimumVelocity + 10.0, maxVel);
                this.prepStuff();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setStretchMutePercent(double stretchMutePercent) {
        this.m_stretchMutePercent = Math.max(stretchMutePercent, 5.0);
        this.m_stretchMutePercent = Math.min(stretchMutePercent, 100.0);
    }

    public double getStretchMutePercent() {
        return this.m_stretchMutePercent;
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return this.m_bContentsChangedSinceLastPaint;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int pixPerVel = 1 + (int)(scaleX * this.m_velocityIncrement);
            float pixPerTime = (float)(scaleY * this.m_digi);
            int plotPixPerTime = 1 + (int)pixPerTime;
            for (int n = 0; n < this.m_numVelocities; ++n) {
                double v = this.m_minimumVelocity + this.m_velocityIncrement * ((double)n - 0.5);
                int x = (int)(scaleX * v + shiftX);
                double time = this.m_minimumTime - 0.5 * this.m_digi;
                double pixY = scaleY * time + shiftY;
                for (int s = 0; s < this.m_numTimes; ++s) {
                    double val = this.m_semblance[n][s];
                    if (colorWrapper.valueOK(val)) {
                        g2d.setColor(colorWrapper.colorUsingValue(val));
                        g2d.fillRect(x, (int)pixY, pixPerVel, plotPixPerTime);
                    }
                    pixY += (double)pixPerTime;
                }
            }
            this.m_bContentsChangedSinceLastPaint = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            if (!this.m_valid) {
                return;
            }
            rangeX.expandRange(this.m_minimumVelocity);
            rangeX.expandRange(this.m_maximumVelocity);
            rangeY.expandRange(this.m_minimumTime);
            rangeY.expandRange(this.m_maximumTime);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
        try {
            rangeC.expandRange(0.0);
            rangeC.expandRange(this.m_semblanceMax);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

