/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Seismic.XtGeo;

import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.Seismic.ITraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class XtGeo_Exporter {
    protected ITraceInterpolator m_interpolator = new CubicTraceInterpolator();
    protected String m_fileName;
    protected int m_maxSampleCount;
    protected int m_numTracesWritten = 0;
    protected ByteBuffer m_binaryHeaderBuffer = ByteBuffer.allocate(300);
    protected EnsembleHeaderDictionary m_dictionary;
    protected ByteBuffer m_dictionaryHeaderBuffer;
    protected int m_numDictionaryBytes = 0;
    protected int[] m_headerIndexLookup;
    protected double[] m_headerMax = new double[300];
    protected double[] m_headerMin = new double[300];
    protected int m_bytesPerTrace_Total;
    protected int m_bytesPerTrace_Header;
    protected int m_bytesPerTrace_Data;
    protected int m_bytesPerTrace_Info;
    protected int m_traceBufferLength = 0;
    protected ByteBuffer m_traceBuffer;
    protected boolean m_createIndexSection = false;
    protected int m_totalIndexSection = 0;
    protected int m_currentIndexSection = 0;
    protected int m_indexSectionByteCount = 0;
    protected ByteBuffer m_indexHeaderBuffer;
    protected int m_index1 = -9999;
    protected int m_index2 = -9999;
    protected int m_index3 = -9999;
    protected String m_indexTbl1 = "";
    protected String m_indexTbl2 = "";
    protected String m_indexTbl3 = "";
    protected String m_indexCol1 = "";
    protected String m_indexCol2 = "";
    protected String m_indexCol3 = "";
    protected float[] m_inputTraceData = new float[100];

    public void setSingleIndexArray(String tbl, String col, int count) {
        this.m_indexTbl1 = tbl;
        this.m_indexCol1 = col;
        this.m_createIndexSection = true;
        this.m_totalIndexSection = count;
        this.m_currentIndexSection = 0;
        this.m_indexSectionByteCount = 20 * this.m_totalIndexSection;
        this.m_indexHeaderBuffer = ByteBuffer.allocate(this.m_indexSectionByteCount);
    }

    public XtGeo_Exporter(String fileName, int maxSamplesPerTrace) {
        try {
            this.m_fileName = fileName;
            this.m_maxSampleCount = Math.max(maxSamplesPerTrace, 100);
            Tools_FileSystem.deleteFile(fileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void finishedAppending() {
        try {
            this.m_binaryHeaderBuffer.putInt(0, 5445789);
            this.m_binaryHeaderBuffer.putInt(4, 1000);
            this.m_binaryHeaderBuffer.putInt(8, 1001);
            this.m_binaryHeaderBuffer.putInt(12, this.m_maxSampleCount);
            this.m_binaryHeaderBuffer.putInt(16, this.m_numTracesWritten);
            this.m_binaryHeaderBuffer.putInt(20, this.m_dictionary.size());
            this.m_binaryHeaderBuffer.putInt(24, this.m_totalIndexSection);
            this.m_binaryHeaderBuffer.putInt(28, this.m_index1);
            this.m_binaryHeaderBuffer.putInt(32, this.m_index2);
            this.m_binaryHeaderBuffer.putInt(36, this.m_index3);
            this.m_binaryHeaderBuffer.putDouble(100, -9999.0);
            this.m_binaryHeaderBuffer.putDouble(108, 9999.0);
            this.m_binaryHeaderBuffer.putDouble(116, 1.0E10);
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            raf.seek(0L);
            raf.write(this.m_binaryHeaderBuffer.array(), 0, 300);
            if (this.m_totalIndexSection > 0) {
                raf.seek(300 + 50 * this.m_dictionary.size());
                raf.write(this.m_indexHeaderBuffer.array(), 0, this.m_indexSectionByteCount);
            }
            raf.close();
            for (int n = 0; n < this.m_dictionary.size(); ++n) {
                EnsembleHeaderDictionary.Entry e = this.m_dictionary.getEntry(n);
                String s = String.format("%s  %s  %f  %f", e.Table, e.Column, this.m_headerMin[n], this.m_headerMax[n]);
                System.out.println(s);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void appendEnsemble(Ensemble ensemble, int id1, int id2, int id3) {
        try {
            if (this.m_dictionary == null) {
                this.prepareFile(ensemble);
            }
            if (!this.m_dictionary.compare(ensemble.dictionary())) {
                throw new Exception("m_dictionary.compare(ensemble.dictionary()) == false");
            }
            int numTraces = ensemble.traceCount();
            if (this.m_createIndexSection) {
                int offset = 20 * this.m_currentIndexSection;
                this.m_indexHeaderBuffer.putInt(offset + 0, id1);
                this.m_indexHeaderBuffer.putInt(offset + 4, id2);
                this.m_indexHeaderBuffer.putInt(offset + 8, id3);
                this.m_indexHeaderBuffer.putInt(offset + 12, numTraces);
                this.m_indexHeaderBuffer.putInt(offset + 16, this.m_numTracesWritten);
                ++this.m_currentIndexSection;
            }
            if (numTraces < 1) {
                return;
            }
            int numBytesNeeded = numTraces * this.m_bytesPerTrace_Total;
            if (numBytesNeeded > this.m_traceBufferLength) {
                this.m_traceBufferLength = numBytesNeeded + 300 * this.m_bytesPerTrace_Total;
                this.m_traceBuffer = ByteBuffer.allocate(this.m_traceBufferLength);
            }
            for (int n = 0; n < numTraces; ++n) {
                int s;
                EnsembleTrace trace = ensemble.trace(n);
                int offset = n * this.m_bytesPerTrace_Total;
                offset += 20;
                for (int h = 0; h < this.m_dictionary.size(); ++h) {
                    int index = this.m_headerIndexLookup[h];
                    double v = trace.header().getDouble(index);
                    this.m_traceBuffer.putDouble(offset + 8 * h, v);
                    this.m_headerMin[h] = Math.min(this.m_headerMin[h], v);
                    this.m_headerMax[h] = Math.max(this.m_headerMax[h], v);
                }
                if (this.m_inputTraceData.length < trace.data().length()) {
                    this.m_inputTraceData = new float[trace.data().length()];
                }
                trace.data().copyToArray(this.m_inputTraceData);
                int traceLength = Math.min(trace.data().length(), this.m_maxSampleCount);
                offset += this.m_dictionary.size() * 8;
                float max = 1.0E-8f;
                for (int s2 = 0; s2 < traceLength; ++s2) {
                    max = Math.max(max, Math.abs(this.m_inputTraceData[s2]));
                }
                float scalar = 32000.0f / max;
                for (s = 0; s < traceLength; ++s) {
                    short v = (short)(this.m_inputTraceData[s] * scalar);
                    this.m_traceBuffer.putShort(offset + s * 2, v);
                }
                for (s = traceLength; s < this.m_maxSampleCount; ++s) {
                    this.m_traceBuffer.putShort(offset + s * 2, (short)0);
                }
                offset = n * this.m_bytesPerTrace_Total;
                this.m_traceBuffer.putInt(offset + 0, this.m_numTracesWritten);
                this.m_traceBuffer.putInt(offset + 4, traceLength);
                this.m_traceBuffer.putFloat(offset + 8, trace.data().getFirstSampleCoord_WithShifts());
                this.m_traceBuffer.putFloat(offset + 12, trace.data().getSampleInterval());
                this.m_traceBuffer.putFloat(offset + 16, max);
                ++this.m_numTracesWritten;
            }
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            raf.seek(raf.length());
            raf.write(this.m_traceBuffer.array(), 0, numBytesNeeded);
            raf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void prepareFile(Ensemble ensemble) {
        try {
            int offset;
            int n;
            this.m_binaryHeaderBuffer.order(ByteOrder.nativeOrder());
            this.m_dictionary = ensemble.dictionary().createExactCopy();
            int numheaders = this.m_dictionary.size();
            this.m_numDictionaryBytes = 50 * numheaders;
            this.m_headerIndexLookup = new int[numheaders];
            this.m_dictionaryHeaderBuffer = ByteBuffer.allocate(this.m_numDictionaryBytes);
            this.m_dictionaryHeaderBuffer.order(ByteOrder.nativeOrder());
            byte[] array = this.m_dictionaryHeaderBuffer.array();
            for (n = 0; n < array.length; ++n) {
                array[n] = 0;
            }
            for (n = 0; n < this.m_dictionary.size(); ++n) {
                int c;
                offset = 50 * n;
                EnsembleHeaderDictionary.Entry e = this.m_dictionary.getEntry(n);
                this.m_headerIndexLookup[n] = e.Index;
                byte[] bytes = e.Table.getBytes();
                for (c = 0; c < e.Table.length(); ++c) {
                    array[offset + c] = bytes[c];
                }
                offset += 10;
                bytes = e.Column.getBytes();
                for (c = 0; c < e.Column.length(); ++c) {
                    array[offset + c] = bytes[c];
                }
                this.m_headerMin[n] = 1.0E20;
                this.m_headerMax[n] = -1.0E20;
            }
            this.m_bytesPerTrace_Info = 20;
            this.m_bytesPerTrace_Header = 8 * numheaders;
            this.m_bytesPerTrace_Data = 2 * this.m_maxSampleCount;
            this.m_bytesPerTrace_Total = this.m_bytesPerTrace_Header + this.m_bytesPerTrace_Data + this.m_bytesPerTrace_Info;
            this.m_traceBufferLength = 2000 * this.m_bytesPerTrace_Total;
            this.m_traceBuffer = ByteBuffer.allocate(this.m_traceBufferLength);
            this.m_traceBuffer.order(ByteOrder.nativeOrder());
            if (this.m_createIndexSection) {
                if (this.m_dictionary.containsEntry(this.m_indexTbl1, this.m_indexCol1)) {
                    this.m_indexSectionByteCount = this.m_totalIndexSection * 20;
                    this.m_index1 = this.m_dictionary.getIndexInListArray(this.m_indexTbl1, this.m_indexCol1);
                    this.m_indexHeaderBuffer = ByteBuffer.allocate(this.m_indexSectionByteCount);
                    this.m_indexHeaderBuffer.order(ByteOrder.nativeOrder());
                    this.m_currentIndexSection = 0;
                    for (n = 0; n < this.m_totalIndexSection; ++n) {
                        offset = 20 * n;
                        this.m_indexHeaderBuffer.putInt(offset + 0, -9999);
                        this.m_indexHeaderBuffer.putInt(offset + 4, -9999);
                        this.m_indexHeaderBuffer.putInt(offset + 8, -9999);
                        this.m_indexHeaderBuffer.putInt(offset + 12, 0);
                        this.m_indexHeaderBuffer.putInt(offset + 16, 0);
                    }
                } else {
                    this.m_createIndexSection = false;
                }
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            file.write(this.m_binaryHeaderBuffer.array(), 0, 300);
            file.write(this.m_dictionaryHeaderBuffer.array(), 0, this.m_numDictionaryBytes);
            if (this.m_createIndexSection) {
                file.write(this.m_indexHeaderBuffer.array(), 0, this.m_indexSectionByteCount);
            }
            file.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

