/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Seismic;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_Ensemble_RefractionProject;
import com.PecosLibrary.Seismic.LightweightDiskTrace;
import com.PecosLibrary.Seismic.OffsetGathers;
import com.PecosLibrary.Stack.SeismicProfileStack;
import com.PecosLibrary.Stack.SemblanceProfileVelocityCollection;
import com.PecosLibrary.Stack.SemblanceProfileVolume;
import com.PecosLibrary.Stack.VelocityLocationCollection;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Paintable_TimeGrid;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;

public class SeismicProfile {
    protected VelocityLocationCollection m_velField;
    public float[][] TempHVA = null;
    public double HvaMinVel;
    public double HvaMaxVel;
    protected int m_version = -9999;
    protected String m_offsetGatherPath;
    protected OffsetGathers m_offsetGathers;
    protected int m_traceHeaderBytes = 40;
    protected int m_traceBytes = 24;
    protected int m_binHeaderBytes = 100;
    protected ArrayList<ProfileBin> m_list = new ArrayList();
    public static final String HeaderFileName = "header.bin";
    protected String m_path;
    protected String m_headerFileName;
    protected String m_name;
    protected String m_stackPath;
    protected SeismicProfileStack m_stackIO = new SeismicProfileStack();
    protected float m_sampleInterval = -9999.0f;
    protected double m_angle;
    protected double m_radius;
    protected double m_spacing;
    protected double m_length;
    protected double m_startX;
    protected double m_startY;
    protected double m_endX;
    protected double m_endY;
    protected float[] m_tempArray;
    public boolean Dim2D = false;
    public boolean ProfileSnapOn = false;
    protected int m_samplesPerTrace = 0;
    protected SemblanceProfileVolume m_semblanceProfileVolume;
    protected String m_pathULWS = "";
    protected String m_pathStacksULWS = "";
    protected SemblanceProfileVelocityCollection m_semblanceProfileVelocityCollection;
    public double MinimumOffset = 0.0;
    public double MaximumOffset = 100000.0;

    public void setVelocityLocationCollection(VelocityLocationCollection velField) {
        this.m_velField = velField;
    }

    public int version() {
        return this.m_version;
    }

    public boolean needToCreateGathers(double binSize) {
        try {
            if (!this.m_offsetGathers.valid()) {
                return true;
            }
            double diff = Math.abs(binSize - this.m_offsetGathers.offsetBinSize());
            return diff > 0.01;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    public OffsetGathers offsetGathers() {
        return this.m_offsetGathers;
    }

    public void createOffsetGathers(double offsetBinSize, JProgressBar bar) {
        try {
            Tools_FileSystem.deletePathIfExists(this.m_offsetGatherPath);
            this.m_offsetGatherPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "OffsetGathers");
            this.m_offsetGathers.prepareToAppend(offsetBinSize, this.m_traceHeaderBytes, this.m_traceBytes, this.m_sampleInterval, this.m_samplesPerTrace);
            Ensemble ensemble = new Ensemble();
            bar.setMinimum(0);
            bar.setMaximum(this.binCount());
            for (int n = 0; n < this.binCount(); ++n) {
                bar.setValue(n);
                bar.paintImmediately(0, 0, 555, 25);
                this.populateSeismicProfileEnsemble(n, ensemble, true);
                RefractionStaticsProject.singleton().prepGeometryHeaders(ensemble, false, false);
                this.m_offsetGathers.append(ensemble);
            }
            bar.setValue(0);
            this.m_offsetGathers.finishedAppending();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int binCount() {
        return this.m_list.size();
    }

    public ProfileBin bin(int index) {
        return this.m_list.get(index);
    }

    public double binX(int index) {
        return this.m_list.get((int)index).X;
    }

    public double binY(int index) {
        return this.m_list.get((int)index).Y;
    }

    public String path() {
        return this.m_path;
    }

    public String name() {
        return this.m_name;
    }

    public String stackPath() {
        return this.m_stackPath;
    }

    public String getStackFullPath(String stackName) {
        return this.m_stackPath + "/" + stackName;
    }

    public ArrayList<String> stackNames() {
        try {
            return Tools_FileSystem.files(this.m_stackPath, false, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<String> stackNamesULWS() {
        try {
            return Tools_FileSystem.files(this.m_pathStacksULWS, false, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void saveStackULWS(String stackName, Ensemble ensemble, float t0, float digi, int sampPerTrace) throws Exception {
        try {
            String fileName = this.m_pathStacksULWS + "/" + stackName;
            this.m_stackIO.saveVersion1000(fileName, ensemble, t0, digi, sampPerTrace);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void saveStack(String stackName, Ensemble ensemble, float t0, float digi, int sampPerTrace) throws Exception {
        try {
            String fileName = this.getStackFullPath(stackName);
            this.m_stackIO.saveVersion1000(fileName, ensemble, t0, digi, sampPerTrace);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble getStackULWS(String stackName) throws Exception {
        try {
            String fileName = this.m_pathStacksULWS + "/" + stackName;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return null;
            }
            Ensemble ensemble = this.m_stackIO.read(fileName);
            int indexBin = ensemble.dictionary().addEntry("Trace", "ProfileBin", DataType.Int);
            int indexEasting = ensemble.dictionary().addEntry("Trace", "Easting", DataType.Double);
            int indexNorthing = ensemble.dictionary().addEntry("Trace", "Northing", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                double x = this.binX(n);
                double y = this.binY(n);
                header.putInt(n, n);
                header.putDouble(indexEasting, x);
                header.putDouble(indexNorthing, y);
            }
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Ensemble getStack(String stackName) throws Exception {
        try {
            String fileName = this.getStackFullPath(stackName);
            if (!Tools_FileSystem.exists_file(fileName)) {
                return null;
            }
            Ensemble ensemble = this.m_stackIO.read(fileName);
            int indexBin = ensemble.dictionary().addEntry("Trace", "ProfileBin", DataType.Int);
            int indexEasting = ensemble.dictionary().addEntry("Trace", "Easting", DataType.Double);
            int indexNorthing = ensemble.dictionary().addEntry("Trace", "Northing", DataType.Double);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                double x = this.binX(n);
                double y = this.binY(n);
                header.putInt(n, n);
                header.putDouble(indexEasting, x);
                header.putDouble(indexNorthing, y);
            }
            return ensemble;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float sampleInterval() {
        return this.m_sampleInterval;
    }

    public double startX() {
        return this.m_startX;
    }

    public double endX() {
        return this.m_endX;
    }

    public double startY() {
        return this.m_startY;
    }

    public double endY() {
        return this.m_endY;
    }

    public int samplesPerTrace() {
        return this.m_samplesPerTrace;
    }

    public SemblanceProfileVolume semblanceProfileVolume() {
        return this.m_semblanceProfileVolume;
    }

    public String pathULWS() {
        return this.m_pathULWS;
    }

    public String pathStacksULWS() {
        return this.m_pathStacksULWS;
    }

    public boolean validStackNameULWS(String name) {
        try {
            if (name == null) {
                return false;
            }
            if ((name = Tools_Strings.removeCrap(name, true)).length() < 2) {
                return false;
            }
            String path = this.m_pathStacksULWS + "/" + name;
            return !Tools_FileSystem.exists_path(path);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected void prepSemblanceProfileVolume() {
        try {
            this.m_pathULWS = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "ULWS");
            this.m_pathStacksULWS = Tools_FileSystem.confirmSubDirectoryExists(this.m_pathULWS, "Stacks");
            String fileName = this.m_pathULWS + "/semblance.vol";
            this.m_semblanceProfileVolume = new SemblanceProfileVolume(fileName);
            fileName = this.m_pathULWS + "/velocity.picks";
            this.m_semblanceProfileVelocityCollection = new SemblanceProfileVelocityCollection(fileName, this.binCount(), this);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public SemblanceProfileVelocityCollection semblanceProfileVelocityCollection() {
        return this.m_semblanceProfileVelocityCollection;
    }

    public Java2D_Paintable_TimeGrid getVelocityAlongSemblanceProfile() {
        try {
            int numTimes = this.m_semblanceProfileVolume.numTimes();
            float t0 = (float)this.m_semblanceProfileVolume.minimumTime();
            float t1 = (float)this.m_semblanceProfileVolume.maximumTime();
            float digi = (t1 - t0) / (float)(numTimes - 1);
            this.m_semblanceProfileVelocityCollection.prepVelocity(t0, digi, numTimes);
            Java2D_Paintable_TimeGrid profile = new Java2D_Paintable_TimeGrid(this.m_list.size(), numTimes);
            for (int n = 0; n < this.m_list.size(); ++n) {
                float[] v = this.m_semblanceProfileVelocityCollection.getVelocity(n);
                for (int s = 0; s < numTimes; ++s) {
                    profile.set(n, s, v[s]);
                }
            }
            profile.setTime(t0, digi);
            return profile;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public SeismicProfile(String path, double x1, double y1, double x2, double y2, double spacing, double radius) throws Exception {
        try {
            this.m_path = path;
            this.m_name = Tools_FileSystem.getObjectName(this.m_path);
            this.m_stackPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "Stacks");
            this.m_headerFileName = this.m_path + "/header.bin";
            this.m_offsetGatherPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "OffsetGathers");
            this.m_offsetGathers = new OffsetGathers(this.m_offsetGatherPath);
            this.m_samplesPerTrace = RefractionStaticsProject.singleton().maxSamplesPerTrace();
            double dx = x2 - x1;
            double dy = y2 - y1;
            double len = Math.sqrt(dx * dx + dy * dy);
            this.m_angle = Math.atan2(dy, dx);
            int num = (int)(0.9 + len / spacing);
            this.m_radius = radius;
            this.m_spacing = spacing;
            this.m_length = spacing * (double)(num - 1);
            this.m_startX = x1;
            this.m_startY = y1;
            this.m_endX = this.m_startX + this.m_length * Math.cos(this.m_angle);
            this.m_endY = this.m_startY + this.m_length * Math.sin(this.m_angle);
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, this.m_binHeaderBytes);
            int n = 0;
            while (n < num) {
                double dist = spacing * (double)n;
                ProfileBin bin = new ProfileBin();
                bin.Index = n++;
                bin.Count = 0;
                bin.X = this.m_startX + dist * Math.cos(this.m_angle);
                bin.Y = this.m_startY + dist * Math.sin(this.m_angle);
                bin.FileName = path + "/" + String.format("Bin%d.data", bin.Index);
                buffer.putDouble(0, bin.X);
                buffer.putDouble(8, bin.Y);
                buffer.putInt(16, bin.Index);
                buffer.putInt(20, bin.Count);
                RandomAccessFile file = new RandomAccessFile(bin.FileName, "rw");
                file.write(buffer.array(), 0, this.m_binHeaderBytes);
                file.close();
                this.m_list.add(bin);
            }
            this.m_traceBytes = this.m_traceHeaderBytes + 2 * this.m_samplesPerTrace;
            this.prepSemblanceProfileVolume();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void populateSeismicProfileEnsemble(int index, Ensemble ensemble) throws Exception {
        try {
            this.populateSeismicProfileEnsemble(index, ensemble, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void populateSeismicProfileEnsemble(int index, Ensemble ensemble, boolean keepRawBytes) throws Exception {
        try {
            long len;
            ensemble.clearTraces(false);
            ProfileBin bin = this.m_list.get(index);
            RandomAccessFile file = new RandomAccessFile(bin.FileName, "rw");
            int numBytes = (int)file.length();
            if (bin.Count >= 0) {
                numBytes = this.m_binHeaderBytes + bin.Count * this.m_traceBytes;
            }
            if ((len = file.length()) != (long)numBytes) {
                file.close();
                throw new Exception("file.length() != (long)numBytes");
            }
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
            file.read(buffer.array(), 0, numBytes);
            file.close();
            if (bin.Count < 0) {
                bin.Index = buffer.getInt(16);
                bin.Count = buffer.getInt(20);
            }
            int indexShotID = ensemble.dictionary().addEntry("Trace", "ShotID", DataType.Int);
            int indexRecID = ensemble.dictionary().addEntry("Trace", "ReceiverID", DataType.Int);
            int indexTraceIndex = -9999;
            if (this.m_version >= 1001) {
                indexTraceIndex = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Long);
            }
            if (this.m_tempArray == null) {
                this.m_tempArray = new float[this.m_samplesPerTrace];
            }
            if (this.m_tempArray.length != this.m_samplesPerTrace) {
                this.m_tempArray = new float[this.m_samplesPerTrace];
            }
            for (int n = 0; n < bin.Count; ++n) {
                int offset = this.m_binHeaderBytes + n * this.m_traceBytes;
                int magic = buffer.getInt(offset + 0);
                int shotID = buffer.getInt(offset + 8);
                int recID = buffer.getInt(offset + 4);
                float scalar = buffer.getFloat(offset + 12);
                if (magic != 8254829) {
                    throw new Exception("magic != 8254829");
                }
                EnsembleTrace trace = ensemble.addTrace();
                trace.header().putInt(indexShotID, shotID);
                trace.header().putInt(indexRecID, recID);
                if (indexTraceIndex >= 0) {
                    int traceIndex = buffer.getInt(offset + 16);
                    trace.header().putLong(indexTraceIndex, traceIndex);
                }
                int dataOff = offset + this.m_traceHeaderBytes;
                for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                    short v = buffer.getShort(dataOff + 2 * s);
                    this.m_tempArray[s] = (float)v / scalar;
                }
                trace.data().insertArray(this.m_tempArray, this.m_tempArray.length);
                trace.data().setSampleInterval(this.m_sampleInterval);
                if (!keepRawBytes) continue;
                if (trace.RawByteBuffer == null) {
                    trace.RawByteBuffer = ByteBuffer.allocate(this.m_traceBytes);
                }
                if (trace.RawByteBuffer.capacity() != this.m_traceBytes) {
                    trace.RawByteBuffer = ByteBuffer.allocate(this.m_traceBytes);
                }
                byte[] to = trace.RawByteBuffer.array();
                byte[] from = buffer.array();
                System.arraycopy(from, offset, to, 0, this.m_traceBytes);
            }
            Tools_Ensemble.killTraces(ensemble);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Java2D_Paintable_TimeGrid getVelocityProfile() {
        try {
            Java2D_Paintable_TimeGrid profile = new Java2D_Paintable_TimeGrid(this.m_list.size(), this.m_samplesPerTrace);
            if (this.m_velField.numValid() < 1) {
                return profile;
            }
            for (int n = 0; n < this.m_list.size(); ++n) {
                ProfileBin bin = this.m_list.get(n);
                for (int s = 0; s < this.m_samplesPerTrace; ++s) {
                    double time = this.m_sampleInterval * (float)s;
                    float v = (float)this.m_velField.getVelocityAtTime(bin.X, bin.Y, time);
                    profile.set(n, s, v);
                }
            }
            profile.setTime(0.0, this.m_sampleInterval);
            return profile;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public double pointDistance(double x, double y) {
        try {
            double minDist = 1.0E50;
            for (ProfileBin bin : this.m_list) {
                double dx = x - bin.X;
                double dy = y - bin.Y;
                double dist = dx * dx + dy * dy;
                if (!(dist < minDist)) continue;
                minDist = dist;
            }
            return Math.sqrt(minDist + 1.0E-40);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 1.0E50;
        }
    }

    public void appendEnsemble_SecondPass(Ensemble e) throws Exception {
        try {
            Tools_Ensemble_RefractionProject.computeCdpCoords(e);
            int indexX = e.dictionary().getEntryIndex("Trace", "CdpX");
            int indexY = e.dictionary().getEntryIndex("Trace", "CdpY");
            int indexShotID = e.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRecID = e.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexTraceIndex = e.dictionary().getEntryIndex("Trace", "TraceIndex");
            int indexOffset = e.dictionary().getEntryIndex("Trace", "Offset");
            double radiusSquared = this.m_radius * this.m_radius;
            double cos = Math.cos(this.m_angle);
            double sin = Math.sin(this.m_angle);
            float[] data = new float[10];
            for (int n = 0; n < e.traceCount(); ++n) {
                EnsembleTrace t = e.trace(n);
                double offset = t.header().getDouble(indexOffset);
                if (!t.hasData() || !(offset >= this.MinimumOffset) || !(offset <= this.MaximumOffset)) continue;
                if (this.m_sampleInterval < 0.01f) {
                    this.m_sampleInterval = t.data().getSampleInterval();
                }
                double x = t.header().getDouble(indexX);
                double y = t.header().getDouble(indexY);
                if (this.Dim2D || this.ProfileSnapOn) {
                    double dx = x - this.m_startX;
                    double dy = y - this.m_startY;
                    double distAlongLine = dx * cos + dy * sin;
                    x = this.m_startX + distAlongLine * cos;
                    y = this.m_startY + distAlongLine * sin;
                }
                for (ProfileBin entry : this.m_list) {
                    int s;
                    double dx = entry.X - x;
                    double dy = entry.Y - y;
                    if (!(dx * dx + dy * dy < radiusSquared)) continue;
                    if (t.data().length() != data.length) {
                        data = new float[t.data().length()];
                    }
                    t.data().copyToArray(data);
                    float max = t.data().absoluteMax();
                    max = Math.max(max, 1.0E-20f);
                    LightweightDiskTrace pt = new LightweightDiskTrace();
                    pt.Data = new short[this.m_samplesPerTrace];
                    pt.Scalar = 30000.0f / max;
                    int minIndex = Math.min(data.length, this.m_samplesPerTrace);
                    for (s = 0; s < minIndex; ++s) {
                        pt.Data[s] = (short)(pt.Scalar * data[s]);
                    }
                    for (s = minIndex; s < this.m_samplesPerTrace; ++s) {
                        pt.Data[s] = 0;
                    }
                    pt.ShotID = t.header().getInt(indexShotID);
                    pt.ReceiverID = t.header().getInt(indexRecID);
                    pt.TraceIndex = t.header().getInt(indexTraceIndex);
                    entry.TraceList.add(pt);
                    ++entry.Count;
                }
            }
            int totalBytes = 0;
            for (ProfileBin bin : this.m_list) {
                totalBytes += this.m_traceBytes * bin.TraceList.size();
            }
            if (totalBytes > 20000000) {
                this.flush();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finishedSecondPass() {
        try {
            this.flush();
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, this.m_binHeaderBytes);
            for (ProfileBin bin : this.m_list) {
                RandomAccessFile file = new RandomAccessFile(bin.FileName, "rw");
                file.read(buffer.array(), 0, this.m_binHeaderBytes);
                int index = buffer.getInt(16);
                buffer.putInt(20, bin.Count);
                file.seek(0L);
                file.write(buffer.array(), 0, this.m_binHeaderBytes);
                file.seek(0L);
                file.read(buffer.array(), 0, this.m_binHeaderBytes);
                int count = buffer.getInt(20);
                file.close();
            }
            RandomAccessFile header = new RandomAccessFile(this.m_headerFileName, "rw");
            this.m_version = 1001;
            int magic = 5777222;
            header.writeInt(magic);
            header.writeInt(this.m_version);
            if (this.m_version == 1000 || this.m_version == 1001) {
                header.writeFloat(this.m_sampleInterval);
                header.writeInt(this.m_samplesPerTrace);
                header.writeInt(this.m_list.size());
                header.writeDouble(this.m_angle);
                header.writeDouble(this.m_radius);
                header.writeDouble(this.m_spacing);
                header.writeDouble(this.m_length);
                header.writeDouble(this.m_startX);
                header.writeDouble(this.m_startY);
                header.writeDouble(this.m_endX);
                header.writeDouble(this.m_endY);
            }
            header.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void flush() {
        try {
            int magic = 8254829;
            for (ProfileBin bin : this.m_list) {
                if (bin.TraceList.size() <= 0) continue;
                int numBytes = this.m_traceBytes * bin.TraceList.size();
                ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
                for (int n = 0; n < bin.TraceList.size(); ++n) {
                    LightweightDiskTrace trace = bin.TraceList.get(n);
                    int offset = n * this.m_traceBytes;
                    buffer.putInt(offset + 0, magic);
                    buffer.putInt(offset + 4, trace.ReceiverID);
                    buffer.putInt(offset + 8, trace.ShotID);
                    buffer.putFloat(offset + 12, trace.Scalar);
                    buffer.putInt(offset + 16, trace.TraceIndex);
                    int dataOff = offset + this.m_traceHeaderBytes;
                    for (int s = 0; s < trace.Data.length; ++s) {
                        buffer.putShort(dataOff + 2 * s, trace.Data[s]);
                    }
                }
                RandomAccessFile file = new RandomAccessFile(bin.FileName, "rw");
                long fileLength = file.length();
                file.seek(fileLength);
                file.write(buffer.array(), 0, numBytes);
                file.close();
                bin.TraceList.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public SeismicProfile(String path) throws Exception {
        try {
            this.m_path = path;
            this.m_name = Tools_FileSystem.getObjectName(this.m_path);
            this.m_stackPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "Stacks");
            this.m_headerFileName = this.m_path + "/header.bin";
            this.m_offsetGatherPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_path, "OffsetGathers");
            this.m_offsetGathers = new OffsetGathers(this.m_offsetGatherPath);
            RandomAccessFile file = new RandomAccessFile(this.m_headerFileName, "rw");
            int magic = file.readInt();
            if (magic != 5777222) {
                file.close();
                throw new Exception("bad magic");
            }
            this.m_version = file.readInt();
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, this.m_binHeaderBytes);
            if (this.m_version == 1000 || this.m_version == 1001) {
                this.m_sampleInterval = file.readFloat();
                this.m_samplesPerTrace = file.readInt();
                this.m_traceBytes = this.m_traceHeaderBytes + 2 * this.m_samplesPerTrace;
                int numBins = file.readInt();
                this.m_angle = file.readDouble();
                this.m_radius = file.readDouble();
                this.m_spacing = file.readDouble();
                this.m_length = file.readDouble();
                this.m_startX = file.readDouble();
                this.m_startY = file.readDouble();
                this.m_endX = file.readDouble();
                this.m_endY = file.readDouble();
                double dx = (this.m_endX - this.m_startX) / (double)(numBins - 1);
                double dy = (this.m_endY - this.m_startY) / (double)(numBins - 1);
                for (int n = 0; n < numBins; ++n) {
                    ProfileBin bin = new ProfileBin();
                    bin.FileName = path + "/" + String.format("Bin%d.data", n);
                    bin.X = this.m_startX + (double)n * dx;
                    bin.Y = this.m_startY + (double)n * dy;
                    bin.Count = -9999;
                    bin.Index = -9999;
                    this.m_list.add(bin);
                }
            } else {
                file.close();
                throw new Exception("bad version");
            }
            file.close();
            this.prepSemblanceProfileVolume();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean isNewStackNameOkay(String stackName) {
        try {
            if (stackName == null) {
                JOptionPane.showMessageDialog(null, "Profile name must have at least three characters", "", 0);
                return false;
            }
            if (stackName.length() < 3) {
                JOptionPane.showMessageDialog(null, "Profile name must have at least three characters", "", 0);
                return false;
            }
            if (!Tools_Strings.isAlphaNumeric(stackName, true, false)) {
                JOptionPane.showMessageDialog(null, "Spaces and special characters not allowed", "", 0);
                return false;
            }
            if (Tools_Strings.startsWithNumber(stackName)) {
                JOptionPane.showMessageDialog(null, "Name cannot start with a number", "", 0);
                return false;
            }
            String path = this.getStackFullPath(stackName);
            if (Tools_FileSystem.exists_path(path)) {
                JOptionPane.showMessageDialog(null, "Stack already exists", "", 0);
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void reloadProfileList() {
    }

    public static class ProfileBin {
        public double X;
        public double Y;
        public int Index = 0;
        public int Count = 0;
        public String FileName;
        public ArrayList<LightweightDiskTrace> TraceList = new ArrayList();
    }
}

