/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Seismic.Echos;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Echos.XtType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Echos_Dictionary
extends AbstractTableModel {
    protected ArrayList<Entry> m_mapEntries = new ArrayList();
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    public String m_fileName = "";
    public boolean m_fileNameValid = false;
    public static String FileSuffix = "EchosDictXML";
    protected boolean m_sendModMessage = true;
    protected HashMap<String, Object> m_testDataMap = new HashMap();
    protected long m_firstTraceIndex = -999L;
    protected String m_testHeaderLabel = "";
    protected String m_testDatabaseLabel = "";
    protected int TotalDumps = 0;
    public String PreStackErrorMessage = "";
    protected ArrayList<RequiredPair> m_requiredList = new ArrayList();
    public String ReasonNotValidPostStack = "";
    public boolean ShowTestColumnsInTable = true;

    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public Echos_Dictionary(String sApplication, boolean b3d) {
        try {
            this.addDefaultEntries(sApplication, b3d);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setTestData(HashMap<String, Object> dataMap, long firstTraceIndex) {
        try {
            this.m_firstTraceIndex = -999999L;
            for (Entry e : this.m_mapEntries) {
                e.TestDatabase = "";
                e.TestHeader = "";
            }
            if (dataMap == null) {
                this.fireTableDataChanged();
                return;
            }
            if (firstTraceIndex < 0L) {
                this.fireTableDataChanged();
                return;
            }
            this.m_firstTraceIndex = firstTraceIndex;
            this.m_testHeaderLabel = "QC: Header value, " + Long.toString(this.m_firstTraceIndex + 1L);
            this.m_testDatabaseLabel = "QC: Database value, " + Long.toString(this.m_firstTraceIndex + 1L);
            this.m_testDataMap = dataMap;
            this.computeTestValues();
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean isFileNameValid() {
        return this.m_fileNameValid;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setOpenFileName(String fileName) {
        try {
            this.m_mapEntries.clear();
            this.m_fileNameValid = false;
            this.m_fileName = "";
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.fireTableDataChanged();
                return;
            }
            if (!fileName.toLowerCase().endsWith(FileSuffix.toLowerCase())) {
                this.fireTableDataChanged();
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readContentsFromNode(root);
            this.m_fileNameValid = true;
            this.m_fileName = fileName;
            this.fireTableDataChanged();
            this.handleMod(true, false, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileName = Tools_Strings.confirmSuffix(fileName, FileSuffix);
            this.m_fileNameValid = true;
            this.save();
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            if (!this.m_fileNameValid) {
                return;
            }
            if (this.m_fileName.length() < 2) {
                return;
            }
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("EchosDictionary");
            document.appendChild(root);
            this.writeContentsToNode(root);
            Tools_XML.writeDocumentToFile(document, this.m_fileName);
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            try {
                this.m_mapEntries.clear();
                this.m_fileNameValid = false;
                this.m_fileName = "";
                this.fireTableDataChanged();
            }
            catch (Exception error2) {
                ExceptionMonitor.add(error2);
            }
            return;
        }
    }

    public ArrayList<String> columns(String tableName) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (Entry e : this.m_mapEntries) {
                if (!e.Table.equalsIgnoreCase(tableName)) continue;
                list.add(e.Column);
            }
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void computeTestValues() {
        try {
            for (Entry e : this.m_mapEntries) {
                e.TestDatabase = "";
                e.TestHeader = "";
            }
            if (this.m_firstTraceIndex < 0L) {
                return;
            }
            this.prepareSeismicHeaderDictionary(null);
            this.fillTraceHeader(this.m_testDataMap, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void handleMod(boolean fireTableMod, boolean bSave, Object modData) {
        try {
            if (fireTableMod) {
                this.computeTestValues();
                this.fireTableDataChanged();
            }
            if (bSave) {
                this.save();
            }
            this.m_listenerManager.broadcast(this, modData);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareEnsembleHeaderDictionary(EnsembleHeaderDictionary headerDict) {
        try {
            for (Entry entry : this.m_mapEntries) {
                entry.HeaderIndex = -9999;
                if (!headerDict.containsEntry(entry.Table, entry.Column)) continue;
                entry.HeaderIndex = headerDict.getEntryIndex(entry.Table, entry.Column);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void fillTraceHeader(HashMap<String, Object> dataMap, Column_Abstract header) {
        try {
            int tempInt = 0;
            double tempDouble = 0.0;
            for (Entry entry : this.m_mapEntries) {
                Object objValue = null;
                if (dataMap.containsKey(entry.EchosHeader)) {
                    objValue = dataMap.get(entry.EchosHeader);
                }
                tempInt = (int)entry.DefaultValue;
                tempDouble = entry.DefaultValue;
                if (entry.Factor < 1) {
                    entry.Factor = 1;
                }
                if (entry.Valid) {
                    boolean bFoundType = false;
                    if (objValue instanceof Float) {
                        bFoundType = true;
                        Float fVal = (Float)objValue;
                        tempDouble = fVal.floatValue();
                        if (header == null) {
                            entry.TestHeader = Double.toString(tempDouble);
                        }
                    } else if (objValue instanceof Double) {
                        bFoundType = true;
                        Double dVal = (Double)objValue;
                        tempDouble = dVal;
                        if (header == null) {
                            entry.TestHeader = Double.toString(tempDouble);
                        }
                    } else if (objValue instanceof Integer) {
                        bFoundType = true;
                        Integer iVal = (Integer)objValue;
                        tempInt = iVal;
                        if (header == null) {
                            entry.TestHeader = Integer.toString(tempInt);
                        }
                        tempDouble = tempInt;
                    }
                    if (bFoundType) {
                        if (entry.ModMethod == Modification.FactorDivide) {
                            tempDouble = entry.DatabaseType == DataType.Double || entry.DatabaseType == DataType.Float ? (tempDouble /= (double)entry.Factor) : (double)(tempInt /= entry.Factor);
                        }
                        if (entry.ModMethod == Modification.FactorRemainder) {
                            tempDouble = tempInt %= entry.Factor;
                        }
                    }
                    if (this.TotalDumps < 100 && entry.Column.equalsIgnoreCase("CdpX")) {
                        ++this.TotalDumps;
                    }
                } else {
                    tempDouble = entry.DefaultValue;
                    tempInt = (int)Math.round(tempDouble);
                    if (header == null) {
                        entry.TestHeader = Double.toString(tempDouble);
                    }
                }
                if (entry.DatabaseType == DataType.Int) {
                    long l = Math.round(tempDouble);
                    l = Math.min(l, Integer.MAX_VALUE);
                    l = Math.max(l, Integer.MIN_VALUE);
                    if (header != null) {
                        header.putInt(entry.HeaderIndex, (int)l);
                    } else {
                        entry.TestDatabase = Long.toString(l);
                    }
                }
                if (entry.DatabaseType == DataType.Double) {
                    if (header != null) {
                        header.putDouble(entry.HeaderIndex, tempDouble);
                    } else {
                        entry.TestDatabase = Double.toString(tempDouble);
                    }
                }
                if (entry.DatabaseType != DataType.Float) continue;
                if (header != null) {
                    header.putFloat(entry.HeaderIndex, (float)tempDouble);
                    continue;
                }
                entry.TestDatabase = Double.toString(tempDouble);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareSeismicHeaderDictionary(EnsembleHeaderDictionary headerDict) {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (headerDict != null) {
                    entry.HeaderIndex = headerDict.addEntry(entry.Table, entry.Column, entry.DatabaseType);
                }
                entry.Factor = Math.max(entry.Factor, 1);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortByTableColumn() {
        try {
            Collections.sort(this.m_mapEntries, new Sorter_TableColumn());
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void sortByOffset() {
        try {
            Collections.sort(this.m_mapEntries, new Sorter_Offset());
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeAll() {
        try {
            this.m_mapEntries.clear();
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int entryCount() {
        return this.m_mapEntries.size();
    }

    public void removeEntry(int row) {
        try {
            if (row >= 0 && row < this.m_mapEntries.size()) {
                this.m_mapEntries.remove(row);
                this.handleMod(true, true, null);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static Modification getModFromString(String mod) {
        try {
            if (mod.equals("None")) {
                return Modification.None;
            }
            if (mod.equals("FactorDivide")) {
                return Modification.FactorDivide;
            }
            if (mod.equals("FactorRemainder")) {
                return Modification.FactorRemainder;
            }
            if (mod.equals("ElevationScalar")) {
                return Modification.ElevationScalar;
            }
            if (mod.equals("CoordScalar")) {
                return Modification.CoordScalar;
            }
            if (mod.equals("TimeScalar")) {
                return Modification.TimeScalar;
            }
            return Modification.None;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return Modification.None;
        }
    }

    public void writeContentsToNode(Element node) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                Element e = node.getOwnerDocument().createElement("Entry");
                e.setAttribute("Table", entry.Table);
                e.setAttribute("Column", entry.Column);
                e.setAttribute("EchosHeader", entry.EchosHeader);
                e.setAttribute("HeaderType", entry.HeaderType.Description);
                e.setAttribute("DatabaseType", entry.DatabaseType.Description);
                e.setAttribute("ModMethod", entry.ModMethod.toString());
                e.setAttribute("Factor", Integer.toString(entry.Factor));
                e.setAttribute("Valid", Boolean.toString(entry.Valid));
                e.setAttribute("DefaultValue", Double.toString(entry.DefaultValue));
                node.appendChild(e);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void readContentsFromNode(Element node) throws Exception {
        try {
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(node, "Entry");
            this.m_sendModMessage = false;
            for (Element e : nodes) {
                String table = e.getAttribute("Table");
                String column = e.getAttribute("Column");
                String echosHeader = e.getAttribute("EchosHeader");
                String HeaderType = e.getAttribute("HeaderType");
                String DatabaseType = e.getAttribute("DatabaseType");
                String off = e.getAttribute("Offset");
                String mod = e.getAttribute("ModMethod");
                String fac = e.getAttribute("Factor");
                column = Tools_Strings.removeCrap(column, true);
                boolean valid = true;
                if (e.hasAttribute("Valid")) {
                    valid = Boolean.valueOf(e.getAttribute("Valid"));
                }
                double defvalue = 0.0;
                if (e.hasAttribute("DefaultValue")) {
                    defvalue = Double.valueOf(e.getAttribute("DefaultValue"));
                }
                DataType ht = DataType.typeFromDescription(HeaderType);
                DataType dt = DataType.typeFromDescription(DatabaseType);
                int factor = Integer.parseInt(fac);
                Modification m = Echos_Dictionary.getModFromString(mod);
                Entry entry = this.addEntry(table, column, echosHeader, ht, dt, m, factor);
                entry.Valid = valid;
                entry.DefaultValue = defvalue;
            }
            this.m_sendModMessage = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void addRequiredPair(String table, String column) {
        this.m_requiredList.add(new RequiredPair(table, column));
    }

    public boolean checkPreStackEntry(String table, String column) {
        try {
            if (!this.hasEntry(table, column)) {
                this.PreStackErrorMessage = "Required entry not present: " + table + " " + column;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidPostStack(boolean is3D) {
        try {
            this.ReasonNotValidPostStack = "";
            this.m_requiredList.clear();
            this.addRequiredPair("Trace", "CdpX");
            this.addRequiredPair("Trace", "CdpY");
            if (is3D) {
                this.addRequiredPair("Trace", "Inline");
                this.addRequiredPair("Trace", "Crossline");
            } else {
                this.addRequiredPair("Trace", "CDP");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                this.ReasonNotValidPostStack = "Required header (" + pair.Table + ", " + pair.Column + ") not defined";
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidVelocity2D() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Trace", "Bin2D");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "Offset");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidVelocity3D() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Trace", "Inline");
                this.addRequiredPair("Trace", "Crossline");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "CdpX");
                this.addRequiredPair("Trace", "Offset");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidResidual(boolean is3D) {
        try {
            this.ReasonNotValidPostStack = "";
            this.m_requiredList.clear();
            this.addRequiredPair("Trace", "CdpX");
            this.addRequiredPair("Trace", "CdpY");
            this.addRequiredPair("Shot", "Easting");
            this.addRequiredPair("Shot", "Northing");
            this.addRequiredPair("Shot", "PointNumber");
            this.addRequiredPair("Receiver", "Easting");
            this.addRequiredPair("Receiver", "Northing");
            this.addRequiredPair("Receiver", "PointNumber");
            if (is3D) {
                this.addRequiredPair("Trace", "Inline");
                this.addRequiredPair("Trace", "Crossline");
            } else {
                this.addRequiredPair("Trace", "CDP");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                this.ReasonNotValidPostStack = "Required header (" + pair.Table + ", " + pair.Column + ") not defined";
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean isValidPreStack() {
        try {
            if (this.m_requiredList.size() < 1) {
                this.addRequiredPair("Shot", "Easting");
                this.addRequiredPair("Shot", "Northing");
                this.addRequiredPair("Shot", "Elevation");
                this.addRequiredPair("Shot", "PointNumber");
                this.addRequiredPair("Receiver", "Easting");
                this.addRequiredPair("Receiver", "Northing");
                this.addRequiredPair("Receiver", "Elevation");
                this.addRequiredPair("Receiver", "PointNumber");
            }
            for (RequiredPair pair : this.m_requiredList) {
                if (this.checkPreStackEntry(pair.Table, pair.Column)) continue;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public boolean hasEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void removeEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                this.m_mapEntries.remove(entry);
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntry(int index) throws Exception {
        try {
            return this.m_mapEntries.get(index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntryNullIfNotExists(String table, String column) {
        for (Entry entry : this.m_mapEntries) {
            if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
            return entry;
        }
        return null;
    }

    public Entry getEntry(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return entry;
            }
            throw new Exception("Does not have entry");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry getEntry_Create(String table, String column) throws Exception {
        try {
            for (Entry entry : this.m_mapEntries) {
                if (!table.equalsIgnoreCase(entry.Table) || !column.equalsIgnoreCase(entry.Column)) continue;
                return entry;
            }
            this.addEntry(table, column, "", DataType.Int, DataType.Int, Modification.None, 1);
            Entry entry = this.getEntry(table, column);
            entry.Valid = false;
            entry.DefaultValue = 0.0;
            return entry;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public Entry addEntry(String table, String column, String echosHeader, DataType HeaderType, DataType DatabaseType, Modification mod, int factor) {
        try {
            if (this.hasEntry(table, column)) {
                return this.getEntry(table, column);
            }
            Entry entry = new Entry();
            entry.Table = table;
            entry.Column = column;
            entry.EchosHeader = echosHeader;
            entry.HeaderType = HeaderType;
            entry.DatabaseType = DatabaseType;
            entry.ModMethod = mod;
            entry.Factor = factor;
            this.m_mapEntries.add(entry);
            if (this.m_sendModMessage) {
                this.handleMod(true, true, null);
            }
            return entry;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void addDefaultResidualStaticsEntries(boolean b3D) {
        this.addEntry("Trace", "CdpX", "cdpx", DataType.Double, DataType.Double, Modification.None, 1);
        this.addEntry("Trace", "CdpY", "cdpy", DataType.Double, DataType.Double, Modification.None, 1);
        if (b3D) {
            this.addEntry("Trace", "Inline", "inline", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Trace", "Crossline", "xline", DataType.Int, DataType.Int, Modification.None, 1);
        } else {
            this.addEntry("Trace", "Bin", "cdp", DataType.Int, DataType.Int, Modification.None, 1);
        }
        this.addEntry("Shot", "PointNumber", "shtstn", DataType.Int, DataType.Int, Modification.None, 1);
        this.addEntry("Shot", "LineNumber", "shtline", DataType.Int, DataType.Int, Modification.None, 1);
        this.addEntry("Shot", "PointIndex", "shot", DataType.Int, DataType.Int, Modification.None, 1);
        this.addEntry("Receiver", "PointNumber", "recstn", DataType.Int, DataType.Int, Modification.None, 1);
        this.addEntry("Receiver", "LineNumber", "recline", DataType.Int, DataType.Int, Modification.None, 1);
        this.addEntry("Shot", "Easting", "shotx", DataType.Double, DataType.Double, Modification.None, 1);
        this.addEntry("Shot", "Northing", "shoty", DataType.Double, DataType.Double, Modification.None, 1);
        this.addEntry("Receiver", "Easting", "recx", DataType.Double, DataType.Double, Modification.None, 1);
        this.addEntry("Receiver", "Northing", "recy", DataType.Double, DataType.Double, Modification.None, 1);
        this.addEntry("Trace", "Offset", "offset", DataType.Int, DataType.Int, Modification.None, 1);
    }

    public void addDefaultEntries(String sApplication, boolean b3d) {
        if (sApplication.equals("Flatirons")) {
            this.addDefaultRefractionStaticsEntries();
        }
        if (sApplication.equals("Pecos")) {
            this.addDefaultResidualStaticsEntries(b3d);
        }
    }

    public void addDefaultRefractionStaticsEntries() {
        try {
            this.addEntry("Trace", "Channel", "chan", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Receiver", "Easting", "recx", DataType.Double, DataType.Double, Modification.None, 1);
            this.addEntry("Receiver", "Northing", "recy", DataType.Double, DataType.Double, Modification.None, 1);
            this.addEntry("Receiver", "Elevation", "relev", DataType.Float, DataType.Double, Modification.None, 1);
            this.addEntry("Receiver", "PointNumber", "recstn", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Receiver", "LineNumber", "recline", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Shot", "Easting", "shotx", DataType.Double, DataType.Double, Modification.None, 1);
            this.addEntry("Shot", "Northing", "shoty", DataType.Double, DataType.Double, Modification.None, 1);
            this.addEntry("Shot", "Elevation", "selev", DataType.Float, DataType.Double, Modification.None, 1);
            this.addEntry("Shot", "PointDepth", "shtdpth", DataType.Float, DataType.Double, Modification.None, 1);
            Entry upholeTimeEntry = this.addEntry("Shot", "UpholeTime", "uphole", DataType.Float, DataType.Int, Modification.None, 0);
            this.addEntry("Shot", "PointNumber", "shtstn", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Shot", "LineNumber", "shtline", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Shot", "PointIndex", "shot", DataType.Int, DataType.Int, Modification.None, 1);
            this.addEntry("Shot", "FFID", "ffid", DataType.Int, DataType.Int, Modification.None, 1);
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Table";
            }
            if (column == 1) {
                return "Column";
            }
            if (column == 2) {
                return "Echos Header";
            }
            if (column == 5) {
                return "Database type";
            }
            if (column == 3) {
                return "Modification";
            }
            if (column == 4) {
                return "Factor";
            }
            if (column == 6) {
                return "Value valid";
            }
            if (column == 7) {
                return "Default value";
            }
            if (column == 8) {
                return "Test: Header value";
            }
            if (column == 9) {
                return "Test: Database value";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (!this.m_fileNameValid) {
            return 0;
        }
        int rows = this.m_mapEntries.size();
        return rows;
    }

    @Override
    public int getColumnCount() {
        if (this.ShowTestColumnsInTable) {
            return 10;
        }
        return 8;
    }

    public Class getColumnClass(int column) {
        if (column == 6) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 8) {
            return false;
        }
        return column != 9;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        try {
            if (!this.m_fileNameValid) {
                return;
            }
            if (value == null) {
                return;
            }
            Entry entry = this.m_mapEntries.get(row);
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                if (column == 6) {
                    entry.Valid = b;
                    this.handleMod(true, true, null);
                }
                return;
            }
            if (!(value instanceof String)) {
                return;
            }
            String s = (String)value;
            if (s.length() < 1) {
                return;
            }
            if (column == 0) {
                entry.Table = s;
            }
            if (column == 2) {
                entry.EchosHeader = s;
            }
            if (column == 1) {
                s = Tools_Strings.removeSpace(s);
                entry.Column = s = Tools_Strings.removeCrap(s, true);
            }
            if (column == 5) {
                entry.DatabaseType = DataType.typeFromDescription(s);
            }
            if (column == 3) {
                entry.ModMethod = Modification.modFromDescription(s);
            }
            if (column == 4) {
                entry.Factor = Integer.parseInt(s);
            }
            if (column == 7) {
                entry.DefaultValue = Double.parseDouble(s);
            }
            this.handleMod(true, true, null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (!this.m_fileNameValid) {
                return "";
            }
            Entry e = this.m_mapEntries.get(row);
            if (column == 0) {
                return e.Table;
            }
            if (column == 1) {
                return e.Column;
            }
            if (column == 2) {
                return e.EchosHeader;
            }
            if (column == 5) {
                return e.DatabaseType.Description;
            }
            if (column == 3) {
                return e.ModMethod.Description;
            }
            if (column == 4) {
                if (e.ModMethod == Modification.FactorDivide || e.ModMethod == Modification.FactorRemainder) {
                    return Integer.toString(e.Factor);
                }
                return "";
            }
            if (column == 6) {
                return e.Valid;
            }
            if (column == 7) {
                return Double.toString(e.DefaultValue);
            }
            if (column == 8) {
                return e.TestHeader;
            }
            if (column == 9) {
                return e.TestDatabase;
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    public static class Entry {
        public String EchosHeader = "";
        public DataType HeaderType = DataType.Int;
        public Modification ModMethod = Modification.None;
        public int Factor = 0;
        public String Table = "Error";
        public String Column = "Error";
        public DataType DatabaseType = DataType.Int;
        public int HeaderIndex = 0;
        public DataType EnsembleType = DataType.Int;
        public boolean IsEnsembleFloatType = false;
        public boolean Valid = true;
        public double DefaultValue;
        protected String TestHeader = "";
        protected String TestDatabase = "";
        public int EchosHeaderWordIndex = -1;
        public XtType EchosType = XtType.XtTypeUnknown;
        public int EchosHeaderIndex = -1;

        public String toString() {
            try {
                String s = String.format("%10s%10s", this.Table, this.Column);
                return s;
            }
            catch (Exception error) {
                return "Error";
            }
        }
    }

    public static enum Modification {
        None("None"),
        FactorDivide("Divide by factor"),
        FactorRemainder("Divide by factor, use remainder"),
        ElevationScalar("Apply the elevation scalar"),
        CoordScalar("Apply the coordinate scalar"),
        TimeScalar("Apply the time scalar");

        public final String Description;

        private Modification(String desc) {
            this.Description = desc;
        }

        public static Modification modFromDescription(String s) {
            Modification[] arr = Modification.values();
            for (int n = 0; n < arr.length; ++n) {
                if (!s.equalsIgnoreCase(arr[n].Description)) continue;
                return arr[n];
            }
            return None;
        }
    }

    public static class Sorter_TableColumn
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                if (e1.Table.equals(e2.Table)) {
                    return e1.Column.compareTo(e2.Column);
                }
                return e1.Table.compareTo(e2.Table);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    public static class Sorter_Offset
    implements Comparator<Entry> {
        @Override
        public int compare(Entry e1, Entry e2) {
            try {
                int iCompare = e1.EchosHeader.compareTo(e2.EchosHeader);
                return iCompare;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                return 0;
            }
        }
    }

    protected class RequiredPair {
        public String Table;
        public String Column;

        public RequiredPair(String tbl, String col) {
            this.Table = tbl;
            this.Column = col;
        }
    }

    public class ColumnIndex {
        public static final int Table = 0;
        public static final int Column = 1;
        public static final int EchosHeader = 2;
        public static final int Modification = 3;
        public static final int Factor = 4;
        public static final int DatabaseType = 5;
        public static final int Valid = 6;
        public static final int DefaultValue = 7;
        public static final int TestHeaderValue = 8;
        public static final int TestDatabaseValue = 9;
        public static final int Count = 10;
    }
}

