/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Uphole;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Uphole.UpholeImportData;
import com.PecosLibrary.Windows.Refraction.Uphole.UpholeMappingDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;

public class UpholeModel {
    protected Table_Abstract m_table;
    protected String m_modelName;
    protected int m_maxLayers = 1;
    protected ArrayList<Integer> m_timeColumns = new ArrayList();
    protected ArrayList<Integer> m_depthColumns = new ArrayList();
    protected ArrayList<Integer> m_elevColumns = new ArrayList();
    protected ArrayList<Integer> m_thickColumns = new ArrayList();
    protected ArrayList<Integer> m_velColumns = new ArrayList();
    protected IDatabaseConnection m_databaseConnection;
    protected int m_indexX;
    protected int m_indexY;
    protected int m_indexZ;
    protected boolean m_valid = false;
    protected boolean m_bContainsVelocityInversions = false;
    double _dMaxDepthCalculated = -9999.0;
    float[][] m_interpolatedVels;
    double m_dInterpolationdDepthDigi = 0.0;
    double m_dInterpolationMaxDepth = 0.0;
    int m_nInterpolatedDepthArraySize = 0;

    public UpholeModel() {
        try {
            this.m_table = new Table_Memory();
            this.m_indexX = this.m_table.column_append("Easting", DataType.Double);
            this.m_indexY = this.m_table.column_append("Northing", DataType.Double);
            this.m_indexZ = this.m_table.column_append("Elevation", DataType.Double);
            this.m_timeColumns.add(this.m_table.column_append("Uphole_Time" + Integer.toString(0), DataType.Double));
            this.m_depthColumns.add(this.m_table.column_append("Uphole_Depth" + Integer.toString(0), DataType.Double));
            this.m_velColumns.add(this.m_table.column_append("Uphole_Velocity" + Integer.toString(0), DataType.Double));
            this.m_valid = false;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            String projectPath = RefractionStaticsProject.singleton().projectPath();
            String upholePath = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "Uphole");
            String fileNameDB = upholePath + "/uphole.db";
            this.m_databaseConnection = Tools_JDBC.getConnection(false, fileNameDB);
            if (this.m_databaseConnection.tableExists(this.m_table.name())) {
                this.m_databaseConnection.dropTable(this.m_table.name());
            }
            this.m_databaseConnection.createDatabaseTable(this.m_table);
            this.m_databaseConnection.appendTable(this.m_table, 0);
            this.m_databaseConnection.closeConnection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void save(IDatabaseConnection connection, String name) {
        String sOriginalTableName = "";
        try {
            sOriginalTableName = this.m_table.name();
            this.m_table.setName(name);
            connection.createDatabaseTable(this.m_table);
            connection.appendTable(this.m_table, 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        finally {
            try {
                this.m_table.setName(sOriginalTableName);
            }
            catch (Exception e) {
                ExceptionMonitor.add(e);
            }
        }
    }

    public void load(String name) throws Exception {
        try {
            String projectPath = RefractionStaticsProject.singleton().projectPath();
            String upholePath = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "Uphole");
            String fileNameDB = upholePath + "/uphole.db";
            this.m_databaseConnection = Tools_JDBC.getConnection(false, fileNameDB);
            ArrayList<String> list = this.m_databaseConnection.getTableNames();
            String dbname = list.get(0);
            String sql = String.format("SELECT * FROM %s", dbname);
            this.m_table = this.m_databaseConnection.extractTableDataUsingQuery(dbname, sql, 0);
            this.m_indexX = this.m_table.column_indexOfColumn("Easting");
            this.m_indexY = this.m_table.column_indexOfColumn("Northing");
            this.m_indexZ = this.m_table.column_indexOfColumn("Elevation");
            ArrayList<String> columnNames = this.m_table.column_listOfNames();
            int iMaxTimeIndex = -1;
            int iMaxDepthIndex = -1;
            String sTime = "Uphole_Time".toUpperCase();
            String sDepth = "Uphole_Depth".toUpperCase();
            for (String sTempColumnName : columnNames) {
                String sTemp;
                int iTimeIndex = -1;
                int iDepthIndex = -1;
                String sColumnName = sTempColumnName.toUpperCase();
                if (sColumnName.contains(sTime)) {
                    sTemp = sColumnName.replace(sTime, "");
                    try {
                        iTimeIndex = Integer.parseInt(sTemp);
                        iMaxTimeIndex = Math.max(iMaxTimeIndex, iTimeIndex);
                    }
                    catch (Exception e) {
                        iTimeIndex = -1;
                    }
                }
                if (!sColumnName.contains(sDepth)) continue;
                sTemp = sColumnName.replace(sDepth, "");
                try {
                    iDepthIndex = Integer.parseInt(sTemp);
                    iMaxDepthIndex = Math.max(iMaxDepthIndex, iDepthIndex);
                }
                catch (Exception e) {
                    iDepthIndex = -1;
                }
            }
            this.m_timeColumns.clear();
            this.m_depthColumns.clear();
            this.m_velColumns.clear();
            if (iMaxTimeIndex == iMaxDepthIndex && iMaxTimeIndex >= 0) {
                for (int iIndex = 0; iIndex <= iMaxTimeIndex; ++iIndex) {
                    String sTimeColumn = "Uphole_Time" + Integer.toString(iIndex);
                    String sDepthColumn = "Uphole_Depth" + Integer.toString(iIndex);
                    String sVelColumn = "Uphole_Velocity" + Integer.toString(iIndex);
                    if (!this.m_table.column_exists(sTimeColumn) && !this.m_table.column_exists(sDepthColumn)) continue;
                    this.m_timeColumns.add(this.m_table.column_indexOfColumn(sTimeColumn));
                    this.m_depthColumns.add(this.m_table.column_indexOfColumn(sDepthColumn));
                    if (!this.m_table.column_exists(sVelColumn)) {
                        this.m_table.column_append(sVelColumn, DataType.Double);
                    }
                    this.m_velColumns.add(this.m_table.column_indexOfColumn(sVelColumn));
                }
            }
            this.m_maxLayers = this.m_velColumns.size();
            int nRows = this.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double x = this.getX(iRow);
                double y = this.getY(iRow);
                double z = this.getZ(iRow);
                int nVels = this.getNumLayers(iRow);
                for (int iVel = 0; iVel < nVels; ++iVel) {
                    double dDepth = this.getDepth(iRow, iVel);
                    double dTime = this.getTime(iRow, iVel);
                }
            }
            this.m_modelName = name;
            this.m_databaseConnection.closeConnection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static UpholeModel importSurvey(UpholeImportData data) {
        try {
            UpholeModel model = new UpholeModel();
            String fileName = data.ImportFileName;
            String surveyName = data.ImportSurveyName;
            ArrayList<String> columnNames = data.MasterColumnList;
            boolean useComma = data.UseComma;
            boolean useSpace = !useComma;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = reader.readLine();
            Table_Memory table = new Table_Memory();
            table.setName(surveyName);
            for (int col = 0; col < columnNames.size(); ++col) {
                String cn = columnNames.get(col);
                table.column_append(cn, DataType.Double);
            }
            String colNameID = surveyName + "ID";
            int indexID = table.column_append(colNameID, DataType.Int);
            int nextID = 1000;
            line = reader.readLine();
            while (line != null) {
                ArrayList<String> tokens = null;
                if (useComma) {
                    tokens = Tools_Strings.tokenizer_improved(line, ',');
                }
                if (useSpace) {
                    tokens = Tools_Strings.tokenizer_space(line, false);
                }
                if (tokens.size() >= columnNames.size()) {
                    int row = table.row_increment();
                    for (int col = 0; col < columnNames.size(); ++col) {
                        String token = tokens.get(col);
                        double v = -999999.0;
                        if (token.length() > 0 && !token.equalsIgnoreCase("NULL")) {
                            try {
                                v = Double.parseDouble(token);
                            }
                            catch (Exception ex) {
                                v = -999999.0;
                            }
                        }
                        table.putDouble(row, col, v);
                    }
                    table.putInt(row, indexID, nextID++);
                }
                line = reader.readLine();
            }
            reader.close();
            model.m_table = table;
            model.save();
            return model;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static Table_Abstract importSurvey_ScanColumns(UpholeImportData data) {
        try {
            String fileName = data.ImportFileName;
            ArrayList<String> columnNames = data.MasterColumnList;
            boolean useComma = data.UseComma;
            boolean useSpace = !useComma;
            BufferedReader reader = new BufferedReader(new FileReader(fileName));
            String line = reader.readLine();
            Table_Memory table = new Table_Memory();
            table.setName("Temp");
            for (int col = 0; col < columnNames.size(); ++col) {
                String cn = columnNames.get(col);
                table.column_append(cn, DataType.Double);
            }
            String colNameID = "TempID";
            int indexID = table.column_append(colNameID, DataType.Int);
            int nextID = 1000;
            line = reader.readLine();
            while (line != null) {
                ArrayList<String> tokens = null;
                if (useComma) {
                    tokens = Tools_Strings.tokenizer_improved(line, ',');
                }
                if (useSpace) {
                    tokens = Tools_Strings.tokenizer_space(line, false);
                }
                if (tokens.size() >= columnNames.size()) {
                    int row = table.row_increment();
                    for (int col = 0; col < columnNames.size(); ++col) {
                        String token = tokens.get(col);
                        double v = -999999.0;
                        if (token.length() > 0 && !token.equalsIgnoreCase("NULL")) {
                            try {
                                v = Double.parseDouble(token);
                            }
                            catch (Exception ex) {
                                v = -999999.0;
                            }
                        }
                        table.putDouble(row, col, v);
                    }
                    table.putInt(row, indexID, nextID++);
                }
                line = reader.readLine();
            }
            reader.close();
            return table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void mapColumns(ArrayList<UpholeMappingDialog.UpholeMappingRow> rowList, boolean importVelocity) {
        try {
            int n;
            int[] indexTime = new int[rowList.size()];
            int[] indexDepth = new int[rowList.size()];
            int[] indexVelocity = new int[rowList.size()];
            for (n = 0; n < rowList.size(); ++n) {
                indexTime[n] = this.m_table.column_append("Uphole_Time" + Integer.toString(n), DataType.Double);
                indexDepth[n] = this.m_table.column_append("Uphole_Depth" + Integer.toString(n), DataType.Double);
                if (!importVelocity) continue;
                indexVelocity[n] = this.m_table.column_append("Uphole_Velocity" + Integer.toString(n), DataType.Double);
            }
            for (n = 0; n < rowList.size(); ++n) {
                UpholeMappingDialog.UpholeMappingRow row = rowList.get(n);
                String timeString = row.TimeColumns.getSelectedString();
                String depthString = row.DepthColumns.getSelectedString();
                String velocityString = row.VelocityColumns.getSelectedString();
                int indexOldTime = this.m_table.column_indexOfColumn(timeString);
                int indexOldDepth = this.m_table.column_indexOfColumn(depthString);
                int indexOldVelocity = -1;
                if (importVelocity) {
                    indexOldVelocity = this.m_table.column_indexOfColumn(velocityString);
                }
                for (int r = 0; r < this.m_table.row_count(); ++r) {
                    double time = this.m_table.getDouble(r, indexOldTime);
                    double depth = this.m_table.getDouble(r, indexOldDepth);
                    double velocity = 0.0;
                    if (importVelocity) {
                        velocity = this.m_table.getDouble(r, indexOldVelocity);
                    }
                    this.m_table.putDouble(r, indexTime[n], time);
                    this.m_table.putDouble(r, indexDepth[n], depth);
                    if (!importVelocity) continue;
                    this.m_table.putDouble(r, indexVelocity[n], velocity);
                }
            }
            String projectPath = RefractionStaticsProject.singleton().projectPath();
            String upholePath = Tools_FileSystem.confirmSubDirectoryExists(projectPath, "Uphole");
            String fileNameDB = upholePath + "/uphole.db";
            this.m_databaseConnection = Tools_JDBC.getConnection(false, fileNameDB);
            for (int i = 0; i < rowList.size(); ++i) {
                this.m_databaseConnection.writeColumnContentsToDatabase(this.m_table, "Uphole_Time" + Integer.toString(i));
                this.m_databaseConnection.writeColumnContentsToDatabase(this.m_table, "Uphole_Depth" + Integer.toString(i));
                if (!importVelocity) continue;
                this.m_databaseConnection.writeColumnContentsToDatabase(this.m_table, "Uphole_Velocity" + Integer.toString(i));
            }
            this.m_databaseConnection.closeConnection();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int maxLayers() {
        return this.m_maxLayers;
    }

    public int getNumLayers(int row) throws Exception {
        int count = 0;
        for (int n = 0; n < this.m_maxLayers; ++n) {
            if (!(this.m_table.getDouble(row, this.m_timeColumns.get(n)) > 0.0)) continue;
            count = n + 1;
        }
        return count;
    }

    public double getX(int row) throws Exception {
        return this.m_table.getDouble(row, this.m_indexX);
    }

    public double getY(int row) throws Exception {
        return this.m_table.getDouble(row, this.m_indexY);
    }

    public double getZ(int row) throws Exception {
        return this.m_table.getDouble(row, this.m_indexZ);
    }

    public double getTime(int row, int index) throws Exception {
        return this.m_table.getDouble(row, this.m_timeColumns.get(index));
    }

    public double getDepth(int row, int index) throws Exception {
        return this.m_table.getDouble(row, this.m_depthColumns.get(index));
    }

    public double getVelocity(int row, int index) throws Exception {
        return this.m_table.getDouble(row, this.m_velColumns.get(index));
    }

    public int getRowCount() {
        return this.m_table.row_count();
    }

    public double getMaxDepth() throws Exception {
        double dMaxDepth = 0.0;
        try {
            if (this._dMaxDepthCalculated > 0.0) {
                return this._dMaxDepthCalculated;
            }
            int nRows = this.getRowCount();
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int nVals = this.getNumLayers(iRow);
                for (int iVal = 0; iVal < nVals; ++iVal) {
                    double dDepth = this.getDepth(iRow, iVal);
                    if (!(dDepth > dMaxDepth)) continue;
                    dMaxDepth = dDepth;
                }
            }
            this._dMaxDepthCalculated = dMaxDepth;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
        return dMaxDepth;
    }

    public void interpolateVelocities(double dDepthDigi, double dMaxDepth) throws Exception {
        try {
            if (dMaxDepth <= 0.0) {
                throw new Exception("invalid uphole model max depth = " + Double.toString(dMaxDepth));
            }
            if (dDepthDigi <= 0.0) {
                throw new Exception("invalid depth digi : " + Double.toString(dDepthDigi));
            }
            this.m_nInterpolatedDepthArraySize = (int)(dMaxDepth / dDepthDigi + 1.0);
            this.m_dInterpolationdDepthDigi = dDepthDigi;
            int nRows = this.getRowCount();
            if (nRows <= 0) {
                throw new Exception("no data in uphole survey");
            }
            this.m_interpolatedVels = new float[nRows][this.m_nInterpolatedDepthArraySize];
            for (int iRow = 0; iRow < nRows; ++iRow) {
                int nVals = this.getNumLayers(iRow);
                double dPreviousTime = 0.0;
                double dPreviousDepth = 0.0;
                float fPreviousVel = 0.0f;
                double dDepth = 0.0;
                int iInterplatedVelSample = 0;
                for (int iVal = 0; iVal < nVals; ++iVal) {
                    double dUpholeTime = this.getTime(iRow, iVal);
                    double dUpholeDepth = this.getDepth(iRow, iVal);
                    float fVel = 0.0f;
                    fVel = (float)(1000.0 * (dUpholeDepth - dPreviousDepth) / (dUpholeTime - dPreviousTime));
                    if (fVel > 20000.0f) {
                        boolean bl = false;
                    }
                    if (iVal > 0 && fVel < fPreviousVel) {
                        this.m_bContainsVelocityInversions = true;
                    }
                    while (dDepth <= dUpholeDepth && iInterplatedVelSample < this.m_nInterpolatedDepthArraySize) {
                        this.m_interpolatedVels[iRow][iInterplatedVelSample] = fVel;
                        dDepth += this.m_dInterpolationdDepthDigi;
                        ++iInterplatedVelSample;
                    }
                    dPreviousTime = dUpholeTime;
                    dPreviousDepth = dUpholeDepth;
                    fPreviousVel = fVel;
                }
                for (int iSample = iInterplatedVelSample; iSample < this.m_nInterpolatedDepthArraySize; ++iSample) {
                    this.m_interpolatedVels[iRow][iSample] = fPreviousVel;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double getInterpolationMaxDepth() {
        return this.m_dInterpolationMaxDepth;
    }

    public double getInterpolationDepthDigi() {
        return this.m_dInterpolationdDepthDigi;
    }

    public double getSurfaceElevation(double x, double y) throws Exception {
        try {
            double elev = 0.0;
            return elev;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double getInterpolatedMaxDepth(double x, double y) throws Exception {
        try {
            double dMaxDepth = 0.0;
            int nRows = this.getRowCount();
            if (nRows <= 0) {
                throw new Exception("no data in uphole survey");
            }
            double dSumWeight = 0.0;
            double dCount = 0.0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                double dRowElev = this.getZ(iRow);
                double dRowX = this.getX(iRow);
                double dRowY = this.getY(iRow);
                double dx = dRowX - x;
                double dy = dRowY - y;
                double distSquared = dx * dx + dy * dy + 0.001;
                double dWeight = 1.0 / distSquared;
                int nVels = this.getNumLayers(iRow);
                if (nVels <= 0) continue;
                double depth = this.getDepth(iRow, nVels - 1);
                dSumWeight += depth * dWeight;
                dCount += dWeight;
            }
            dMaxDepth = dSumWeight / dCount;
            return dMaxDepth;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void getInterpolatedVelocity(double x, double y, double dSurfaceElevation, float[] fDepths, float[] fVelsAtDepth) throws Exception {
        try {
            if (this.m_interpolatedVels == null) {
                throw new Exception("interpolateVelocities needs to be called first");
            }
            if (fDepths == null || fVelsAtDepth == null) {
                throw new Exception("null depths or vels");
            }
            if (fDepths.length != fVelsAtDepth.length) {
                throw new Exception("depths / vels array lengths differ");
            }
            int nRows = this.getRowCount();
            if (nRows <= 0) {
                throw new Exception("no data in uphole survey");
            }
            int nDepthsOutput = fDepths.length;
            for (int iOutput = 0; iOutput < nDepthsOutput; ++iOutput) {
                double dSumWeight = 0.0;
                double dCount = 0.0;
                double dOutputElev = dSurfaceElevation - (double)fDepths[iOutput];
                for (int iRow = 0; iRow < nRows; ++iRow) {
                    double dSample;
                    int iSample;
                    double dRowElev = this.getZ(iRow);
                    double dRowX = this.getX(iRow);
                    double dRowY = this.getY(iRow);
                    double dx = dRowX - x;
                    double dy = dRowY - y;
                    double distSquared = dx * dx + dy * dy + 0.001;
                    double dDepth = dRowElev - dOutputElev;
                    if (dDepth < 0.0) {
                        dDepth = 0.0;
                    }
                    if ((iSample = (int)Math.round(dSample = dDepth / this.m_dInterpolationdDepthDigi)) >= this.m_nInterpolatedDepthArraySize) {
                        iSample = this.m_nInterpolatedDepthArraySize - 1;
                    }
                    float fVel = this.m_interpolatedVels[iRow][iSample];
                    double dWeight = 1.0 / distSquared;
                    dSumWeight += (double)fVel * dWeight;
                    dCount += dWeight;
                }
                double dVel = dSumWeight / dCount;
                if (dCount == 0.0) {
                    boolean bl = false;
                }
                fVelsAtDepth[iOutput] = (float)dVel;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public boolean getContainsVelocityInversions() {
        return this.m_bContainsVelocityInversions;
    }

    public String name() throws Exception {
        return this.m_table.name();
    }

    public Table_Abstract getTable() {
        try {
            return this.m_table;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public IDatabaseConnection getDBConnection() {
        return this.m_databaseConnection;
    }

    public void createTestData() throws Exception {
        this.m_maxLayers = 2;
        this.m_timeColumns.add(this.m_table.column_append("Time" + Integer.toString(1), DataType.Double));
        this.m_depthColumns.add(this.m_table.column_append("Depth" + Integer.toString(1), DataType.Double));
        this.m_velColumns.add(this.m_table.column_append("Velocity" + Integer.toString(1), DataType.Double));
        int iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2182500.51);
        this.m_table.putDouble(iRow, this.m_indexY, 720000.32);
        this.m_table.putDouble(iRow, this.m_indexZ, 109.98);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 49.19);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 97.79);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 125.43);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 260.54);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2188000.27);
        this.m_table.putDouble(iRow, this.m_indexY, 718500.83);
        this.m_table.putDouble(iRow, this.m_indexZ, 102.09);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 47.16);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 96.19);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 120.74);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 256.54);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2193000.12);
        this.m_table.putDouble(iRow, this.m_indexY, 718700.01);
        this.m_table.putDouble(iRow, this.m_indexZ, 92.61);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 51.0);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 103.27);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 126.47);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 270.76);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2188300.21);
        this.m_table.putDouble(iRow, this.m_indexY, 714400.78);
        this.m_table.putDouble(iRow, this.m_indexZ, 95.4);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 46.43);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 93.98);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 125.36);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 260.87);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2188600.04);
        this.m_table.putDouble(iRow, this.m_indexY, 714450.53);
        this.m_table.putDouble(iRow, this.m_indexZ, 95.15);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 47.58);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 94.83);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 126.09);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 257.43);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2192600.43);
        this.m_table.putDouble(iRow, this.m_indexY, 714100.32);
        this.m_table.putDouble(iRow, this.m_indexZ, 90.76);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 47.83);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 96.1);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 120.76);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 252.56);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2183000.34);
        this.m_table.putDouble(iRow, this.m_indexY, 707300.76);
        this.m_table.putDouble(iRow, this.m_indexZ, 110.01);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 46.45);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 92.42);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 125.87);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 255.51);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2188400.38);
        this.m_table.putDouble(iRow, this.m_indexY, 707100.35);
        this.m_table.putDouble(iRow, this.m_indexZ, 92.63);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 48.68);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 95.73);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 129.49);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 260.75);
        iRow = this.m_table.row_increment();
        this.m_table.putDouble(iRow, this.m_indexX, 2192000.84);
        this.m_table.putDouble(iRow, this.m_indexY, 707000.32);
        this.m_table.putDouble(iRow, this.m_indexZ, 89.92);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(0), 46.61);
        this.m_table.putDouble(iRow, this.m_timeColumns.get(1), 92.56);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(0), 123.52);
        this.m_table.putDouble(iRow, this.m_depthColumns.get(1), 250.34);
    }

    public boolean mapped() {
        try {
            return this.m_table.column_exists("Uphole_Time0") && this.m_table.column_exists("Uphole_Depth0");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }
}

