/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Tools_StrangeEnsembles {
    public static void innerOffsetsWithinRadius(Ensemble ensemble, double x, double y, double radius, int maxTraces) {
        try {
            ensemble.clearTraces(false);
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            double radiusSquared = radius * radius;
            int numInArray = 0;
            long[] arrayTraceRow = new long[maxTraces];
            double[] arrayOffset = new double[maxTraces];
            ITraceTable traceTable = p.traceTableWrapper().traceTable();
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            Table_Abstract shotTable = p.shotTable();
            HashMap_Integer shotMap = p.shotMap();
            int colShotKilled = shotTable.column_indexOfColumn("Killed");
            int colShotX = shotTable.column_indexOfColumn("Easting");
            int colShotY = shotTable.column_indexOfColumn("Northing");
            Table_Abstract recTable = p.receiverTable();
            HashMap_Integer recMap = p.receiverMap();
            int colRecKilled = recTable.column_indexOfColumn("Killed");
            int colRecX = recTable.column_indexOfColumn("Easting");
            int colRecY = recTable.column_indexOfColumn("Northing");
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                double ry;
                double diffy;
                boolean killed;
                int shotID = traceTable.getInt(row, indexShotID);
                int shotRow = shotMap.get(shotID);
                int recID = traceTable.getInt(row, indexRecID);
                int recRow = recMap.get(recID);
                boolean bl = killed = shotTable.getBool(shotRow, colShotKilled) || recTable.getBool(recRow, colRecKilled);
                if (killed) continue;
                double sx = shotTable.getDouble(shotRow, colShotX);
                double sy = shotTable.getDouble(shotRow, colShotY);
                double rx = recTable.getDouble(recRow, colRecX);
                double diffx = 0.5 * (sx + rx) - x;
                double distSquared = diffx * diffx + (diffy = 0.5 * (sy + (ry = recTable.getDouble(recRow, colRecY))) - y) * diffy;
                if (!(distSquared < radiusSquared)) continue;
                double dx = rx - sx;
                double dy = ry - sy;
                double offset = Math.sqrt(dx * dx + dy * dy);
                if (numInArray < maxTraces) {
                    arrayTraceRow[numInArray] = row;
                    arrayOffset[numInArray] = offset;
                    ++numInArray;
                    continue;
                }
                int maxIndex = 0;
                double maxValue = 0.0;
                for (int n = 0; n < maxTraces; ++n) {
                    if (!(arrayOffset[n] > maxValue)) continue;
                    maxValue = arrayOffset[n];
                    maxIndex = n;
                }
                if (!(offset < maxValue)) continue;
                arrayOffset[maxIndex] = offset;
                arrayTraceRow[maxIndex] = row;
            }
            if (numInArray < 1) {
                return;
            }
            Column_Long indices = new Column_Long();
            for (int n = 0; n < numInArray; ++n) {
                indices.putLong(n, arrayTraceRow[n]);
            }
            traceTable.populateEnsemble(ensemble, indices, numInArray);
            p.prepGeometryHeaders(ensemble, true, true);
            p.populateData(ensemble, false, false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

