/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedReader;
import java.io.FileReader;

public class Tools_SpecialCases {
    public static void importAnadarko() {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            String fileName = "/Users/matt/Data/AnadarkoOkay/attachments/REFR33_receiver.txt";
            Tools_SpecialCases.importAnadarkoTable(fileName, project.receiverTable());
            fileName = "/Users/matt/Data/AnadarkoOkay/attachments/REFR33_source.txt";
            Tools_SpecialCases.importAnadarkoTable(fileName, project.shotTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void importAnadarkoTable(String fileName, Table_Abstract table) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            HashMap_Integer map = new HashMap_Integer();
            int indexPointNumber = table.column_indexOfColumn("PointNumber");
            for (int row = 0; row < table.row_count(); ++row) {
                int point = table.getInt(row, indexPointNumber);
                if (map.containsKey(point)) {
                    System.out.println("conflict " + point);
                }
                map.put(point, row);
            }
            int indexStatic = table.column_append("STATICS_REFR33", DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putDouble(row, indexStatic, -9999.0);
            }
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            while (line != null) {
                if (line.startsWith("<")) {
                    String pointString = line.substring(12, 20);
                    String staticString = line.substring(25, 35);
                    int point = Integer.parseInt(pointString);
                    double stat = Double.parseDouble(staticString);
                    if (map.containsKey(point)) {
                        int row = map.get(point);
                        table.putDouble(row, indexStatic, stat);
                    }
                }
                line = br.readLine();
            }
            project.geometryDatabase().writeColumnContentsToDatabase(table, "STATICS_REFR33");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

