/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.VNS;

import com.PecosLibrary.Refraction.Tomography.VNS.Tomo_VNS;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;

public class TomoVNS_PolygonEdit {
    protected int m_numX = 0;
    protected int m_numY = 0;
    protected int m_numZ = 0;
    protected float[][][] m_slowness;
    protected float[][][] m_countTemp;
    protected float[][][] m_slownessTemp;
    protected float[][][] m_count;
    protected float m_minValidCount = 10.0f;
    protected float m_averageCount = 9.0f;
    protected boolean[][] m_insidePolygon;
    protected int m_numNotSet = -9999;

    protected void update_layer(boolean[][] updated, float[][] layer) {
        try {
            int radius = 2;
            boolean[][] currok = new boolean[this.m_numX][this.m_numY];
            while (true) {
                int iy;
                int ix;
                int num_not_OK = 0;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        currok[ix][iy] = updated[ix][iy];
                    }
                }
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        if (updated[ix][iy]) continue;
                        ++num_not_OK;
                        int minx = Math.max(ix - 1, 0);
                        int maxx = Math.min(ix + 1, this.m_numX - 1);
                        int miny = Math.max(iy - 1, 0);
                        int maxy = Math.min(iy + 1, this.m_numY - 1);
                        int numok = 0;
                        for (int x = minx; x <= maxx; ++x) {
                            for (int y = miny; y <= maxy; ++y) {
                                if (!currok[x][y]) continue;
                                ++numok;
                            }
                        }
                        if (numok <= 0) continue;
                        updated[ix][iy] = true;
                        float sum1 = 0.0f;
                        float sum2 = 1.0E-20f;
                        minx = Math.max(ix - radius, 0);
                        maxx = Math.min(ix + radius, this.m_numX - 1);
                        miny = Math.max(iy - radius, 0);
                        maxy = Math.min(iy + radius, this.m_numY - 1);
                        for (int x = minx; x <= maxx; ++x) {
                            float wx = 1.0f / (1.0f + (float)Math.abs(ix - x));
                            for (int y = miny; y <= maxy; ++y) {
                                float wy = 1.0f / (1.0f + (float)Math.abs(iy - y));
                                if (!currok[x][y]) continue;
                                float w = wx * wx * wy * wy;
                                sum1 += w * layer[x][y];
                                sum2 += w;
                            }
                        }
                        layer[ix][iy] = sum1 / sum2;
                    }
                }
                if (num_not_OK < 1) {
                    return;
                }
                ++radius;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
            return;
        }
    }

    public void extrapolate_outside(float[][][] arr) {
        try {
            boolean[][] updated = new boolean[this.m_numX][this.m_numY];
            float[][] layer = new float[this.m_numX][this.m_numY];
            for (int iz = 0; iz < this.m_numZ; ++iz) {
                int iy;
                int ix;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        updated[ix][iy] = this.m_insidePolygon[ix][iy];
                        layer[ix][iy] = arr[ix][iy][iz];
                    }
                }
                this.update_layer(updated, layer);
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        arr[ix][iy][iz] = layer[ix][iy];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void interpolate_inside(float[][][] arr) {
        try {
            boolean[][] updated = new boolean[this.m_numX][this.m_numY];
            float[][] layer = new float[this.m_numX][this.m_numY];
            for (int iz = 0; iz < this.m_numZ; ++iz) {
                int iy;
                int ix;
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        updated[ix][iy] = !this.m_insidePolygon[ix][iy];
                        layer[ix][iy] = arr[ix][iy][iz];
                    }
                }
                this.update_layer(updated, layer);
                for (ix = 0; ix < this.m_numX; ++ix) {
                    for (iy = 0; iy < this.m_numY; ++iy) {
                        arr[ix][iy][iz] = layer[ix][iy];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void prepare(Java2D_Polygon p, Tomo_VNS tomo) {
        try {
            int iy;
            int ix;
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            this.m_insidePolygon = new boolean[this.m_numX][this.m_numY];
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    tomo.setGridLocation(ix, iy);
                    this.m_insidePolygon[ix][iy] = p.contains(tomo.WorldX, tomo.WorldY);
                }
            }
            this.m_slowness = this.clone3(tomo.slowness());
            this.m_countTemp = this.clone3(tomo.weight());
            this.m_slownessTemp = this.clone3(tomo.error());
            this.m_count = this.clone3(tomo.count());
            for (ix = 0; ix < this.m_numX; ++ix) {
                for (iy = 0; iy < this.m_numY; ++iy) {
                    int iz;
                    if (this.m_insidePolygon[ix][iy]) {
                        for (iz = 0; iz < this.m_numZ; ++iz) {
                            this.m_slownessTemp[ix][iy][iz] = 0.0f;
                            this.m_count[ix][iy][iz] = 0.0f;
                            this.m_countTemp[ix][iy][iz] = 0.0f;
                        }
                        continue;
                    }
                    for (iz = 0; iz < this.m_numZ; ++iz) {
                        this.m_slownessTemp[ix][iy][iz] = 20.0f;
                        this.m_count[ix][iy][iz] = 20.0f;
                        this.m_countTemp[ix][iy][iz] = 20.0f;
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void finishedPolygon(Tomo_VNS tomo) {
        try {
            this.m_numX = tomo.numX();
            this.m_numY = tomo.numY();
            this.m_numZ = tomo.numZ();
            float[][][] slowness = tomo.slowness();
            for (int ix = 0; ix < this.m_numX; ++ix) {
                for (int iy = 0; iy < this.m_numY; ++iy) {
                    for (int iz = 0; iz < this.m_numZ; ++iz) {
                        slowness[ix][iy][iz] = this.m_slowness[ix][iy][iz];
                    }
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected float[][] clone2(float[][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            float[][] c = new float[nx][ny];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    c[x][y] = arr[x][y];
                }
            }
            return arr;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected float[][][] clone3(float[][][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            int nz = arr[0][0].length;
            float[][][] c = new float[nx][ny][nz];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        c[x][y][z] = arr[x][y][z];
                    }
                }
            }
            return c;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }

    protected double[][][] clone3(double[][][] arr) {
        try {
            int nx = arr.length;
            int ny = arr[0].length;
            int nz = arr[0][0].length;
            double[][][] c = new double[nx][ny][nz];
            for (int x = 0; x < nx; ++x) {
                for (int y = 0; y < ny; ++y) {
                    for (int z = 0; z < nz; ++z) {
                        c[x][y][z] = arr[x][y][z];
                    }
                }
            }
            return c;
        }
        catch (Exception error) {
            error.printStackTrace();
            return null;
        }
    }
}

