/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.Tomography.InteractiveModel;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.Tomography.InteractiveModel.TomoInteractiveModel_DelayTime;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class TomoInteractiveModel_PickCollection
implements Java2D_PaintableInterface {
    protected ArrayList<TomoInteractiveModel_DelayTime> m_picks = new ArrayList();
    protected String m_fileName;
    protected TomoInteractiveModel_DelayTime m_current = null;
    protected double[] m_tempElevWeight = new double[2];
    protected ArrayList<TempData> m_tempData = new ArrayList();
    protected double m_tempDepth;
    protected double m_tempSize;
    public double[] TempProfile;
    public BasicStroke m_lineStroke = new BasicStroke(2.0f);

    public TomoInteractiveModel_DelayTime current() {
        return this.m_current;
    }

    public TomoInteractiveModel_PickCollection(String fileName) {
        try {
            this.m_fileName = fileName;
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int magic = file.readInt();
            if (magic != 6172888) {
                throw new Exception("wrong magic");
            }
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                for (int n = 0; n < count; ++n) {
                    this.m_picks.add(new TomoInteractiveModel_DelayTime(file));
                }
                file.close();
                return;
            }
            file.close();
            throw new Exception("Bad version");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return;
        }
    }

    public void clear() {
        try {
            this.m_picks.clear();
            this.m_current = null;
            this.save();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeClosest(int pixelX, int pixelY) {
        try {
            this.m_current = null;
            int minPixelDist = 3000;
            int nearest = -1;
            for (int n = 0; n < this.m_picks.size(); ++n) {
                TomoInteractiveModel_DelayTime location = this.m_picks.get(n);
                int dist = Math.abs(pixelX - location.BasemapPixelX) + Math.abs(pixelY - location.BasemapPixelY);
                if (dist >= minPixelDist) continue;
                minPixelDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                this.m_picks.remove(nearest);
            }
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeElevationProfile(double x, double y, double originZ, double zinc, double[] vel) {
        try {
            if (this.m_tempElevWeight.length != vel.length) {
                this.m_tempElevWeight = new double[vel.length];
            }
            for (int n = 0; n < vel.length; ++n) {
                vel[n] = 0.0;
                this.m_tempElevWeight[n] = 1.0E-50;
            }
            for (TempData td : this.m_tempData) {
                double dx = x - td.X;
                double dy = y - td.Y;
                double w = 10000.0 / (1.0 + dx * dx + dy * dy);
                for (int n = 0; n < vel.length; ++n) {
                    double z = originZ + zinc * (double)n;
                    double depth = td.Z - z;
                    int index = (int)(depth / this.m_tempSize);
                    index = Math.max(0, index);
                    index = Math.min(index, td.Velocity.length - 1);
                    vel[n] = vel[n] + w * td.Velocity[index];
                    this.m_tempElevWeight[n] = this.m_tempElevWeight[n] + w;
                }
            }
            for (int n = 0; n < vel.length; ++n) {
                vel[n] = vel[n] / this.m_tempElevWeight[n];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeInterpolatedProfile(double x, double y) {
        try {
            double sumWeight = 1.0E-60;
            for (int n = 0; n < this.TempProfile.length; ++n) {
                this.TempProfile[n] = 0.0;
            }
            for (TempData td : this.m_tempData) {
                double dx = x - td.X;
                double dy = y - td.Y;
                double dist = Math.sqrt(1.0 + dx * dx + dy * dy);
                double temp = 1000.0 + dist;
                double w = 10000.0 / (temp * temp);
                sumWeight += w;
                for (int n = 0; n < this.TempProfile.length; ++n) {
                    this.TempProfile[n] = this.TempProfile[n] + w * td.Velocity[n];
                }
            }
            for (int n = 0; n < this.TempProfile.length; ++n) {
                this.TempProfile[n] = this.TempProfile[n] / sumWeight;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public double tempSize() {
        return this.m_tempSize;
    }

    public void prepTempData(double depth, double size) {
        try {
            this.m_tempSize = size;
            this.m_tempDepth = depth;
            this.m_tempData.clear();
            int num = (int)(depth / size);
            double[] flipped = new double[10];
            this.TempProfile = new double[num];
            for (TomoInteractiveModel_DelayTime p : this.m_picks) {
                if (p.numValidPicks() < 1) continue;
                p.computeDelayTimeModel();
                if (!p.modelValid()) continue;
                p.computeLinearSegments();
                TempData td = new TempData();
                td.X = p.WorldX;
                td.Y = p.WorldY;
                td.Z = p.WorldZ;
                td.Velocity = new double[num];
                for (int n = 0; n < num; ++n) {
                    double d = (double)n * this.m_tempSize;
                    td.Velocity[n] = p.getVelocityFromDepth_LinearSegments(d);
                }
                this.m_tempData.add(td);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save() {
        try {
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int magic = 6172888;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_picks.size());
                for (TomoInteractiveModel_DelayTime p : this.m_picks) {
                    p.save(file);
                }
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void recomputeAllVelocityProfiles() {
        try {
            for (TomoInteractiveModel_DelayTime p : this.m_picks) {
                p.computeDelayTimeModel();
                p.computeLinearSegments();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int numValid() {
        try {
            int num = 0;
            for (TomoInteractiveModel_DelayTime p : this.m_picks) {
                if (p.numValidPicks() < 2) continue;
                ++num;
            }
            return num;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public void deleteUnpickedLocations() {
        try {
            this.m_current = null;
            for (int n = this.m_picks.size() - 1; n >= 0; --n) {
                TomoInteractiveModel_DelayTime p = this.m_picks.get(n);
                if (p.numValidPicks() >= 2) continue;
                this.m_picks.remove(n);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setCurrent(double x, double y, double z, double minDistance) {
        try {
            this.deleteUnpickedLocations();
            int nearest = -9999;
            double minDist = 1000000.0;
            for (int n = 0; n < this.m_picks.size(); ++n) {
                TomoInteractiveModel_DelayTime p = this.m_picks.get(n);
                double dx = x - p.WorldX;
                double dy = y - p.WorldY;
                double dist = Math.sqrt(dx * dx + dy * dy);
                if (!(dist < minDistance) || !(dist < minDist)) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                this.m_current = this.m_picks.get(nearest);
                return;
            }
            this.m_current = new TomoInteractiveModel_DelayTime();
            this.m_current.WorldX = x;
            this.m_current.WorldY = y;
            this.m_current.WorldZ = z;
            this.m_picks.add(this.m_current);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.m_lineStroke);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int dotSize = 15;
            int half = dotSize / 2;
            g2d.setColor(Color.green);
            for (TomoInteractiveModel_DelayTime p : this.m_picks) {
                p.BasemapPixelX = (int)(scaleX * p.WorldX + shiftX);
                p.BasemapPixelY = (int)(scaleY * p.WorldY + shiftY);
                g2d.fillOval(p.BasemapPixelX - half, p.BasemapPixelY - half, dotSize, dotSize);
            }
            if (this.m_current != null) {
                g2d.setColor(Color.red);
                this.m_current.BasemapPixelX = (int)(scaleX * this.m_current.WorldX + shiftX);
                this.m_current.BasemapPixelY = (int)(scaleY * this.m_current.WorldY + shiftY);
                g2d.drawOval(this.m_current.BasemapPixelX - half, this.m_current.BasemapPixelY - half, dotSize, dotSize);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public class TempData {
        public double X;
        public double Y;
        public double Z;
        public double[] Velocity;
    }
}

