/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosLibrary.Refraction.DelayTime.BranchAssignment;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeModel;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentDialog;
import com.PecosLibrary.Windows.Refraction.DelayTime.BranchAssignmentWidget;
import com.PecosLibrary.Windows.Refraction.Picking.PickCopyDialog;
import com.PecosLibrary.Windows.Shared.VerboseOptionDialog;

public class RefractionProjectSuggestions {
    public static boolean On = true;
    protected static RefractionProjectSuggestions m_singleton = null;
    protected HtmlBuilder m_html = new HtmlBuilder();

    protected RefractionProjectSuggestions() {
        try {
            On = SharedApplicationData.singleton().getParameterTree().bool_get("ShowSuggestions", true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static RefractionProjectSuggestions singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new RefractionProjectSuggestions();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void firstTimeSegyRun() {
    }

    public void branchModified() {
        try {
            if (!On) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            if (maxbranch < 1) {
                return;
            }
            VerboseOptionDialog.OptionList list = new VerboseOptionDialog.OptionList();
            String dtText = "Execute standard delay time analysis sequence";
            String cancelText = "Not now";
            String desc = "<html>Branches have just been modified, <br> so you might want to perform delay time analysis.</html>";
            list.add("Delay time analysis", desc, dtText);
            list.add("", null, cancelText);
            String prelimText = null;
            VerboseOptionDialog dlg = new VerboseOptionDialog(prelimText, null, "Delay time analysis", list);
            if (dlg.SelectedButtonText.equalsIgnoreCase(dtText)) {
                DelayTimeModel.singleton().launchStandardSequence();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void userPicksModified() {
        try {
            if (!On) {
                return;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BranchAssignment ba = project.delayTimeData().branchAssignment();
            int maxbranch = ba.maxBranch();
            VerboseOptionDialog.OptionList list = new VerboseOptionDialog.OptionList();
            String branchText = "Open the branch assignment dialog";
            String dtText = "Execute standard delay time analysis sequence";
            String cancelText = "Not now";
            String desc = "<html>Before performing delay time analysis you must assign branches</html>";
            if (maxbranch >= 1) {
                desc = "<html>You have already done branch assignment. <br> However, you may want to consider reassigning branches using the new picks</html>";
            }
            list.add("Branch assignment", desc, branchText);
            if (maxbranch >= 1) {
                desc = "<html>Branches have already been defined, so you might want to perform delay time analysis.</html>";
                list.add("Delay time analysis", desc, dtText);
            }
            list.add("", null, cancelText);
            String prelimText = "<html>The user first break picks (FBP_User) have just been modified.</html>";
            VerboseOptionDialog dlg = new VerboseOptionDialog(prelimText, null, "Delay time analysis", list);
            if (dlg.SelectedButtonText.equalsIgnoreCase(branchText)) {
                BranchAssignmentDialog branchAssignmentDialog = new BranchAssignmentDialog(BranchAssignmentWidget.PlotType.Picks, false);
            }
            if (dlg.SelectedButtonText.equalsIgnoreCase(dtText)) {
                DelayTimeModel.singleton().launchStandardSequence();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void autopickSuggestion(String pickName) {
        try {
            if (!On) {
                return;
            }
            VerboseOptionDialog.OptionList list = new VerboseOptionDialog.OptionList();
            String openText = "Open pick copy dialog";
            String cancelText = "Not now";
            String desc = String.format("<html>The auto picks (%s) must be copied to user picks (FBP_User)<br> before they can be used in any analysis</html>", pickName);
            list.add("Copy auto picks to user picks", desc, openText);
            list.add("", null, cancelText);
            VerboseOptionDialog dlg = new VerboseOptionDialog(null, null, "Copy auto picks", list);
            if (dlg.SelectedButtonText.equalsIgnoreCase(openText)) {
                PickCopyDialog pickCopyDialog = PickCopyDialog.singleton();
                pickCopyDialog.showDialog(pickName);
                if (pickCopyDialog.OK) {
                    Messenger.broadcast(Messenger.Message.PicksChanged, null, null);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected class HtmlBuilder {
        protected String m_html = "<html></html>";
        protected boolean m_done = true;

        protected HtmlBuilder() {
        }

        public void reset() {
            this.m_html = "<html>";
            this.m_done = false;
        }

        public String done() {
            if (this.m_done) {
                this.reset();
            }
            this.m_html = this.m_html + "</html>";
            this.m_done = true;
            return this.m_html;
        }

        public String addLine(String s, boolean finish) {
            try {
                if (this.m_done) {
                    this.reset();
                }
                this.m_html = this.m_html + s + "<br>";
                if (finish) {
                    return this.done();
                }
                return "INCOMPLETE";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "ERROR";
            }
        }
    }
}

