/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.GLI;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_PickCollection;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_SingleLocation;
import com.PecosLibrary.Refraction.GLI.GliProfile;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class GliModel {
    private boolean Initialized = false;
    private int model_layerCount;
    private int modelGridCountX;
    private int modelGridCountY;
    private int interpRadiusElevation = 1;
    private int interpRadiusVelocity = 16;
    private double depthErrorTotal;
    private double velocityErrorTotal;
    private long depthHitCount;
    private long velocityHitCount;
    private String m_name;
    private String m_gridFileName;
    private RefractionStaticsProject m_project = RefractionStaticsProject.singleton();
    private Table_Abstract m_shotTable = RefractionStaticsProject.singleton().shotTable();
    private Table_Abstract m_receiverTable = RefractionStaticsProject.singleton().receiverTable();
    private HashMap_Integer m_shotMap = RefractionStaticsProject.singleton().shotMap();
    private HashMap_Integer m_receiverMap = RefractionStaticsProject.singleton().receiverMap();
    private TraceTable_Huge m_tempTraceTable;
    private TraceTable_Huge_Wrapper m_tempTraceTableWrapper;
    private String m_gliDirectory;
    private String m_tempTraceTablePath;
    private Ensemble m_ensemble = new Ensemble();
    private ArrayList<Grid3D> elevationGrid;
    private ArrayList<Grid3D> velocityGrid;
    private Grid3D deltaElevation;
    private Grid3D deltaVelocity;
    private Grid3D deltaElevNum;
    private Grid3D deltaElevDenom;
    private int[][] elevCount;
    private float[][] ray_shotT;
    private float[][] ray_receiverT;
    private float[][] ray_shotHD;
    private float[][] ray_receiverHD;
    private int index_shotRow;
    private int index_shotID;
    private int index_shotX;
    private int index_shotY;
    private int index_receiverRow;
    private int index_receiverID;
    private int index_receiverX;
    private int index_receiverY;
    private int index_shotKilled;
    private int index_receiverKilled;
    private int index_shotElevation;
    private int index_receiverElevation;
    private int index_tempTraceIndex;
    private int index_tempTraceKilled;
    private int index_tempTraceMidX;
    private int index_tempTraceMidY;
    private int index_tempTraceShotRow;
    private int index_tempTraceReceiverRow;
    private int index_tempTraceFBP;
    private int index_tempTraceOffset;
    private int index_tempTraceAzimuth;
    private int index_tempTraceChangeFactorShot;
    private int index_tempTraceChangeFactorReceiver;
    private int index_tempTraceResidual;
    private int index_tempTraceProduct;
    private int index_tempTraceError;
    private int current_shotID;
    private double current_shotWorldX;
    private double current_shotWorldY;
    private int current_shotGridX;
    private int current_shotGridY;
    private int current_receiverID;
    private double current_receiverWorldX;
    private double current_receiverWorldY;
    private int current_receiverGridX;
    private int current_receiverGridY;
    private double current_traceOffset;
    private float current_traceFBP;
    private double depth_rSq;
    private double depth_tSq;
    private double depth_alpha;
    private double depth_beta;
    private double[][] depth_basisVector;
    private double[][] depth_residualVector;
    private double[][] depth_nextResidual;
    private int[] m_headerIndex = new int[50];
    private DataType[] m_headerType = new DataType[50];
    private boolean[] m_headerDoubleType = new boolean[50];
    private double m_traceErrorSum;
    private long m_traceErrorCount;
    private int[] m_layerHitCountElev;
    private int[] m_layerHitCountVel;
    int hitCount;

    public GliModel() {
        try {
            this.m_gliDirectory = Tools_FileSystem.confirmSubDirectoryExists(RefractionStaticsProject.singleton().projectPath(), "GLI");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createTempTraceTable() {
        try {
            Table_Memory tempTraceTable = new Table_Memory();
            ITraceTable fullTraceTable = RefractionStaticsProject.singleton().traceTableWrapper().traceTable();
            String tempDirectory = Tools_FileSystem.confirmSubDirectoryExists(this.m_gliDirectory, "Temp");
            String oldTempTablePath = tempDirectory + "/Trace";
            Tools_FileSystem.deletePathIfExists(oldTempTablePath);
            this.m_tempTraceTablePath = Tools_FileSystem.confirmSubDirectoryExists(tempDirectory, "Trace");
            this.index_tempTraceIndex = ((Table_Abstract)tempTraceTable).column_append("TraceTableIndex", DataType.Int);
            this.index_tempTraceKilled = ((Table_Abstract)tempTraceTable).column_append("Killed", DataType.Int);
            this.index_tempTraceMidX = ((Table_Abstract)tempTraceTable).column_append("CdpX", DataType.Int);
            this.index_tempTraceMidY = ((Table_Abstract)tempTraceTable).column_append("CdpY", DataType.Int);
            this.index_tempTraceShotRow = ((Table_Abstract)tempTraceTable).column_append("ShotRow", DataType.Int);
            this.index_tempTraceReceiverRow = ((Table_Abstract)tempTraceTable).column_append("ReceiverRow", DataType.Int);
            this.index_tempTraceFBP = ((Table_Abstract)tempTraceTable).column_append("FBP_User", DataType.Float);
            this.index_tempTraceOffset = ((Table_Abstract)tempTraceTable).column_append("Offset", DataType.Float);
            this.index_tempTraceAzimuth = ((Table_Abstract)tempTraceTable).column_append("Azimuth", DataType.Float);
            this.index_tempTraceChangeFactorShot = ((Table_Abstract)tempTraceTable).column_append("GliChangeFactorShot", DataType.Float);
            this.index_tempTraceChangeFactorReceiver = ((Table_Abstract)tempTraceTable).column_append("GliChangeFactorReceiver", DataType.Float);
            this.index_tempTraceProduct = ((Table_Abstract)tempTraceTable).column_append("GliProduct", DataType.Float);
            this.index_tempTraceResidual = ((Table_Abstract)tempTraceTable).column_append("GliResidual", DataType.Float);
            this.index_tempTraceError = ((Table_Abstract)tempTraceTable).column_append("Error", DataType.Float);
            this.m_tempTraceTable = new TraceTable_Huge(this.m_tempTraceTablePath, "Trace", tempTraceTable, 4);
            int indexKilled = -9999;
            if (fullTraceTable.column_exists("Killed")) {
                indexKilled = fullTraceTable.column_indexOfColumn("Killed");
            }
            int indexFBP = -9999;
            if (fullTraceTable.column_exists("FBP_User")) {
                indexFBP = fullTraceTable.column_indexOfColumn("FBP_User");
            }
            int indexShotID = fullTraceTable.column_indexOfColumn("ShotID");
            int indexReceiverID = fullTraceTable.column_indexOfColumn("ReceiverID");
            for (long row = 0L; row < fullTraceTable.rowCount(); ++row) {
                boolean addOkay;
                float fbp;
                int shotID = fullTraceTable.getInt(row, indexShotID);
                int receiverID = fullTraceTable.getInt(row, indexReceiverID);
                int shotRow = this.m_shotMap.get(shotID);
                int receiverRow = this.m_receiverMap.get(receiverID);
                boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
                boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
                boolean traceKilled = false;
                if (indexKilled >= 0) {
                    traceKilled = fullTraceTable.getInt(row, indexKilled) != 0;
                }
                int killed = 0;
                if (shotKilled) {
                    ++killed;
                }
                if (receiverKilled) {
                    ++killed;
                }
                if (traceKilled) {
                    ++killed;
                }
                double shotX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
                double shotY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
                double receiverX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
                double receiverY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
                double midX = (shotX + receiverX) / 2.0;
                double midY = (shotY + receiverY) / 2.0;
                double distanceX = receiverX - shotX;
                double distanceY = receiverY - shotY;
                double offset = Math.sqrt(distanceX * distanceX + distanceY * distanceY + 1.0E-24);
                double azimuth = 0.0;
                if (offset > 1.0E-5) {
                    azimuth = Math.atan2(distanceX, distanceY);
                }
                if ((fbp = fullTraceTable.getFloat(row, indexFBP)) < 0.0f) {
                    fbp = -9999.0f;
                }
                if (!(addOkay = true)) continue;
                int currentRow = ((Table_Abstract)tempTraceTable).row_increment();
                ((Table_Abstract)tempTraceTable).putLong(currentRow, this.index_tempTraceIndex, row);
                ((Table_Abstract)tempTraceTable).putInt(currentRow, this.index_tempTraceKilled, killed);
                ((Table_Abstract)tempTraceTable).putInt(currentRow, this.index_tempTraceMidX, (int)midX);
                ((Table_Abstract)tempTraceTable).putInt(currentRow, this.index_tempTraceMidY, (int)midY);
                ((Table_Abstract)tempTraceTable).putInt(currentRow, this.index_tempTraceShotRow, shotRow);
                ((Table_Abstract)tempTraceTable).putInt(currentRow, this.index_tempTraceReceiverRow, receiverRow);
                ((Table_Abstract)tempTraceTable).putFloat(currentRow, this.index_tempTraceOffset, (float)offset);
                ((Table_Abstract)tempTraceTable).putFloat(currentRow, this.index_tempTraceAzimuth, (float)azimuth);
                ((Table_Abstract)tempTraceTable).putFloat(currentRow, this.index_tempTraceFBP, fbp);
                if (((Table_Abstract)tempTraceTable).row_count() <= 50000) continue;
                this.m_tempTraceTable.appendTable(tempTraceTable);
                ((Table_Abstract)tempTraceTable).row_clear(false);
            }
            if (((Table_Abstract)tempTraceTable).row_count() > 0) {
                this.m_tempTraceTable.appendTable(tempTraceTable);
                ((Table_Abstract)tempTraceTable).row_clear(false);
            }
            this.m_tempTraceTable.finishedAppending(null);
            this.m_tempTraceTable = null;
            this.m_tempTraceTable = new TraceTable_Huge(this.m_tempTraceTablePath, "Trace");
            this.index_tempTraceIndex = this.m_tempTraceTable.column_indexOfColumn("TraceTableIndex");
            this.index_tempTraceMidX = this.m_tempTraceTable.column_indexOfColumn("CdpX");
            this.index_tempTraceMidY = this.m_tempTraceTable.column_indexOfColumn("CdpY");
            this.index_tempTraceShotRow = this.m_tempTraceTable.column_indexOfColumn("ShotRow");
            this.index_tempTraceReceiverRow = this.m_tempTraceTable.column_indexOfColumn("ReceiverRow");
            this.index_tempTraceOffset = this.m_tempTraceTable.column_indexOfColumn("Offset");
            this.index_tempTraceAzimuth = this.m_tempTraceTable.column_indexOfColumn("Azimuth");
            this.index_tempTraceChangeFactorShot = this.m_tempTraceTable.column_indexOfColumn("GliChangeFactorShot");
            this.index_tempTraceChangeFactorReceiver = this.m_tempTraceTable.column_indexOfColumn("GliChangeFactorReceiver");
            this.index_tempTraceProduct = this.m_tempTraceTable.column_indexOfColumn("GliProduct");
            this.index_tempTraceResidual = this.m_tempTraceTable.column_indexOfColumn("GliResidual");
            this.index_tempTraceFBP = this.m_tempTraceTable.column_indexOfColumn("FBP_User");
            this.index_tempTraceError = this.m_tempTraceTable.column_indexOfColumn("Error");
            this.m_tempTraceTableWrapper = new TraceTable_Huge_Wrapper(this.m_tempTraceTablePath);
            long l = this.m_tempTraceTable.rowCount();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepModel(int layers, float[] velocities, float[] depths) {
        try {
            int y;
            int x;
            int n;
            this.model_layerCount = layers;
            if (depths.length != this.model_layerCount) {
                return;
            }
            if (velocities.length != this.model_layerCount + 1) {
                return;
            }
            this.elevationGrid = new ArrayList();
            this.velocityGrid = new ArrayList();
            for (n = 0; n <= this.model_layerCount; ++n) {
                this.elevationGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
                this.velocityGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
            }
            this.deltaElevation = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.deltaVelocity = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.ray_shotT = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
            this.ray_shotHD = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
            this.ray_receiverT = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
            this.ray_receiverHD = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
            this.modelGridCountX = this.elevationGrid.get(0).numInline();
            this.modelGridCountY = this.elevationGrid.get(0).numCrossline();
            this.deltaElevNum = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.deltaElevDenom = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.elevCount = new int[this.modelGridCountX][this.modelGridCountY];
            this.depth_basisVector = new double[this.modelGridCountX][this.modelGridCountY];
            this.depth_residualVector = new double[this.modelGridCountX][this.modelGridCountY];
            this.depth_nextResidual = new double[this.modelGridCountX][this.modelGridCountY];
            this.m_layerHitCountElev = new int[this.model_layerCount + 1];
            this.m_layerHitCountVel = new int[this.model_layerCount + 1];
            this.interpolateElevation();
            for (n = 0; n < velocities.length; ++n) {
                for (x = 0; x < this.modelGridCountX; ++x) {
                    for (y = 0; y < this.modelGridCountY; ++y) {
                        this.velocityGrid.get((int)n).data()[x][y] = velocities[n];
                    }
                }
            }
            for (n = 0; n < depths.length; ++n) {
                for (x = 0; x < this.modelGridCountX; ++x) {
                    for (y = 0; y < this.modelGridCountY; ++y) {
                        this.elevationGrid.get((int)(n + 1)).data()[x][y] = this.elevationGrid.get(n).data()[x][y] - depths[n];
                    }
                }
            }
            this.Initialized = true;
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepInteractiveModel(String name) {
        try {
            double y;
            double x;
            GliInteractiveModel_PickCollection pickCollection;
            int n;
            this.m_name = name;
            this.model_layerCount = RefractionStaticsProject.singleton().gliNewModelLayerCount();
            this.elevationGrid = new ArrayList();
            this.velocityGrid = new ArrayList();
            for (n = 0; n <= this.model_layerCount; ++n) {
                this.elevationGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
                this.velocityGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
            }
            this.deltaElevation = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.deltaVelocity = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.ray_shotT = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
            this.ray_shotHD = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
            this.ray_receiverT = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
            this.ray_receiverHD = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
            this.modelGridCountX = this.elevationGrid.get(0).numInline();
            this.modelGridCountY = this.elevationGrid.get(0).numCrossline();
            this.deltaElevNum = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.deltaElevDenom = RefractionStaticsProject.singleton().getEmptyGrid3D();
            this.elevCount = new int[this.modelGridCountX][this.modelGridCountY];
            this.depth_basisVector = new double[this.modelGridCountX][this.modelGridCountY];
            this.depth_residualVector = new double[this.modelGridCountX][this.modelGridCountY];
            this.depth_nextResidual = new double[this.modelGridCountX][this.modelGridCountY];
            this.interpolateElevation();
            this.m_layerHitCountElev = new int[this.model_layerCount + 1];
            this.m_layerHitCountVel = new int[this.model_layerCount + 1];
            for (n = 1; n <= this.model_layerCount; ++n) {
                this.elevationGrid.get(n).interp_Prep();
                pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
                for (GliInteractiveModel_SingleLocation location : pickCollection.m_picks) {
                    location.computeGliModel(false);
                    x = location.WorldX;
                    y = location.WorldY;
                    double depth = location.m_top[n];
                    double surface = this.elevationGrid.get(0).getNearestValue(x, y);
                    double elev = surface - depth;
                    this.elevationGrid.get(n).interp_Add(x, y, (float)elev, 1.0f);
                }
                this.elevationGrid.get(n).interp_Finish(this.interpRadiusElevation);
                this.elevationGrid.get(n).interp_Free();
            }
            for (n = 0; n <= this.model_layerCount; ++n) {
                this.velocityGrid.get(n).interp_Prep();
                pickCollection = RefractionStaticsProject.singleton().gliInteractiveModel_PickCollection();
                for (GliInteractiveModel_SingleLocation location : pickCollection.m_picks) {
                    location.computeGliModel(false);
                    x = location.WorldX;
                    y = location.WorldY;
                    double vel = location.m_velocity[n];
                    this.velocityGrid.get(n).interp_Add(x, y, (float)vel, 1.0f);
                }
                this.velocityGrid.get(n).interp_Finish(this.interpRadiusVelocity);
                this.velocityGrid.get(n).interp_Free();
            }
            this.Initialized = true;
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double findMax(double[] array1, double[] array2) {
        try {
            int n;
            double max = -1.0E24;
            for (n = 0; n < array1.length; ++n) {
                if (!(array1[n] > max)) continue;
                max = array1[n];
            }
            for (n = 0; n < array2.length; ++n) {
                if (!(array2[n] > max)) continue;
                max = array2[n];
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public double findMin(double[] array1, double[] array2) {
        try {
            int n;
            double min = 1.0E24;
            for (n = 0; n < array1.length; ++n) {
                if (!(array1[n] < min)) continue;
                min = array1[n];
            }
            for (n = 0; n < array2.length; ++n) {
                if (!(array2[n] < min)) continue;
                min = array2[n];
            }
            return min;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public void interpolateElevation() {
        try {
            double elev;
            this.index_shotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            this.index_receiverKilled = this.m_receiverTable.column_indexOfColumn("Killed");
            this.index_shotX = this.m_shotTable.column_indexOfColumn("Easting");
            this.index_shotY = this.m_shotTable.column_indexOfColumn("Northing");
            this.index_receiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            this.index_receiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            this.index_shotElevation = this.m_shotTable.column_indexOfColumn("Elevation");
            this.index_receiverElevation = this.m_receiverTable.column_indexOfColumn("Elevation");
            this.elevationGrid.get(0).interp_Prep();
            for (int shot = 0; shot < this.m_shotTable.row_count(); ++shot) {
                boolean sKilled = this.m_shotTable.getBool(shot, this.index_shotKilled);
                if (sKilled) continue;
                double shotWorldX = this.m_shotTable.getDouble(shot, this.index_shotX);
                double shotWorldY = this.m_shotTable.getDouble(shot, this.index_shotY);
                elev = this.m_shotTable.getDouble(shot, this.index_shotElevation);
                this.elevationGrid.get(0).interp_Add(shotWorldX, shotWorldY, (float)elev, 1.0f);
            }
            for (int rec = 0; rec < this.m_receiverTable.row_count(); ++rec) {
                boolean rKilled = this.m_receiverTable.getBool(rec, this.index_receiverKilled);
                if (rKilled) continue;
                double receiverWorldX = this.m_receiverTable.getDouble(rec, this.index_receiverX);
                double receiverWorldY = this.m_receiverTable.getDouble(rec, this.index_receiverY);
                elev = this.m_receiverTable.getDouble(rec, this.index_receiverElevation);
                this.elevationGrid.get(0).interp_Add(receiverWorldX, receiverWorldY, (float)elev, 1.0f);
            }
            this.elevationGrid.get(0).interp_Finish(this.interpRadiusElevation);
            this.elevationGrid.get(0).interp_Free();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeSRTimes(int thislayer) {
        try {
            int j;
            int layer;
            this.index_shotID = this.m_shotTable.column_indexOfColumn("ShotID");
            this.index_shotX = this.m_shotTable.column_indexOfColumn("Easting");
            this.index_shotY = this.m_shotTable.column_indexOfColumn("Northing");
            this.index_receiverID = this.m_receiverTable.column_indexOfColumn("ReceiverID");
            this.index_receiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            this.index_receiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            this.clearArray(this.ray_shotT, 0.0f);
            this.clearArray(this.ray_shotHD, 0.0f);
            this.clearArray(this.ray_receiverT, 0.0f);
            this.clearArray(this.ray_receiverHD, 0.0f);
            for (int shot = 0; shot < this.m_shotTable.row_count(); ++shot) {
                int shotID = this.m_shotTable.getInt(shot, this.index_shotRow);
                int shot_index = shotID - 1000;
                this.current_shotWorldX = this.m_shotTable.getDouble(shot, this.index_shotX);
                this.current_shotWorldY = this.m_shotTable.getDouble(shot, this.index_shotY);
                for (layer = 1; layer <= this.model_layerCount; ++layer) {
                    this.ray_shotT[shot_index][layer] = 0.0f;
                    double vel_baseS = this.velocityGrid.get(layer).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                    for (j = 1; j <= layer; ++j) {
                        double elev_aboveS = this.elevationGrid.get(j - 1).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                        double elev_belowS = this.elevationGrid.get(j).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                        double vel_aboveS = this.velocityGrid.get(j - 1).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                        double vel_belowS = this.velocityGrid.get(j).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                        double refraction_angleS = Math.asin(vel_aboveS / vel_baseS);
                        float[] fArray = this.ray_shotT[shot_index];
                        int n = layer;
                        fArray[n] = (float)((double)fArray[n] + (elev_aboveS - elev_belowS) / (vel_aboveS * Math.cos(refraction_angleS)));
                        float[] fArray2 = this.ray_shotHD[shot_index];
                        int n2 = layer;
                        fArray2[n2] = (float)((double)fArray2[n2] + (elev_aboveS - elev_belowS) * Math.tan(refraction_angleS));
                    }
                }
            }
            for (int rec = 0; rec < this.m_receiverTable.row_count(); ++rec) {
                int recID = this.m_receiverTable.getInt(rec, this.index_receiverRow);
                int rec_index = recID - 1000;
                this.current_receiverWorldX = this.m_receiverTable.getDouble(rec, this.index_receiverX);
                this.current_receiverWorldY = this.m_receiverTable.getDouble(rec, this.index_receiverY);
                for (layer = 1; layer <= this.model_layerCount; ++layer) {
                    this.ray_receiverT[rec_index][layer] = 0.0f;
                    double vel_baseR = this.velocityGrid.get(layer).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                    for (j = 1; j <= layer; ++j) {
                        double elev_aboveR = this.elevationGrid.get(j - 1).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                        double elev_belowR = this.elevationGrid.get(j).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                        double vel_aboveR = this.velocityGrid.get(j - 1).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                        double vel_belowR = this.velocityGrid.get(j).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                        double refraction_angleR = Math.asin(vel_aboveR / vel_baseR);
                        float[] fArray = this.ray_receiverT[rec_index];
                        int n = layer;
                        fArray[n] = (float)((double)fArray[n] + (elev_aboveR - elev_belowR) / (vel_aboveR * Math.cos(refraction_angleR)));
                        float[] fArray3 = this.ray_receiverHD[rec_index];
                        int n3 = layer;
                        fArray3[n3] = (float)((double)fArray3[n3] + (elev_aboveR - elev_belowR) * Math.tan(refraction_angleR));
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double rayTrace(int w_layer) {
        try {
            double[] t_total = new double[this.model_layerCount + 1];
            double[] t_horiz = new double[this.model_layerCount + 1];
            int shot_index = this.current_shotID - 1000;
            int rec_index = this.current_receiverID - 1000;
            for (int layer = 1; layer <= this.model_layerCount; ++layer) {
                double elev_aboveS = this.elevationGrid.get(layer - 1).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                double elev_aboveR = this.elevationGrid.get(layer - 1).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                double vel_belowS = this.velocityGrid.get(layer).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                double vel_belowR = this.velocityGrid.get(layer).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                t_horiz[layer] = 2.0 * (Math.sqrt((this.current_traceOffset - (double)this.ray_shotHD[shot_index][layer] - (double)this.ray_receiverHD[rec_index][layer]) * (this.current_traceOffset - (double)this.ray_shotHD[shot_index][layer] - (double)this.ray_receiverHD[rec_index][layer]) + (elev_aboveS - elev_aboveR) * (elev_aboveS - elev_aboveR)) / (vel_belowS + vel_belowR));
                t_total[layer] = (double)(this.ray_shotT[shot_index][layer] + this.ray_receiverT[rec_index][layer]) + t_horiz[layer];
            }
            double elev_directS = this.elevationGrid.get(0).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double elev_directR = this.elevationGrid.get(0).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            double vel_directS = this.velocityGrid.get(0).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double vel_directR = this.velocityGrid.get(0).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            t_total[0] = 2.0 * (Math.sqrt(this.current_traceOffset * this.current_traceOffset + (elev_directS - elev_directR) * (elev_directS - elev_directR)) / (vel_directS + vel_directR));
            double t_best = this.findShortestPath(w_layer, t_total);
            return t_best;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999.0;
        }
    }

    public double rayTrace_ensembleWorker(int shotID, int receiverID) {
        try {
            double[] t_total = new double[this.model_layerCount + 1];
            double[] t_horiz = new double[this.model_layerCount + 1];
            int shot_index = shotID - 1000;
            int rec_index = receiverID - 1000;
            int indexShotX = this.m_shotTable.column_indexOfColumn("Easting");
            int indexShotY = this.m_shotTable.column_indexOfColumn("Northing");
            int indexShotZ = this.m_shotTable.column_indexOfColumn("Elevation");
            int indexReceiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            int indexReceiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            int indexReceiverZ = this.m_receiverTable.column_indexOfColumn("Elevation");
            int shotRow = this.m_shotMap.get(shotID);
            int receiverRow = this.m_receiverMap.get(receiverID);
            double shotX = this.m_shotTable.getDouble(shotRow, indexShotX);
            double shotY = this.m_shotTable.getDouble(shotRow, indexShotY);
            double shotZ = this.m_shotTable.getDouble(shotRow, indexShotZ);
            double receiverX = this.m_receiverTable.getDouble(receiverRow, indexReceiverX);
            double receiverY = this.m_receiverTable.getDouble(receiverRow, indexReceiverY);
            double receiverZ = this.m_receiverTable.getDouble(receiverRow, indexReceiverZ);
            double offset = Math.sqrt((receiverX - shotX) * (receiverX - shotX) + (receiverY - shotY) * (receiverY - shotY));
            for (int layer = 1; layer <= this.model_layerCount; ++layer) {
                double elev_aboveS = this.elevationGrid.get(layer - 1).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                double elev_aboveR = this.elevationGrid.get(layer - 1).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                double vel_belowS = this.velocityGrid.get(layer).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
                double vel_belowR = this.velocityGrid.get(layer).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
                t_horiz[layer] = 2.0 * (Math.sqrt((offset - (double)this.ray_shotHD[shot_index][layer] - (double)this.ray_receiverHD[rec_index][layer]) * (offset - (double)this.ray_shotHD[shot_index][layer] - (double)this.ray_receiverHD[rec_index][layer]) + (elev_aboveS - elev_aboveR) * (elev_aboveS - elev_aboveR)) / (vel_belowS + vel_belowR));
                t_total[layer] = (double)(this.ray_shotT[shot_index][layer] + this.ray_receiverT[rec_index][layer]) + t_horiz[layer];
                boolean bl = false;
            }
            double elev_directS = this.elevationGrid.get(0).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double elev_directR = this.elevationGrid.get(0).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            double vel_directS = this.velocityGrid.get(0).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double vel_directR = this.velocityGrid.get(0).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            t_total[0] = 2.0 * (Math.sqrt(offset * offset + (elev_directS - elev_directR) * (elev_directS - elev_directR)) / (vel_directS + vel_directR));
            double best = 1.0E24;
            for (int n = 0; n < t_total.length; ++n) {
                if (!(t_total[n] < best)) continue;
                best = t_total[n];
            }
            if (best < 1.0E24) {
                return best;
            }
            return 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999.0;
        }
    }

    public double findShortestPath(int layer, double[] rays) {
        try {
            int n;
            double best = 1.0E24;
            int raypath = -1;
            for (n = 0; n < rays.length; ++n) {
                if (!(rays[n] < best)) continue;
                best = rays[n];
                raypath = n;
            }
            if (raypath != layer) {
                return -100.0;
            }
            for (n = 0; n < rays.length; ++n) {
                if (n == raypath || !(rays[n] > 0.95 * best) || !(rays[n] < 1.05 * best)) continue;
                return -100.0;
            }
            return best;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public float findCoeffA(int index, double value1) {
        try {
            float value = (float)value1;
            float coeff = index == 1 ? 2.0f * value * value * value - 3.0f * value * value + 1.0f : (index == 2 ? -(2.0f * value * value * value) + 3.0f * value * value : (index == 3 ? value * value * value - 2.0f * value * value + value : (index == 4 ? value * value * value - value * value : 0.0f)));
            return coeff;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0f;
        }
    }

    public void updateDepthCG(int layer) {
        try {
            int y;
            int x;
            this.clearArray(this.elevCount, 0);
            this.clearArray(this.depth_residualVector, 0.0);
            this.clearArray(this.depth_basisVector, 0.0);
            this.deltaElevation.setValue(0.0f);
            this.deltaElevNum.setValue(0.0f);
            this.deltaElevDenom.setValue(0.0f);
            this.clearChangeFactors();
            this.clearTraceColumns();
            this.depth_rSq = 0.0;
            this.depth_tSq = 0.0;
            this.depth_alpha = 0.0;
            long start = System.currentTimeMillis();
            this.computeSRTimes(layer);
            this.deltaElevNum.interp_Prep();
            this.deltaElevDenom.interp_Prep();
            this.depthErrorTotal = 0.0;
            this.depthHitCount = 0L;
            for (long trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                this.singleTraceDepthUpdateCG(trace, layer);
            }
            this.deltaElevNum.interp_Finish(this.interpRadiusElevation);
            this.deltaElevDenom.interp_Finish(this.interpRadiusElevation);
            long end = System.currentTimeMillis();
            long time = end - start;
            long timeSec = time / 1000L;
            double averageError = this.depthErrorTotal / (double)this.depthHitCount;
            boolean pause = false;
            for (int x2 = 0; x2 < this.modelGridCountX; ++x2) {
                for (int y2 = 0; y2 < this.modelGridCountY; ++y2) {
                    if (this.deltaElevDenom.data()[x2][y2] == 0.0f) continue;
                    this.deltaElevation.data()[x2][y2] = this.deltaElevNum.data()[x2][y2] / this.deltaElevDenom.data()[x2][y2];
                }
            }
            double absChange = 0.0;
            double count = 0.0;
            boolean a = false;
            this.depthConjugateGradient_FirstPass();
            for (int n = 0; n < 10; ++n) {
                double error = this.depthConjugateGradient();
            }
            for (x = 0; x < this.modelGridCountX; ++x) {
                for (y = 0; y < this.modelGridCountY; ++y) {
                    absChange += (double)Math.abs(this.deltaElevation.data()[x][y]);
                    if (this.deltaElevation.data()[x][y] == 0.0f) continue;
                    count += 1.0;
                }
            }
            for (x = 0; x < this.modelGridCountX; ++x) {
                for (y = 0; y < this.modelGridCountY; ++y) {
                    float[] fArray = this.elevationGrid.get(layer).data()[x];
                    int n = y;
                    fArray[n] = fArray[n] - this.deltaElevation.data()[x][y];
                    if (!(this.elevationGrid.get(layer).data()[x][y] > this.elevationGrid.get(layer - 1).data()[x][y])) continue;
                    this.elevationGrid.get((int)layer).data()[x][y] = this.elevationGrid.get(layer - 1).data()[x][y] - 1.0f;
                }
            }
            this.elevationGrid.get(layer).smooth(2);
            double d = this.findAverageElevation(layer);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void depthConjugateGradient_FirstPass() {
        try {
            int x;
            boolean traceKilled;
            boolean receiverKilled;
            boolean shotKilled;
            int receiverRow;
            int shotRow;
            long trace;
            for (trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
                receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
                shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
                receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
                traceKilled = false;
                if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                    traceKilled = true;
                }
                if (shotKilled || receiverKilled || traceKilled) continue;
                this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
                this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
                this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
                this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
                this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
                this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
                this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                double error = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceError);
                double scaledChangeS = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorShot);
                double scaledChangeR = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorReceiver);
                double changeS = scaledChangeS / 1.0E8;
                double changeR = scaledChangeR / 1.0E8;
                double term2 = changeS * (double)this.deltaElevation.data()[this.current_shotGridX][this.current_shotGridY] + changeR * (double)this.deltaElevation.data()[this.current_receiverGridX][this.current_receiverGridY];
                double residual = error - term2;
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceResidual, (float)residual);
                double[] dArray = this.depth_residualVector[this.current_shotGridX];
                int n = this.current_shotGridY;
                dArray[n] = dArray[n] + residual * changeS;
                double[] dArray2 = this.depth_residualVector[this.current_receiverGridX];
                int n2 = this.current_receiverGridY;
                dArray2[n2] = dArray2[n2] + residual * changeR;
                double[] dArray3 = this.depth_basisVector[this.current_shotGridX];
                int n3 = this.current_shotGridY;
                dArray3[n3] = dArray3[n3] + residual * changeS;
                double[] dArray4 = this.depth_basisVector[this.current_receiverGridX];
                int n4 = this.current_receiverGridY;
                dArray4[n4] = dArray4[n4] + residual * changeR;
            }
            for (trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
                receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
                shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
                receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
                traceKilled = false;
                if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                    traceKilled = true;
                }
                if (shotKilled || receiverKilled || traceKilled) continue;
                this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
                this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
                this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
                this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
                this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
                this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
                this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                double scaledChangeS = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorShot);
                double scaledChangeR = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorReceiver);
                double changeS = scaledChangeS / 1.0E8;
                double changeR = scaledChangeR / 1.0E8;
                double product = changeS * this.depth_basisVector[this.current_shotGridX][this.current_shotGridY] + changeR * this.depth_basisVector[this.current_receiverGridX][this.current_receiverGridY];
                double product_scaled = product * 1.0E12;
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceProduct, (float)product_scaled);
                this.depth_tSq += product * product;
            }
            for (x = 0; x < this.modelGridCountX; ++x) {
                for (int y = 0; y < this.modelGridCountY; ++y) {
                    this.depth_rSq += this.depth_residualVector[x][y] * this.depth_residualVector[x][y];
                }
            }
            this.depth_alpha = this.depth_rSq / this.depth_tSq;
            x = 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double depthConjugateGradient() {
        try {
            int y;
            int x;
            double scaledChangeR;
            double scaledChangeS;
            boolean shot_tracecount = false;
            double dSq = 0.0;
            double zSq = 0.0;
            this.index_shotX = this.m_shotTable.column_indexOfColumn("Easting");
            this.index_shotY = this.m_shotTable.column_indexOfColumn("Northing");
            this.index_shotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            this.index_receiverX = this.m_receiverTable.column_indexOfColumn("Easting");
            this.index_receiverY = this.m_receiverTable.column_indexOfColumn("Northing");
            this.index_receiverKilled = this.m_receiverTable.column_indexOfColumn("Killed");
            boolean pause = false;
            for (int x2 = 0; x2 < this.modelGridCountX; ++x2) {
                for (int y2 = 0; y2 < this.modelGridCountY; ++y2) {
                    float[] fArray = this.deltaElevation.data()[x2];
                    int n = y2;
                    fArray[n] = (float)((double)fArray[n] + this.depth_alpha * this.depth_basisVector[x2][y2]);
                    zSq += (double)(this.deltaElevation.data()[x2][y2] * this.deltaElevation.data()[x2][y2]);
                }
            }
            pause = false;
            for (long trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
                int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
                boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
                boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
                boolean traceKilled = false;
                if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                    traceKilled = true;
                }
                if (shotKilled || receiverKilled || traceKilled) continue;
                this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
                this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
                this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
                this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
                this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
                this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
                this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                double residual = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceResidual);
                scaledChangeS = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorShot);
                scaledChangeR = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorReceiver);
                double product_scaled = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceProduct);
                double changeS = scaledChangeS / 1.0E8;
                double changeR = scaledChangeR / 1.0E8;
                double product = product_scaled / 1.0E12;
                double residual_new = residual - this.depth_alpha * product;
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceResidual, (float)residual_new);
                dSq += residual_new * residual_new;
                if (residual_new != 0.0) {
                    pause = false;
                }
                double[] dArray = this.depth_nextResidual[this.current_shotGridX];
                int n = this.current_shotGridY;
                dArray[n] = dArray[n] + changeS * residual_new;
                double[] dArray2 = this.depth_nextResidual[this.current_receiverGridX];
                int n2 = this.current_receiverGridY;
                dArray2[n2] = dArray2[n2] + changeR * residual_new;
            }
            double r_temp = 0.0;
            for (x = 0; x < this.modelGridCountX; ++x) {
                for (y = 0; y < this.modelGridCountY; ++y) {
                    r_temp += this.depth_nextResidual[x][y] * this.depth_nextResidual[x][y];
                    this.depth_residualVector[x][y] = this.depth_nextResidual[x][y];
                }
            }
            this.clearArray(this.depth_nextResidual, 0.0);
            this.depth_beta = r_temp / this.depth_rSq;
            pause = false;
            for (x = 0; x < this.modelGridCountX; ++x) {
                for (y = 0; y < this.modelGridCountY; ++y) {
                    double temp = this.depth_basisVector[x][y];
                    this.depth_basisVector[x][y] = (float)(this.depth_residualVector[x][y] + this.depth_beta * temp);
                }
            }
            this.depth_tSq = 0.0;
            for (long trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
                int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
                boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
                boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
                boolean traceKilled = false;
                if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                    traceKilled = true;
                }
                if (shotKilled || receiverKilled || traceKilled) continue;
                this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
                this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
                this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
                this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
                this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
                this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
                this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
                this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
                scaledChangeS = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorShot);
                scaledChangeR = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceChangeFactorReceiver);
                double changeS = scaledChangeS / 1.0E8;
                double changeR = scaledChangeR / 1.0E8;
                double t_new = changeS * this.depth_residualVector[this.current_shotGridX][this.current_shotGridY] + changeR * this.depth_residualVector[this.current_receiverGridX][this.current_receiverGridY];
                double t_scaled = t_new * 1.0E12;
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceProduct, (float)t_scaled);
                this.depth_tSq += t_new * t_new;
                if (!(changeS > 0.0)) continue;
                pause = false;
            }
            this.depth_rSq = 0.0;
            for (int x3 = 0; x3 < this.modelGridCountX; ++x3) {
                for (y = 0; y < this.modelGridCountY; ++y) {
                    this.depth_rSq += this.depth_residualVector[x3][y] * this.depth_residualVector[x3][y];
                }
            }
            this.depth_alpha = this.depth_rSq / this.depth_tSq;
            double error_quotient = dSq / zSq;
            return error_quotient;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -1.0;
        }
    }

    public void updateModel() {
        try {
            long start = System.currentTimeMillis();
            this.m_traceErrorSum = 0.0;
            this.m_traceErrorCount = 0L;
            for (int n = 1; n <= this.model_layerCount; ++n) {
                this.clearAllArrays();
                this.updateDepthCG(n);
                this.updateVelocity(n);
            }
            long end = System.currentTimeMillis();
            long time = end - start;
            long timeSec = time / 1000L;
            double averageError = this.m_traceErrorSum / (double)this.m_traceErrorCount;
            System.out.println("Total model update time: " + timeSec + " seconds");
            System.out.println("Average trace error: " + averageError);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void singleTraceDepthUpdateCG(long trace, int layer) {
        try {
            boolean bl;
            boolean bl2;
            int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
            int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
            boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
            if (shotKilled) {
                return;
            }
            boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
            if (receiverKilled) {
                return;
            }
            if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                return;
            }
            this.current_traceFBP = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceFBP);
            if (this.current_traceFBP < 0.0f) {
                return;
            }
            this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
            this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
            this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
            this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
            this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
            this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
            this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_shotID = this.m_shotTable.getInt(shotRow, this.index_shotID);
            this.current_receiverID = this.m_receiverTable.getInt(receiverRow, this.index_receiverID);
            this.current_traceOffset = Math.sqrt((this.current_shotWorldX - this.current_receiverWorldX) * (this.current_shotWorldX - this.current_receiverWorldX) + (this.current_shotWorldY - this.current_receiverWorldY) * (this.current_shotWorldY - this.current_receiverWorldY));
            double traceTime = this.rayTrace(layer);
            if (traceTime < 0.0) {
                return;
            }
            int n = layer;
            this.m_layerHitCountElev[n] = this.m_layerHitCountElev[n] + 1;
            float pickTime = this.current_traceFBP / 1000.0f;
            float traceError = (float)((double)pickTime - traceTime);
            this.m_traceErrorSum += (double)Math.abs(traceError);
            ++this.m_traceErrorCount;
            double vel_aboveS = this.velocityGrid.get(layer - 1).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double vel_belowS = this.velocityGrid.get(layer).getNearestValue(this.current_shotWorldX, this.current_shotWorldY);
            double vel_aboveR = this.velocityGrid.get(layer - 1).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            double vel_belowR = this.velocityGrid.get(layer).getNearestValue(this.current_receiverWorldX, this.current_receiverWorldY);
            double refraction_angleS = Math.asin(vel_aboveS / vel_belowS);
            double refraction_angleR = Math.asin(vel_aboveR / vel_belowR);
            float change_factorS = (float)(1.0 / (vel_aboveS * Math.cos(refraction_angleS)) - 2.0 * Math.tan(refraction_angleS) / (vel_belowS + vel_belowR));
            float change_factorR = (float)(1.0 / (vel_aboveR * Math.cos(refraction_angleR)) - 2.0 * Math.tan(refraction_angleR) / (vel_belowS + vel_belowR));
            if (change_factorS > 0.0f) {
                bl2 = false;
            }
            if (change_factorR > 0.0f) {
                bl2 = false;
            }
            float scaledChangeFactorS = change_factorS * 1.0E8f;
            float scaledChangeFactorR = change_factorR * 1.0E8f;
            this.depthErrorTotal += (double)Math.abs(traceError);
            ++this.depthHitCount;
            this.m_tempTraceTable.putFloat(trace, this.index_tempTraceChangeFactorShot, scaledChangeFactorS);
            this.m_tempTraceTable.putFloat(trace, this.index_tempTraceChangeFactorReceiver, scaledChangeFactorR);
            this.m_tempTraceTable.putFloat(trace, this.index_tempTraceError, traceError);
            double num_changeS = change_factorS * (traceError / 2.0f);
            double denom_changeS = change_factorS * change_factorS;
            double num_changeR = change_factorR * (traceError / 2.0f);
            double denom_changeR = change_factorR * change_factorR;
            if (this.current_shotGridX >= this.modelGridCountX) {
                bl = false;
            }
            if (this.current_shotGridY >= this.modelGridCountY) {
                bl = false;
            }
            this.deltaElevNum.interp_Add(this.current_shotWorldX, this.current_shotWorldY, (float)num_changeS, 1.0f);
            this.deltaElevNum.interp_Add(this.current_receiverWorldX, this.current_receiverWorldY, (float)num_changeR, 1.0f);
            this.deltaElevDenom.interp_Add(this.current_shotWorldX, this.current_shotWorldY, (float)denom_changeS, 1.0f);
            this.deltaElevDenom.interp_Add(this.current_receiverWorldX, this.current_receiverWorldY, (float)denom_changeR, 1.0f);
            int[] nArray = this.elevCount[this.current_shotGridX];
            int n2 = this.current_shotGridY;
            nArray[n2] = nArray[n2] + 1;
            int[] nArray2 = this.elevCount[this.current_receiverGridX];
            int n3 = this.current_receiverGridY;
            nArray2[n3] = nArray2[n3] + 1;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void singleTraceDepthUpdateGS(long trace, int layer) {
        try {
            int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
            int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
            boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
            if (shotKilled) {
                return;
            }
            boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
            if (receiverKilled) {
                return;
            }
            if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                return;
            }
            this.current_traceFBP = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceFBP);
            if (this.current_traceFBP < 0.0f) {
                return;
            }
            this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
            this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
            this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
            this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
            this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
            this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
            this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_shotID = this.m_shotTable.getInt(shotRow, this.index_shotID);
            this.current_receiverID = this.m_receiverTable.getInt(receiverRow, this.index_receiverID);
            this.current_traceOffset = Math.sqrt((this.current_shotWorldX - this.current_receiverWorldX) * (this.current_shotWorldX - this.current_receiverWorldX) + (this.current_shotWorldY - this.current_receiverWorldY) * (this.current_shotWorldY - this.current_receiverWorldY));
            double cdpX = (this.current_shotWorldX + this.current_receiverWorldX) / 2.0;
            double cdpY = (this.current_shotWorldY + this.current_receiverWorldY) / 2.0;
            this.velocityGrid.get(0).setWorldLocation(cdpX, cdpY);
            int cdpGridX = this.velocityGrid.get((int)0).InlineGridIndex;
            int cdpGridY = this.velocityGrid.get((int)0).CrosslineGridIndex;
            double traceTime = this.rayTrace(layer);
            if (traceTime < 0.0) {
                return;
            }
            int n = layer;
            this.m_layerHitCountElev[n] = this.m_layerHitCountElev[n] + 1;
            if (layer == 2) {
                boolean bl = false;
            }
            float pickTime = this.current_traceFBP / 1000.0f;
            float traceError = (float)((double)pickTime - traceTime);
            this.m_traceErrorSum += (double)Math.abs(traceError);
            ++this.m_traceErrorCount;
            double percentError = traceError / pickTime;
            double thicknessShot = this.elevationGrid.get(layer - 1).data()[this.current_shotGridX][this.current_shotGridY] - this.elevationGrid.get(layer).data()[this.current_shotGridX][this.current_shotGridY];
            double thicknessReceiver = this.elevationGrid.get(layer - 1).data()[this.current_receiverGridX][this.current_receiverGridY] - this.elevationGrid.get(layer).data()[this.current_receiverGridX][this.current_receiverGridY];
            double thicknessCDP = this.elevationGrid.get(layer - 1).data()[cdpGridX][cdpGridY] - this.elevationGrid.get(layer).data()[cdpGridX][cdpGridY];
            double deltaThicknessShot = percentError * thicknessShot * 0.5;
            double deltaThicknessReceiver = percentError * thicknessReceiver * 0.5;
            double deltaThicknessCDP = percentError * thicknessCDP * 0.2;
            double newThicknessShot = thicknessShot + deltaThicknessShot;
            double newThicknessReceiver = thicknessReceiver + deltaThicknessReceiver;
            double newThicknessCDP = thicknessCDP + deltaThicknessCDP;
            if (newThicknessShot < 1.0) {
                newThicknessShot = 1.0;
            }
            if (newThicknessReceiver < 1.0) {
                newThicknessReceiver = 1.0;
            }
            if (newThicknessCDP < 1.0) {
                newThicknessCDP = 1.0;
            }
            double newElevShot = (double)this.elevationGrid.get(layer - 1).data()[this.current_shotGridX][this.current_shotGridY] - newThicknessShot;
            double newElevReceiver = (double)this.elevationGrid.get(layer - 1).data()[this.current_receiverGridX][this.current_receiverGridY] - newThicknessReceiver;
            double newElevCDP = (double)this.elevationGrid.get(layer - 1).data()[cdpGridX][cdpGridY] - newThicknessCDP;
            if (layer == 2) {
                boolean bl = false;
            }
            this.elevationGrid.get(layer).interp_Add(this.current_shotGridX, this.current_shotGridY, (float)newElevShot, 1.0f);
            this.elevationGrid.get(layer).interp_Add(this.current_receiverGridX, this.current_receiverGridY, (float)newElevReceiver, 1.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void singleTraceVelocityUpdate(long trace, int layer) {
        try {
            int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
            int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
            boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
            if (shotKilled) {
                return;
            }
            boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
            if (receiverKilled) {
                return;
            }
            if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                return;
            }
            this.current_traceFBP = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceFBP);
            if (this.current_traceFBP < 0.0f) {
                return;
            }
            int n = layer;
            this.m_layerHitCountVel[n] = this.m_layerHitCountVel[n] + 1;
            this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
            this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
            this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
            this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
            this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
            this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
            this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_shotID = this.m_shotTable.getInt(shotRow, this.index_shotID);
            this.current_receiverID = this.m_receiverTable.getInt(receiverRow, this.index_receiverID);
            this.current_traceOffset = Math.sqrt((this.current_shotWorldX - this.current_receiverWorldX) * (this.current_shotWorldX - this.current_receiverWorldX) + (this.current_shotWorldY - this.current_receiverWorldY) * (this.current_shotWorldY - this.current_receiverWorldY));
            double traceTime = this.rayTrace(layer);
            if (traceTime < 0.0) {
                return;
            }
            float pickTime = this.current_traceFBP / 1000.0f;
            float traceError = (float)((double)pickTime - traceTime);
            int intTrace = (int)trace;
            this.velocityErrorTotal += (double)Math.abs(traceError);
            ++this.velocityHitCount;
            double cdpX = (this.current_shotWorldX + this.current_receiverWorldX) / 2.0;
            double cdpY = (this.current_shotWorldY + this.current_receiverWorldY) / 2.0;
            this.velocityGrid.get(0).setWorldLocation(cdpX, cdpY);
            int cdpGridX = this.velocityGrid.get((int)0).InlineGridIndex;
            int cdpGridY = this.velocityGrid.get((int)0).CrosslineGridIndex;
            double percentError = traceError / pickTime;
            double slownessShot = 1.0 / (double)this.velocityGrid.get(layer).data()[this.current_shotGridX][this.current_shotGridY];
            double slownessReceiver = 1.0 / (double)this.velocityGrid.get(layer).data()[this.current_receiverGridX][this.current_receiverGridY];
            double slownessCDP = 1.0 / (double)this.velocityGrid.get(layer).data()[cdpGridX][cdpGridY];
            double deltaSlownessShot = percentError * slownessShot * 0.5;
            double deltaSlownessReceiver = percentError * slownessReceiver * 0.5;
            double deltaSlownessCDP = percentError * slownessCDP * 0.2;
            double newVelocityShot = 1.0 / (slownessShot + deltaSlownessShot);
            double newVelocityReceiver = 1.0 / (slownessReceiver + deltaSlownessReceiver);
            double newVelocityCDP = 1.0 / (slownessCDP + deltaSlownessCDP);
            double avgVelocityUpper = 0.0;
            double avgVelocityLower = 0.0;
            if (layer < this.model_layerCount) {
                avgVelocityUpper = this.findAverageVelocity(layer - 1);
                avgVelocityLower = this.findAverageVelocity(layer + 1);
            }
            if (layer == this.model_layerCount) {
                avgVelocityUpper = this.findAverageVelocity(layer - 1);
                avgVelocityLower = 28000.0;
            }
            if (newVelocityShot > avgVelocityUpper && newVelocityShot < avgVelocityLower) {
                this.velocityGrid.get(layer).interp_Add(this.current_shotWorldX, this.current_shotWorldY, (float)newVelocityShot, 1.0f);
            }
            if (newVelocityReceiver > avgVelocityUpper && newVelocityReceiver < avgVelocityLower) {
                this.velocityGrid.get(layer).interp_Add(this.current_receiverWorldX, this.current_receiverWorldY, (float)newVelocityReceiver, 1.0f);
            }
            if (!(newVelocityCDP > avgVelocityUpper) || newVelocityCDP < avgVelocityLower) {
                // empty if block
            }
            float[] fArray = this.deltaVelocity.data()[this.current_shotGridX];
            int n2 = this.current_shotGridY;
            fArray[n2] = (float)((double)fArray[n2] + percentError);
            float[] fArray2 = this.deltaVelocity.data()[this.current_receiverGridX];
            int n3 = this.current_receiverGridY;
            fArray2[n3] = (float)((double)fArray2[n3] + percentError);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void singleTraceSimpleVelocityUpdate(long trace, int layer) {
        try {
            int shotRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceShotRow);
            int receiverRow = this.m_tempTraceTable.getInt(trace, this.index_tempTraceReceiverRow);
            boolean shotKilled = this.m_shotTable.getBool(shotRow, this.index_shotKilled);
            if (shotKilled) {
                return;
            }
            boolean receiverKilled = this.m_receiverTable.getBool(receiverRow, this.index_receiverKilled);
            if (receiverKilled) {
                return;
            }
            if (this.m_tempTraceTable.getInt(trace, this.index_tempTraceKilled) > 0) {
                return;
            }
            this.current_traceFBP = this.m_tempTraceTable.getFloat(trace, this.index_tempTraceFBP);
            if (this.current_traceFBP < 0.0f) {
                return;
            }
            this.current_shotWorldX = this.m_shotTable.getDouble(shotRow, this.index_shotX);
            this.current_shotWorldY = this.m_shotTable.getDouble(shotRow, this.index_shotY);
            this.elevationGrid.get(0).setWorldLocation(this.current_shotWorldX, this.current_shotWorldY);
            this.current_shotGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_shotGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_receiverWorldX = this.m_receiverTable.getDouble(receiverRow, this.index_receiverX);
            this.current_receiverWorldY = this.m_receiverTable.getDouble(receiverRow, this.index_receiverY);
            this.elevationGrid.get(0).setWorldLocation(this.current_receiverWorldX, this.current_receiverWorldY);
            this.current_receiverGridX = this.elevationGrid.get((int)0).InlineGridIndex;
            this.current_receiverGridY = this.elevationGrid.get((int)0).CrosslineGridIndex;
            this.current_shotID = this.m_shotTable.getInt(shotRow, this.index_shotID);
            this.current_receiverID = this.m_receiverTable.getInt(receiverRow, this.index_receiverID);
            this.current_traceOffset = Math.sqrt((this.current_shotWorldX - this.current_receiverWorldX) * (this.current_shotWorldX - this.current_receiverWorldX) + (this.current_shotWorldY - this.current_receiverWorldY) * (this.current_shotWorldY - this.current_receiverWorldY));
            double traceTime = this.rayTrace(layer);
            if (traceTime < 0.0) {
                return;
            }
            double cdpX = (this.current_shotWorldX + this.current_receiverWorldX) / 2.0;
            double cdpY = (this.current_shotWorldY + this.current_receiverWorldY) / 2.0;
            this.velocityGrid.get(layer).linearFit_Add(cdpX, cdpY, (float)this.current_traceOffset, this.current_traceFBP, 1.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void simpleVelocityUpdate(int layer) {
        try {
            long start = System.currentTimeMillis();
            this.computeSRTimes(layer);
            this.velocityErrorTotal = 0.0;
            this.velocityHitCount = 0L;
            this.velocityGrid.get(layer).linearFit_Prep();
            for (long t = 0L; t < this.m_tempTraceTable.rowCount(); ++t) {
                this.singleTraceSimpleVelocityUpdate(t, layer);
            }
            this.velocityGrid.get(layer).linearFit_Compute(1.0, false);
            for (int x = 0; x < this.modelGridCountX; ++x) {
                for (int y = 0; y < this.modelGridCountY; ++y) {
                    this.velocityGrid.get((int)layer).data()[x][y] = 1000.0f / this.velocityGrid.get((int)layer).Alpha[x][y];
                }
            }
            this.velocityGrid.get(layer).linearFit_Free();
            long end = System.currentTimeMillis();
            long time = end - start;
            long timeSec = time / 1000L;
            double d = this.findAverageVelocity(layer);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double[][] surfaceSmooth(double[][] inputArray, int smootherLengthX, int smootherLengthY) {
        try {
            double upperValue;
            double lowerValue;
            int col;
            int row;
            int col2;
            int row2;
            int xDim = inputArray.length;
            int yDim = inputArray[0].length;
            int[] upperLimitX = new int[xDim];
            int[] lowerLimitX = new int[xDim];
            int[] upperLimitY = new int[yDim];
            int[] lowerLimitY = new int[yDim];
            double[][] cumulativeX = new double[xDim][yDim];
            double[][] cumulativeY = new double[xDim][yDim];
            double[][] intermediateArray = new double[xDim][yDim];
            double[][] finalArray = new double[xDim][yDim];
            for (row2 = 0; row2 < xDim; ++row2) {
                cumulativeY[row2][0] = inputArray[row2][0];
            }
            for (col2 = 1; col2 < yDim; ++col2) {
                for (row = 0; row < xDim; ++row) {
                    cumulativeY[row][col2] = inputArray[row][col2] + cumulativeY[row][col2 - 1];
                }
            }
            for (int j = 0; j < yDim; ++j) {
                upperLimitY[j] = j + smootherLengthY / 2;
                if (upperLimitY[j] > yDim - 1) {
                    upperLimitY[j] = yDim - 1;
                }
                lowerLimitY[j] = j - smootherLengthY / 2 - 1;
                if (lowerLimitY[j] >= 0) continue;
                lowerLimitY[j] = -1;
            }
            for (int i = 0; i < xDim; ++i) {
                upperLimitX[i] = i + smootherLengthX / 2;
                if (upperLimitX[i] > xDim - 1) {
                    upperLimitX[i] = xDim - 1;
                }
                lowerLimitX[i] = i - smootherLengthX / 2 - 1;
                if (lowerLimitX[i] >= 0) continue;
                lowerLimitX[i] = -1;
            }
            for (row2 = 0; row2 < xDim; ++row2) {
                for (col = 0; col < yDim; ++col) {
                    lowerValue = lowerLimitY[col] == -1 ? 0.0 : cumulativeY[row2][lowerLimitY[col]];
                    upperValue = cumulativeY[row2][upperLimitY[col]];
                    intermediateArray[row2][col] = (upperValue - lowerValue) / (double)(upperLimitY[col] - lowerLimitY[col]);
                }
            }
            for (col2 = 0; col2 < yDim; ++col2) {
                cumulativeX[0][col2] = intermediateArray[0][col2];
            }
            for (row2 = 1; row2 < xDim; ++row2) {
                for (col = 0; col < yDim; ++col) {
                    cumulativeX[row2][col] = intermediateArray[row2][col] + cumulativeX[row2 - 1][col];
                }
            }
            for (col2 = 0; col2 < yDim; ++col2) {
                for (row = 0; row < xDim; ++row) {
                    lowerValue = lowerLimitX[row] == -1 ? 0.0 : cumulativeX[lowerLimitX[row]][col2];
                    upperValue = cumulativeX[upperLimitX[row]][col2];
                    finalArray[row][col2] = (upperValue - lowerValue) / (double)(upperLimitX[row] - lowerLimitX[row]);
                }
            }
            return finalArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public void updateVelocity(int layer) {
        try {
            this.deltaVelocity.setValue(0.0f);
            long start = System.currentTimeMillis();
            this.computeSRTimes(layer);
            this.velocityErrorTotal = 0.0;
            this.velocityHitCount = 0L;
            this.velocityGrid.get(layer).interp_Prep();
            for (long t = 0L; t < this.m_tempTraceTable.rowCount(); ++t) {
                this.singleTraceVelocityUpdate(t, layer);
            }
            if (layer == 2) {
                boolean t = false;
            }
            this.velocityGrid.get(layer).interp_Finish(this.interpRadiusVelocity);
            this.velocityGrid.get(layer).interp_Free();
            long end = System.currentTimeMillis();
            long time = end - start;
            long timeSec = time / 1000L;
            double d = this.findAverageVelocity(layer);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void updateDepthGS(int layer) {
        try {
            this.computeSRTimes(layer);
            this.elevationGrid.get(layer).interp_Prep();
            for (long t = 0L; t < this.m_tempTraceTable.rowCount(); ++t) {
                this.singleTraceDepthUpdateGS(t, layer);
            }
            if (layer == 1) {
                boolean t = false;
            }
            if (layer == 2) {
                boolean t = false;
            }
            this.elevationGrid.get(layer).interp_Finish(this.interpRadiusElevation);
            this.elevationGrid.get(layer).interp_Free();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeProfile(GliProfile profile) {
        try {
            if (profile == null) {
                return;
            }
            int count = profile.TotalNodeCount;
            double spacing = profile.NodeSpacing;
            double az = profile.Azimuth;
            double sx = profile.ShotWorldX;
            double sy = profile.ShotWorldY;
            for (int i = 0; i < count; ++i) {
                double x = sx + spacing * Math.cos(az);
                double y = sy + spacing * Math.sin(az);
                for (int l = 0; l <= this.model_layerCount; ++l) {
                    double ele = this.elevationGrid.get(l).getNearestValue(x, y);
                    double vel = this.velocityGrid.get(l).getNearestValue(x, y);
                    profile.Elevation[l][i] = ele;
                    profile.Velocity[l][i] = vel;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void createShotEnsemble(int shotID) {
        try {
            this.m_ensemble.clearTraces(false);
            this.m_tempTraceTableWrapper.populateEnsemble(this.m_ensemble, "ShotID", shotID, shotID);
            this.ensemble_prepGeometryHeaders();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_prepGeometryHeaders() {
        try {
            if (this.m_ensemble.traceCount() < 1) {
                return;
            }
            for (int n = 0; n < this.m_ensemble.traceCount(); ++n) {
                this.m_ensemble.trace((int)n).Removed = false;
                this.m_ensemble.trace((int)n).PureDC = false;
                this.m_ensemble.trace((int)n).DC_Biased = false;
                this.m_ensemble.trace((int)n).TooNoisy = false;
                this.m_ensemble.trace((int)n).TraceKilled = false;
            }
            this.ensemble_populateShotHeader(this.m_ensemble);
            this.ensemble_populateReceiverHeader(this.m_ensemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_populateShotHeader(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "ShotID")) {
                return;
            }
            int indexID = ensemble.dictionary().getEntryIndex("Trace", "ShotID");
            int indexRow = ensemble.dictionary().addEntry("Shot", "ShotRow", DataType.Int);
            boolean crap = false;
            this.ensemble_prepIndexConnectors(ensemble, this.m_shotTable);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                int id = header.getInt(indexID);
                if (!this.m_shotMap.containsKey(id)) {
                    crap = true;
                }
                int row = this.m_shotMap.get(id);
                header.putInt(indexRow, row);
                for (int col = 0; col < this.m_shotTable.column_count(); ++col) {
                    int headerIndex = this.m_headerIndex[col];
                    if (this.m_headerDoubleType[col]) {
                        header.putDouble(headerIndex, this.m_shotTable.getDouble(row, col));
                        continue;
                    }
                    header.putInt(headerIndex, this.m_shotTable.getInt(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_populateReceiverHeader(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "ReceiverID")) {
                return;
            }
            int indexID = ensemble.dictionary().getEntryIndex("Trace", "ReceiverID");
            int indexRow = ensemble.dictionary().addEntry("Receiver", "ReceiverRow", DataType.Int);
            this.ensemble_prepIndexConnectors(ensemble, this.m_receiverTable);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                int id = header.getInt(indexID);
                int row = this.m_receiverMap.get(id);
                header.putInt(indexRow, row);
                for (int col = 0; col < this.m_receiverTable.column_count(); ++col) {
                    int headerIndex = this.m_headerIndex[col];
                    if (this.m_headerDoubleType[col]) {
                        header.putDouble(headerIndex, this.m_receiverTable.getDouble(row, col));
                        continue;
                    }
                    header.putInt(headerIndex, this.m_receiverTable.getInt(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void ensemble_prepIndexConnectors(Ensemble ensemble, Table_Abstract table) {
        try {
            if (this.m_headerIndex.length <= table.column_count()) {
                this.m_headerIndex = new int[20 + table.column_count()];
            }
            if (this.m_headerType.length <= table.column_count()) {
                this.m_headerType = new DataType[20 + table.column_count()];
            }
            if (this.m_headerDoubleType.length <= table.column_count()) {
                this.m_headerDoubleType = new boolean[20 + table.column_count()];
            }
            String tableName = table.name();
            for (int col = 0; col < table.column_count(); ++col) {
                String name = table.column_name(col);
                this.m_headerType[col] = table.column_type(col);
                this.m_headerIndex[col] = ensemble.dictionary().addEntry(tableName, name, this.m_headerType[col]);
                this.m_headerDoubleType[col] = this.m_headerType[col] == DataType.Double || this.m_headerType[col] == DataType.Float;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearTraceColumns() {
        try {
            for (long trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceResidual, 0.0f);
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceProduct, 0.0f);
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceError, 0.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearChangeFactors() {
        try {
            for (long trace = 0L; trace < this.m_tempTraceTable.rowCount(); ++trace) {
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceChangeFactorShot, 0.0f);
                this.m_tempTraceTable.putFloat(trace, this.index_tempTraceChangeFactorReceiver, 0.0f);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearAllArrays() {
        try {
            this.deltaElevation.setValue(0.0f);
            this.deltaVelocity.setValue(0.0f);
            this.deltaElevNum.setValue(0.0f);
            this.deltaElevDenom.setValue(0.0f);
            this.clearArray(this.ray_shotT, 0.0f);
            this.clearArray(this.ray_shotHD, 0.0f);
            this.clearArray(this.ray_receiverT, 0.0f);
            this.clearArray(this.ray_receiverHD, 0.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(float[][][] array, float value) {
        try {
            int dim1 = array.length;
            int dim2 = array[0].length;
            int dim3 = array[0][0].length;
            for (int i = 0; i < dim1; ++i) {
                for (int j = 0; j < dim2; ++j) {
                    for (int k = 0; k < dim3; ++k) {
                        array[i][j][k] = value;
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(float[][] array, float value) {
        try {
            int dim1 = array.length;
            int dim2 = array[0].length;
            for (int i = 0; i < dim1; ++i) {
                for (int j = 0; j < dim2; ++j) {
                    array[i][j] = value;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(double[][] array, double value) {
        try {
            int dim1 = array.length;
            int dim2 = array[0].length;
            for (int i = 0; i < dim1; ++i) {
                for (int j = 0; j < dim2; ++j) {
                    array[i][j] = value;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(int[][] array, int value) {
        try {
            int dim1 = array.length;
            int dim2 = array[0].length;
            for (int i = 0; i < dim1; ++i) {
                for (int j = 0; j < dim2; ++j) {
                    array[i][j] = value;
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(float[] array, float value) {
        try {
            int dim = array.length;
            for (int i = 0; i < dim; ++i) {
                array[i] = value;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clearArray(double[] array, double value) {
        try {
            int dim = array.length;
            for (int i = 0; i < dim; ++i) {
                array[i] = value;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int LayerCount() {
        return this.model_layerCount;
    }

    public void testModelUpdate() {
        try {
            int l;
            long start = System.currentTimeMillis();
            for (l = 0; l <= this.model_layerCount; ++l) {
                System.out.println("Layer " + l + " Initial Elevation: " + this.findAverageElevation(l));
                System.out.println("Layer " + l + " Initial Velocity: " + this.findAverageVelocity(l));
            }
            this.createTempTraceTable();
            this.simpleVelocityUpdate(1);
            for (l = 1; l <= this.model_layerCount; ++l) {
                System.out.println("Updating layer " + l);
                for (int i = 0; i < 10; ++i) {
                    this.m_traceErrorSum = 0.0;
                    this.m_traceErrorCount = 0L;
                    this.m_layerHitCountElev[l] = 0;
                    this.m_layerHitCountVel[l] = 0;
                    this.updateDepthGS(l);
                    this.updateVelocity(l);
                    double averageError = this.m_traceErrorSum / (double)this.m_traceErrorCount;
                    System.out.println("     Iteration " + (i + 1) + ": error = " + averageError);
                }
            }
            long end = System.currentTimeMillis();
            long time = end - start;
            long timeSec = time / 1000L;
            System.out.println("Total model update time: " + timeSec + " seconds");
            for (int l2 = 0; l2 <= this.model_layerCount; ++l2) {
                System.out.println("Layer " + l2 + " Elevation: " + this.findAverageElevation(l2));
                System.out.println("Layer " + l2 + " Velocity: " + this.findAverageVelocity(l2));
            }
            Tools_FileSystem.deletePathIfExists(this.m_tempTraceTablePath);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void testLoopUpdate(int iterations) {
        try {
            for (int i = 0; i < iterations; ++i) {
                this.createTempTraceTable();
                this.updateDepthGS(1);
                this.updateVelocity(1);
                double elev = this.findAverageElevation(1);
                double vel = this.findAverageVelocity(1);
                Tools_FileSystem.deletePathIfExists(this.m_tempTraceTablePath);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void testModelSetDepthVel() {
        try {
            this.velocityGrid.get(0).setValue(4000.0f);
            this.velocityGrid.get(1).setValue(8000.0f);
            this.elevationGrid.get(1).setValue(4500.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNewModel() {
        try {
            float[] velocities = new float[2];
            float[] depths = new float[1];
            velocities[0] = 3300.0f;
            velocities[1] = 7000.0f;
            depths[0] = 250.0f;
            this.prepModel(1, velocities, depths);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void testTrace() {
        try {
            Ensemble m_ensemble = new Ensemble();
            for (int shot = 0; shot < this.m_shotTable.row_count(); ++shot) {
                this.current_shotID = shot + 1000;
                this.index_shotRow = this.m_shotMap.get(this.current_shotID);
                RefractionStaticsProject.singleton().ensemble_Shot(m_ensemble, this.current_shotID, false);
                int shot_tracecount = m_ensemble.traceCount();
                int columnIndex = m_ensemble.dictionary().getEntryIndex("Trace", "GliChangeFactorShot");
                int headerIndex = m_ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
                for (int trace = 0; trace < shot_tracecount; ++trace) {
                    EnsembleTrace m_trace = m_ensemble.trace(trace);
                    long l = m_trace.header().getLong(headerIndex);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void test_tempTraceTableColumns() {
        try {
            ArrayList<String> columnList = this.m_tempTraceTable.columns();
            for (String string : columnList) {
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double findAverageElevation(int layer) {
        try {
            int count = this.modelGridCountX * this.modelGridCountY;
            double sum = 0.0;
            for (int x = 0; x < this.modelGridCountX; ++x) {
                for (int y = 0; y < this.modelGridCountY; ++y) {
                    sum += (double)this.elevationGrid.get(layer).data()[x][y];
                }
            }
            double average = sum / (double)count;
            return average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public double findAverageVelocity(int layer) {
        try {
            int count = this.modelGridCountX * this.modelGridCountY;
            double sum = 0.0;
            for (int x = 0; x < this.modelGridCountX; ++x) {
                for (int y = 0; y < this.modelGridCountY; ++y) {
                    sum += (double)this.velocityGrid.get(layer).data()[x][y];
                }
            }
            double average = sum / (double)count;
            return average;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public void computeStatics() {
        try {
            double staticShift;
            double up;
            double down;
            double v1;
            double v0;
            double layer1;
            double surface;
            double replacement = 4800.0;
            String staticsName = "STATICS_GLI";
            int shotStaticsIndex = this.m_shotTable.column_exists(staticsName) ? this.m_shotTable.column_indexOfColumn(staticsName) : this.m_shotTable.column_append(staticsName, DataType.Float);
            int receiverStaticsIndex = this.m_receiverTable.column_exists(staticsName) ? this.m_receiverTable.column_indexOfColumn(staticsName) : this.m_receiverTable.column_append(staticsName, DataType.Float);
            Range_Double range = new Range_Double();
            this.elevationGrid.get(1).getRange(range);
            double tempDatum = range.rangeMin();
            int intDatum = (int)(tempDatum - 10.0);
            double datum = intDatum;
            for (int shot = 0; shot < this.m_shotTable.row_count(); ++shot) {
                double shotX = this.m_shotTable.getDouble(shot, this.index_shotX);
                double shotY = this.m_shotTable.getDouble(shot, this.index_shotY);
                surface = this.elevationGrid.get(0).getNearestValue(shotX, shotY);
                layer1 = this.elevationGrid.get(1).getNearestValue(shotX, shotY);
                v0 = this.velocityGrid.get(0).getNearestValue(shotX, shotY);
                v1 = this.velocityGrid.get(1).getNearestValue(shotX, shotY);
                down = (surface - layer1) / v0 + (layer1 - datum) / v1;
                up = (120.0 - datum) / replacement;
                staticShift = (up - down) * 1000.0;
                this.m_shotTable.putFloat(shot, shotStaticsIndex, (float)staticShift);
            }
            for (int receiver = 0; receiver < this.m_receiverTable.row_count(); ++receiver) {
                double receiverX = this.m_receiverTable.getDouble(receiver, this.index_receiverX);
                double receiverY = this.m_receiverTable.getDouble(receiver, this.index_receiverY);
                surface = this.elevationGrid.get(0).getNearestValue(receiverX, receiverY);
                layer1 = this.elevationGrid.get(1).getNearestValue(receiverX, receiverY);
                v0 = this.velocityGrid.get(0).getNearestValue(receiverX, receiverY);
                v1 = this.velocityGrid.get(1).getNearestValue(receiverX, receiverY);
                down = (surface - layer1) / v0 + (layer1 - datum) / v1;
                up = (120.0 - datum) / replacement;
                staticShift = (up - down) * 1000.0;
                this.m_receiverTable.putFloat(receiver, receiverStaticsIndex, (float)staticShift);
            }
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(this.m_shotTable, staticsName);
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(this.m_receiverTable, staticsName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            if (!this.Initialized) {
                System.out.println("Model not initialized; not saving");
                return;
            }
            if (this.m_name == null) {
                System.out.println("Model does not have a name; not saving");
                return;
            }
            if (this.m_name.length() < 2) {
                System.out.println("Model name is too short; not saving");
                return;
            }
            String gliPath = RefractionStaticsProject.singleton().gliProjectsPath();
            Object modelPath = gliPath + "/" + this.m_name;
            Tools_FileSystem.deletePathIfExists((String)modelPath);
            modelPath = Tools_FileSystem.confirmSubDirectoryExists(gliPath, this.m_name);
            int version = 1000;
            if (version == 1000) {
                for (int i = 0; i <= this.model_layerCount; ++i) {
                    Grid3D eGrid = this.elevationGrid.get(i);
                    String eLayerName = "model.elevation" + i;
                    String eLayerPath = (String)modelPath + "/" + eLayerName;
                    eGrid.save(eLayerPath);
                    Grid3D vGrid = this.velocityGrid.get(i);
                    String vLayerName = "model.velocity" + i;
                    String vLayerPath = (String)modelPath + "/" + vLayerName;
                    vGrid.save(vLayerPath);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void load(String modelName) {
        try {
            this.m_name = modelName;
            this.model_layerCount = -1;
            this.elevationGrid = new ArrayList();
            this.velocityGrid = new ArrayList();
            String gliPath = RefractionStaticsProject.singleton().gliProjectsPath();
            String modelPath = gliPath + "/" + modelName;
            if (Tools_FileSystem.exists_path(modelPath)) {
                ArrayList<String> gridList = Tools_FileSystem.files(modelPath, false);
                if (!modelPath.endsWith("/")) {
                    modelPath = modelPath + "/";
                }
                for (String grid : gridList) {
                    String extension = grid.substring(6);
                    if (extension.startsWith("elevation")) {
                        this.elevationGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
                        ++this.model_layerCount;
                    }
                    if (!extension.startsWith("velocity")) continue;
                    this.velocityGrid.add(RefractionStaticsProject.singleton().getEmptyGrid3D());
                }
                for (String grid : gridList) {
                    int indexInt;
                    String indexString;
                    String filePath = modelPath + grid;
                    String extension = grid.substring(6);
                    if (extension.startsWith("elevation")) {
                        indexString = extension.substring(9);
                        indexInt = Tools_Strings.toInt(indexString, 0);
                        this.elevationGrid.get(indexInt).read(filePath);
                        continue;
                    }
                    if (!extension.startsWith("velocity")) continue;
                    indexString = extension.substring(8);
                    indexInt = Tools_Strings.toInt(indexString, 0);
                    this.velocityGrid.get(indexInt).read(filePath);
                }
                this.deltaElevation = RefractionStaticsProject.singleton().getEmptyGrid3D();
                this.deltaVelocity = RefractionStaticsProject.singleton().getEmptyGrid3D();
                this.ray_shotT = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
                this.ray_shotHD = new float[this.m_shotTable.row_count()][this.model_layerCount + 1];
                this.ray_receiverT = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
                this.ray_receiverHD = new float[this.m_receiverTable.row_count()][this.model_layerCount + 1];
                this.modelGridCountX = this.elevationGrid.get(0).numInline();
                this.modelGridCountY = this.elevationGrid.get(0).numCrossline();
                this.deltaElevNum = RefractionStaticsProject.singleton().getEmptyGrid3D();
                this.deltaElevDenom = RefractionStaticsProject.singleton().getEmptyGrid3D();
                this.elevCount = new int[this.modelGridCountX][this.modelGridCountY];
                this.depth_basisVector = new double[this.modelGridCountX][this.modelGridCountY];
                this.depth_residualVector = new double[this.modelGridCountX][this.modelGridCountY];
                this.depth_nextResidual = new double[this.modelGridCountX][this.modelGridCountY];
                this.m_layerHitCountElev = new int[this.model_layerCount + 1];
                this.m_layerHitCountVel = new int[this.model_layerCount + 1];
                this.Initialized = true;
            } else {
                System.out.println("Model does not exist");
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String name() {
        return this.m_name;
    }

    public boolean initialized() {
        return this.Initialized;
    }

    public ArrayList<Grid3D> elevationGrid() {
        return this.elevationGrid;
    }

    public ArrayList<Grid3D> velocityGrid() {
        return this.velocityGrid;
    }
}

