/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.GLI;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Refraction.GLI.GliInteractiveModel_SingleLocation;
import com.PecosLibrary.Windows.Java2D.Java2D_ColorArrayWrapper;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class GliInteractiveModel_PickCollection
implements Java2D_PaintableInterface {
    protected ArrayList<GliInteractiveModel_SingleLocation> m_picks = new ArrayList();
    protected String m_fileName;
    protected GliInteractiveModel_SingleLocation m_current;
    public BasicStroke m_lineStroke = new BasicStroke(2.0f);

    public GliInteractiveModel_SingleLocation current() {
        return this.m_current;
    }

    public GliInteractiveModel_PickCollection(String fileName) {
        try {
            this.m_fileName = fileName;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int version = file.readInt();
            if (version == 1000) {
                int count = file.readInt();
                for (int i = 0; i < count; ++i) {
                    this.m_picks.add(new GliInteractiveModel_SingleLocation(file));
                }
                file.close();
                return;
            }
            file.close();
            throw new Exception("Bad version");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return;
        }
    }

    public void clear() {
        try {
            this.m_picks.clear();
            this.m_current = null;
            this.save();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save() {
        try {
            RandomAccessFile file = new RandomAccessFile(this.m_fileName, "rw");
            int version = 1000;
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_picks.size());
                for (GliInteractiveModel_SingleLocation sl : this.m_picks) {
                    sl.save(file);
                }
                file.close();
                return;
            }
            file.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setCurrent(double x, double y, double z, double minDistance) {
        try {
            this.deleteUnpickedLocations();
            int nearest = -9999;
            double minDist = 1000000.0;
            for (int n = 0; n < this.m_picks.size(); ++n) {
                GliInteractiveModel_SingleLocation location = this.m_picks.get(n);
                double dx = x - location.WorldX;
                double dy = y - location.WorldY;
                double dist = Math.sqrt(dx * dx + dy * dy);
                if (!(dist < minDistance) || !(dist < minDist)) continue;
                minDist = dist;
                nearest = n;
            }
            if (nearest >= 0) {
                this.m_current = this.m_picks.get(nearest);
                return;
            }
            this.m_current = new GliInteractiveModel_SingleLocation();
            this.m_current.WorldX = x;
            this.m_current.WorldY = y;
            this.m_current.WorldZ = z;
            this.m_picks.add(this.m_current);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void deleteUnpickedLocations() {
        try {
            this.m_current = null;
            for (int n = this.m_picks.size() - 1; n >= 0; --n) {
                GliInteractiveModel_SingleLocation location = this.m_picks.get(n);
                if (location.validPickCount() >= 2) continue;
                this.m_picks.remove(n);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void deleteAllLocations() {
        try {
            this.m_current = null;
            this.m_picks.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_ColorArrayWrapper colorWrapper = paintParameter.ColorArrayWrapper;
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setStroke(this.m_lineStroke);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            int dotSize = 15;
            int half = dotSize / 2;
            g2d.setColor(Color.GREEN);
            for (GliInteractiveModel_SingleLocation sl : this.m_picks) {
                int ix = (int)(scaleX * sl.WorldX + shiftX);
                int iy = (int)(scaleY * sl.WorldY + shiftY);
                g2d.fillOval(ix - half, iy - half, dotSize, dotSize);
            }
            if (this.m_current != null) {
                g2d.setColor(Color.RED);
                int ix = (int)(scaleX * this.m_current.WorldX + shiftX);
                int iy = (int)(scaleY * this.m_current.WorldY + shiftY);
                g2d.drawOval(ix - half, iy - half, dotSize, dotSize);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    public int getLayerCount() {
        try {
            if (this.m_picks.size() > 0) {
                int count = this.m_picks.get((int)0).m_validPickCount - 1;
                return count;
            }
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }
}

