/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Ensemble.CommonHeaderIndexWrapper;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Tools_DelayTime_Geometry {
    protected static Tools_DelayTime_Geometry m_singleton = null;
    protected double[] m_sumDelayTime = new double[10];
    protected double[] m_sumWeight = new double[10];
    protected float m_errorScalar = 50.0f;
    protected CommonHeaderIndexWrapper m_indices = new CommonHeaderIndexWrapper();

    protected Tools_DelayTime_Geometry() {
    }

    public static Tools_DelayTime_Geometry singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new Tools_DelayTime_Geometry();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    protected void computeGeometryCorrection_Receiver(boolean writeToDatabase, Ensemble ensemble) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            boolean moved = true;
            Ensemble.PredictedCoordinates pred = ensemble.predictedCoordinates();
            pred.Valid = false;
            pred.ElementID = Tools_Ensemble.isReceiverEnsemble(ensemble);
            for (int loop = 0; moved && loop < 6; ++loop) {
                if (loop == 0 || p.UpdateBranchDuringGeomCorr) {
                    dtd.branchAssignment().assignBranch_UsingGeomErrorData(ensemble);
                }
                this.updateDelayTime(ensemble, false, true);
                this.computeGeometryErrorTerms(ensemble, loop == 0);
                double sumDeltaX = 0.0;
                double sumDeltaY = 0.0;
                double sumCount = 1.0E-20;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    EnsembleTrace.GeometryError errorData = trace.geometryErrorData();
                    if (!trace.traceOkay() || errorData.Branch < 1) continue;
                    sumCount += 1.0;
                    sumDeltaX += errorData.ReceiverDeltaX;
                    sumDeltaY += errorData.ReceiverDeltaY;
                }
                pred.Valid = sumCount > 0.5;
                double dx = sumDeltaX / sumCount;
                double dy = sumDeltaY / sumCount;
                double dist = Math.sqrt(dx * dx + dy * dy);
                moved = dist > 0.5;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace.GeometryError errorData = ensemble.trace(n).geometryErrorData();
                    errorData.ReceiverX += dx;
                    errorData.ReceiverY += dy;
                }
            }
            EnsembleTrace.GeometryError errorData = ensemble.trace(0).geometryErrorData();
            pred.CurrentX = ensemble.trace(0).header().getDouble(this.m_indices.IndexRecX);
            pred.CurrentY = ensemble.trace(0).header().getDouble(this.m_indices.IndexRecY);
            pred.ShiftX = errorData.ReceiverX - pred.CurrentX;
            pred.ShiftY = errorData.ReceiverY - pred.CurrentY;
            if (writeToDatabase && pred.Valid) {
                Table_Abstract table = p.receiverTable();
                double dist = Math.sqrt(pred.ShiftX * pred.ShiftX + pred.ShiftY * pred.ShiftY + 0.01);
                double az = Math.atan2(pred.ShiftY, pred.ShiftX);
                p.geometryDatabase().confirmColumn_Double("Receiver", "GeomErr_Dist", 0.0);
                p.geometryDatabase().confirmColumn_Double("Receiver", "GeomErr_Az", 0.0);
                p.geometryDatabase().updateSingleRow_Double("Receiver", "GeomErr_Dist", pred.ElementID, dist);
                p.geometryDatabase().updateSingleRow_Double("Receiver", "GeomErr_Az", pred.ElementID, az);
                if (!table.column_exists("GeomErr_Dist")) {
                    table.column_append("GeomErr_Dist", DataType.Double);
                }
                if (!table.column_exists("GeomErr_Az")) {
                    table.column_append("GeomErr_Az", DataType.Double);
                }
                int colDist = table.column_indexOfColumn("GeomErr_Dist");
                int colAz = table.column_indexOfColumn("GeomErr_Az");
                int row = p.receiverMap().get(pred.ElementID);
                table.putDouble(row, colAz, az);
                table.putDouble(row, colDist, dist);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void computeGeometryCorrection_Shot(boolean writeToDatabase, Ensemble ensemble) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            boolean moved = true;
            Ensemble.PredictedCoordinates pred = ensemble.predictedCoordinates();
            pred.Valid = false;
            pred.ElementID = Tools_Ensemble.isShotEnsemble(ensemble);
            for (int loop = 0; moved && loop < 6; ++loop) {
                if (loop == 0 || p.UpdateBranchDuringGeomCorr) {
                    dtd.branchAssignment().assignBranch_UsingGeomErrorData(ensemble);
                }
                this.updateDelayTime(ensemble, true, false);
                this.computeGeometryErrorTerms(ensemble, loop == 0);
                double sumDeltaX = 0.0;
                double sumDeltaY = 0.0;
                double sumCount = 1.0E-20;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    EnsembleTrace.GeometryError errorData = trace.geometryErrorData();
                    if (!trace.traceOkay() || errorData.Branch < 1) continue;
                    sumCount += 1.0;
                    sumDeltaX += errorData.ShotDeltaX;
                    sumDeltaY += errorData.ShotDeltaY;
                }
                pred.Valid = sumCount > 0.5;
                double dx = sumDeltaX / sumCount;
                double dy = sumDeltaY / sumCount;
                double dist = Math.sqrt(dx * dx + dy * dy);
                moved = dist > 0.5;
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace.GeometryError errorData = ensemble.trace(n).geometryErrorData();
                    errorData.ShotX += dx;
                    errorData.ShotY += dy;
                }
            }
            EnsembleTrace.GeometryError errorData = ensemble.trace(0).geometryErrorData();
            pred.CurrentX = ensemble.trace(0).header().getDouble(this.m_indices.IndexShotX);
            pred.CurrentY = ensemble.trace(0).header().getDouble(this.m_indices.IndexShotY);
            pred.ShiftX = errorData.ShotX - pred.CurrentX;
            pred.ShiftY = errorData.ShotY - pred.CurrentY;
            if (writeToDatabase && pred.Valid) {
                Table_Abstract table = p.shotTable();
                double dist = Math.sqrt(pred.ShiftX * pred.ShiftX + pred.ShiftY * pred.ShiftY + 0.01);
                double az = Math.atan2(pred.ShiftY, pred.ShiftX);
                p.geometryDatabase().confirmColumn_Double("Shot", "GeomErr_Dist", 0.0);
                p.geometryDatabase().confirmColumn_Double("Shot", "GeomErr_Az", 0.0);
                p.geometryDatabase().updateSingleRow_Double("Shot", "GeomErr_Dist", pred.ElementID, dist);
                p.geometryDatabase().updateSingleRow_Double("Shot", "GeomErr_Az", pred.ElementID, az);
                if (!table.column_exists("GeomErr_Dist")) {
                    table.column_append("GeomErr_Dist", DataType.Double);
                }
                if (!table.column_exists("GeomErr_Az")) {
                    table.column_append("GeomErr_Az", DataType.Double);
                }
                int colDist = table.column_indexOfColumn("GeomErr_Dist");
                int colAz = table.column_indexOfColumn("GeomErr_Az");
                int row = p.shotMap().get(pred.ElementID);
                table.putDouble(row, colAz, az);
                table.putDouble(row, colDist, dist);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void computeGeometryCorrection(boolean writeToDatabase, Ensemble ensemble, String pickName) {
        try {
            long start = System.currentTimeMillis();
            this.m_indices.prep(ensemble);
            if (!ensemble.dictionary().containsEntry("Trace", pickName)) {
                return;
            }
            this.m_indices.IndexPick = ensemble.dictionary().getEntryIndex("Trace", pickName);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                EnsembleTrace.GeometryError errorData = trace.geometryErrorData();
                errorData.clear();
                errorData.ShotX = header.getDouble(this.m_indices.IndexShotX);
                errorData.ShotY = header.getDouble(this.m_indices.IndexShotY);
                errorData.ReceiverX = header.getDouble(this.m_indices.IndexRecX);
                errorData.ReceiverY = header.getDouble(this.m_indices.IndexRecY);
                errorData.Pick = header.getFloat(this.m_indices.IndexPick);
                for (int b = 0; b < 10; ++b) {
                    errorData.ReceiverDelayTime[b] = this.m_indices.IndexReceiverDelayTime[b] >= 0 ? header.getFloat(this.m_indices.IndexReceiverDelayTime[b]) : 0.0f;
                    errorData.ShotDelayTime[b] = this.m_indices.IndexShotDelayTime[b] >= 0 ? header.getFloat(this.m_indices.IndexShotDelayTime[b]) : 0.0f;
                }
                errorData.prepOffAz();
            }
            if (Tools_Ensemble.isShotEnsemble(ensemble) >= 1) {
                this.computeGeometryCorrection_Shot(writeToDatabase, ensemble);
            }
            if (Tools_Ensemble.isReceiverEnsemble(ensemble) >= 1) {
                this.computeGeometryCorrection_Receiver(writeToDatabase, ensemble);
            }
            long l = System.currentTimeMillis() - start;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected int computeGeometryErrorTerms(Ensemble ensemble, boolean firstPass) {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            int numOkay = 0;
            if (ensemble == null) {
                return numOkay;
            }
            if (dtd.branchAssignment().maxBranch() < 1) {
                return numOkay;
            }
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            ensemble.prepDelayTimeAnalysisIndices();
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                Column_Abstract header = trace.header();
                EnsembleTrace.GeometryError errorData = trace.geometryErrorData();
                errorData.clear();
                if (firstPass) {
                    errorData.InitialShotDeltaX = 0.0;
                    errorData.InitialShotDeltaY = 0.0;
                    errorData.InitialReceiverDeltaX = 0.0;
                    errorData.InitialReceiverDeltaY = 0.0;
                }
                int branch = errorData.Branch;
                float pick = errorData.Pick;
                if (branch < 1 || !(pick > 0.1f)) continue;
                double sx = errorData.ShotX;
                double sy = errorData.ShotY;
                double rx = errorData.ReceiverX;
                double ry = errorData.ReceiverY;
                double dx = rx - sx;
                double dy = ry - sy;
                float offset = (float)Math.sqrt(dx * dx + dy * dy + 1.0E-40);
                float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[branch]);
                float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[branch]);
                float vel = 0.5f * (recVel + shotVel);
                float travelTime = 1000.0f * offset / vel;
                float shotDT = errorData.ShotDelayTime[branch];
                float recDT = errorData.ReceiverDelayTime[branch];
                float upholeCorrection = ensemble.trace(n).header().getFloat(indexUpholeCorr);
                float wbCorrection = ensemble.trace(n).header().getFloat(indexWbCorr);
                pick = pick + upholeCorrection + wbCorrection;
                float error = pick - (travelTime + shotDT + recDT);
                float azimuth = header.getFloat(this.m_indices.IndexAzimuth);
                double shotDist = 0.001 * (double)error * (double)shotVel;
                errorData.ShotDeltaX = 0.0 - shotDist * Math.cos(azimuth);
                errorData.ShotDeltaY = 0.0 - shotDist * Math.sin(azimuth);
                double recDist = 0.001 * (double)error * (double)recVel;
                errorData.ReceiverDeltaX = recDist * Math.cos(azimuth);
                errorData.ReceiverDeltaY = recDist * Math.sin(azimuth);
                if (firstPass) {
                    errorData.InitialShotDeltaX = errorData.ShotDeltaX;
                    errorData.InitialShotDeltaY = errorData.ShotDeltaY;
                    errorData.InitialReceiverDeltaX = errorData.ReceiverDeltaX;
                    errorData.InitialReceiverDeltaY = errorData.ReceiverDeltaY;
                }
                ++numOkay;
            }
            return numOkay;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected int updateDelayTime(Ensemble ensemble, boolean updateShot, boolean updateRec) {
        try {
            EnsembleTrace.GeometryError errorData;
            int n;
            updateRec = !updateShot;
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            DelayTimeData dtd = p.getDelayTimeData();
            int numOkay = 0;
            if (ensemble == null) {
                return numOkay;
            }
            if (dtd.branchAssignment().maxBranch() < 1) {
                return numOkay;
            }
            for (int b = 0; b < this.m_sumDelayTime.length; ++b) {
                this.m_sumDelayTime[b] = 0.0;
                this.m_sumWeight[b] = 1.0E-40;
            }
            UpholeCorrection.singleton().compute(ensemble);
            int indexUpholeCorr = ensemble.dictionary().getEntryIndex("Shot", "UpholeCorrection");
            WaterBottomCorrection.singleton().compute(ensemble);
            int indexWbCorr = ensemble.dictionary().getEntryIndex("Trace", "WaterBottomCorrection");
            ensemble.prepDelayTimeAnalysisIndices();
            for (n = 0; n < ensemble.traceCount(); ++n) {
                errorData = ensemble.trace(n).geometryErrorData();
                Column_Abstract header = ensemble.trace(n).header();
                int branch = errorData.Branch;
                float pick = errorData.Pick;
                if (branch < 1 || !(pick > 0.1f)) continue;
                double sx = errorData.ShotX;
                double sy = errorData.ShotY;
                double rx = errorData.ReceiverX;
                double ry = errorData.ReceiverY;
                double dx = rx - sx;
                double dy = ry - sy;
                float offset = (float)Math.sqrt(dx * dx + dy * dy + 1.0E-40);
                float recVel = header.getFloat(ensemble.HeaderIndex_RecVel[branch]);
                float shotVel = header.getFloat(ensemble.HeaderIndex_ShotVel[branch]);
                float vel = 0.5f * (recVel + shotVel);
                float travelTime = 1000.0f * offset / vel;
                float shotDT = errorData.ShotDelayTime[branch];
                float recDT = errorData.ReceiverDelayTime[branch];
                float wbCorrection = ensemble.trace(n).header().getFloat(indexWbCorr);
                float upholeCorrection = ensemble.trace(n).header().getFloat(indexUpholeCorr);
                pick = pick + upholeCorrection + wbCorrection;
                float error = pick - (travelTime + shotDT + recDT);
                float ratio = Math.abs(error) / this.m_errorScalar;
                double weight = 1.0 / (1.0 + (double)(ratio * ratio));
                float predictedDelayTime = 0.0f;
                predictedDelayTime = updateShot ? pick - travelTime - recDT : pick - travelTime - shotDT;
                predictedDelayTime = Math.max(predictedDelayTime, 0.0f);
                this.m_sumDelayTime[branch] = this.m_sumDelayTime[branch] + (double)predictedDelayTime * weight;
                this.m_sumWeight[branch] = this.m_sumWeight[branch] + weight;
            }
            for (n = 0; n < ensemble.traceCount(); ++n) {
                int b;
                errorData = ensemble.trace(n).geometryErrorData();
                if (updateShot) {
                    for (b = 0; b < this.m_sumDelayTime.length; ++b) {
                        errorData.ShotDelayTime[b] = (float)(this.m_sumDelayTime[b] / this.m_sumWeight[b]);
                        errorData.ShotDelayTime[b] = Math.max(errorData.ShotDelayTime[b], 0.0f);
                    }
                    continue;
                }
                for (b = 0; b < this.m_sumDelayTime.length; ++b) {
                    errorData.ReceiverDelayTime[b] = (float)(this.m_sumDelayTime[b] / this.m_sumWeight[b]);
                    errorData.ReceiverDelayTime[b] = Math.max(errorData.ReceiverDelayTime[b], 0.0f);
                }
            }
            return numOkay;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }
}

