/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SolutionStackData {
    protected int m_magic = 2770071;
    protected double m_stackMinTime;
    protected double m_stackMaxTime;
    protected double m_stackDigi;
    protected int m_stackLength;
    protected int m_stackBranch;
    protected HashMap_Integers<StackData> m_shotHash = new HashMap_Integers();
    protected HashMap_Integers<StackData> m_recHash = new HashMap_Integers();
    protected float[] m_tempArray = new float[10];
    protected ArrayList<GroupData> m_groupList = new ArrayList();
    protected Ensemble m_groupEnsemble = new Ensemble();

    protected class GroupData {
        public String Label = "";
        public ArrayList<StackData> StackArray = new ArrayList();

        protected GroupData() {
        }
    }

    protected class StackData {
        public int ID;
        public int Count;
        public float[] Data;
        public float PickTime = -9999.0f;
        public double DelayTime;
        public double OriginalPolarity = 1.0;

        public void read(RandomAccessFile file) throws Exception {
            block9: {
                try {
                    int magic = file.readInt();
                    if (magic != SolutionStackData.this.m_magic) {
                        throw new Exception("magic != m_magic");
                    }
                    int version = file.readInt();
                    if (version == 1000) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.Data = new float[SolutionStackData.this.m_stackLength];
                        for (int n = 0; n < SolutionStackData.this.m_stackLength; ++n) {
                            this.Data[n] = file.readFloat();
                        }
                        break block9;
                    }
                    if (version == 1001) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.OriginalPolarity = file.readDouble();
                        this.Data = new float[SolutionStackData.this.m_stackLength];
                        for (int n = 0; n < SolutionStackData.this.m_stackLength; ++n) {
                            this.Data[n] = file.readFloat();
                        }
                        break block9;
                    }
                    if (version == 1002) {
                        this.ID = file.readInt();
                        this.Count = file.readInt();
                        this.DelayTime = file.readDouble();
                        this.OriginalPolarity = file.readDouble();
                        ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.Data.length);
                        file.read(buff.array(), 0, 4 * this.Data.length);
                        this.Data = new float[SolutionStackData.this.m_stackLength];
                        for (int n = 0; n < SolutionStackData.this.m_stackLength; ++n) {
                            this.Data[n] = buff.getFloat(4 * n);
                        }
                        break block9;
                    }
                    throw new Exception("Unrecognized version");
                }
                catch (Exception error) {
                    ExceptionMonitor.add(error);
                    throw error;
                }
            }
        }

        public void save(RandomAccessFile file) {
            try {
                int n;
                file.writeInt(SolutionStackData.this.m_magic);
                int version = 1002;
                file.writeInt(version);
                if (version == 1000) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    for (n = 0; n < this.Data.length; ++n) {
                        file.writeFloat(this.Data[n]);
                    }
                }
                if (version == 1001) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    file.writeDouble(this.OriginalPolarity);
                    for (n = 0; n < this.Data.length; ++n) {
                        file.writeFloat(this.Data[n]);
                    }
                }
                if (version == 1002) {
                    file.writeInt(this.ID);
                    file.writeInt(this.Count);
                    file.writeDouble(this.DelayTime);
                    file.writeDouble(this.OriginalPolarity);
                    ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 * this.Data.length);
                    for (int n2 = 0; n2 < this.Data.length; ++n2) {
                        buff.putFloat(n2 * 4, this.Data[n2]);
                    }
                    file.write(buff.array(), 0, 4 * this.Data.length);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

