/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosCore.Shared.PolygonUsage;
import com.PecosCore.Shared.Range_Double;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;

public class DelayTimeModel_StaticsInfo {
    public int MaxBranch;
    public String ColumnName = "";
    public WeatheringVelocityEnum WeatheringVelocity = WeatheringVelocityEnum.Normal;
    public Table_Abstract ElevationTable = new Table_Memory();
    public Table_Abstract VelocityTable = new Table_Memory();
    public IntermediateDatumEnum IntermediateDatum = IntermediateDatumEnum.FixedElevation;
    public String Intermediate_DatabaseColumn = "Elevation";
    public double Intermediate_FixedElevation = 0.0;
    public double Intermediate_FixedDepth = 0.0;
    public int Intermediate_RefractorNumber = 0;
    public boolean Intermediate_SmoothRefractor = false;
    public double Intermediate_SmoothRadius = 2000.0;
    public double Intermediate_DownwardDistance = 0.0;
    public double Intermediate_SurfaceSmoothRadius = 2000.0;
    public double Intermediate_SurfaceDownwardDistance = 1000.0;
    public FinalDatumEnum FinalDatum = FinalDatumEnum.FixedElevation;
    public String Final_DatabaseColumn = "Elevation";
    public double Final_FixedElevation = 0.0;
    public double Final_FixedDepth = 0.0;
    public double Final_FixedDepthSmoothRadius = 0.0;
    public double Final_ReplacementVelocity = 1000.0;
    public FinalShiftMethod ShiftMethod = FinalShiftMethod.None;
    public String TieStaticsColumn = "";
    public double m_sumStatic = 0.0;
    public double m_sumValid = 1.0E-20;
    public double m_averageStatic = 0.0;
    protected int[] m_indexZ = new int[20];
    protected int[] m_indexV = new int[20];
    protected int m_indexDepth;
    protected int m_indexWaterDepth;
    protected int m_indexStatic;
    protected int m_indexDatumIntermediate;
    protected int m_indexDatumFinal;
    protected double[] m_elevation = new double[20];
    protected double[] m_velocity = new double[20];
    protected double m_depth;
    protected double m_waterDepth;
    protected double m_waterVel;
    protected double m_startZ;
    protected double m_datumIntermediate;
    protected double m_datumFinal;
    protected int m_finalLayer;
    protected int m_startLayer;
    public IntermediateDatumComputationMethod ComputationMethod = IntermediateDatumComputationMethod.AlwaysUseDeepestRefractor;

    public String getIntermediateDatumDescription() {
        try {
            String s = this.IntermediateDatum.Description;
            if (this.IntermediateDatum == IntermediateDatumEnum.FixedElevation) {
                return s + ": " + Double.toString(this.Intermediate_FixedElevation);
            }
            if (this.IntermediateDatum == IntermediateDatumEnum.FixedDepth) {
                return s + ": " + Double.toString(this.Intermediate_FixedDepth);
            }
            if (this.IntermediateDatum == IntermediateDatumEnum.DatabaseColumn) {
                return s + " - " + this.Intermediate_DatabaseColumn;
            }
            if (this.IntermediateDatum == IntermediateDatumEnum.RefractorSurface) {
                if (this.Intermediate_SmoothRefractor) {
                    return String.format("%s: Refractor # %d, Smooth radius %f, Pushed down %f: ", this.IntermediateDatum.Description, this.Intermediate_RefractorNumber, Float.valueOf((float)this.Intermediate_SmoothRadius), Float.valueOf((float)this.Intermediate_DownwardDistance));
                }
                return String.format("%s: Refractor # %d, refractor surface not smoothed", this.IntermediateDatum.Description, this.Intermediate_RefractorNumber);
            }
            if (this.IntermediateDatum == IntermediateDatumEnum.Surface) {
                return String.format("%s: Smooth radius %f, Pushed down %f: ", this.IntermediateDatum.Description, Float.valueOf((float)this.Intermediate_SurfaceSmoothRadius), Float.valueOf((float)this.Intermediate_SurfaceDownwardDistance));
            }
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getIntermediateDatumDescription";
        }
    }

    public String getReplacementVelocityDescription() {
        try {
            return String.format("Replacement velocity %f", Float.valueOf((float)this.Final_ReplacementVelocity));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getReplacementVelocityDescription";
        }
    }

    public String getFinalDatumDescription() {
        try {
            String s = this.FinalDatum.Description;
            if (this.FinalDatum == FinalDatumEnum.DatabaseColumn) {
                return s + ": " + this.Final_DatabaseColumn;
            }
            if (this.FinalDatum == FinalDatumEnum.FixedElevation) {
                return s + ": " + Double.toString(this.Final_FixedElevation);
            }
            if (this.FinalDatum == FinalDatumEnum.FixedDepth) {
                if (this.Final_FixedDepthSmoothRadius < 5.0) {
                    return s + ": " + Double.toString(this.Final_FixedDepth) + " (unsmoothed)";
                }
                return s + ": " + Double.toString(this.Final_FixedDepth) + ", smooth radius = " + Double.toString(this.Final_FixedDepthSmoothRadius);
            }
            return s;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR getFinalDatumDescription";
        }
    }

    public DelayTimeModel_StaticsInfo() {
        try {
            int indexName = this.ElevationTable.column_append("Surface name", DataType.Text);
            int indexMin = this.ElevationTable.column_append("Minimum elevation", DataType.Double);
            int indexMax = this.ElevationTable.column_append("Maximum elevation", DataType.Double);
            this.VelocityTable.column_append("Layer", DataType.Text);
            this.VelocityTable.column_append("Minimum velocity", DataType.Double);
            this.VelocityTable.column_append("Maximum velocity", DataType.Double);
            this.reloadElevationTable();
            this.reloadVelocityTable();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadVelocityTable() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.MaxBranch = p.delayTimeData().branchAssignment().maxBranch();
            int indexName = this.VelocityTable.column_indexOfColumn("Layer");
            int indexMin = this.VelocityTable.column_indexOfColumn("Minimum velocity");
            int indexMax = this.VelocityTable.column_indexOfColumn("Maximum velocity");
            this.VelocityTable.row_clear(true);
            for (int b = 0; b <= this.MaxBranch; ++b) {
                int row = this.VelocityTable.row_increment();
                Range_Double range = Tools_RefractionStaticsProject.getRange(Pecos.getColNameVel(b), true, true);
                if (b == 0) {
                    this.VelocityTable.putString(row, indexName, "Weathering layer");
                } else {
                    this.VelocityTable.putString(row, indexName, String.format("Refractor %d", b));
                }
                if (!range.rangeValid()) continue;
                this.VelocityTable.putDouble(row, indexMin, range.rangeMin());
                this.VelocityTable.putDouble(row, indexMax, range.rangeMax());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void reloadElevationTable() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.MaxBranch = p.delayTimeData().branchAssignment().maxBranch();
            int indexName = this.ElevationTable.column_indexOfColumn("Surface name");
            int indexMin = this.ElevationTable.column_indexOfColumn("Minimum elevation");
            int indexMax = this.ElevationTable.column_indexOfColumn("Maximum elevation");
            this.ElevationTable.row_clear(true);
            for (int b = 0; b <= this.MaxBranch; ++b) {
                int row = this.ElevationTable.row_increment();
                Range_Double range = Tools_RefractionStaticsProject.getRange(Pecos.getColNameElev(b), true, true);
                if (b == 0) {
                    this.ElevationTable.putString(row, indexName, "Surface elevation");
                } else {
                    this.ElevationTable.putString(row, indexName, String.format("Refractor %d elevation", b));
                }
                this.ElevationTable.putDouble(row, indexMin, range.rangeMin());
                this.ElevationTable.putDouble(row, indexMax, range.rangeMax());
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void prepIndices(Table_Abstract table) throws Exception {
        try {
            this.m_indexStatic = table.column_indexOfColumn(this.ColumnName);
            this.m_indexDatumIntermediate = table.column_indexOfColumn("Datum_Intermediate");
            this.m_indexDatumFinal = table.column_indexOfColumn("Datum_Final");
            this.m_indexWaterDepth = -9999;
            if (table.column_exists("WaterDepth")) {
                this.m_indexWaterDepth = table.column_indexOfColumn("WaterDepth");
            }
            this.m_indexWaterDepth = -9999;
            if (table.column_exists("WaterDepth")) {
                this.m_indexWaterDepth = table.column_indexOfColumn("WaterDepth");
            }
            this.m_indexDepth = -9999;
            if (table.column_exists("PointDepth")) {
                this.m_indexDepth = table.column_indexOfColumn("PointDepth");
            }
            for (int b = 0; b <= this.MaxBranch; ++b) {
                this.m_indexZ[b] = table.column_indexOfColumn(Pecos.getColNameElev(b));
                this.m_indexV[b] = table.column_indexOfColumn(Pecos.getColNameVel(b));
            }
            if (this.WeatheringVelocity == WeatheringVelocityEnum.AnisotropicFast && table.column_exists("DTA_AnisFastV0")) {
                this.m_indexV[0] = table.column_indexOfColumn("DTA_AnisFastV0");
            }
            if (this.WeatheringVelocity == WeatheringVelocityEnum.AnisotropicSlow && table.column_exists("DTA_AnisSlowV0")) {
                this.m_indexV[0] = table.column_indexOfColumn("DTA_AnisSlowV0");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepValues(Table_Abstract table, int row) throws Exception {
        try {
            for (int b = 0; b <= this.MaxBranch; ++b) {
                this.m_elevation[b] = table.getDouble(row, this.m_indexZ[b]);
                this.m_velocity[b] = table.getDouble(row, this.m_indexV[b]);
            }
            this.m_datumIntermediate = table.getDouble(row, this.m_indexDatumIntermediate);
            this.m_datumFinal = table.getDouble(row, this.m_indexDatumFinal);
            this.m_waterDepth = 0.0;
            if (this.m_indexWaterDepth >= 0) {
                this.m_waterDepth = table.getDouble(row, this.m_indexWaterDepth);
            }
            this.m_waterDepth = Math.max(this.m_waterDepth, 0.0);
            this.m_depth = 0.0;
            if (this.m_indexDepth >= 0) {
                this.m_depth = table.getDouble(row, this.m_indexDepth);
            }
            this.m_depth = Math.max(this.m_depth, 0.0);
            this.m_waterDepth = 0.0;
            if (this.m_indexWaterDepth >= 0) {
                this.m_waterDepth = table.getDouble(row, this.m_indexWaterDepth);
            }
            this.m_waterDepth = Math.max(this.m_waterDepth, 0.0);
            this.m_startZ = this.m_elevation[0] - this.m_depth;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected int findLayer(double z) throws Exception {
        try {
            if (z >= this.m_elevation[1]) {
                return 0;
            }
            if (z <= this.m_elevation[this.MaxBranch]) {
                return this.MaxBranch;
            }
            for (int b = 2; b <= this.MaxBranch; ++b) {
                if (!(z >= this.m_elevation[b])) continue;
                return b - 1;
            }
            return this.MaxBranch;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float computeTimeFromStartToIntermediate_Newer(double intermediateDatum) throws Exception {
        try {
            double waterBottomZ;
            double top = Math.max(this.m_startZ, intermediateDatum);
            double bottom = Math.min(this.m_startZ, intermediateDatum);
            if (this.m_startZ <= this.m_elevation[this.MaxBranch]) {
                return (float)(1000.0 * (intermediateDatum - this.m_startZ) / this.m_velocity[this.MaxBranch]);
            }
            double currentZ = this.m_startZ;
            float timeToWaterBottom = 0.0f;
            if (this.m_waterDepth >= 1.0 && currentZ > (waterBottomZ = this.m_elevation[0] - this.m_waterDepth)) {
                timeToWaterBottom = (float)(1000.0 * (currentZ - waterBottomZ) / this.m_waterVel);
                currentZ = waterBottomZ;
            }
            double timeToLowestRefractor = 0.0;
            for (int currentBranch = 1; currentBranch <= this.MaxBranch; ++currentBranch) {
                if (!(currentZ > this.m_elevation[currentBranch])) continue;
                double time = 1000.0 * (currentZ - this.m_elevation[currentBranch]) / this.m_velocity[currentBranch - 1];
                timeToLowestRefractor += time;
                currentZ = this.m_elevation[currentBranch];
            }
            double timeToDatum = 1000.0 * (this.m_elevation[this.MaxBranch] - intermediateDatum) / this.m_velocity[this.MaxBranch];
            double totalTime = (double)timeToWaterBottom + timeToLowestRefractor + timeToDatum;
            return -((float)totalTime);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float computeTimeFromStartToIntermediate_New(double intermediateDatum) throws Exception {
        try {
            double waterBottomZ;
            if (this.m_startZ <= this.m_elevation[this.MaxBranch]) {
                return (float)(1000.0 * (intermediateDatum - this.m_startZ) / this.m_velocity[this.MaxBranch]);
            }
            double currentZ = this.m_startZ;
            float timeToWaterBottom = 0.0f;
            if (this.m_waterDepth >= 1.0 && currentZ > (waterBottomZ = this.m_elevation[0] - this.m_waterDepth)) {
                timeToWaterBottom = (float)(1000.0 * (currentZ - waterBottomZ) / this.m_waterVel);
                currentZ = waterBottomZ;
            }
            double timeToLowestRefractor = 0.0;
            for (int currentBranch = 1; currentBranch <= this.MaxBranch; ++currentBranch) {
                if (!(currentZ > this.m_elevation[currentBranch])) continue;
                double time = 1000.0 * (currentZ - this.m_elevation[currentBranch]) / this.m_velocity[currentBranch - 1];
                timeToLowestRefractor += time;
                currentZ = this.m_elevation[currentBranch];
            }
            double timeToDatum = 1000.0 * (this.m_elevation[this.MaxBranch] - intermediateDatum) / this.m_velocity[this.MaxBranch];
            double totalTime = (double)timeToWaterBottom + timeToLowestRefractor + timeToDatum;
            return -((float)totalTime);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float computeTimeFromStartToIntermediate_Old(double finalZ) throws Exception {
        try {
            int finalLayer;
            int startLayer;
            float timeToWaterBottom = 0.0f;
            if (this.m_waterDepth >= 1.0) {
                double waterBottomZ = this.m_elevation[0] - this.m_waterDepth;
                timeToWaterBottom = this.m_startZ > waterBottomZ ? (float)(1000.0 * (this.m_startZ - waterBottomZ) / this.m_waterVel) : (float)(1000.0 * (this.m_startZ - waterBottomZ) / this.m_velocity[0]);
                this.m_startZ = waterBottomZ;
            }
            if ((startLayer = this.findLayer(this.m_startZ)) == (finalLayer = this.findLayer(finalZ))) {
                return (float)(1000.0 * (finalZ - this.m_startZ) / this.m_velocity[finalLayer]);
            }
            if (startLayer > finalLayer) {
                float timeStart = (float)(1000.0 * (this.m_elevation[startLayer] - this.m_startZ) / this.m_velocity[startLayer]);
                float timeFinal = (float)(1000.0 * (finalZ - this.m_elevation[finalLayer + 1]) / this.m_velocity[finalLayer]);
                float timeMiddle = 0.0f;
                for (int layer = finalLayer + 1; layer < startLayer; ++layer) {
                    float time = (float)(1000.0 * (this.m_elevation[layer] - this.m_elevation[layer + 1]) / this.m_velocity[layer]);
                    timeMiddle += time;
                }
                return timeMiddle + timeStart + timeFinal;
            }
            float timeFinal = (float)(1000.0 * (this.m_elevation[finalLayer] - finalZ) / this.m_velocity[finalLayer]);
            float timeStart = (float)(1000.0 * (this.m_startZ - this.m_elevation[startLayer + 1]) / this.m_velocity[startLayer]);
            float timeMiddle = 0.0f;
            for (int layer = startLayer + 1; layer < finalLayer; ++layer) {
                float time = (float)(1000.0 * (this.m_elevation[layer] - this.m_elevation[layer + 1]) / this.m_velocity[layer]);
                timeMiddle += time;
            }
            return -(timeMiddle + timeStart + timeFinal + timeToWaterBottom);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeStatics() throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            this.m_waterVel = p.getWaterVelocity();
            Tools_RefractionStaticsProject.setColumnValue_Double("Datum_Final", -999999.0);
            Tools_RefractionStaticsProject.setColumnValue_Double("Datum_Intermediate", -999999.0);
            this.setStaticToZero(p.receiverTable());
            this.setStaticToZero(p.shotTable());
            if (this.IntermediateDatum == IntermediateDatumEnum.FixedDepth) {
                this.computeIntermediateDatum_FixedDepth(p.receiverTable());
                this.computeIntermediateDatum_FixedDepth(p.shotTable());
            } else if (this.IntermediateDatum == IntermediateDatumEnum.DatabaseColumn) {
                this.computeIntermediateDatum_Database();
            } else if (this.IntermediateDatum == IntermediateDatumEnum.Surface) {
                this.computeIntermediateDatum_SmoothedSurface();
            } else if (this.IntermediateDatum == IntermediateDatumEnum.RefractorSurface) {
                if (!this.Intermediate_SmoothRefractor) {
                    this.computeIntermediateDatum_RefractorSurface(p.receiverTable());
                    this.computeIntermediateDatum_RefractorSurface(p.shotTable());
                } else {
                    this.computeIntermediateDatum_SmoothedRefractorSurface();
                }
            } else {
                Tools_RefractionStaticsProject.setColumnValue_Double("Datum_Intermediate", this.Intermediate_FixedElevation);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), "Datum_Intermediate");
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), "Datum_Intermediate");
            this.computeIntermediateStatics(p.shotTable());
            this.computeIntermediateStatics(p.receiverTable());
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), "Time_Intermediate");
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), "Time_Intermediate");
            this.m_sumStatic = 0.0;
            this.m_sumValid = 1.0E-40;
            if (this.FinalDatum == FinalDatumEnum.FixedElevation) {
                this.computeFinalDatum_FixedElevation(p.receiverTable());
                this.computeFinalDatum_FixedElevation(p.shotTable());
            } else if (this.FinalDatum == FinalDatumEnum.DatabaseColumn) {
                this.computeFinalDatum_Database();
            } else {
                this.computeFinalDatum_FixedDepth(p.receiverTable());
                this.computeFinalDatum_FixedDepth(p.shotTable());
                if (this.Final_FixedDepthSmoothRadius > 3.0) {
                    Tools_RefractionStaticsProject.smoothColumn("Datum_Final", -9.9999999E7, this.Final_FixedDepthSmoothRadius, PolygonUsage.NotUsed);
                }
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), "Datum_Final");
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), "Datum_Final");
            this.computeFinalStatics_FromIntermediateDatum(p.receiverTable());
            this.computeFinalStatics_FromIntermediateDatum(p.shotTable());
            this.m_averageStatic = this.m_sumStatic / this.m_sumValid;
            if (this.ShiftMethod == FinalShiftMethod.ZeroMean) {
                this.subtractAverage(p.receiverTable());
                this.subtractAverage(p.shotTable());
            }
            if (this.ShiftMethod == FinalShiftMethod.TieToAnother && p.shotTable().column_exists(this.TieStaticsColumn)) {
                double avg = Tools_RefractionStaticsProject.computeAverage(this.TieStaticsColumn, -1.0E20, 1.0E20);
                double shift = avg - this.m_averageStatic;
                this.addShift(p.shotTable(), (float)shift);
                this.addShift(p.receiverTable(), (float)shift);
            }
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), this.ColumnName);
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), this.ColumnName);
            this.computeEffectiveRepVel(p.receiverTable());
            this.computeEffectiveRepVel(p.shotTable());
            p.geometryDatabase().writeColumnContentsToDatabase(p.shotTable(), "EffectiveRepVel");
            p.geometryDatabase().writeColumnContentsToDatabase(p.receiverTable(), "EffectiveRepVel");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeEffectiveRepVel(Table_Abstract table) {
        try {
            int indexTI = table.column_indexOfColumn("Time_Intermediate");
            int indexS = table.column_indexOfColumn(this.ColumnName);
            int indexID = table.column_indexOfColumn("Datum_Intermediate");
            int indexFD = table.column_indexOfColumn("Datum_Final");
            int indexEV = table.column_append("EffectiveRepVel", DataType.Float);
            for (int row = 0; row < table.row_count(); ++row) {
                float timeInt = table.getFloat(row, indexTI);
                float stat = table.getFloat(row, indexS);
                float id = table.getFloat(row, indexID);
                float fd = table.getFloat(row, indexFD);
                float t = Math.abs(stat + timeInt);
                float v = 1000.0f * Math.abs(id - fd) / t;
                table.putFloat(row, indexEV, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeFinalDatum_FixedElevation(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putDouble(row, this.m_indexDatumFinal, this.Final_FixedElevation);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeFinalDatum_FixedDepth(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                double surface = table.getDouble(row, this.m_indexZ[0]);
                this.m_datumFinal = surface - this.Final_FixedDepth;
                table.putDouble(row, this.m_indexDatumFinal, this.m_datumFinal);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeFinalStatics_FromIntermediateDatum(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            float maxStatic = -1000000.0f;
            float minStatic = 1000000.0f;
            int numHuge = 0;
            int indexKilled = table.column_indexOfColumn("Killed");
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                double shift = 1000.0 * (this.m_datumFinal - this.m_datumIntermediate) / this.Final_ReplacementVelocity;
                float currentStatic = table.getFloat(row, this.m_indexStatic);
                float totalStatic = currentStatic + (float)shift;
                if (!table.getBool(row, indexKilled)) {
                    this.m_sumStatic += (double)totalStatic;
                    this.m_sumValid += 1.0;
                }
                table.putFloat(row, this.m_indexStatic, totalStatic);
            }
            String s = String.format("computeFinalStatics_FromIntermediateDatum %f  to %f   %d", Float.valueOf(minStatic), Float.valueOf(maxStatic), numHuge);
            System.out.println(s);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addShift(Table_Abstract table, float shift) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                float stat = table.getFloat(row, this.m_indexStatic);
                table.putFloat(row, this.m_indexStatic, stat += shift);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void subtractAverage(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            for (int row = 0; row < table.row_count(); ++row) {
                float stat = table.getFloat(row, this.m_indexStatic);
                table.putFloat(row, this.m_indexStatic, stat -= (float)this.m_averageStatic);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_SmoothedRefractorSurface() throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.computeIntermediateDatum_RefractorSurface(project.receiverTable());
            this.computeIntermediateDatum_RefractorSurface(project.shotTable());
            double smoothRadius = this.Intermediate_SmoothRadius;
            smoothRadius = Math.max(smoothRadius, 1.0);
            Tools_RefractionStaticsProject.smoothColumn("Datum_Intermediate", -9.9999999E7, smoothRadius, PolygonUsage.NotUsed);
            double downShift = this.Intermediate_DownwardDistance;
            Tools_RefractionStaticsProject.shiftColumnValue_Double("Datum_Intermediate", -downShift);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_SmoothedSurface() throws Exception {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.computeIntermediateDatum_Surface(project.receiverTable());
            this.computeIntermediateDatum_Surface(project.shotTable());
            double smoothRadius = this.Intermediate_SurfaceSmoothRadius;
            smoothRadius = Math.max(smoothRadius, 1.0);
            Tools_RefractionStaticsProject.smoothColumn("Datum_Intermediate", -9.9999999E7, smoothRadius, PolygonUsage.NotUsed);
            double downShift = this.Intermediate_SurfaceDownwardDistance;
            Tools_RefractionStaticsProject.shiftColumnValue_Double("Datum_Intermediate", -downShift);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_Surface(Table_Abstract table) throws Exception {
        try {
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int indexSurface = table.column_indexOfColumn("Elevation");
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                table.putDouble(row, indexDatum, surface);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_RefractorSurface(Table_Abstract table) throws Exception {
        try {
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int indexSurface = table.column_indexOfColumn(Pecos.getColNameElev(this.Intermediate_RefractorNumber));
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                table.putDouble(row, indexDatum, surface);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateStatics(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            int indexIntermediateStatic = table.column_append("Time_Intermediate", DataType.Float);
            for (int row = 0; row < table.row_count(); ++row) {
                this.prepValues(table, row);
                float time = 0.0f;
                if (this.ComputationMethod == IntermediateDatumComputationMethod.AlwaysUseDeepestRefractor) {
                    time = this.computeTimeFromStartToIntermediate_New(this.m_datumIntermediate);
                }
                if (this.ComputationMethod == IntermediateDatumComputationMethod.JustUseIntermediateDatum) {
                    time = this.computeTimeFromStartToIntermediate_Old(this.m_datumIntermediate);
                }
                table.putFloat(row, this.m_indexStatic, time);
                table.putFloat(row, indexIntermediateStatic, -time);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeFinalDatum_Database() throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract t = p.shotTable();
                if (iter == 0) {
                    t = p.receiverTable();
                }
                int indexDatum = t.column_indexOfColumn("Datum_Final");
                int indexCol = t.column_indexOfColumn(this.Final_DatabaseColumn);
                for (int row = 0; row < t.row_count(); ++row) {
                    double v = t.getDouble(row, indexCol);
                    t.putDouble(row, indexDatum, v);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_Database() throws Exception {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract t = p.shotTable();
                if (iter == 0) {
                    t = p.receiverTable();
                }
                int indexDatum = t.column_indexOfColumn("Datum_Intermediate");
                int indexCol = t.column_indexOfColumn(this.Intermediate_DatabaseColumn);
                for (int row = 0; row < t.row_count(); ++row) {
                    double v = t.getDouble(row, indexCol);
                    t.putDouble(row, indexDatum, v);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeIntermediateDatum_FixedDepth(Table_Abstract table) throws Exception {
        try {
            this.prepIndices(table);
            int indexDatum = table.column_indexOfColumn("Datum_Intermediate");
            int indexSurface = table.column_indexOfColumn(Pecos.getColNameElev(0));
            for (int row = 0; row < table.row_count(); ++row) {
                double surface = table.getDouble(row, indexSurface);
                double intermediateDepth = surface - this.Intermediate_FixedDepth;
                table.putDouble(row, indexDatum, intermediateDepth);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void setStaticToZero(Table_Abstract table) throws Exception {
        try {
            int indexStatic = table.column_append(this.ColumnName, DataType.Float);
            for (int row = 0; row < table.row_count(); ++row) {
                table.putFloat(row, indexStatic, 0.0f);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static enum IntermediateDatumEnum {
        FixedElevation("Intermediate datum at a constant elevation"),
        FixedDepth("Intermediate datum at a fixed depth below the surface"),
        RefractorSurface("Intermediate datum at a refractor surface"),
        Surface("Intermediate datum at surface (smoothed and shifted down!)"),
        DatabaseColumn("Use database column");

        public final String Description;

        private IntermediateDatumEnum(String s) {
            this.Description = s;
        }
    }

    public static enum FinalDatumEnum {
        FixedElevation("Final datum at a constant elevation"),
        FixedDepth("Final datum at a fixed depth below the (smoothed) surface"),
        DatabaseColumn("Use database column");

        public final String Description;

        private FinalDatumEnum(String s) {
            this.Description = s;
        }
    }

    public static enum WeatheringVelocityEnum {
        Normal,
        AnisotropicFast,
        AnisotropicSlow;

    }

    public static enum FinalShiftMethod {
        None,
        ZeroMean,
        TieToAnother;

    }

    public static enum IntermediateDatumComputationMethod {
        AlwaysUseDeepestRefractor,
        JustUseIntermediateDatum;

    }
}

