/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Refraction.DelayTime;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Pecos;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class DelayTimeAnisotropy {
    public static void computeV0() {
        try {
            DelayTimeAnisotropy.computeV0(RefractionStaticsProject.singleton().receiverTable());
            DelayTimeAnisotropy.computeV0(RefractionStaticsProject.singleton().shotTable());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void computeV0(Table_Abstract table) {
        try {
            int indexAnis = table.column_indexOfColumn(Pecos.getColNameDtAnisMag(1));
            int indexV0 = table.column_indexOfColumn(Pecos.getColNameVel(0));
            int indexV1 = table.column_indexOfColumn(Pecos.getColNameVel(1));
            int indexDT = table.column_indexOfColumn(Pecos.getColNameDT(1));
            int indexFast = table.column_append("DTA_AnisFastV0", DataType.Double);
            int indexSlow = table.column_append("DTA_AnisSlowV0", DataType.Double);
            for (int n = 0; n < table.row_count(); ++n) {
                double v0 = table.getDouble(n, indexV0);
                double v1 = table.getDouble(n, indexV1);
                v0 = Math.max(0.1 * v1, v0);
                v0 = Math.min(0.99 * v1, v0);
                double dt = table.getDouble(n, indexDT);
                double anis = table.getDouble(n, indexAnis);
                dt = Math.max(1.0, dt);
                double h = 0.001 * dt * (v1 * v0) / Math.sqrt(v1 * v1 - v0 * v0);
                double dt1 = Math.max(0.001, 0.001 * (dt + anis));
                double dt2 = Math.max(0.001, 0.001 * (dt - anis));
                double v01 = h * v1 / Math.sqrt(h * h + dt1 * dt1 * v1 * v1);
                double v02 = h * v1 / Math.sqrt(h * h + dt2 * dt2 * v1 * v1);
                double fast = Math.max(v01, v02);
                double slow = Math.min(v01, v02);
                table.putDouble(n, indexFast, fast);
                table.putDouble(n, indexSlow, slow);
            }
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(table, "DTA_AnisFastV0");
            RefractionStaticsProject.singleton().geometryDatabase().writeColumnContentsToDatabase(table, "DTA_AnisSlowV0");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

