/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import java.math.BigInteger;
import java.security.SecureRandom;

public class RSA {
    protected BigInteger m_product;
    protected BigInteger m_privateKey;
    protected BigInteger m_publicKey;

    public RSA(int bitLength) {
        try {
            bitLength = Math.max(32, bitLength);
            bitLength = Math.min(2048, bitLength);
            SecureRandom r = new SecureRandom();
            BigInteger p = new BigInteger(bitLength / 2, 100, r);
            BigInteger q = new BigInteger(bitLength / 2, 100, r);
            this.m_product = p.multiply(q);
            BigInteger pMinusOne = p.subtract(BigInteger.ONE);
            BigInteger qMinusOne = q.subtract(BigInteger.ONE);
            BigInteger totient = pMinusOne.multiply(qMinusOne);
            this.m_publicKey = new BigInteger("3");
            while (totient.gcd(this.m_publicKey).intValue() > 1) {
                this.m_publicKey = this.m_publicKey.add(new BigInteger("2"));
            }
            this.m_privateKey = this.m_publicKey.modInverse(totient);
            System.out.println("p = " + p.toString());
            System.out.println("q = " + q.toString());
            System.out.println("m_privateKey = " + this.m_privateKey.toString());
            System.out.println("m_publicKey = " + this.m_publicKey.toString());
            System.out.println("m_product = " + this.m_product.toString());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public BigInteger encrypt(BigInteger message) {
        return message.modPow(this.m_publicKey, this.m_product);
    }

    public BigInteger decrypt(BigInteger message) {
        return message.modPow(this.m_privateKey, this.m_product);
    }
}

