/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Matrix_Simple;

public class PlanarFit {
    public double A;
    public double B;
    public double C;
    protected Table_Abstract m_table = new Table_Memory();
    protected int m_indexX = 0;
    protected int m_indexY = 0;
    protected int m_indexZ = 0;

    public PlanarFit() {
        try {
            this.m_indexX = this.m_table.column_append("X", DataType.Double);
            this.m_indexY = this.m_table.column_append("Y", DataType.Double);
            this.m_indexZ = this.m_table.column_append("Z", DataType.Double);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public double errorL1() throws Exception {
        try {
            double sum1 = 0.0;
            double sum2 = 1.0E-40;
            for (int row = 0; row < this.m_table.row_count(); ++row) {
                double x = this.m_table.getDouble(row, this.m_indexX);
                double y = this.m_table.getDouble(row, this.m_indexY);
                double z = this.m_table.getDouble(row, this.m_indexZ);
                double pred = this.A * x + this.B * y + this.C;
                double error = pred - z;
                sum1 += Math.abs(error);
                sum2 += 1.0;
            }
            return sum1 / sum2;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public double errorL2() throws Exception {
        try {
            double sum1 = 0.0;
            double sum2 = 1.0E-40;
            for (int row = 0; row < this.m_table.row_count(); ++row) {
                double x = this.m_table.getDouble(row, this.m_indexX);
                double y = this.m_table.getDouble(row, this.m_indexY);
                double z = this.m_table.getDouble(row, this.m_indexZ);
                double pred = this.A * x + this.B * y + this.C;
                double error = pred - z;
                sum1 += error * error;
                sum2 += 1.0;
            }
            return Math.sqrt(sum1 / sum2);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void leastSquaredFit() throws Exception {
        try {
            if (this.m_table.row_count() < 3) {
                throw new Exception("m_table.row_count() < 3");
            }
            double sumX = 0.0;
            double sumY = 0.0;
            double sumZ = 0.0;
            double sumXY = 0.0;
            double sumXX = 0.0;
            double sumYY = 0.0;
            double sumYZ = 0.0;
            double sumXZ = 0.0;
            double sumN = 0.0;
            for (int row = 0; row < this.m_table.row_count(); ++row) {
                double x = this.m_table.getDouble(row, this.m_indexX);
                double y = this.m_table.getDouble(row, this.m_indexY);
                double z = this.m_table.getDouble(row, this.m_indexZ);
                sumN += 1.0;
                sumXY += x * y;
                sumXZ += x * z;
                sumXX += x * x;
                sumYY += y * y;
                sumYZ += y * z;
                sumX += x;
                sumY += y;
                sumZ += z;
            }
            Matrix_Simple matrixMain = new Matrix_Simple(3, 3);
            matrixMain.Data[0][0] = sumXX;
            matrixMain.Data[0][1] = sumXY;
            matrixMain.Data[0][2] = sumX;
            matrixMain.Data[1][0] = sumXY;
            matrixMain.Data[1][1] = sumYY;
            matrixMain.Data[1][2] = sumY;
            matrixMain.Data[2][0] = sumX;
            matrixMain.Data[2][1] = sumY;
            matrixMain.Data[2][2] = sumN;
            Matrix_Simple matrixLeftX = new Matrix_Simple(3, 1);
            matrixLeftX.Data[0][0] = sumXZ;
            matrixLeftX.Data[1][0] = sumYZ;
            matrixLeftX.Data[2][0] = sumZ;
            Matrix_Simple matrixRightX = matrixMain.solve(matrixLeftX);
            this.A = matrixRightX.Data[0][0];
            this.B = matrixRightX.Data[1][0];
            this.C = matrixRightX.Data[2][0];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void add(double x, double y, double z) {
        try {
            int row = this.m_table.row_increment();
            this.m_table.putDouble(row, this.m_indexX, x);
            this.m_table.putDouble(row, this.m_indexY, y);
            this.m_table.putDouble(row, this.m_indexZ, z);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void clear() {
        try {
            this.m_table.row_clear(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

