/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Map.HashMap_Integers;
import java.util.ArrayList;

public class InversePowerInterpolator {
    protected double m_radius;
    protected double[] m_x;
    protected double[] m_y;
    protected double[] m_v;
    protected double[] m_w;
    protected int m_numValid = 0;
    protected HashMap_Integers<ArrayList<Integer>> m_hash;
    public int MaxIndexX = Integer.MIN_VALUE;
    public int MinIndexX = Integer.MAX_VALUE;
    public int MaxIndexY = Integer.MIN_VALUE;
    public int MinIndexY = Integer.MAX_VALUE;

    public InversePowerInterpolator(double radius, int maxCount) {
        try {
            this.m_radius = Math.max(radius, 20.0);
            this.m_hash = new HashMap_Integers();
            this.m_x = new double[maxCount];
            this.m_y = new double[maxCount];
            this.m_v = new double[maxCount];
            this.m_w = new double[maxCount];
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(Table_Abstract table, String colValue, String colWeight) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colValue);
            int indexKilled = table.column_indexOfColumn("Killed");
            int indexW = -99;
            if (table.column_exists(colWeight)) {
                indexW = table.column_indexOfColumn(colWeight);
            }
            for (int n = 0; n < table.row_count(); ++n) {
                if (table.getBool(n, indexKilled)) continue;
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                double v = table.getDouble(n, indexV);
                double w = 1.0;
                if (indexW >= 0) {
                    w = table.getDouble(n, indexW);
                }
                this.add(x, y, v, w);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(double x, double y, double v, double w) {
        try {
            this.m_x[this.m_numValid] = x;
            this.m_y[this.m_numValid] = y;
            this.m_v[this.m_numValid] = v;
            this.m_w[this.m_numValid] = w;
            int ix = (int)(x / this.m_radius);
            int iy = (int)(y / this.m_radius);
            if (!this.m_hash.containsKey(ix, iy)) {
                this.m_hash.put(new ArrayList(), ix, iy);
            }
            ArrayList<Integer> list = this.m_hash.get(ix, iy);
            list.add(new Integer(this.m_numValid));
            ++this.m_numValid;
            this.MaxIndexX = Math.max(this.MaxIndexX, ix);
            this.MinIndexX = Math.min(this.MinIndexX, ix);
            this.MaxIndexY = Math.max(this.MaxIndexY, iy);
            this.MinIndexY = Math.min(this.MinIndexY, iy);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void get(Table_Abstract table, String colValue, boolean inverseSquare) {
        try {
            int indexX = table.column_indexOfColumn("Easting");
            int indexY = table.column_indexOfColumn("Northing");
            int indexV = table.column_indexOfColumn(colValue);
            for (int n = 0; n < table.row_count(); ++n) {
                double x = table.getDouble(n, indexX);
                double y = table.getDouble(n, indexY);
                if (inverseSquare) {
                    table.putDouble(n, indexV, this.getInverseSquare(x, y));
                    continue;
                }
                table.putDouble(n, indexV, this.getInverseFourth(x, y));
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public double getInverseFourth(double x, double y) {
        try {
            int ix = (int)(x / this.m_radius);
            int iy = (int)(y / this.m_radius);
            double sum1 = 0.0;
            double sum2 = 1.0E-30;
            int rad = 4;
            for (int ix1 = ix - rad; ix1 <= ix + rad; ++ix1) {
                for (int iy1 = iy - rad; iy1 <= iy + rad; ++iy1) {
                    if (!this.m_hash.containsKey(ix1, iy1)) continue;
                    ArrayList<Integer> list = this.m_hash.get(ix1, iy1);
                    for (Integer i : list) {
                        int index = i;
                        double dx = x - this.m_x[index];
                        double dy = y - this.m_y[index];
                        double weight = this.m_radius / (this.m_radius + Math.sqrt(1.0E-20 + dx * dx + dy * dy));
                        weight = weight * weight * weight * weight * this.m_w[index];
                        sum1 += weight * this.m_v[index];
                        sum2 += weight;
                    }
                }
            }
            return sum1 / sum2;
        }
        catch (Exception error) {
            error.printStackTrace();
            return -9999.0;
        }
    }

    public double getInverseSquare(double x, double y) {
        try {
            int ix = (int)(x / this.m_radius);
            int iy = (int)(y / this.m_radius);
            double sum1 = 0.0;
            double sum2 = 1.0E-30;
            int rad = 6;
            for (int ix1 = ix - rad; ix1 <= ix + rad; ++ix1) {
                for (int iy1 = iy - rad; iy1 <= iy + rad; ++iy1) {
                    if (!this.m_hash.containsKey(ix1, iy1)) continue;
                    ArrayList<Integer> list = this.m_hash.get(ix1, iy1);
                    for (Integer i : list) {
                        int index = i;
                        double dx = x - this.m_x[index];
                        double dy = y - this.m_y[index];
                        double weight = this.m_radius / (this.m_radius + Math.sqrt(1.0E-20 + dx * dx + dy * dy));
                        weight = weight * weight * this.m_w[index];
                        sum1 += weight * this.m_v[index];
                        sum2 += weight;
                    }
                }
            }
            return sum1 / sum2;
        }
        catch (Exception error) {
            error.printStackTrace();
            return -9999.0;
        }
    }
}

