/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.IGrid2D_Conversion;

public class Grid2D_Conversion_Line
implements IGrid2D_Conversion {
    protected double m_originX = 0.0;
    protected double m_originY = 0.0;
    protected double m_angle = 0.0;
    protected double m_angleSin = 0.0;
    protected double m_angleCos = 1.0;
    protected double m_binSize = 100.0;
    protected double m_maxX = 0.0;
    protected double m_maxY = 0.0;
    protected int m_minBin = Integer.MAX_VALUE;
    protected int m_maxBin = Integer.MIN_VALUE;
    public static final String FileName = "GridDefinition2D.xml";
    public static final String OriginX = "OriginX";
    public static final String OriginY = "OriginY";
    public static final String Size = "Size";
    public static final String Angle = "Angle";

    public double maxX() {
        return this.m_maxX;
    }

    public double maxY() {
        return this.m_maxY;
    }

    public double distanceFromOrigin(double x, double y) {
        try {
            double s = this.m_angleCos * (x - this.m_originX) + this.m_angleSin * (y - this.m_originY);
            return s;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public double distanceFromLine(double x, double y) {
        try {
            double s = this.m_angleCos * (x - this.m_originX) + this.m_angleSin * (y - this.m_originY);
            double xc = this.m_originX + s * this.m_angleCos;
            double yc = this.m_originY + s * this.m_angleSin;
            double dx = x - xc;
            double dy = y - yc;
            return Math.sqrt(dx * dx + dy * dy);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    @Override
    public IGrid2D_Conversion clone() {
        Grid2D_Conversion_Line grid = new Grid2D_Conversion_Line();
        grid.setBinSize(this.m_binSize);
        grid.setAngle(this.m_angle);
        grid.setOrigin(this.m_originX, this.m_originY);
        return grid;
    }

    public void setBinSize(double binSize) {
        this.m_binSize = binSize;
        this.computeInternals(true);
    }

    public double angle() {
        return this.m_angle;
    }

    public void setAngle(double angle) {
        this.m_angle = angle;
        this.computeInternals(true);
    }

    public double originX() {
        return this.m_originX;
    }

    public double originY() {
        return this.m_originY;
    }

    public void setOrigin(double x, double y) {
        this.m_originX = x;
        this.m_originY = y;
        this.computeInternals(true);
    }

    @Override
    public void save(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.double_put(OriginX, this.m_originX);
            tree.double_put(OriginY, this.m_originY);
            tree.double_put(Size, this.m_binSize);
            tree.double_put(Angle, this.m_angle);
            tree.save(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void read(String fileName) {
        try {
            ParameterTree tree = new ParameterTree();
            tree.read(fileName);
            this.m_originX = tree.double_get(OriginX, 0.0);
            this.m_originY = tree.double_get(OriginY, 0.0);
            this.m_binSize = tree.double_get(Size, 1000.0);
            this.m_angle = tree.double_get(Angle, 0.0);
            this.computeInternals(true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void prepareRangeFinder() {
        this.m_minBin = Integer.MAX_VALUE;
        this.m_maxBin = Integer.MIN_VALUE;
    }

    @Override
    public void addToRangeFinder(double x, double y, double buffer) {
        this.addToRangeFinder(x - buffer, y - buffer);
        this.addToRangeFinder(x - buffer, y + buffer);
        this.addToRangeFinder(x + buffer, y - buffer);
        this.addToRangeFinder(x + buffer, y + buffer);
    }

    public void addToRangeFinder(double x, double y) {
        int bin = this.getBin(x, y);
        this.m_minBin = Math.min(this.m_minBin, bin);
        this.m_maxBin = Math.max(this.m_maxBin, bin);
    }

    @Override
    public void computeInternals(boolean prepRangeFinder) {
        try {
            this.m_angleCos = Math.cos(this.m_angle);
            this.m_angleSin = Math.sin(this.m_angle);
            this.m_binSize = Math.max(10.0, this.m_binSize);
            if (prepRangeFinder) {
                this.prepareRangeFinder();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public double getX(int bin) {
        try {
            return this.m_originX + this.m_angleCos * ((double)bin * this.m_binSize);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    @Override
    public double getY(int bin) {
        try {
            return this.m_originY + this.m_angleSin * ((double)bin * this.m_binSize);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    @Override
    public int getBin(double worldX, double worldY) {
        try {
            double s = this.distanceFromOrigin(worldX, worldY);
            long bin = Math.round(s / this.m_binSize);
            return (int)bin;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    @Override
    public double binSize() {
        return this.m_binSize;
    }
}

