/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

public class EmptyGridInterpolator {
    public int NumX;
    public int NumY;
    public boolean[][] Valid1;
    public boolean[][] Valid2;
    public double[][] Sum1;
    public double[][] Sum2;
    public double[][] Value;
    public long Count;

    public EmptyGridInterpolator(int nx, int ny) {
        try {
            this.NumX = nx;
            this.NumY = ny;
            this.Valid1 = new boolean[this.NumX][this.NumY];
            this.Valid2 = new boolean[this.NumX][this.NumY];
            this.Sum1 = new double[this.NumX][this.NumY];
            this.Sum2 = new double[this.NumX][this.NumY];
            this.Value = new double[this.NumX][this.NumY];
            this.clear();
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void add(int x, int y, float v, float w) {
        try {
            if (x < 0 || x >= this.NumX || y < 0 || y >= this.NumY) {
                return;
            }
            this.Valid1[x][y] = true;
            w = Math.max(w, 0.001f);
            this.Sum1[x][y] = this.Sum1[x][y] + (double)(w * v);
            this.Sum2[x][y] = this.Sum2[x][y] + (double)w;
            ++this.Count;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public double[][] smooth(int rad, double smoothDecay, boolean useWeights) {
        try {
            if (this.Count < 1L) {
                return this.Value;
            }
            rad = Math.max(rad, 1);
            rad = Math.min(rad, 10);
            int maxRadius = 120;
            double[] decay = new double[maxRadius];
            double alpha = -Math.log(smoothDecay) / (double)rad;
            for (int n = 0; n < decay.length; ++n) {
                decay[n] = Math.exp(-alpha * (double)n);
            }
            for (int x = 0; x < this.NumX; ++x) {
                for (int y = 0; y < this.NumY; ++y) {
                    this.Sum1[x][y] = this.Value[x][y];
                }
            }
            int radx = 3 * rad;
            for (int x = 0; x < this.NumX; ++x) {
                for (int y = 0; y < this.NumY; ++y) {
                    double sum1 = 0.0;
                    double sum2 = 1.0E-20;
                    int minx = Math.max(0, x - radx);
                    int maxx = Math.min(this.NumX - 1, x + radx);
                    int miny = Math.max(0, y - radx);
                    int maxy = Math.min(this.NumY - 1, y + radx);
                    for (int ix = minx; ix <= maxx; ++ix) {
                        for (int iy = miny; iy <= maxy; ++iy) {
                            double wx = decay[Math.abs(x - ix)];
                            double wy = decay[Math.abs(y - iy)];
                            double w = wx * wx;
                            if (useWeights) {
                                w *= this.Sum2[ix][iy];
                            }
                            sum1 += w * this.Sum1[ix][iy];
                            sum2 += w;
                        }
                    }
                    this.Value[x][y] = sum1 / sum2;
                }
            }
            return this.Value;
        }
        catch (Exception error) {
            error.printStackTrace();
            return this.Value;
        }
    }

    public double[][] finish(int maxRadius, boolean useWeights) {
        try {
            if (this.Count < 1L) {
                return this.Value;
            }
            double min_weight = 1.0E30;
            for (int x = 0; x < this.NumX; ++x) {
                for (int y = 0; y < this.NumY; ++y) {
                    if (!this.Valid1[x][y]) continue;
                    this.Value[x][y] = this.Sum1[x][y] / this.Sum2[x][y];
                    min_weight = Math.min(min_weight, this.Sum2[x][y]);
                }
            }
            int rad = 1;
            boolean notDone = true;
            while (notDone) {
                int y;
                int x;
                notDone = false;
                ++rad;
                rad = Math.min(rad, maxRadius);
                for (x = 0; x < this.NumX; ++x) {
                    for (y = 0; y < this.NumY; ++y) {
                        this.Valid2[x][y] = this.Valid1[x][y];
                    }
                }
                for (x = 0; x < this.NumX; ++x) {
                    for (y = 0; y < this.NumY; ++y) {
                        if (this.Valid1[x][y]) continue;
                        notDone = true;
                        int startx = Math.max(x - 1, 0);
                        int endx = Math.min(x + 1, this.NumX - 1);
                        int starty = Math.max(y - 1, 0);
                        int endy = Math.min(y + 1, this.NumY - 1);
                        int nn = 0;
                        for (int ix = startx; ix <= endx; ++ix) {
                            for (int iy = starty; iy <= endy; ++iy) {
                                if (!this.Valid1[ix][iy]) continue;
                                ++nn;
                            }
                        }
                        if (nn < true) continue;
                        startx = Math.max(x - rad, 0);
                        endx = Math.min(x + rad, this.NumX - 1);
                        starty = Math.max(y - rad, 0);
                        endy = Math.min(y + rad, this.NumY - 1);
                        float s1 = 0.0f;
                        float s2 = 0.0f;
                        for (int ix = startx; ix <= endx; ++ix) {
                            for (int iy = starty; iy <= endy; ++iy) {
                                if (!this.Valid1[ix][iy]) continue;
                                int dx = Math.abs(x - ix);
                                int dy = Math.abs(y - iy);
                                float wx = (float)rad / (float)(1 + dx);
                                float wy = (float)rad / (float)(1 + dy);
                                float w = wx * wy;
                                if (useWeights) {
                                    w *= (float)this.Sum2[ix][iy];
                                }
                                s1 = (float)((double)s1 + this.Value[ix][iy] * (double)w);
                                s2 += w;
                            }
                        }
                        this.Valid2[x][y] = true;
                        this.Value[x][y] = s1 / s2;
                        this.Sum2[x][y] = 0.01 * min_weight;
                    }
                }
                for (x = 0; x < this.NumX; ++x) {
                    for (y = 0; y < this.NumY; ++y) {
                        this.Valid1[x][y] = this.Valid2[x][y];
                    }
                }
            }
            return this.Value;
        }
        catch (Exception error) {
            error.printStackTrace();
            return this.Value;
        }
    }

    public void clear() {
        try {
            this.Count = 0L;
            for (int x = 0; x < this.NumX; ++x) {
                for (int y = 0; y < this.NumY; ++y) {
                    this.Valid1[x][y] = false;
                    this.Valid2[x][y] = false;
                    this.Sum1[x][y] = 0.0;
                    this.Sum2[x][y] = 0.0;
                    this.Value[x][y] = 0.0;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

