/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math.Delauney;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.Delauney.DelaunayPoint;

public class DelaunayEdge {
    public DelaunayPoint Point1 = null;
    public DelaunayPoint Point2 = null;
    public double DeltaX;
    public double DeltaY;
    public double Length;
    public boolean Horizontal_Ish;
    public double m_nominalDistance;
    public boolean Ray_HitPoint1;
    public boolean Ray_HitPoint2;
    public boolean Ray_CoLinear;
    public boolean Ray_Cut;

    public DelaunayEdge(DelaunayPoint p1, DelaunayPoint p2, double nominalDistance) {
        this.m_nominalDistance = Math.max(1.0E-4, nominalDistance);
        this.Point1 = p1;
        this.Point2 = p2;
        this.DeltaX = this.Point2.X - this.Point1.X;
        this.DeltaY = this.Point2.Y - this.Point1.Y;
        this.Length = Math.sqrt(this.DeltaX * this.DeltaX + this.DeltaY * this.DeltaY);
        this.Horizontal_Ish = Math.abs(this.DeltaY) < Math.abs(this.DeltaX);
    }

    public void freePointers() {
        this.Point1 = null;
        this.Point2 = null;
    }

    public void prepareRayCuttingInfo(double x, double y, double cos, double sin) throws Exception {
        try {
            this.Ray_Cut = false;
            this.Ray_HitPoint1 = false;
            this.Ray_HitPoint2 = false;
            this.Ray_CoLinear = false;
            this.Point1.prepareRayInfo(x, y, cos, sin);
            this.Point2.prepareRayInfo(x, y, cos, sin);
            if (this.Point1.Ray_MinimumS > 0.0) {
                boolean bl = this.Ray_HitPoint1 = this.Point1.Ray_Distance < 0.01 * this.m_nominalDistance;
            }
            if (this.Point2.Ray_MinimumS > 0.0) {
                this.Ray_HitPoint2 = this.Point2.Ray_Distance < 0.01 * this.m_nominalDistance;
            }
            this.Ray_CoLinear = this.Ray_HitPoint1 && this.Ray_HitPoint2;
            double denom = sin * this.DeltaX - cos * this.DeltaY;
            if (Math.abs(denom) < 1.0E-7) {
                return;
            }
            double r = (sin * (x - this.Point1.X) - cos * (y - this.Point1.Y)) / denom;
            if (r <= 0.0 || r >= 1.0) {
                return;
            }
            double s = 0.0;
            s = Math.abs(cos) > 0.01 ? (this.Point1.X - x + r * this.DeltaX) / cos : (this.Point1.Y - y + r * this.DeltaY) / sin;
            this.Ray_Cut = s > 0.0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean pointOnLine(double x, double y) throws Exception {
        try {
            double r = (this.DeltaX * (x - this.Point1.X) + this.DeltaY * (y - this.Point1.Y)) / (this.Length * this.Length);
            if (r < 0.0 || r > 1.0) {
                return false;
            }
            double xt = this.Point1.X + r * (this.Point2.X - this.Point1.X);
            double dx = xt - x;
            double yt = this.Point1.Y + r * (this.Point2.Y - this.Point1.Y);
            double dy = yt - y;
            double dist = Math.sqrt(dx * dx + dy * dy + 1.0E-40);
            return dist < 0.05 * this.m_nominalDistance;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

