/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.AxisGridBase;

public class AxisGrid_LinearFit
extends AxisGridBase {
    protected int m_maxCount = 0;
    public int[][] Count = null;
    public float[][] SumU = null;
    public float[][] SumUU = null;
    public float[][] SumUV = null;
    public float[][] SumV = null;
    public float[][] Weight = null;
    public boolean[][] Valid = null;
    public float[][] Alpha = null;
    public float[][] Beta = null;
    protected int m_smearRadius = 0;

    public AxisGrid_LinearFit(double ox, double oy, double sx, double sy, int nx, int ny, int smearRadius) throws Exception {
        try {
            this.prep(ox, oy, sx, sy, nx, ny);
            this.m_smearRadius = smearRadius;
            this.m_smearRadius = Math.max(this.m_smearRadius, 0);
            this.m_smearRadius = Math.min(this.m_smearRadius, 10);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void compute() throws Exception {
        try {
            int numValid = 0;
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    this.Valid[x][y] = false;
                    int N = this.Count[x][y];
                    if (N < 6) continue;
                    ++numValid;
                    double sumU = this.SumU[x][y];
                    double sumUU = this.SumUU[x][y];
                    double sumUV = this.SumUV[x][y];
                    double sumV = this.SumV[x][y];
                    this.Weight[x][y] = N;
                    double denom = (double)N * sumUU - sumU * sumU;
                    if (!(Math.abs(denom) > 1.0E-5)) continue;
                    double b = (sumV * sumUU - sumU * sumUV) / denom;
                    double a = ((double)N * sumUV - sumU * sumV) / denom;
                    this.Alpha[x][y] = (float)a;
                    this.Beta[x][y] = (float)b;
                }
            }
            if (numValid < 1) {
                return;
            }
            boolean bad = true;
            while (bad) {
                for (int x = 0; x < this.m_numCellsX; ++x) {
                    for (int y = 0; y < this.m_numCellsY; ++y) {
                        if (this.Valid[x][y]) continue;
                        float sumAlpha = 0.0f;
                        float sumBeta = 0.0f;
                        float sumWeight = 1.0E-40f;
                        int minIndexX = this.minIndexX(x, 4);
                        int maxIndexX = this.maxIndexX(x, 4);
                        int minIndexY = this.minIndexY(y, 4);
                        int maxIndexY = this.maxIndexY(y, 4);
                        int count = 0;
                        for (int ix = minIndexX; ix <= maxIndexX; ++ix) {
                            for (int iy = minIndexY; iy <= maxIndexY; ++iy) {
                                if (!this.Valid[ix][iy]) continue;
                                ++count;
                                double dx = x - ix;
                                double dy = y - iy;
                                double dw = 1.0 / (1.0 + dx * dx + dy * dy);
                                float w = (float)dw * this.Weight[ix][iy];
                                sumAlpha += w * this.Alpha[ix][iy];
                                sumBeta += w * this.Beta[ix][iy];
                                sumWeight += w;
                            }
                        }
                        if (count >= 1) {
                            this.Valid[x][y] = true;
                            this.Weight[x][y] = sumWeight;
                            this.Alpha[x][y] = sumAlpha / sumWeight;
                            this.Beta[x][y] = sumBeta / sumWeight;
                            continue;
                        }
                        bad = true;
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addPoint(double x, double y, float u, float v) throws Exception {
        try {
            this.prepInternalIndex(x, y);
            int minIndexX = this.minIndexX(this.TempIndexX, this.m_smearRadius);
            int maxIndexX = this.maxIndexX(this.TempIndexX, this.m_smearRadius);
            int minIndexY = this.minIndexY(this.TempIndexY, this.m_smearRadius);
            int maxIndexY = this.maxIndexY(this.TempIndexY, this.m_smearRadius);
            for (int ix = minIndexX; ix <= maxIndexX; ++ix) {
                int iy = minIndexY;
                while (iy <= maxIndexY) {
                    int[] nArray = this.Count[ix];
                    int n = iy;
                    nArray[n] = nArray[n] + 1;
                    this.m_maxCount = Math.max(this.m_maxCount, this.Count[ix][iy]);
                    float[] fArray = this.SumU[ix];
                    int n2 = iy;
                    fArray[n2] = fArray[n2] + u;
                    float[] fArray2 = this.SumUU[ix];
                    int n3 = iy;
                    fArray2[n3] = fArray2[n3] + u * u;
                    float[] fArray3 = this.SumUV[ix];
                    int n4 = iy;
                    fArray3[n4] = fArray3[n4] + u * v;
                    float[] fArray4 = this.SumV[ix];
                    int n5 = iy++;
                    fArray4[n5] = fArray4[n5] + v;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prep(double ox, double oy, double sx, double sy, int nx, int ny) throws Exception {
        try {
            this.m_originX = ox;
            this.m_originY = oy;
            this.m_cellSizeX = sx;
            this.m_cellSizeY = sy;
            this.m_numCellsX = nx;
            this.m_numCellsY = ny;
            long total = (long)nx * (long)ny;
            if (total < 1L) {
                throw new Exception("(total < 1)");
            }
            if (total >= 50000000L) {
                throw new Exception("total >= 50000000");
            }
            this.Count = new int[nx][ny];
            this.SumU = new float[nx][ny];
            this.SumUU = new float[nx][ny];
            this.SumUV = new float[nx][ny];
            this.SumV = new float[nx][ny];
            this.Weight = new float[nx][ny];
            this.Alpha = new float[nx][ny];
            this.Beta = new float[nx][ny];
            this.Valid = new boolean[nx][ny];
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    this.Valid[x][y] = false;
                    this.Count[x][y] = 0;
                    this.SumU[x][y] = 1.0E-40f;
                    this.SumUU[x][y] = 1.0E-40f;
                    this.SumUV[x][y] = 1.0E-40f;
                    this.Weight[x][y] = 1.0E-40f;
                    this.SumV[x][y] = 1.0E-40f;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

