/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Math.AxisGridBase;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class AxisGrid
extends AxisGridBase {
    protected float[][] m_grid;
    protected float[] m_weightArray;
    protected AxisGrid m_blobGrid = null;
    protected int m_numCellsPerBlob = 20;
    protected float[][] m_tempSumGrid = null;
    protected float[][] m_tempWeightGrid = null;
    protected int[][] m_tempCountGrid = null;
    protected long m_numAddedToTemp = 0L;
    protected float m_minAddedWeight;
    protected HashMap<String, float[][]> ArrayMap = new HashMap();

    public float[][] grid() {
        return this.m_grid;
    }

    public float[][] array(String name) throws Exception {
        try {
            if (!this.ArrayMap.containsKey(name)) {
                this.ArrayMap.put(name, new float[this.m_numCellsX][this.m_numCellsY]);
            }
            return this.ArrayMap.get(name);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void array_clear(String name, float v) throws Exception {
        try {
            float[][] array = this.array(name);
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    array[x][y] = v;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public AxisGrid() {
    }

    public AxisGrid(double ox, double oy, double sx, double sy, int nx, int ny) throws Exception {
        try {
            this.prep(ox, oy, sx, sy, nx, ny);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public AxisGrid(String fileName) throws Exception {
        try {
            this.read(fileName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void update_table(Table_Abstract t, String col) throws Exception {
        try {
            this.prepareTempArrays(false);
            int indexx = t.column_indexOfColumn("Easting");
            int indexy = t.column_indexOfColumn("Northing");
            int indexk = t.column_indexOfColumn("Killed");
            int indexv = t.column_indexOfColumn(col);
            for (int r = 0; r < t.row_count(); ++r) {
                double x = t.getDouble(r, indexx);
                double y = t.getDouble(r, indexy);
                float v = this.getValue(x, y);
                t.putDouble(r, indexv, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void create_from_tables(Table_Abstract t1, Table_Abstract t2, String col) throws Exception {
        try {
            this.prepareTempArrays(false);
            for (int iter = 0; iter <= 1; ++iter) {
                Table_Abstract t = t1;
                if (iter == 1) {
                    t = t2;
                }
                int indexx = t.column_indexOfColumn("Easting");
                int indexy = t.column_indexOfColumn("Northing");
                int indexk = t.column_indexOfColumn("Killed");
                int indexv = t.column_indexOfColumn(col);
                for (int r = 0; r < t.row_count(); ++r) {
                    double x = t.getDouble(r, indexx);
                    double y = t.getDouble(r, indexy);
                    double v = t.getDouble(r, indexv);
                    boolean k = t.getBool(r, indexk);
                    if (k) continue;
                    this.addValueToUpdateArrays(x, y, (float)v, 1.0f);
                }
            }
            this.finished_adding();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void range_compression(double compression) {
        try {
            compression = Math.max(compression, 1.0);
            compression = Math.min(compression, 10.0);
            double sum = 0.0;
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    sum += (double)this.m_grid[x][y];
                }
            }
            float avg = (float)(sum / (double)(this.m_numCellsX * this.m_numCellsY));
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    float diff = this.m_grid[x][y] - avg;
                    this.m_grid[x][y] = avg + diff / (float)compression;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void finished_adding() throws Exception {
        try {
            boolean[][] b1 = new boolean[this.m_numCellsX][this.m_numCellsY];
            boolean[][] b2 = new boolean[this.m_numCellsX][this.m_numCellsY];
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    b1[x][y] = this.m_tempCountGrid[x][y] >= 1;
                    b2[x][y] = b1[x][y];
                    if (!b1[x][y]) continue;
                    this.m_grid[x][y] = this.m_tempSumGrid[x][y] / this.m_tempWeightGrid[x][y];
                }
            }
            boolean keepgoing = true;
            while (keepgoing) {
                int y;
                int x;
                keepgoing = false;
                for (x = 0; x < this.m_numCellsX; ++x) {
                    for (y = 0; y < this.m_numCellsY; ++y) {
                        b2[x][y] = b1[x][y];
                        if (b1[x][y]) continue;
                        keepgoing = true;
                        int numadjacent = 0;
                        int minx = Math.max(x - 3, 0);
                        int maxx = Math.min(x + 3, this.m_numCellsX - 1);
                        int miny = Math.max(y - 3, 0);
                        int maxy = Math.min(y + 3, this.m_numCellsY - 1);
                        double s1 = 0.0;
                        double s2 = 1.0E-10;
                        for (int ix = minx; ix <= maxx; ++ix) {
                            for (int iy = miny; iy <= maxy; ++iy) {
                                if (!b1[ix][iy]) continue;
                                int dx = Math.abs(x - ix);
                                int dy = Math.abs(y - iy);
                                if (dx <= 1 && dy <= 1) {
                                    ++numadjacent;
                                }
                                double w = 1.0 / (1.0 + (double)dx + (double)dy);
                                s1 += (double)this.m_grid[ix][iy] * w;
                                s2 += w;
                            }
                        }
                        if (numadjacent < true) continue;
                        b2[x][y] = true;
                        this.m_grid[x][y] = (float)(s1 / s2);
                    }
                }
                for (x = 0; x < this.m_numCellsX; ++x) {
                    for (y = 0; y < this.m_numCellsY; ++y) {
                        b1[x][y] = b2[x][y];
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void save(String fileName) throws Exception {
        try {
            int magic = 876123;
            int version = 1000;
            int headerLength = 200;
            int numBytes = headerLength + 4 * this.m_numCellsX * this.m_numCellsY;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            buff.putInt(magic);
            buff.putInt(version);
            if (version == 1000) {
                buff.putDouble(8, this.m_originX);
                buff.putDouble(16, this.m_originY);
                buff.putDouble(24, this.m_cellSizeX);
                buff.putDouble(32, this.m_cellSizeY);
                buff.putInt(40, this.m_numCellsX);
                buff.putInt(44, this.m_numCellsY);
                buff.putInt(48, headerLength);
                int off = headerLength;
                for (int x = 0; x < this.m_numCellsX; ++x) {
                    for (int y = 0; y < this.m_numCellsY; ++y) {
                        buff.putFloat(off, this.m_grid[x][y]);
                        off += 4;
                    }
                }
            } else {
                throw new Exception("Unrecognized version");
            }
            RandomAccessFile writer = new RandomAccessFile(fileName, "rw");
            writer.write(buff.array());
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void read(String fileName) throws Exception {
        block6: {
            try {
                RandomAccessFile reader = new RandomAccessFile(fileName, "r");
                long numBytes = reader.length();
                ByteBuffer buff = ByteBuffer_Shared.buffer(0, (int)numBytes);
                reader.read(buff.array(), 0, (int)numBytes);
                reader.close();
                int magic = buff.getInt(0);
                if (magic != 876123) {
                    throw new Exception("Bad magic");
                }
                int version = buff.getInt(4);
                if (version == 1000) {
                    double ox = buff.getDouble(8);
                    double oy = buff.getDouble(16);
                    double sx = buff.getDouble(24);
                    double sy = buff.getDouble(32);
                    int nx = buff.getInt(40);
                    int ny = buff.getInt(44);
                    int headerLength = buff.getInt(48);
                    this.prep(ox, oy, sx, sy, nx, ny);
                    int off = headerLength;
                    for (int x = 0; x < this.m_numCellsX; ++x) {
                        for (int y = 0; y < this.m_numCellsY; ++y) {
                            this.m_grid[x][y] = buff.getFloat(off);
                            off += 4;
                        }
                    }
                    break block6;
                }
                throw new Exception("Unrecognized version");
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                throw error;
            }
        }
    }

    protected void prep(double ox, double oy, double sx, double sy, int nx, int ny) throws Exception {
        try {
            this.m_originX = ox;
            this.m_originY = oy;
            this.m_cellSizeX = sx;
            this.m_cellSizeY = sy;
            this.m_numCellsX = nx;
            this.m_numCellsY = ny;
            long total = (long)nx * (long)ny;
            if (total < 1L) {
                throw new Exception("(total < 1)");
            }
            if (total >= 50000000L) {
                throw new Exception("total >= 50000000");
            }
            this.m_grid = new float[nx][ny];
            this.setToValue(0.0f);
            this.m_weightArray = new float[10 + Math.max(this.m_numCellsX, this.m_numCellsY)];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float getValue(double midX, double midY) throws Exception {
        try {
            this.prepInternalIndex(midX, midY);
            return this.m_grid[this.TempIndexX][this.TempIndexY];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setToValue(float v) throws Exception {
        try {
            for (int x = 0; x < this.m_numCellsX; ++x) {
                for (int y = 0; y < this.m_numCellsY; ++y) {
                    this.m_grid[x][y] = v;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addValue(int ix, int iy, float v) throws Exception {
        try {
            this.m_grid[ix][iy] = this.m_grid[ix][iy] + v;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setValue(int ix, int iy, float v) throws Exception {
        try {
            this.m_grid[ix][iy] = v;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public float getValue(int ix, int iy) throws Exception {
        try {
            return this.m_grid[ix][iy];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void smooth(int rad) throws Exception {
        try {
            int iy;
            int ix;
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    float sum = 0.0f;
                    float sumWeight = 1.0E-30f;
                    int maxIndexX = Math.min(ix + rad, this.m_numCellsX - 1);
                    int minIndexX = Math.min(ix - rad, 0);
                    int maxIndexY = Math.min(iy + rad, this.m_numCellsY - 1);
                    int minIndexY = Math.min(iy - rad, 0);
                    for (int nx = minIndexX; nx <= maxIndexX; ++nx) {
                        for (int ny = minIndexY; ny <= maxIndexY; ++ny) {
                            int dx = ix - nx;
                            int dy = iy - ny;
                            float w = 1.0f / (1.0f + (float)(dx * dx + dy * dy));
                            sum += w * this.m_grid[nx][ny];
                            sumWeight += w;
                        }
                    }
                    this.m_tempSumGrid[ix][iy] = sum / sumWeight;
                }
            }
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    this.m_grid[ix][iy] = this.m_tempSumGrid[ix][iy];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected float getTempValue(double x, double y, int radius) throws Exception {
        try {
            this.prepInternalIndex(x, y);
            float sum = 0.0f;
            float sumWeight = 1.0E-30f;
            for (int ix = this.TempIndexX - radius; ix <= this.TempIndexX + radius; ++ix) {
                for (int iy = this.TempIndexY - radius; iy <= this.TempIndexY + radius; ++iy) {
                    if (ix < 0 || ix >= this.m_numCellsX || iy < 0 || iy >= this.m_numCellsY) continue;
                    double dx = x - (this.m_originX + (double)ix * this.m_cellSizeX);
                    double dy = y - (this.m_originY + (double)iy * this.m_cellSizeY);
                    double dw = 1.0 / (0.01 + dx * dx + dy * dy);
                    float w = (float)dw;
                    sum += w * this.m_grid[ix][iy];
                    sumWeight += w;
                }
            }
            return sum / sumWeight;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected int tempGridCount(int nx, int ny, int radius) throws Exception {
        try {
            int count = 0;
            for (int ix = nx - radius; ix <= nx + radius; ++ix) {
                for (int iy = ny - radius; iy <= ny + radius; ++iy) {
                    if (ix < 0 || ix >= this.m_numCellsX || iy < 0 || iy >= this.m_numCellsY) continue;
                    count += this.m_tempCountGrid[ix][iy];
                }
            }
            return count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void handleChildBlobGrid() throws Exception {
        try {
            int iy;
            int ix;
            float minValid = Float.MAX_VALUE;
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    if (this.m_tempCountGrid[ix][iy] < 1) continue;
                    this.m_grid[ix][iy] = this.m_tempSumGrid[ix][iy] / this.m_tempWeightGrid[ix][iy];
                    minValid = Math.min(minValid, this.m_tempWeightGrid[ix][iy]);
                }
            }
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    if (this.m_tempCountGrid[ix][iy] >= 1) continue;
                    float sum = 0.0f;
                    float sumWeight = 1.0E-30f;
                    for (int nx = 0; nx < this.m_numCellsX; ++nx) {
                        for (int ny = 0; ny < this.m_numCellsY; ++ny) {
                            if (this.m_tempCountGrid[nx][ny] < 1) continue;
                            int dx = ix - nx;
                            int dy = iy - ny;
                            float w = 1.0f / (1.0f + (float)(dx * dx + dy * dy));
                            sum += (w *= this.m_tempWeightGrid[nx][ny]) * this.m_grid[nx][ny];
                            sumWeight += w;
                        }
                    }
                    this.m_grid[ix][iy] = sum / sumWeight;
                    this.m_tempWeightGrid[ix][iy] = minValid;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void handleParentGrid() throws Exception {
        try {
            int ix;
            int iy;
            int ix2;
            this.m_blobGrid.computeGridFromTemp();
            float minValid = Float.MAX_VALUE;
            for (ix2 = 0; ix2 < this.m_numCellsX; ++ix2) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    if (this.m_tempCountGrid[ix2][iy] < 1) continue;
                    this.m_grid[ix2][iy] = this.m_tempSumGrid[ix2][iy] / this.m_tempWeightGrid[ix2][iy];
                    minValid = Math.min(minValid, this.m_tempWeightGrid[ix2][iy]);
                }
            }
            for (ix2 = 0; ix2 < this.m_numCellsX; ++ix2) {
                for (iy = 0; iy < this.m_numCellsY; ++iy) {
                    if (this.m_tempCountGrid[ix2][iy] >= 1) continue;
                    double x = this.m_originX + (double)ix2 * this.m_cellSizeX;
                    double y = this.m_originX + (double)iy * this.m_cellSizeY;
                    this.m_grid[ix2][iy] = this.m_blobGrid.getTempValue(x, y, 4);
                    this.m_tempWeightGrid[ix2][iy] = 0.1f * minValid;
                }
            }
            int rad = 10;
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (int iy2 = 0; iy2 < this.m_numCellsY; ++iy2) {
                    float sum = 0.0f;
                    float sumWeight = 1.0E-30f;
                    int maxIndexX = Math.min(ix + rad, this.m_numCellsX - 1);
                    int minIndexX = Math.min(ix - rad, 0);
                    int maxIndexY = Math.min(iy2 + rad, this.m_numCellsY - 1);
                    int minIndexY = Math.min(iy2 - rad, 0);
                    for (int nx = minIndexX; nx <= maxIndexX; ++nx) {
                        for (int ny = minIndexY; ny <= maxIndexY; ++ny) {
                            int dx = ix - nx;
                            int dy = iy2 - ny;
                            float w = 1.0f / (1.0f + (float)(dx * dx + dy * dy));
                            sum += (w *= this.m_tempWeightGrid[nx][ny]) * this.m_grid[nx][ny];
                            sumWeight += w;
                        }
                    }
                    this.m_tempSumGrid[ix][iy2] = sum / sumWeight;
                }
            }
            for (ix = 0; ix < this.m_numCellsX; ++ix) {
                for (int iy3 = 0; iy3 < this.m_numCellsY; ++iy3) {
                    this.m_grid[ix][iy3] = this.m_tempSumGrid[ix][iy3];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void computeGridFromTemp() throws Exception {
        try {
            if (this.m_numAddedToTemp < 1L) {
                throw new Exception("m_numAddedToTemp < 1");
            }
            if (this.m_blobGrid == null) {
                this.handleChildBlobGrid();
            } else {
                this.handleParentGrid();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addValueToUpdateArrays(double x, double y, float v, float w) {
        try {
            w = Math.abs(w);
            this.m_minAddedWeight = Math.min(this.m_minAddedWeight, w);
            ++this.m_numAddedToTemp;
            this.prepInternalIndex(x, y);
            this.m_tempWeightGrid[this.TempIndexX][this.TempIndexY] = this.m_tempWeightGrid[this.TempIndexX][this.TempIndexY] + w;
            this.m_tempSumGrid[this.TempIndexX][this.TempIndexY] = this.m_tempSumGrid[this.TempIndexX][this.TempIndexY] + v * w;
            this.m_tempCountGrid[this.TempIndexX][this.TempIndexY] = this.m_tempCountGrid[this.TempIndexX][this.TempIndexY] + 1;
            if (this.m_blobGrid != null) {
                this.m_blobGrid.addValueToUpdateArrays(x, y, v, w);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void freeTempArrays() {
        try {
            this.m_minAddedWeight = Float.MAX_VALUE;
            this.m_tempWeightGrid = null;
            this.m_tempSumGrid = null;
            this.m_numAddedToTemp = 0L;
            this.m_blobGrid = null;
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareTempArrays(boolean prepareBlob) {
        try {
            this.m_minAddedWeight = Float.MAX_VALUE;
            this.m_numAddedToTemp = 0L;
            if (this.m_tempWeightGrid == null) {
                this.m_tempWeightGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempSumGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempCountGrid = new int[this.m_numCellsX][this.m_numCellsY];
            }
            if (this.m_tempWeightGrid.length != this.m_grid.length) {
                this.m_tempWeightGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempSumGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempCountGrid = new int[this.m_numCellsX][this.m_numCellsY];
            }
            if (this.m_tempWeightGrid[0].length != this.m_grid[0].length) {
                this.m_tempWeightGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempSumGrid = new float[this.m_numCellsX][this.m_numCellsY];
                this.m_tempCountGrid = new int[this.m_numCellsX][this.m_numCellsY];
            }
            for (int ix = 0; ix < this.m_numCellsX; ++ix) {
                for (int iy = 0; iy < this.m_numCellsY; ++iy) {
                    this.m_tempWeightGrid[ix][iy] = 1.0E-30f;
                    this.m_tempSumGrid[ix][iy] = 0.0f;
                    this.m_tempCountGrid[ix][iy] = 0;
                }
            }
            if (prepareBlob) {
                int numBlobsX = 1 + this.m_numCellsX / this.m_numCellsPerBlob;
                int numBlobsY = 1 + this.m_numCellsY / this.m_numCellsPerBlob;
                double blobOriginX = this.m_originX + ((double)this.m_numCellsPerBlob / 2.0 - 0.5) * this.m_cellSizeX;
                double blobOriginY = this.m_originY + ((double)this.m_numCellsPerBlob / 2.0 - 0.5) * this.m_cellSizeY;
                double blobSizeX = this.m_cellSizeX * (double)this.m_numCellsPerBlob;
                double blobSizeY = this.m_cellSizeY * (double)this.m_numCellsPerBlob;
                if (this.m_blobGrid == null) {
                    this.m_blobGrid = new AxisGrid(blobOriginX, blobOriginY, blobSizeX, blobSizeY, numBlobsX, numBlobsY);
                }
                if (!this.m_blobGrid.compare(blobOriginX, blobOriginY, blobSizeX, blobSizeY, numBlobsX, numBlobsY)) {
                    this.m_blobGrid = new AxisGrid(blobOriginX, blobOriginY, blobSizeX, blobSizeY, numBlobsX, numBlobsY);
                }
                this.m_blobGrid.prepareTempArrays(false);
            } else {
                this.m_blobGrid = null;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

