/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Math;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashKey_Integers;
import com.PecosCore.Seismic.Segy.Segy;
import java.util.ArrayList;
import java.util.HashMap;

public class ArrayInterpolator3D {
    protected HashKey_Integers m_key = new HashKey_Integers(0);
    public HashMap<HashKey_Integers, Location> LocMap = new HashMap();
    public double BinSize = 500.0;

    public void addSegy(Segy segy) {
        try {
            Ensemble gather = new Ensemble();
            int numPerChunk = 1000;
            int start = 0;
            while ((long)start < segy.traceCount()) {
                gather.clearTraces(true);
                segy.populateEnsemble(gather, start, numPerChunk, true, true);
                if (gather.dictionary().containsEntry("Trace", "CdpX") && gather.dictionary().containsEntry("Trace", "CdpY")) {
                    int indexx = gather.dictionary().getEntryIndex("Trace", "CdpX");
                    int indexy = gather.dictionary().getEntryIndex("Trace", "CdpY");
                    for (int n = 0; n < gather.traceCount(); ++n) {
                        EnsembleTrace t = gather.trace(n);
                        double x = t.header().getDouble(indexx);
                        double y = t.header().getDouble(indexy);
                        FloatArrayWrapper faw = t.data();
                        this.add(faw.cloneData(), x, y);
                    }
                }
                start += numPerChunk;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void add(float[] data, double x, double y) {
        try {
            int ix = (int)(0.5 + x / this.BinSize);
            int iy = (int)(0.5 + y / this.BinSize);
            this.m_key.setKey(ix, iy);
            if (!this.LocMap.containsKey(this.m_key)) {
                this.LocMap.put(new HashKey_Integers(ix, iy), new Location((double)ix * this.BinSize, (double)iy * this.BinSize));
            }
            this.LocMap.get(this.m_key).add(data, x, y);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float[] nearest(double x, double y) {
        try {
            int ix = (int)(0.5 + x / this.BinSize);
            int iy = (int)(0.5 + y / this.BinSize);
            float[] arr = null;
            double minDist = 1.0E30;
            for (int rad = 2; rad < 1000; ++rad) {
                for (int ix1 = ix - rad; ix1 <= ix + rad; ++ix1) {
                    for (int iy1 = iy - rad; iy1 <= iy + rad; ++iy1) {
                        this.m_key.setKey(ix1, iy1);
                        if (!this.LocMap.containsKey(this.m_key)) continue;
                        Location loc = this.LocMap.get(this.m_key);
                        for (Entry e : loc.EntryList) {
                            double dx = x - e.X;
                            double dy = y - e.Y;
                            double dist = Math.sqrt(1.0E-10 + dx * dx + dy * dy);
                            if (!(dist < minDist)) continue;
                            minDist = dist;
                            arr = e.Data;
                        }
                    }
                }
                if (arr == null) continue;
                return arr;
            }
            return arr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public class Location {
        public double CenterX;
        public double CenterY;
        public ArrayList<Entry> EntryList = new ArrayList();

        public Location(double x, double y) {
            this.CenterX = x;
            this.CenterY = y;
        }

        public void add(float[] data, double x, double y) {
            this.EntryList.add(new Entry(data, x, y));
        }
    }

    public class Entry {
        public float[] Data;
        public double X;
        public double Y;

        public Entry(float[] data, double x, double y) {
            this.Data = data;
            this.X = x;
            this.Y = y;
        }
    }
}

