/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.IWorkerMonitor;
import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobManagerFileMonitor;
import com.PecosLibrary.Job.JobManagerWorkerMonitor;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobStatus;
import com.PecosLibrary.Job.Worker_Base;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;

public class JobWorkerThread
extends Thread
implements IWorkerMonitor {
    Worker_Base _worker;
    JobState _jobState;
    String _sJobStateFile;
    String _sKillJobFile;
    Path _killJobFilePath;
    File _killJobFile;
    Exception _lastError;
    ParameterTree _parameterTree;
    long _lastJobStateWriteTime;

    JobWorkerThread(Worker_Base worker, ParameterTree paramTree, JobState jobState, String sJobStateFile) {
        try {
            this._worker = worker;
            this._jobState = jobState;
            this._sJobStateFile = sJobStateFile;
            this._parameterTree = paramTree;
            this._lastJobStateWriteTime = 0L;
            this._sKillJobFile = JobManager.singleton().getJobKillFilePath(this._jobState.getJobID());
            this._killJobFilePath = Paths.get(this._sKillJobFile, new String[0]);
            this._killJobFile = new File(this._sKillJobFile);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void writeJobState(boolean bForceWrite) {
        try {
            Date currentTime = new Date();
            long lCurrentTime = currentTime.getTime();
            long timeSinceLastWrite = lCurrentTime - this._lastJobStateWriteTime;
            if (timeSinceLastWrite > 5000L || bForceWrite) {
                JobState.writeJobState(this._sJobStateFile, this._jobState);
                this._lastJobStateWriteTime = lCurrentTime;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Worker_Base getWorker() {
        return this._worker;
    }

    public JobState getJobState() {
        return this._jobState;
    }

    public String getJobStateFile() {
        return this._sJobStateFile;
    }

    public Exception getLastError() {
        return this._lastError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String sScratchDirectory = "";
        try {
            Date date = new Date();
            this._jobState.setStartTime(date);
            this.addMessageLevel1(this._worker, "Running " + this._worker.getDescription());
            this._jobState.setPercentDone(0.0, new Date());
            this._jobState.setStatus(JobStatus.SettingParameters);
            this.writeJobState(true);
            if (this._parameterTree != null) {
                sScratchDirectory = this._parameterTree.string_get("Scratch", "");
            }
            this._worker.setParameterTree(this._parameterTree);
            this._jobState.setStatus(JobStatus.Working);
            this.writeJobState(true);
            if (!this._worker.getIsHalted()) {
                this._worker.work();
            }
            date = new Date();
            this._jobState.setEndTime(date);
            if (this._worker.getIsHalted()) {
                this._jobState.setJobStatus(JobStatus.FinishedHalted);
                this._worker.cleanupAfterFinishedFailure();
            } else {
                this._jobState.setJobStatus(JobStatus.FinishedSuccess);
            }
            this._jobState.setPercentDone(100.0, date);
            this._jobState.setStatus(JobStatus.FinishedSuccess);
            this.writeJobState(true);
        }
        catch (InterruptedException e) {
            Date date = new Date();
            this._jobState.setEndTime(date);
            this._jobState.setPercentDone(100.0, date);
            this._jobState.setJobStatus(JobStatus.FinishedHalted);
            this._worker.cleanupAfterFinishedFailure();
        }
        catch (Exception error) {
            try {
                this._lastError = error;
                Date date = new Date();
                this._jobState.setEndTime(date);
                this._jobState.setLastError(error);
                this._jobState.setPercentDone(100.0, date);
                this._jobState.setJobStatus(JobStatus.FinishedFailure);
                this.writeJobState(true);
                this._worker.cleanupAfterFinishedFailure();
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
        finally {
            try {
                JobManagerWorkerMonitor monitor = (JobManagerWorkerMonitor)JobManager.singleton().getWorkerMonitor();
                monitor.removeWorkerThread(this);
                if (sScratchDirectory.length() > 1) {
                    File fScratch = new File(sScratchDirectory);
                    File fDir = fScratch.getParentFile();
                    if (fDir != null) {
                        if (fDir.exists()) {
                            JobManagerFileMonitor.deleteDirectory(fDir);
                        }
                    } else {
                        int iii = 0;
                        ++iii;
                    }
                }
                if (this._jobState.getStatus() != JobStatus.FinishedHalted) {
                    this.writeJobState(true);
                }
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
            }
        }
    }

    @Override
    public void setPercentDone(Object sender, double percent, String message) throws InterruptedException {
        try {
            if (this._killJobFile.exists()) {
                this.killJob();
                throw new InterruptedException();
            }
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (this._worker != null && this._worker.getIsHalted()) {
                throw new InterruptedException();
            }
            JobState jobState = this.getJobState();
            Date date = new Date();
            jobState.setPercentDone(percent, date);
            jobState.addMessageLevel1(message, date);
            this.writeJobState(false);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setPercentDone(Object sender, double percent) throws InterruptedException {
        try {
            if (this._killJobFile.exists()) {
                this.killJob();
                throw new InterruptedException();
            }
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (this._worker != null && this._worker.getIsHalted()) {
                throw new InterruptedException();
            }
            JobState jobState = this.getJobState();
            Date date = new Date();
            jobState.setPercentDone(percent, date);
            this.writeJobState(false);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void addMessageLevel1(Object sender, String message) throws InterruptedException {
        try {
            if (this._killJobFile.exists()) {
                this.killJob();
                throw new InterruptedException();
            }
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (this._worker != null && this._worker.getIsHalted()) {
                throw new InterruptedException();
            }
            String sJobStateFilePath = this.getJobStateFile();
            JobState jobState = this.getJobState();
            Date date = new Date();
            jobState.addMessageLevel1(message, date);
            this.writeJobState(false);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void addMemoryAtTimeEntry(Object sender) throws InterruptedException {
        try {
            if (this._killJobFile.exists()) {
                this.killJob();
                throw new InterruptedException();
            }
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            if (this._worker != null && this._worker.getIsHalted()) {
                throw new InterruptedException();
            }
            String sJobStateFilePath = this.getJobStateFile();
            JobState jobState = this.getJobState();
            Date date = new Date();
            long lMemory = Runtime.getRuntime().totalMemory();
            jobState.addMemoryAtTime(lMemory, date.getTime());
            this.writeJobState(false);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void killJob() {
        try {
            File fScratchDirectory;
            String sJobID = this._jobState.getJobID();
            String sScratchDirectory = "";
            String sParamsFile = JobManager.singleton().getJobParamsFilePath(sJobID);
            String sKillFile = JobManager.singleton().getJobKillFilePath(sJobID);
            String sStateFile = JobManager.singleton().getJobStateFilePath(sJobID);
            File fKillFile = new File(sKillFile);
            File fParamsFile = new File(sParamsFile);
            File fStateFile = new File(sStateFile);
            sScratchDirectory = this._parameterTree.string_get("Scratch", "");
            fKillFile.delete();
            if (fParamsFile.exists()) {
                fParamsFile.delete();
            }
            if (sScratchDirectory.length() > 1 && (fScratchDirectory = new File(sScratchDirectory)).exists()) {
                JobManagerFileMonitor.deleteDirectory(fScratchDirectory);
            }
            if (fStateFile.exists()) {
                fStateFile.delete();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

