/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Job.IJobStateListener;
import com.PecosLibrary.Job.JobManager;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobStatus;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.table.AbstractTableModel;

public class JobTableModel
extends AbstractTableModel
implements IJobStateListener {
    ArrayList<String> _jobIdList = new ArrayList();

    public JobTableModel() {
        try {
            JobManager.singleton().addJobStateListener("", this);
            this.updateData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void updateData() {
        try {
            this._jobIdList = JobManager.singleton().getAllJobs();
            this.fireTableDataChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public int getRowCount() {
        return this._jobIdList.size();
    }

    @Override
    public int getColumnCount() {
        return 10;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Description";
        }
        if (columnIndex == 1) {
            return "State";
        }
        if (columnIndex == 2) {
            return "Message";
        }
        if (columnIndex == 3) {
            return "Percent";
        }
        if (columnIndex == 4) {
            return "Creation Time";
        }
        if (columnIndex == 5) {
            return "Start Time";
        }
        if (columnIndex == 6) {
            return "Stop Time";
        }
        if (columnIndex == 7) {
            return "Elapsed Time";
        }
        if (columnIndex == 8) {
            return "Remaining Time";
        }
        if (columnIndex == 9) {
            return "Kill Job";
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return String.class;
        }
        if (columnIndex == 3) {
            return Integer.TYPE;
        }
        if (columnIndex == 4) {
            return String.class;
        }
        if (columnIndex == 5) {
            return String.class;
        }
        if (columnIndex == 6) {
            return String.class;
        }
        if (columnIndex == 7) {
            return String.class;
        }
        if (columnIndex == 8) {
            return String.class;
        }
        if (columnIndex == 9) {
            return JobState.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 9;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            String sJobID = this._jobIdList.get(rowIndex);
            JobState js = JobManager.singleton().getJobState(sJobID);
            if (columnIndex == 0) {
                if (js == null) {
                    return "";
                }
                return js.getWorkerDescription();
            }
            if (columnIndex == 1) {
                if (js == null) {
                    return "";
                }
                return js.getStatus().toString();
            }
            if (columnIndex == 2) {
                Exception error;
                if (js == null) {
                    return 0;
                }
                if (js.getStatus() == JobStatus.Working) {
                    String sMessage = js.getDescription();
                    return sMessage;
                }
                if (js.getStatus() == JobStatus.FinishedFailure && (error = js.getLastError()) != null) {
                    String sError = "Error: " + error.getMessage();
                    return sError;
                }
                return "";
            }
            if (columnIndex == 3) {
                if (js == null) {
                    return "";
                }
                double dPercentDone = js.getPercentDone();
                int iPercentDone = (int)dPercentDone;
                return iPercentDone;
            }
            if (columnIndex == 4) {
                if (js == null) {
                    return "";
                }
                Date endTime = js.getCreationTime();
                if (endTime.getTime() == 0L) {
                    return "";
                }
                return endTime.toString();
            }
            if (columnIndex == 5) {
                if (js == null) {
                    return "";
                }
                Date endTime = js.getStartTime();
                if (endTime.getTime() == 0L) {
                    return "";
                }
                return endTime.toString();
            }
            if (columnIndex == 6) {
                if (js == null) {
                    return "";
                }
                Date endTime = js.getEndTime();
                if (endTime.getTime() == 0L) {
                    return "";
                }
                return endTime.toString();
            }
            if (columnIndex == 7) {
                if (js.getStatus() == JobStatus.Working) {
                    Date start = js.getStartTime();
                    Date end = js.getTimeAtPercentDone();
                    return this.getTimeSpanString(start, end);
                }
                if (js.getStatus() == JobStatus.FinishedFailure || js.getStatus() == JobStatus.FinishedHalted || js.getStatus() == JobStatus.FinishedSuccess) {
                    Date start = js.getStartTime();
                    Date end = js.getEndTime();
                    return this.getTimeSpanString(start, end);
                }
                return "";
            }
            if (columnIndex == 8) {
                if (js.getStatus() == JobStatus.Working) {
                    Date start = js.getStartTime();
                    Date end = js.getTimeAtPercentDone();
                    double dPercentDone = js.getPercentDone();
                    return this.getTimeRemainingString(start, end, dPercentDone);
                }
                return "";
            }
            if (columnIndex == 9) {
                return js;
            }
            return "";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public void deleteSelectedRows(int[] selectedRows) {
        try {
            ArrayList<String> jobsToDelete = new ArrayList<String>();
            if (selectedRows == null) {
                return;
            }
            for (int iRow = 0; iRow < selectedRows.length; ++iRow) {
                int rowIndex = selectedRows[iRow];
                String sJobID = this._jobIdList.get(rowIndex);
                jobsToDelete.add(sJobID);
            }
            JobManager.singleton().removeJobs(jobsToDelete);
            this.updateData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void jobStateChanged(String sJobID, JobState oldJobState, JobState newJobState) {
        try {
            this.updateData();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    String getTimeRemainingString(Date start, Date timeAtPercentDone, double dPercentDone) {
        Object sTimeSpan = "";
        try {
            long secondsPerHour = 3600L;
            if (start == null) {
                return "";
            }
            if (timeAtPercentDone == null) {
                return "";
            }
            long diffInSeconds = (timeAtPercentDone.getTime() - start.getTime()) / 1000L;
            double dPercentLeft = 100.0 - dPercentDone;
            if (dPercentLeft <= 0.0) {
                return "s:0";
            }
            diffInSeconds = (long)((double)diffInSeconds / dPercentDone * dPercentLeft);
            long hours = diffInSeconds / secondsPerHour;
            long minutes = (diffInSeconds -= hours * secondsPerHour) / 60L;
            sTimeSpan = "h:" + Long.toString(hours) + " m:" + Long.toString(minutes) + " s:" + Long.toString(diffInSeconds -= minutes * 60L);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sTimeSpan;
    }

    String getTimeSpanString(Date start, Date end) {
        Object sTimeSpan = "";
        try {
            long secondsPerHour = 3600L;
            if (start == null) {
                return "";
            }
            if (end == null) {
                return "";
            }
            long diffInSeconds = (end.getTime() - start.getTime()) / 1000L;
            long hours = diffInSeconds / secondsPerHour;
            long minutes = (diffInSeconds -= hours * secondsPerHour) / 60L;
            sTimeSpan = "h:" + Long.toString(hours) + " m:" + Long.toString(minutes) + " s:" + Long.toString(diffInSeconds -= minutes * 60L);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sTimeSpan;
    }
}

