/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Job;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosLibrary.Job.IJobFinishedListener;
import com.PecosLibrary.Job.IJobStateListener;
import com.PecosLibrary.Job.IWorkerMonitor;
import com.PecosLibrary.Job.JobManagerFileMonitor;
import com.PecosLibrary.Job.JobManagerWorkerMonitor;
import com.PecosLibrary.Job.JobState;
import com.PecosLibrary.Job.JobStatus;
import com.PecosLibrary.Job.JobWorkerThread;
import com.PecosLibrary.Job.Worker_Base;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;

public class JobManager {
    static JobManager _singleton;
    String _sExecutionDirectory = "";
    String _sExecutionJarFile = "";
    String _sExecutionJarFilePath = "";
    boolean _bInitialized = false;
    Exception _initializeError = null;
    String _sProjectDirectory = "";
    String _sScratchDirectory = "";
    JobManagerWorkerMonitor _monitor = new JobManagerWorkerMonitor();
    JobManagerFileMonitor _fileMonitor = null;
    public static final String Scratch = "Scratch";

    JobManager() {
    }

    public static JobManager singleton() {
        if (_singleton == null) {
            _singleton = new JobManager();
        }
        return _singleton;
    }

    public void addJobFinishedListener(IJobFinishedListener listener) {
        try {
            this.getFileMonitor().addJobFinishedListener(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void removeJobFinishedListener(IJobFinishedListener listener) {
        try {
            this.getFileMonitor().removeJobFinishedListener(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void addJobStateListener(String sJobID, IJobStateListener listener) {
        try {
            this.getFileMonitor().addJobStateListener(sJobID, listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean containsJobFinishedListener(IJobFinishedListener listener) {
        try {
            return this.getFileMonitor().containsJobFinishedListener(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public boolean containsJobStateListener(String sJobID, IJobStateListener listener) {
        try {
            return this.getFileMonitor().containsJobStateListener(sJobID, listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    public void removeJobStateListener(IJobStateListener listener) {
        try {
            this.getFileMonitor().removeJobStateListener(listener);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public IWorkerMonitor getWorkerMonitor() {
        return this._monitor;
    }

    public JobManagerFileMonitor getFileMonitor() throws Exception {
        if (this._fileMonitor == null) {
            this._fileMonitor = new JobManagerFileMonitor(this.getJobsDirectory());
        }
        return this._fileMonitor;
    }

    public void removeJobs(ArrayList<String> jobs) {
        try {
            if (jobs == null) {
                return;
            }
            for (int iJob = 0; iJob < jobs.size(); ++iJob) {
                String sJobID = jobs.get(iJob);
                this.removeJob(sJobID);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void removeJob(String sJobID) {
        try {
            this.getFileMonitor().removeJob(sJobID);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public JobState getJobState(String sJobID) {
        try {
            return this.getFileMonitor().getJobState(sJobID);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public ArrayList<String> getJobs(JobStatus status) {
        ArrayList<String> jobs;
        try {
            jobs = this.getFileMonitor().getJobs(status);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            jobs = new ArrayList();
        }
        return jobs;
    }

    public ArrayList<String> getAllJobs() {
        ArrayList<Object> jobs = new ArrayList();
        try {
            jobs = this.getFileMonitor().getAllJobs();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            jobs = new ArrayList();
        }
        return jobs;
    }

    public void runJobInThread(String sJobID, String sClassName) throws Exception {
        String sJobStateFilePath = this.getJobStateFilePath(sJobID);
        String sJobParamsFilePath = this.getJobParamsFilePath(sJobID);
        File fJobStateFile = new File(sJobStateFilePath);
        File fJobParamsFile = new File(sJobParamsFilePath);
        if (!fJobStateFile.exists()) {
            throw new Exception("Missing state file for job : " + sJobID);
        }
        if (!fJobParamsFile.exists()) {
            throw new Exception("Missing params file for job : " + sJobID);
        }
        JobState jobState = JobState.readJobState(sJobStateFilePath);
        ParameterTree paramTree = new ParameterTree();
        paramTree.read(sJobParamsFilePath);
        Class<?> workerClass = Class.forName(sClassName);
        Object workerObj = workerClass.newInstance();
        if (!(workerObj instanceof Worker_Base)) {
            throw new Exception("Invalid worker class name '" + sClassName + "'");
        }
        Worker_Base worker = (Worker_Base)workerObj;
        JobWorkerThread jobWorkerThread = new JobWorkerThread(worker, paramTree, jobState, sJobStateFilePath);
        this._monitor.addWorkerThread(jobWorkerThread);
        jobWorkerThread.start();
    }

    public String getLogFilePath(String sJobID) throws Exception {
        String sJobDirectory = this.getJobsDirectory();
        String sJobLogFile = sJobDirectory + File.separator + sJobID + ".txt";
        return sJobLogFile;
    }

    public String getJobStateFilePath(String sJobID) throws Exception {
        String sJobDirectory = this.getJobsDirectory();
        String sJobStateFile = sJobDirectory + File.separator + sJobID + ".state";
        return sJobStateFile;
    }

    public String getJobParamsFilePath(String sJobID) throws Exception {
        String sJobDirectory = this.getJobsDirectory();
        String sJobStateFile = sJobDirectory + File.separator + sJobID + ".params";
        return sJobStateFile;
    }

    public String getJobKillFilePath(String sJobID) throws Exception {
        String sJobDirectory = this.getJobsDirectory();
        String sJobKillFile = sJobDirectory + File.separator + sJobID + ".kill";
        return sJobKillFile;
    }

    public void setScratchDirectory(String sScratchDirectory) throws Exception {
        File fScratchDir = new File(sScratchDirectory);
        if (!fScratchDir.exists() && !fScratchDir.mkdirs()) {
            throw new Exception("Unable to create directory : " + sScratchDirectory);
        }
        this._sScratchDirectory = sScratchDirectory;
    }

    public String getScratchDirectory() throws Exception {
        if (!this._sScratchDirectory.equals("")) {
            File fScratchDir = new File(this._sScratchDirectory);
            if (!fScratchDir.exists() && !fScratchDir.mkdirs()) {
                throw new Exception("Unable to create directory : " + this._sScratchDirectory);
            }
            return this._sScratchDirectory;
        }
        String sHomeDir = SharedApplicationData.singleton().homeDirectory();
        String sScratchDir = sHomeDir + File.separator + Scratch;
        File fScratchDir = new File(sScratchDir);
        if (!fScratchDir.exists() && !fScratchDir.mkdirs()) {
            throw new Exception("Unable to create directory : " + sScratchDir);
        }
        return sScratchDir;
    }

    String getJobsDirectory() throws Exception {
        String sJobsDir;
        File fJobsDir;
        String sHomeDir = SharedApplicationData.singleton().homeDirectory();
        if (!this._sProjectDirectory.equals("")) {
            sHomeDir = this._sProjectDirectory;
        }
        if (!(fJobsDir = new File(sJobsDir = sHomeDir + File.separator + "Jobs")).exists() && !fJobsDir.mkdirs()) {
            throw new Exception("Unable to create directory : " + sJobsDir);
        }
        return sJobsDir;
    }

    public String findLogFile(String[] args) {
        if (args == null) {
            return "";
        }
        for (int iArg = 0; iArg < args.length - 1; ++iArg) {
            String sFlag = args[iArg];
            String sValue = args[iArg + 1];
            if (!sFlag.equals("-logFile")) continue;
            return sValue;
        }
        return "";
    }

    public String findJobID(String[] args) {
        if (args == null) {
            return "";
        }
        for (int iArg = 0; iArg < args.length - 1; ++iArg) {
            String sFlag = args[iArg];
            String sValue = args[iArg + 1];
            if (!sFlag.equals("-batch")) continue;
            return sValue;
        }
        return "";
    }

    public String findClassName(String[] args) {
        if (args == null) {
            return "";
        }
        for (int iArg = 0; iArg < args.length - 1; ++iArg) {
            String sFlag = args[iArg];
            String sValue = args[iArg + 1];
            if (!sFlag.equals("-batchClass")) continue;
            return sValue;
        }
        return "";
    }

    public boolean isInBatchMode(String[] args) {
        try {
            String sBatchClass = this.findClassName(args);
            String sJobID = this.findJobID(args);
            return !sBatchClass.equals("") && !sJobID.equals("");
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    public void runBatchMode(String[] args) {
        try {
            String sBatchClass = this.findClassName(args);
            String sJobID = this.findJobID(args);
            String sLogFile = this.findLogFile(args);
            if (sLogFile.length() > 1) {
                ExceptionMonitor.instance().setPath(sLogFile);
            }
            this.runJobInThread(sJobID, sBatchClass);
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void setProjectDirectory(String sProjectDirectory) {
        this._sProjectDirectory = sProjectDirectory;
    }

    public String getProjectDirectory() {
        return this._sProjectDirectory;
    }

    public void initialize(String sExeDirectory, String sExecutableJarFile) {
        try {
            this._bInitialized = false;
            String sJarPath = sExeDirectory + File.separator + sExecutableJarFile;
            File exeDir = new File(sExeDirectory);
            File jarFile = new File(sJarPath);
            if (jarFile.exists()) {
                this._sExecutionJarFile = sExecutableJarFile;
                this._sExecutionDirectory = sExeDirectory;
                this._sExecutionJarFilePath = sJarPath;
                this._bInitialized = true;
                return;
            }
            File classesDir = exeDir.getParentFile();
            File buildDir = classesDir.getParentFile();
            String sDistDir = buildDir.getPath() + File.separator + "dist";
            sJarPath = sDistDir + File.separator + sExecutableJarFile;
            jarFile = new File(sJarPath);
            if (jarFile.exists()) {
                this._sExecutionJarFile = sExecutableJarFile;
                this._sExecutionDirectory = sExeDirectory;
                this._sExecutionJarFilePath = sJarPath;
                this._bInitialized = true;
                return;
            }
            this._initializeError = new Exception("Unable to find : " + sExecutableJarFile + " in directory " + sExeDirectory);
        }
        catch (Exception error) {
            this._initializeError = error;
            throw error;
        }
    }

    public String getTemporaryScratchDirectory() {
        try {
            return Tools_FileSystem.confirmSubDirectoryExists(this.getScratchDirectory(), UUID.randomUUID().toString());
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "ERROR";
        }
    }
}

