/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Math.Matrix_Simple;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintParameter;
import com.PecosLibrary.Windows.Java2D.Java2D_PaintableInterface;
import com.PecosLibrary.Windows.Java2D.Java2D_Transform;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PromaxGrid
implements Java2D_PaintableInterface {
    protected Corner[] m_corners;
    public static final String FileName = "PromaxGrid.xml";
    protected int m_inlineMin;
    protected int m_inlineMax;
    protected int m_crosslineMin;
    protected int m_crosslineMax;
    protected double m_crosslineBinSize;
    protected double m_crosslineAngle;
    protected double m_crosslineAngle_Cos;
    protected double m_crosslineAngle_Sin;
    protected double m_inlineBinSize;
    protected double m_inlineAngle;
    protected double m_inlineAngle_Cos;
    protected double m_inlineAngle_Sin;
    protected double m_originX;
    protected double m_originY;
    protected int m_index_MinI_MinC = -999;
    protected int m_index_MaxI_MaxC = -999;
    protected int m_index_MinI_MaxC = -999;
    protected int m_index_MaxI_MinC = -999;
    protected boolean m_valid = false;
    protected String m_error = "";
    protected double m_sumCount = 1.0E-40;
    protected double m_sumX;
    protected double m_sumXI;
    protected double m_sumXC;
    protected double m_sumY;
    protected double m_sumYI;
    protected double m_sumYC;
    protected double m_sumI;
    protected double m_sumC;
    protected double m_sumIC;
    protected double m_sumII;
    protected double m_sumCC;

    public int inlineMin() {
        return this.m_inlineMin;
    }

    public int inlineMax() {
        return this.m_inlineMax;
    }

    public int crosslineMin() {
        return this.m_crosslineMin;
    }

    public int crosslineMax() {
        return this.m_crosslineMax;
    }

    public boolean valid() {
        return this.m_valid;
    }

    public PromaxGrid() {
        try {
            this.m_corners = new Corner[4];
            for (int n = 0; n < this.m_corners.length; ++n) {
                this.m_corners[n] = new Corner();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepSegyScan(long numTraces) {
        try {
            this.m_crosslineMax = Integer.MIN_VALUE;
            this.m_crosslineMin = Integer.MAX_VALUE;
            this.m_inlineMax = Integer.MIN_VALUE;
            this.m_inlineMin = Integer.MAX_VALUE;
            this.m_sumCount = 1.0E-40;
            this.m_sumX = 0.0;
            this.m_sumXI = 0.0;
            this.m_sumXC = 0.0;
            this.m_sumY = 0.0;
            this.m_sumYI = 0.0;
            this.m_sumYC = 0.0;
            this.m_sumI = 0.0;
            this.m_sumC = 0.0;
            this.m_sumIC = 0.0;
            this.m_sumII = 0.0;
            this.m_sumCC = 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void segyScanAppend(int inline, int crossline, double x, double y) {
        try {
            this.m_crosslineMax = Math.max(this.m_crosslineMax, crossline);
            this.m_crosslineMin = Math.min(this.m_crosslineMin, crossline);
            this.m_inlineMax = Math.max(this.m_inlineMax, inline);
            this.m_inlineMin = Math.min(this.m_inlineMin, inline);
            this.m_sumCount += 1.0;
            this.m_sumX += x;
            this.m_sumXI += x * (double)inline;
            this.m_sumXC += x * (double)crossline;
            this.m_sumY += y;
            this.m_sumYI += y * (double)inline;
            this.m_sumYC += y * (double)crossline;
            this.m_sumI += (double)inline;
            this.m_sumC += (double)crossline;
            this.m_sumIC += (double)(crossline * inline);
            this.m_sumII += (double)(inline * inline);
            this.m_sumCC += (double)(crossline * crossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void segyScanFinish() {
        try {
            Matrix_Simple matrixMain = new Matrix_Simple(3, 3);
            matrixMain.Data[0][0] = this.m_sumCount;
            matrixMain.Data[0][1] = this.m_sumI;
            matrixMain.Data[0][2] = this.m_sumC;
            matrixMain.Data[1][0] = this.m_sumI;
            matrixMain.Data[1][1] = this.m_sumII;
            matrixMain.Data[1][2] = this.m_sumIC;
            matrixMain.Data[2][0] = this.m_sumC;
            matrixMain.Data[2][1] = this.m_sumIC;
            matrixMain.Data[2][2] = this.m_sumCC;
            Matrix_Simple matrixLeftX = new Matrix_Simple(3, 1);
            matrixLeftX.Data[0][0] = this.m_sumX;
            matrixLeftX.Data[1][0] = this.m_sumXI;
            matrixLeftX.Data[2][0] = this.m_sumXC;
            Matrix_Simple matrixRightX = matrixMain.solve(matrixLeftX);
            double originX = matrixRightX.Data[0][0];
            double alpha = matrixRightX.Data[1][0];
            double beta = matrixRightX.Data[2][0];
            Matrix_Simple matrixLeftY = new Matrix_Simple(3, 1);
            matrixLeftY.Data[0][0] = this.m_sumY;
            matrixLeftY.Data[1][0] = this.m_sumYI;
            matrixLeftY.Data[2][0] = this.m_sumYC;
            Matrix_Simple matrixRightY = matrixMain.solve(matrixLeftY);
            double originY = matrixRightY.Data[0][0];
            double delta = matrixRightY.Data[1][0];
            double gamma = matrixRightY.Data[2][0];
            double inlineSize = Math.sqrt(alpha * alpha + delta * delta);
            double crosslineSize = Math.sqrt(beta * beta + gamma * gamma);
            this.m_corners[0].Crossline = this.m_crosslineMin;
            this.m_corners[0].Inline = this.m_inlineMin;
            this.m_corners[1].Crossline = this.m_crosslineMin;
            this.m_corners[1].Inline = this.m_inlineMax;
            this.m_corners[2].Crossline = this.m_crosslineMax;
            this.m_corners[2].Inline = this.m_inlineMax;
            this.m_corners[3].Crossline = this.m_crosslineMax;
            this.m_corners[3].Inline = this.m_inlineMin;
            for (int n = 0; n < 4; ++n) {
                this.m_corners[n].X = originX + alpha * (double)this.m_corners[n].Inline + beta * (double)this.m_corners[n].Crossline;
                this.m_corners[n].Y = originY + delta * (double)this.m_corners[n].Inline + gamma * (double)this.m_corners[n].Crossline;
            }
            this.prepareConversionGrid();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setCorner(int index, int inline, int crossline, double x, double y) {
        try {
            this.m_valid = false;
            this.m_corners[index].X = x;
            this.m_corners[index].Y = y;
            this.m_corners[index].Inline = inline;
            this.m_corners[index].Crossline = crossline;
            this.prepareConversionGrid();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public int getInline(int index) {
        return this.m_corners[index].Inline;
    }

    public int getCrossline(int index) {
        return this.m_corners[index].Crossline;
    }

    public double getX(int index) {
        return this.m_corners[index].X;
    }

    public double getY(int index) {
        return this.m_corners[index].Y;
    }

    public double getWorldY(double inline, double crossline) {
        try {
            double deltaInline = inline - (double)this.m_inlineMin;
            double deltaCrossline = crossline - (double)this.m_crosslineMin;
            double yi = deltaInline * this.m_inlineBinSize * this.m_inlineAngle_Sin;
            double yc = deltaCrossline * this.m_crosslineBinSize * this.m_crosslineAngle_Sin;
            return this.m_originY + yi + yc;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public double getWorldX(double inline, double crossline) {
        try {
            double deltaInline = inline - (double)this.m_inlineMin;
            double deltaCrossline = crossline - (double)this.m_crosslineMin;
            double xi = deltaInline * this.m_inlineBinSize * this.m_inlineAngle_Cos;
            double xc = deltaCrossline * this.m_crosslineBinSize * this.m_crosslineAngle_Cos;
            return this.m_originX + xi + xc;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0.0;
        }
    }

    public int getCrossline(double x, double y) {
        try {
            double dx = (x - this.m_originX) * this.m_inlineAngle_Sin;
            double dy = (y - this.m_originY) * this.m_inlineAngle_Cos;
            double fc = this.m_inlineAngle_Sin * this.m_crosslineAngle_Cos - this.m_inlineAngle_Cos * this.m_crosslineAngle_Sin;
            double temp = (dx - dy) / fc;
            double crossline = (double)this.m_crosslineMin + temp / this.m_crosslineBinSize;
            return (int)Math.round(crossline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public int getInline(double x, double y) {
        try {
            double dx = (x - this.m_originX) * this.m_crosslineAngle_Sin;
            double dy = (y - this.m_originY) * this.m_crosslineAngle_Cos;
            double fc = this.m_inlineAngle_Cos * this.m_crosslineAngle_Sin - this.m_inlineAngle_Sin * this.m_crosslineAngle_Cos;
            double temp = (dx - dy) / fc;
            double inline = (double)this.m_inlineMin + temp / this.m_inlineBinSize;
            return (int)Math.round(inline);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    public void prepareConversionGrid() {
        try {
            this.m_valid = false;
            this.m_crosslineMax = Integer.MIN_VALUE;
            this.m_crosslineMin = Integer.MAX_VALUE;
            this.m_inlineMax = Integer.MIN_VALUE;
            this.m_inlineMin = Integer.MAX_VALUE;
            for (int n = 0; n < 4; ++n) {
                this.m_crosslineMax = Math.max(this.m_crosslineMax, this.m_corners[n].Crossline);
                this.m_crosslineMin = Math.min(this.m_crosslineMin, this.m_corners[n].Crossline);
                this.m_inlineMax = Math.max(this.m_inlineMax, this.m_corners[n].Inline);
                this.m_inlineMin = Math.min(this.m_inlineMin, this.m_corners[n].Inline);
            }
            int numInlines = 1 + this.m_inlineMax - this.m_inlineMin;
            int numCrosslines = 1 + this.m_crosslineMax - this.m_crosslineMin;
            if (numInlines <= 1) {
                this.m_error = "inline range == 0";
                return;
            }
            if (numCrosslines <= 1) {
                this.m_error = "crossline range == 0";
                return;
            }
            this.m_index_MinI_MinC = -999;
            this.m_index_MaxI_MaxC = -999;
            this.m_index_MinI_MaxC = -999;
            this.m_index_MaxI_MinC = -999;
            for (int n = 0; n < 4; ++n) {
                if (this.m_crosslineMin == this.m_corners[n].Crossline && this.m_inlineMin == this.m_corners[n].Inline) {
                    this.m_index_MinI_MinC = n;
                }
                if (this.m_crosslineMax == this.m_corners[n].Crossline && this.m_inlineMax == this.m_corners[n].Inline) {
                    this.m_index_MaxI_MaxC = n;
                }
                if (this.m_crosslineMin == this.m_corners[n].Crossline && this.m_inlineMax == this.m_corners[n].Inline) {
                    this.m_index_MaxI_MinC = n;
                }
                if (this.m_crosslineMax != this.m_corners[n].Crossline || this.m_inlineMin != this.m_corners[n].Inline) continue;
                this.m_index_MinI_MaxC = n;
            }
            if (this.m_index_MaxI_MaxC < 0 || this.m_index_MinI_MinC < 0 || this.m_index_MaxI_MinC < 0 || this.m_index_MinI_MaxC < 0) {
                this.m_error = "Corners not valid;";
                return;
            }
            this.m_originX = this.m_corners[this.m_index_MinI_MinC].X;
            this.m_originY = this.m_corners[this.m_index_MinI_MinC].Y;
            double dx1 = this.m_corners[this.m_index_MaxI_MaxC].X - this.m_corners[this.m_index_MaxI_MinC].X;
            double dy1 = this.m_corners[this.m_index_MaxI_MaxC].Y - this.m_corners[this.m_index_MaxI_MinC].Y;
            double length1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
            double size1 = length1 / (double)(numCrosslines - 1);
            double dx2 = this.m_corners[this.m_index_MinI_MaxC].X - this.m_corners[this.m_index_MinI_MinC].X;
            double dy2 = this.m_corners[this.m_index_MinI_MaxC].Y - this.m_corners[this.m_index_MinI_MinC].Y;
            double length2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            double size2 = length2 / (double)(numCrosslines - 1);
            this.m_crosslineBinSize = size1;
            this.m_crosslineAngle = Math.atan2(dy1, dx1);
            this.m_crosslineAngle_Cos = Math.cos(this.m_crosslineAngle);
            this.m_crosslineAngle_Sin = Math.sin(this.m_crosslineAngle);
            dx1 = this.m_corners[this.m_index_MaxI_MaxC].X - this.m_corners[this.m_index_MinI_MaxC].X;
            dy1 = this.m_corners[this.m_index_MaxI_MaxC].Y - this.m_corners[this.m_index_MinI_MaxC].Y;
            length1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
            size1 = length1 / (double)(numInlines - 1);
            dx2 = this.m_corners[this.m_index_MaxI_MinC].X - this.m_corners[this.m_index_MinI_MinC].X;
            dy2 = this.m_corners[this.m_index_MaxI_MinC].Y - this.m_corners[this.m_index_MinI_MinC].Y;
            length2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);
            size2 = length2 / (double)(numInlines - 1);
            this.m_inlineBinSize = size1;
            this.m_inlineAngle = Math.atan2(dy1, dx1);
            this.m_inlineAngle_Cos = Math.cos(this.m_inlineAngle);
            this.m_inlineAngle_Sin = Math.sin(this.m_inlineAngle);
            System.out.println("prepareConversionGrid()  m_inlineBinSize = " + this.m_inlineBinSize);
            System.out.println("prepareConversionGrid()  m_inlineAngle = " + this.m_inlineAngle);
            System.out.println("prepareConversionGrid()  m_crosslineBinSize = " + this.m_crosslineBinSize);
            System.out.println("prepareConversionGrid()  m_crosslineAngle = " + this.m_crosslineAngle);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readFourCorner(String fileName) {
        try {
            int row;
            this.m_valid = false;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            for (row = 0; line != null && row < 4; ++row) {
                ArrayList<String> tokens = Tools_Strings.tokenizer_space(line, false);
                int inline = Integer.parseInt(tokens.get(0));
                int xline = Integer.parseInt(tokens.get(1));
                double x = Double.parseDouble(tokens.get(2));
                double y = Double.parseDouble(tokens.get(3));
                this.m_corners[row].Inline = inline;
                this.m_corners[row].Crossline = xline;
                this.m_corners[row].X = x;
                this.m_corners[row].Y = y;
                line = br.readLine();
            }
            if (row < 4) {
                return;
            }
            this.prepareConversionGrid();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void save(String fileName) {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("GridCorners");
            document.appendChild(root);
            this.writeToNode(root);
            Tools_XML.writeDocumentToFile(document, fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void read(String fileName) {
        try {
            this.m_valid = false;
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            this.readFromNode(root);
            this.prepareConversionGrid();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readFromNode(Element node) throws Exception {
        try {
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(node, "Corner");
            int index = 0;
            for (Element element : nodes) {
                Corner corner = new Corner();
                if (index < 4) {
                    this.m_corners[index].X = Tools_XML.getDouble(element, "X", -9999.0);
                    this.m_corners[index].Y = Tools_XML.getDouble(element, "Y", -9999.0);
                    this.m_corners[index].Inline = Tools_XML.getInt(element, "Inline", -9999);
                    this.m_corners[index].Crossline = Tools_XML.getInt(element, "Crossline", -9999);
                }
                ++index;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void writeToNode(Element node) throws Exception {
        try {
            for (Corner corner : this.m_corners) {
                Element subNode = node.getOwnerDocument().createElement("Corner");
                node.appendChild(subNode);
                subNode.setAttribute("Inline", Integer.toString(corner.Inline));
                subNode.setAttribute("Crossline", Integer.toString(corner.Crossline));
                subNode.setAttribute("X", Double.toString(corner.X));
                subNode.setAttribute("Y", Double.toString(corner.Y));
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public boolean Java2D_ImageContentsDirty(int supplementalData) {
        return false;
    }

    @Override
    public int Java2D_MaximumPaintLevel(int supplementalData) {
        return 0;
    }

    @Override
    public void Java2D_Paint(Java2D_PaintParameter paintParameter, int supplementalData) {
        try {
            if (paintParameter.PaintLevel != 0) {
                return;
            }
            Java2D_Transform transform = paintParameter.Transform;
            Graphics2D g2d = paintParameter.G2D;
            g2d.setColor(Color.BLACK);
            double scaleX = transform.scaleX();
            double shiftX = transform.shiftX();
            double scaleY = transform.scaleY();
            double shiftY = transform.shiftY();
            transform.drawLine(g2d, this.m_corners[this.m_index_MinI_MinC].X, this.m_corners[this.m_index_MinI_MinC].Y, this.m_corners[this.m_index_MinI_MaxC].X, this.m_corners[this.m_index_MinI_MaxC].Y);
            transform.drawLine(g2d, this.m_corners[this.m_index_MinI_MinC].X, this.m_corners[this.m_index_MinI_MinC].Y, this.m_corners[this.m_index_MaxI_MinC].X, this.m_corners[this.m_index_MaxI_MinC].Y);
            transform.drawLine(g2d, this.m_corners[this.m_index_MaxI_MaxC].X, this.m_corners[this.m_index_MaxI_MaxC].Y, this.m_corners[this.m_index_MinI_MaxC].X, this.m_corners[this.m_index_MinI_MaxC].Y);
            transform.drawLine(g2d, this.m_corners[this.m_index_MaxI_MaxC].X, this.m_corners[this.m_index_MaxI_MaxC].Y, this.m_corners[this.m_index_MaxI_MinC].X, this.m_corners[this.m_index_MaxI_MinC].Y);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeWorld(Range_Double rangeX, Range_Double rangeY, int supplementalData) {
        try {
            for (Corner c : this.m_corners) {
                rangeX.expandRange(c.X);
                rangeY.expandRange(c.Y);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void Java2D_RangeColor(Range_Double rangeC, int supplementalData) {
    }

    @Override
    public void Java2D_PaintDatum(Java2D_PaintParameter paintParameter) {
    }

    public static class Corner {
        public int Inline;
        public int Crossline;
        public double X;
        public double Y;
    }
}

