/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class GeometryReceiverTableWrapper {
    protected boolean m_valid = false;
    protected String m_failureReason = "";
    protected Table_Abstract m_table;
    protected Table_Abstract m_relationTable;
    protected Table_Abstract m_duplicateTable;
    protected int m_index_Line = -9999;
    protected int m_index_Point = -9999;
    protected int m_index_Index = -9999;
    protected int m_index_Line_Rel = -9999;
    protected int m_index_PointFrom_Rel = -9999;
    protected int m_index_PointTo_Rel = -9999;
    protected int m_index_Index_Rel = -9999;
    protected int m_index_ChanFrom = -9999;
    protected int m_index_ChanTo = -9999;
    protected int m_index_ChanIn = -9999;
    protected HashMap_Integers<Integer> m_hashLPI = new HashMap_Integers();
    protected HashMap_Integers<String> m_fileHash;

    public boolean valid() {
        return this.m_valid;
    }

    public String failureReason() {
        return this.m_failureReason;
    }

    public Table_Abstract duplicateTable() {
        return this.m_duplicateTable;
    }

    public int findReceiverRowFromChan(ArrayList<Integer> relationRows, int chan) {
        try {
            for (Integer row : relationRows) {
                int r = row;
                int fromChan = this.m_relationTable.getInt(r, this.m_index_ChanFrom);
                int toChan = this.m_relationTable.getInt(r, this.m_index_ChanTo);
                int inc = this.m_relationTable.getInt(r, this.m_index_ChanIn);
                int line = 0;
                int index = 0;
                if (this.m_index_Line_Rel >= 0) {
                    line = this.m_relationTable.getInt(r, this.m_index_Line_Rel);
                }
                if (this.m_index_Index_Rel >= 0) {
                    index = this.m_relationTable.getInt(r, this.m_index_Index_Rel);
                }
                if (chan < fromChan || chan > toChan || inc > 1) continue;
                int pointNumberFrom = this.m_relationTable.getInt(r, this.m_index_PointFrom_Rel);
                int point = pointNumberFrom + (chan - fromChan);
                if (this.m_hashLPI.containsKey(line, point, index)) {
                    return this.m_hashLPI.get(line, point, index);
                }
                return -9999;
            }
            return -9999;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return -9999;
        }
    }

    public GeometryReceiverTableWrapper(Table_Abstract table, Table_Abstract relationTable, HashMap_Integers<String> fileHash) {
        try {
            this.m_fileHash = fileHash;
            this.m_table = table;
            this.m_relationTable = relationTable;
            this.m_index_ChanFrom = this.m_relationTable.column_indexOfColumn("FromChannel");
            this.m_index_ChanTo = this.m_relationTable.column_indexOfColumn("ToChannel");
            this.m_index_ChanIn = this.m_relationTable.column_indexOfColumn("ChannelIncrement");
            this.m_duplicateTable = new Table_Memory();
            this.m_duplicateTable.setName("Duplicates");
            int indexLine = this.m_duplicateTable.column_append("LineNumber", DataType.Int);
            int indexPoint = this.m_duplicateTable.column_append("PointNumber", DataType.Int);
            int indexIndex = this.m_duplicateTable.column_append("PointIndex", DataType.Int);
            int indexFile1 = this.m_duplicateTable.column_append("File 1", DataType.Text);
            int indexLine1 = this.m_duplicateTable.column_append("Line 1", DataType.Int);
            int indexFile2 = this.m_duplicateTable.column_append("File 2", DataType.Text);
            int indexLine2 = this.m_duplicateTable.column_append("Line 2", DataType.Int);
            if (!this.m_table.column_exists("PointNumber")) {
                this.m_failureReason = "Receiver must have PointNumber field";
                return;
            }
            if (!this.m_relationTable.column_exists("ToReceiverPointNumber")) {
                this.m_failureReason = "Relation must have ToReceiverPointNumber";
                return;
            }
            if (!this.m_relationTable.column_exists("FromReceiverPointNumber")) {
                this.m_failureReason = "Relation must have FromReceiverPointNumber";
                return;
            }
            this.m_index_Point = this.m_table.column_indexOfColumn("PointNumber");
            this.m_index_PointTo_Rel = this.m_relationTable.column_indexOfColumn("ToReceiverPointNumber");
            this.m_index_PointFrom_Rel = this.m_relationTable.column_indexOfColumn("FromReceiverPointNumber");
            this.m_index_Index = -9999;
            this.m_index_Index_Rel = -9999;
            if (this.m_table.column_exists("PointIndex")) {
                if (!this.m_relationTable.column_exists("ReceiverPointIndex")) {
                    this.m_failureReason = "Receiver has PointIndex, therefore Relation must have ReceiverPointIndex";
                    return;
                }
                this.m_index_Index = this.m_table.column_indexOfColumn("PointIndex");
                this.m_index_Index_Rel = this.m_relationTable.column_indexOfColumn("ReceiverPointIndex");
            }
            this.m_index_Line = -9999;
            this.m_index_Line_Rel = -9999;
            if (this.m_table.column_exists("LineNumber")) {
                if (!this.m_relationTable.column_exists("ReceiverLineNumber")) {
                    this.m_failureReason = "Receiver has LineNumber, therefore Relation must have ReceiverLineNumber";
                }
                this.m_index_Line = this.m_table.column_indexOfColumn("LineNumber");
                this.m_index_Line_Rel = this.m_relationTable.column_indexOfColumn("ReceiverLineNumber");
            }
            int colLineNumber = this.m_table.column_indexOfColumn("LineNumberInFile");
            int colFileID = this.m_table.column_indexOfColumn("FileID");
            for (int row = 0; row < this.m_table.row_count(); ++row) {
                int line = 0;
                int point = this.m_table.getInt(row, this.m_index_Point);
                int index = 0;
                if (this.m_index_Index >= 0) {
                    index = this.m_table.getInt(row, this.m_index_Index);
                }
                if (this.m_index_Line >= 0) {
                    line = this.m_table.getInt(row, this.m_index_Line);
                }
                if (this.m_hashLPI.containsKey(line, point, index)) {
                    int otherRow = this.m_hashLPI.get(line, point, index);
                    int otherFileID = this.m_table.getInt(otherRow, colFileID);
                    int otherLineNumber = this.m_table.getInt(otherRow, colLineNumber);
                    String otherFile = this.m_fileHash.get(otherFileID);
                    int fileID = this.m_table.getInt(row, colFileID);
                    int lineNumber = this.m_table.getInt(row, colLineNumber);
                    String file = this.m_fileHash.get(fileID);
                    int dr = this.m_duplicateTable.row_increment();
                    this.m_duplicateTable.putInt(dr, indexLine, line);
                    this.m_duplicateTable.putInt(dr, indexPoint, point);
                    this.m_duplicateTable.putInt(dr, indexIndex, index);
                    this.m_duplicateTable.putString(dr, indexFile1, file);
                    this.m_duplicateTable.putInt(dr, indexLine1, lineNumber);
                    this.m_duplicateTable.putString(dr, indexFile2, otherFile);
                    this.m_duplicateTable.putInt(dr, indexLine2, otherLineNumber);
                    continue;
                }
                this.m_hashLPI.put(new Integer(row), line, point, index);
            }
            this.m_valid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

