/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Geometry;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;

public class CdpParser {
    public Table_Abstract Table;
    public int NextID = 1000;
    public int ColumnIndex_ID;
    public int ColumnIndex_CDP;
    protected HashMap_Integers<Integer> m_mapCDP = new HashMap_Integers();
    protected HashKey_Integer m_keyID = new HashKey_Integer(1);
    protected HashMap_Integer m_mapID = new HashMap_Integer();
    protected boolean m_useCDP;
    protected HashMap_Integers<Integer> m_hashIC = new HashMap_Integers();
    protected int m_nextCDP = 1;
    protected int[] m_columnIndex = new int[60];
    protected int[] m_headerIndex = new int[60];
    protected DataType[] m_dataType = new DataType[60];
    public boolean IgnoreTraceCode = false;

    public CdpParser(Table_Abstract table, boolean useCDP) {
        try {
            this.m_useCDP = useCDP;
            this.Table = table;
            this.ColumnIndex_ID = this.Table.column_append("CDPID", DataType.Int);
            this.ColumnIndex_CDP = this.Table.column_append("CDP", DataType.Int);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void handleEnsemble(Ensemble ensemble) {
        try {
            int n;
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int headerIndex_Inline = -9999;
            int headerIndex_Crossline = -9999;
            if (this.m_useCDP) {
                if (!dict.containsEntry("CDP", "CDP")) {
                    return;
                }
            } else {
                headerIndex_Inline = dict.getEntryIndex("CDP", "Inline");
                headerIndex_Crossline = dict.getEntryIndex("CDP", "Crossline");
            }
            int headerIndexFileID = dict.getEntryIndex("Trace", "FileID");
            int headerIndexIndex = dict.getEntryIndex("Trace", "IndexInFile");
            int indexTraceCode = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "TraceCode")) {
                indexTraceCode = ensemble.dictionary().getEntryIndex("Trace", "TraceCode");
            }
            int headerIndex_CDP = dict.addEntry("CDP", "CDP", DataType.Int);
            int headerIndex_ID = dict.addEntry("CDP", "CDPID", DataType.Int);
            int headerIndex_TraceID = dict.addEntry("Trace", "CDPID", DataType.Int);
            if (this.m_columnIndex.length < dict.size()) {
                this.m_columnIndex = new int[dict.size() + 10];
                this.m_headerIndex = new int[dict.size() + 10];
                this.m_dataType = new DataType[dict.size() + 10];
            }
            int numConnections = 0;
            for (n = 0; n < dict.size(); ++n) {
                EnsembleHeaderDictionary.Entry entry = dict.getEntry(n);
                if (!entry.Table.equalsIgnoreCase("CDP")) continue;
                this.m_headerIndex[numConnections] = entry.Index;
                this.m_dataType[numConnections] = entry.PreferredType;
                this.m_columnIndex[numConnections] = this.Table.column_append(entry.Column, entry.PreferredType);
                ++numConnections;
            }
            for (n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int cdp = -9999;
                if (this.m_useCDP) {
                    cdp = header.getInt(headerIndex_CDP);
                } else {
                    int crossline;
                    int inline = header.getInt(headerIndex_Inline);
                    if (this.m_hashIC.containsKey(inline, crossline = header.getInt(headerIndex_Crossline))) {
                        cdp = this.m_hashIC.get(inline, crossline);
                    } else {
                        cdp = this.m_nextCDP++;
                        this.m_hashIC.put(new Integer(cdp), inline, crossline);
                    }
                    header.putInt(headerIndex_CDP, cdp);
                }
                int traceCode = 1;
                if (indexTraceCode >= 0) {
                    traceCode = header.getInt(indexTraceCode);
                }
                int id = -9999;
                if (this.IgnoreTraceCode || traceCode == 1) {
                    if (!this.m_mapCDP.containsKey(cdp)) {
                        id = cdp;
                        row = this.Table.row_increment();
                        for (int k = 0; k < numConnections; ++k) {
                            if (this.m_dataType[k] == DataType.Int || this.m_dataType[k] == DataType.Short) {
                                int v = header.getInt(this.m_headerIndex[k]);
                                this.Table.putInt(row, this.m_columnIndex[k], v);
                                continue;
                            }
                            double v = header.getDouble(this.m_headerIndex[k]);
                            this.Table.putDouble(row, this.m_columnIndex[k], v);
                        }
                        this.Table.putInt(row, this.ColumnIndex_ID, id);
                        this.Table.putInt(row, this.ColumnIndex_CDP, cdp);
                        this.m_mapCDP.put(new Integer(row), cdp);
                        ++this.NextID;
                    } else {
                        row = this.m_mapCDP.get(cdp);
                        id = this.Table.getInt(row, this.ColumnIndex_ID);
                        header.putInt(headerIndex_TraceID, id);
                    }
                }
                header.putInt(headerIndex_TraceID, id);
                header.putInt(headerIndex_ID, id);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }
}

