/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker;

import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_XML;
import com.PecosLibrary.Ensemble.Worker.EnsembleWorker_CompleteList;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Tools_EnsembleWorker {
    public static void readFromNode(EnsembleWorker_Sequence sequence, Element node) throws Exception {
        try {
            EnsembleWorker_CompleteList list = EnsembleWorker_CompleteList.singleton();
            String encodeMethod = "Error;";
            if (node.hasAttribute("WorkerEncodeMethod")) {
                encodeMethod = node.getAttribute("WorkerEncodeMethod");
            }
            boolean useUniqueID = encodeMethod.equalsIgnoreCase("EncodeUsingUniqueID");
            sequence.clear();
            ArrayList<Element> nodes = Tools_XML.getChildListWithTagName(node, "Worker");
            for (Element element : nodes) {
                EnsembleWorker_Base worker = null;
                if (useUniqueID) {
                    String uniqueID = "";
                    if (element.hasAttribute("UniqueID")) {
                        uniqueID = element.getAttribute("UniqueID");
                    }
                    worker = list.getWorkerFromUniqueID(uniqueID);
                }
                if (worker == null) continue;
                worker.readParametersFromXmlNode(element);
                worker.addListener(sequence);
                sequence.add(worker);
            }
            sequence.setSelectedIndex(0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void writeToNode(EnsembleWorker_Sequence sequence, Element node, String encodeMethod) throws Exception {
        try {
            node.setAttribute("WorkerEncodeMethod", encodeMethod);
            for (int n = 0; n < sequence.size(); ++n) {
                EnsembleWorker_Base worker = sequence.worker(n);
                Tools_XML.addBlockComment(node, String.format("%s:  %s", worker.Abbreviation, worker.ShortDescription));
                Element workerNode = node.getOwnerDocument().createElement("Worker");
                workerNode.setAttribute("ClassName", worker.getClass().getName());
                workerNode.setAttribute("UniqueID", worker.uniqueID());
                worker.saveParametersInXmlNode(workerNode);
                node.appendChild(workerNode);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void save(EnsembleWorker_Sequence sequence, String fileName) {
        try {
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("EnsembleWorkerSequence");
            String encodeMethod = "EncodeUsingUniqueID";
            document.appendChild(root);
            Tools_EnsembleWorker.writeToNode(sequence, root, encodeMethod);
            Tools_XML.writeDocumentToFile(document, fileName);
            sequence.setDirty(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void read(EnsembleWorker_Sequence sequence, String fileName, boolean broadcast) {
        try {
            sequence.clear();
            if (!Tools_FileSystem.exists_file(fileName)) {
                if (broadcast) {
                    sequence.emit(EnsembleWorker_Sequence.MessageType.SequenceModified, null);
                }
                return;
            }
            sequence.DoNotEmitMessages = true;
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            Tools_EnsembleWorker.readFromNode(sequence, root);
            sequence.DoNotEmitMessages = false;
            if (broadcast) {
                sequence.emit(EnsembleWorker_Sequence.MessageType.SequenceModified, null);
            }
            sequence.setDirty(false);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static void read(EnsembleWorker_Sequence sequence, String fileName) {
        try {
            Tools_EnsembleWorker.read(sequence, fileName, true);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

