/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.TimeShift;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.AppType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Windows.Shared.ComboStringListWrapper;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Refraction.Tools_RefractionStaticsProject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EnsembleWorker_RefractionStatics
extends EnsembleWorker_Base
implements GenericObjectListener.Listener,
ActionListener,
Messenger.Listener {
    protected Ensemble m_inputEnsemble = null;
    protected LinearLayoutWidget m_mainWidget;
    protected ComboStringListWrapper m_combo;

    public EnsembleWorker_RefractionStatics() {
        try {
            this.Abbreviation = "Statics shift";
            this.ShortDescription = "Apply refraction statics";
            this.WorkerType = "Shift T0";
            this.InteractiveFlowsOkay = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_RefractionStatics";
    }

    @Override
    public void handleMessenger(Messenger.Message message, Object sender, Object data) {
        try {
            if (message == Messenger.Message.ColumnsModified || message == Messenger.Message.ProjectVersionChanged) {
                this.reloadCombo();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void handleGenericObjectListener(Object sender, Object data) {
        try {
            String column = this.m_combo.getSelectedString();
            this.m_parameterTree.string_put("Column", column);
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.broadcast(this, "Modified");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            String column = this.m_combo.getSelectedString();
            this.m_parameterTree.string_put("Column", column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = new LinearLayoutWidget(LinearLayoutWidget.Direction.Vertical, 0, null);
                String column = this.m_parameterTree.string_get("Column", "NotSet");
                this.m_combo = new ComboStringListWrapper();
                this.m_combo.listener().addListener(this);
                this.m_combo.setPreferredSelected(column);
                this.m_mainWidget.addComponent(new JLabel("Select statics column:"), 0);
                this.m_mainWidget.addComponent(this.m_combo, 0);
                this.reloadCombo();
                this.m_mainWidget.addStretch(10);
                Messenger.singleton().addListener(this);
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void reloadCombo() {
        try {
            RefractionStaticsProject p = RefractionStaticsProject.singleton();
            if (this.m_mainWidget == null) {
                return;
            }
            ArrayList<String> intersection = null;
            if (AppType.isRefraction()) {
                intersection = Tools_RefractionStaticsProject.getColumnList_Intersection("STATICS_");
            }
            if (AppType.isVelocity()) {
                // empty if block
            }
            Collections.sort(intersection);
            this.m_combo.setStringArray(intersection);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            double shift;
            EnsembleTrace trace;
            int k;
            int index;
            String column;
            this.m_inputEnsemble = ensemble;
            if (this.m_mainWidget != null) {
                column = this.m_combo.getSelectedString();
                this.m_parameterTree.string_put("Column", column);
            }
            column = this.m_parameterTree.string_get("Column", "NotSet");
            if (this.m_inputEnsemble.dictionary().containsEntry("Receiver", column)) {
                index = this.m_inputEnsemble.dictionary().getEntryIndex("Receiver", column);
                for (k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    trace = this.m_inputEnsemble.trace(k);
                    shift = trace.header().getDouble(index);
                    trace.data().addShiftToFirstSampleCoord((float)shift);
                }
            }
            if (this.m_inputEnsemble.dictionary().containsEntry("Shot", column)) {
                index = this.m_inputEnsemble.dictionary().getEntryIndex("Shot", column);
                for (k = 0; k < this.m_inputEnsemble.traceCount(); ++k) {
                    trace = this.m_inputEnsemble.trace(k);
                    shift = trace.header().getDouble(index);
                    trace.data().addShiftToFirstSampleCoord((float)shift);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

