/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Ensemble.Worker.Synthetic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import com.PecosCore.Windows.Shared.LinearLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EnsembleWorker_SyntheticModel
extends EnsembleWorker_Base
implements ActionListener {
    protected Ensemble m_inputEnsemble = null;
    protected Ensemble m_ensemble = new Ensemble();
    protected LinearLayoutWidget m_mainWidget = null;
    protected JTextField m_txtThicknessMin;
    protected JTextField m_txtThicknessMax;
    protected JTextField m_txtV0;
    protected JTextField m_txtH1;
    protected JTextField m_txtV1;
    protected JTextField m_txtH2;
    protected JTextField m_txtV2;
    protected JTextField m_txtV3;
    protected JTextField m_txtMaxTime;
    protected JTextField m_txtEventTime;
    protected double m_h0min;
    protected double m_h0max;
    protected double m_v0;
    protected double m_h1;
    protected double m_v1;
    protected double m_h2;
    protected double m_v2;
    protected double m_v3;
    protected double m_maxTime;
    protected double m_eventTime;

    public EnsembleWorker_SyntheticModel() {
        try {
            this.Abbreviation = "SYN3D";
            this.ShortDescription = "Synthetic model";
            this.WorkerType = "Synthetic";
            this.InteractiveFlowsOkay = false;
            this.RequiresRefractionStaticsProject = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String uniqueID() {
        return "EnsembleWorker_SyntheticModel";
    }

    @Override
    public boolean hasMoreEnsembles() {
        try {
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public double percentDone() {
        return 0.0;
    }

    @Override
    public Ensemble nextEnsemble() {
        return null;
    }

    @Override
    public void getParametersFromWidget() {
        try {
            if (this.m_mainWidget == null) {
                return;
            }
            this.m_h0min = Tools_Widget.extractDouble(this.m_txtThicknessMin, 100.0, 10.0, 500.0);
            this.m_h0max = Tools_Widget.extractDouble(this.m_txtThicknessMax, this.m_h0min + 100.0, this.m_h0min + 10.0, this.m_h0min + 1000.0);
            this.m_parameterTree.double_put("ThicknessMin", this.m_h0min);
            this.m_parameterTree.double_put("ThicknessMax", this.m_h0max);
            this.m_v0 = Tools_Widget.extractDouble(this.m_txtV0, 3000.0, 1000.0, 5000.0);
            this.m_parameterTree.double_put("V0", this.m_v0);
            this.m_v1 = Tools_Widget.extractDouble(this.m_txtV1, this.m_v0 + 2000.0, this.m_v0 + 500.0, this.m_v0 + 5000.0);
            this.m_h1 = Tools_Widget.extractDouble(this.m_txtH1, 200.0, 100.0, 3000.0);
            this.m_parameterTree.double_put("V1", this.m_v1);
            this.m_parameterTree.double_put("H1", this.m_h1);
            this.m_v2 = Tools_Widget.extractDouble(this.m_txtV2, this.m_v1 + 2000.0, this.m_v1 + 500.0, this.m_v1 + 5000.0);
            this.m_h2 = Tools_Widget.extractDouble(this.m_txtH2, 200.0, 100.0, 3000.0);
            this.m_parameterTree.double_put("V2", this.m_v2);
            this.m_parameterTree.double_put("H2", this.m_h2);
            this.m_v3 = Tools_Widget.extractDouble(this.m_txtV3, this.m_v2 + 2000.0, this.m_v2 + 500.0, this.m_v2 + 5000.0);
            this.m_parameterTree.double_put("V3", this.m_v3);
            this.m_eventTime = Tools_Widget.extractDouble(this.m_txtEventTime, 1000.0, 300.0, 2000.0);
            this.m_maxTime = Tools_Widget.extractDouble(this.m_txtMaxTime, 3000.0, 2000.0, 5000.0);
            this.m_parameterTree.double_put("EventTime", this.m_eventTime);
            this.m_parameterTree.double_put("MaxTime", this.m_maxTime);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean hasEditorWidget() {
        return true;
    }

    @Override
    public JComponent editorWidget() throws Exception {
        try {
            if (this.m_mainWidget == null) {
                this.m_mainWidget = LinearLayoutWidget.vert(3, null);
                this.m_txtThicknessMin = new JTextField("50");
                this.m_txtThicknessMax = new JTextField("1000");
                this.m_txtV0 = new JTextField("1300");
                this.m_txtH1 = new JTextField("9000");
                this.m_txtV1 = new JTextField("2000");
                this.m_txtH2 = new JTextField("9000");
                this.m_txtV2 = new JTextField("2000");
                this.m_txtV3 = new JTextField("2000");
                this.m_txtMaxTime = new JTextField("2000");
                this.m_txtEventTime = new JTextField("2000");
                this.m_txtThicknessMin.addActionListener(this);
                this.m_txtThicknessMax.addActionListener(this);
                this.m_txtV0.addActionListener(this);
                this.m_txtH1.addActionListener(this);
                this.m_txtV1.addActionListener(this);
                this.m_txtH2.addActionListener(this);
                this.m_txtV2.addActionListener(this);
                this.m_txtV3.addActionListener(this);
                this.m_txtMaxTime.addActionListener(this);
                this.m_txtEventTime.addActionListener(this);
                this.m_parameterTree.double_get(this.m_txtThicknessMin, "ThicknessMin", 100.0);
                this.m_parameterTree.double_get(this.m_txtThicknessMax, "ThicknessMax", 400.0);
                this.m_parameterTree.double_get(this.m_txtMaxTime, "MaxTime", 3000.0);
                this.m_parameterTree.double_get(this.m_txtEventTime, "EventTime", 1500.0);
                this.m_parameterTree.double_get(this.m_txtV0, "V0", 3000.0);
                this.m_parameterTree.double_get(this.m_txtV1, "V1", 5000.0);
                this.m_parameterTree.double_get(this.m_txtH1, "H1", 500.0);
                this.m_parameterTree.double_get(this.m_txtV2, "V2", 7000.0);
                this.m_parameterTree.double_get(this.m_txtH2, "H2", 500.0);
                this.m_parameterTree.double_get(this.m_txtV3, "V3", 10000.0);
                GridLayoutWidget grid = this.m_mainWidget.createGridLayoutWidget(3, 0);
                int row = 0;
                grid.addSimple(row++, new JLabel("Minimum weathering thickness"), this.m_txtThicknessMin);
                grid.addSimple(row++, new JLabel("Maximum weathering thickness"), this.m_txtThicknessMax);
                grid.addSimple(row++, new JLabel("Weathering velocity"), this.m_txtV0);
                grid.addSimple(row++, new JLabel("First refractor thickness"), this.m_txtH1);
                grid.addSimple(row++, new JLabel("First refractor velocity"), this.m_txtV1);
                grid.addSimple(row++, new JLabel("Second refractor thickness"), this.m_txtH2);
                grid.addSimple(row++, new JLabel("Second refractor velocity"), this.m_txtV2);
                grid.addSimple(row++, new JLabel("Third refractor velocity"), this.m_txtV3);
                grid.addSimple(row++, new JLabel("Trace length (millisec)"), this.m_txtMaxTime);
                grid.addSimple(row++, new JLabel("Event time (millisec)"), this.m_txtEventTime);
                this.m_mainWidget.addStretch(10);
                this.getParametersFromWidget();
            }
            return this.m_mainWidget;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    protected void work(Ensemble ensemble) throws Exception {
        try {
            this.m_inputEnsemble = ensemble;
            this.getParametersFromWidget();
            this.m_h0min = this.m_parameterTree.double_get("ThicknessMin", 100.0);
            this.m_h0max = this.m_parameterTree.double_get("ThicknessMax", 400.0);
            this.m_maxTime = this.m_parameterTree.double_get("MaxTime", 3000.0);
            this.m_eventTime = this.m_parameterTree.double_get("EventTime", 1500.0);
            this.m_v0 = this.m_parameterTree.double_get("V0", 3000.0);
            this.m_v1 = this.m_parameterTree.double_get("V1", 5000.0);
            this.m_h1 = this.m_parameterTree.double_get("H1", 500.0);
            this.m_v2 = this.m_parameterTree.double_get("V2", 7000.0);
            this.m_h2 = this.m_parameterTree.double_get("H2", 500.0);
            this.m_v3 = this.m_parameterTree.double_get("V3", 10000.0);
            double digi = 4.0;
            int len = (int)(0.5 + this.m_maxTime / digi);
            float[] data = new float[len];
            int indexShotX = ensemble.dictionary().getEntryIndex("Shot", "Easting");
            int indexShotY = ensemble.dictionary().getEntryIndex("Shot", "Northing");
            int indexShotZ = ensemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexRecX = ensemble.dictionary().getEntryIndex("Receiver", "Easting");
            int indexRecY = ensemble.dictionary().getEntryIndex("Receiver", "Northing");
            int indexRecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                for (int s = 0; s < data.length; ++s) {
                    data[s] = 0.0f;
                }
                double sx = trace.header().getDouble(indexShotX);
                double sy = trace.header().getDouble(indexShotY);
                double rx = trace.header().getDouble(indexRecX);
                double ry = trace.header().getDouble(indexRecY);
                double dx = rx - sx;
                double dy = ry - sy;
                double off = Math.sqrt(dx * dx + dy * dy);
                double shotH0 = this.getThickness(sx, sy);
                double recH0 = this.getThickness(rx, ry);
                trace.header().putDouble(indexShotZ, 5000.0 + shotH0);
                trace.header().putDouble(indexRecZ, 5000.0 + recH0);
                this.addEvent(data, (float)digi, (float)(1000.0 * off / this.m_v0), 100.0f);
                double shtdt = this.getDelayTime1(shotH0);
                double recdt = this.getDelayTime1(recH0);
                this.addEvent(data, (float)digi, (float)(shtdt + recdt + 1000.0 * off / this.m_v1), 100.0f);
                shtdt = this.getDelayTime2(shotH0);
                recdt = this.getDelayTime2(recH0);
                this.addEvent(data, (float)digi, (float)(shtdt + recdt + 1000.0 * off / this.m_v2), 100.0f);
                shtdt = this.getDelayTime3(shotH0);
                recdt = this.getDelayTime3(recH0);
                this.addEvent(data, (float)digi, (float)(shtdt + recdt + 1000.0 * off / this.m_v3), 100.0f);
                trace.data().insertArray(data, data.length);
                trace.data().setFirstSampleCoord(0.0f);
                trace.data().setSampleInterval((float)digi);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.Success = false;
            this.Reason = error.getMessage();
        }
    }

    protected void addEvent(float[] data, float digi, float time, float amp) {
        try {
            for (int s = 0; s < data.length; ++s) {
                float dt = (float)Math.abs(0.001 * (double)(time - (float)s * digi));
                float exp = (float)(Math.cos(dt / 0.007f) * Math.exp(0.0 - (double)(dt / 0.012f)));
                float v = amp * exp;
                data[s] = data[s] + v;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected double getThickness(double x, double y) {
        try {
            return this.m_h0min;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 400.0;
        }
    }

    protected double getStatic(double h0) {
        try {
            return 1000.0 * (h0 / this.m_v0 + this.m_h1 / this.m_v1 + this.m_h2 / this.m_v2);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    protected double getDelayTime1(double h0) {
        try {
            return 1000.0 * h0 * Math.sqrt(this.m_v1 * this.m_v1 - this.m_v0 * this.m_v0) / (this.m_v1 * this.m_v0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 20.0;
        }
    }

    protected double getDelayTime2(double h0) {
        try {
            double t0 = 1000.0 * h0 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v0 * this.m_v0) / (this.m_v2 * this.m_v0);
            double t1 = 1000.0 * this.m_h1 * Math.sqrt(this.m_v2 * this.m_v2 - this.m_v1 * this.m_v1) / (this.m_v2 * this.m_v1);
            return t0 + t1;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 20.0;
        }
    }

    protected double getDelayTime3(double h0) {
        try {
            double t0 = 1000.0 * h0 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v0 * this.m_v0) / (this.m_v3 * this.m_v0);
            double t1 = 1000.0 * this.m_h1 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v1 * this.m_v1) / (this.m_v3 * this.m_v1);
            double t2 = 1000.0 * this.m_h2 * Math.sqrt(this.m_v3 * this.m_v3 - this.m_v2 * this.m_v2) / (this.m_v3 * this.m_v2);
            return t0 + t1 + t2;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 20.0;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.getParametersFromWidget();
            this.broadcast(this, "Modified");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public int outputCount() {
        return 1;
    }

    @Override
    public boolean outputValid(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble != null;
        }
        return false;
    }

    @Override
    public String outputName(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return "Default";
        }
        return "ERROR";
    }

    @Override
    public Ensemble output(int outputIndex) throws Exception {
        if (outputIndex == 0) {
            return this.m_inputEnsemble;
        }
        return null;
    }

    @Override
    public void reloadEditorWidgetFromParams() {
    }
}

